/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.kafka;

import com.google.auto.value.AutoValue;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.beam.sdk.io.kafka.AutoValue_KafkaReadSchemaTransformConfiguration;
import org.apache.beam.sdk.schemas.AutoValueSchema;
import org.apache.beam.sdk.schemas.annotations.DefaultSchema;
import org.apache.beam.sdk.schemas.annotations.SchemaFieldDescription;
import org.apache.beam.sdk.schemas.transforms.providers.ErrorHandling;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Sets;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@DefaultSchema(value=AutoValueSchema.class)
@AutoValue
public abstract class KafkaReadSchemaTransformConfiguration {
    public static final @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> VALID_START_OFFSET_VALUES = Sets.newHashSet((Object[])new String[]{"earliest", "latest"});
    public static final @UnknownKeyFor @NonNull @Initialized String VALID_FORMATS_STR = "RAW,STRING,AVRO,JSON,PROTO";
    public static final @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> VALID_DATA_FORMATS = Sets.newHashSet((Object[])"RAW,STRING,AVRO,JSON,PROTO".split(","));

    public void validate() {
        String startOffset = this.getAutoOffsetResetConfig();
        Preconditions.checkArgument((startOffset == null || VALID_START_OFFSET_VALUES.contains(startOffset) ? 1 : 0) != 0, (Object)("Valid Kafka Start offset values are " + VALID_START_OFFSET_VALUES));
        String dataFormat = this.getFormat();
        Preconditions.checkArgument((dataFormat == null || VALID_DATA_FORMATS.contains(dataFormat) ? 1 : 0) != 0, (Object)("Valid data formats are " + VALID_DATA_FORMATS));
        String inputSchema = this.getSchema();
        String messageName = this.getMessageName();
        String fileDescriptorPath = this.getFileDescriptorPath();
        String confluentSchemaRegUrl = this.getConfluentSchemaRegistryUrl();
        String confluentSchemaRegSubject = this.getConfluentSchemaRegistrySubject();
        if (confluentSchemaRegUrl != null) {
            Preconditions.checkNotNull((Object)confluentSchemaRegSubject, (Object)"To read from Kafka, a schema must be provided directly or though Confluent Schema Registry. Make sure you are providing one of these parameters.");
        } else if (dataFormat != null && dataFormat.equals("RAW")) {
            Preconditions.checkArgument((inputSchema == null ? 1 : 0) != 0, (Object)"To read from Kafka in RAW format, you can't provide a schema.");
        } else if (dataFormat != null && dataFormat.equals("STRING")) {
            Preconditions.checkArgument((inputSchema == null ? 1 : 0) != 0, (Object)"To read from Kafka in STRING format, you can't provide a schema.");
        } else if (dataFormat != null && dataFormat.equals("JSON")) {
            Preconditions.checkNotNull((Object)inputSchema, (Object)"To read from Kafka in JSON format, you must provide a schema.");
        } else if (dataFormat != null && dataFormat.equals("PROTO")) {
            Preconditions.checkNotNull((Object)messageName, (Object)"To read from Kafka in PROTO format, messageName must be provided.");
            Preconditions.checkArgument((fileDescriptorPath != null || inputSchema != null ? 1 : 0) != 0, (Object)"To read from Kafka in PROTO format, fileDescriptorPath or schema must be provided.");
        } else {
            Preconditions.checkNotNull((Object)inputSchema, (Object)"To read from Kafka in AVRO format, you must provide a schema.");
        }
    }

    public static @UnknownKeyFor @NonNull @Initialized Builder builder() {
        return new AutoValue_KafkaReadSchemaTransformConfiguration.Builder();
    }

    @SchemaFieldDescription(value="A list of host/port pairs to use for establishing the initial connection to the Kafka cluster. The client will make use of all servers irrespective of which servers are specified here for bootstrapping\u2014this list only impacts the initial hosts used to discover the full set of servers. This list should be in the form `host1:port1,host2:port2,...`")
    public abstract @UnknownKeyFor @NonNull @Initialized String getBootstrapServers();

    @Nullable
    public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized String getConfluentSchemaRegistryUrl();

    @SchemaFieldDescription(value="The encoding format for the data stored in Kafka. Valid options are: RAW,STRING,AVRO,JSON,PROTO")
    @Nullable
    public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized String getFormat();

    @Nullable
    public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized String getConfluentSchemaRegistrySubject();

    @SchemaFieldDescription(value="The schema in which the data is encoded in the Kafka topic. For AVRO data, this is a schema defined with AVRO schema syntax (https://avro.apache.org/docs/1.10.2/spec.html#schemas). For JSON data, this is a schema defined with JSON-schema syntax (https://json-schema.org/). If a URL to Confluent Schema Registry is provided, then this field is ignored, and the schema is fetched from Confluent Schema Registry.")
    @Nullable
    public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized String getSchema();

    @SchemaFieldDescription(value="The path to the Protocol Buffer File Descriptor Set file. This file is used for schema definition and message serialization.")
    @Nullable
    public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized String getFileDescriptorPath();

    @SchemaFieldDescription(value="The name of the Protocol Buffer message to be used for schema extraction and data conversion.")
    @Nullable
    public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized String getMessageName();

    @SchemaFieldDescription(value="What to do when there is no initial offset in Kafka or if the current offset does not exist any more on the server. (1) earliest: automatically reset the offset to the earliest offset. (2) latest: automatically reset the offset to the latest offset (3) none: throw exception to the consumer if no previous offset is found for the consumer\u2019s group")
    @Nullable
    public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized String getAutoOffsetResetConfig();

    @SchemaFieldDescription(value="A list of key-value pairs that act as configuration parameters for Kafka consumers. Most of these configurations will not be needed, but if you need to customize your Kafka consumer, you may use this. See a detailed list: https://docs.confluent.io/platform/current/installation/configuration/consumer-configs.html")
    @Nullable
    public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> getConsumerConfigUpdates();

    public abstract @UnknownKeyFor @NonNull @Initialized String getTopic();

    @SchemaFieldDescription(value="Upper bound of how long to read from Kafka.")
    @Nullable
    public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Integer getMaxReadTimeSeconds();

    @SchemaFieldDescription(value="This option specifies whether and where to output unwritable rows.")
    @Nullable
    public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized ErrorHandling getErrorHandling();

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract @UnknownKeyFor @NonNull @Initialized Builder setBootstrapServers(@UnknownKeyFor @NonNull @Initialized String var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setConfluentSchemaRegistryUrl(@UnknownKeyFor @NonNull @Initialized String var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setConfluentSchemaRegistrySubject(@UnknownKeyFor @NonNull @Initialized String var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setSchema(@UnknownKeyFor @NonNull @Initialized String var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setFileDescriptorPath(@UnknownKeyFor @NonNull @Initialized String var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setMessageName(@UnknownKeyFor @NonNull @Initialized String var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setFormat(@UnknownKeyFor @NonNull @Initialized String var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setAutoOffsetResetConfig(@UnknownKeyFor @NonNull @Initialized String var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setConsumerConfigUpdates(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setTopic(@UnknownKeyFor @NonNull @Initialized String var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setMaxReadTimeSeconds(@UnknownKeyFor @NonNull @Initialized Integer var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setErrorHandling(@UnknownKeyFor @NonNull @Initialized ErrorHandling var1);

        public abstract @UnknownKeyFor @NonNull @Initialized KafkaReadSchemaTransformConfiguration build();
    }
}

