/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.kafka;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.beam.sdk.io.kafka.KafkaIO;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.CaseFormat;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.HashMultimap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableSet;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Multimap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Sets;
import org.checkerframework.checker.initialization.qual.UnderInitialization;

class KafkaIOReadImplementationCompatibility {
    KafkaIOReadImplementationCompatibility() {
    }

    static KafkaIOReadImplementationCompatibilityResult getCompatibility(KafkaIO.Read<?, ?> read) {
        HashMultimap notSupportedImplementationsWithProperties = HashMultimap.create();
        for (KafkaIOReadProperties property : KafkaIOReadProperties.values()) {
            Object currentValue;
            EnumSet<KafkaIOReadImplementation> notSupportedImplementations = EnumSet.complementOf(EnumSet.copyOf(property.supportedImplementations));
            if (notSupportedImplementations.isEmpty()) continue;
            Object defaultValue = property.getDefaultValue();
            try {
                currentValue = property.getterMethod.invoke((Object)read, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException("Should not happen", e);
            }
            if (Objects.equals(defaultValue, currentValue)) continue;
            for (KafkaIOReadImplementation notSupportedImplementation : notSupportedImplementations) {
                notSupportedImplementationsWithProperties.put((Object)notSupportedImplementation, (Object)property);
            }
        }
        if (EnumSet.allOf(KafkaIOReadImplementation.class).equals(notSupportedImplementationsWithProperties.keySet())) {
            throw new IllegalStateException("There is no Kafka read implementation that supports every configured property! Not supported implementations with the associated properties: " + notSupportedImplementationsWithProperties);
        }
        return new KafkaIOReadImplementationCompatibilityResult((Multimap)notSupportedImplementationsWithProperties);
    }

    static class KafkaIOReadImplementationCompatibilityResult {
        private final Multimap<KafkaIOReadImplementation, KafkaIOReadProperties> notSupported;

        private KafkaIOReadImplementationCompatibilityResult(Multimap<KafkaIOReadImplementation, KafkaIOReadProperties> notSupportedImplementationsWithAssociatedProperties) {
            this.notSupported = notSupportedImplementationsWithAssociatedProperties;
        }

        boolean supports(KafkaIOReadImplementation implementation) {
            return !this.notSupported.containsKey((Object)implementation);
        }

        boolean supportsOnly(KafkaIOReadImplementation implementation) {
            return EnumSet.complementOf(EnumSet.of(implementation)).equals(this.notSupported.keySet());
        }

        void checkSupport(KafkaIOReadImplementation selectedImplementation) {
            Preconditions.checkState((boolean)this.supports(selectedImplementation), (Object)("The current Kafka read configuration isn't supported by the " + (Object)((Object)selectedImplementation) + " read implementation! Conflicting properties: " + this.notSupported.get((Object)selectedImplementation)));
        }
    }

    @VisibleForTesting
    static enum KafkaIOReadProperties {
        CONSUMER_CONFIG,
        TOPICS,
        TOPIC_PARTITIONS,
        KEY_CODER,
        VALUE_CODER,
        CONSUMER_FACTORY_FN,
        WATERMARK_FN(KafkaIOReadImplementation.LEGACY),
        MAX_NUM_RECORDS(new KafkaIOReadImplementation[]{KafkaIOReadImplementation.LEGACY}){

            @Override
            Object getDefaultValue() {
                return Long.MAX_VALUE;
            }
        }
        ,
        MAX_READ_TIME(KafkaIOReadImplementation.LEGACY),
        START_READ_TIME,
        STOP_READ_TIME(KafkaIOReadImplementation.SDF),
        COMMIT_OFFSETS_IN_FINALIZE_ENABLED{

            @Override
            Object getDefaultValue() {
                return false;
            }
        }
        ,
        DYNAMIC_READ(new KafkaIOReadImplementation[]{KafkaIOReadImplementation.SDF}){

            @Override
            Object getDefaultValue() {
                return false;
            }
        }
        ,
        WATCH_TOPIC_PARTITION_DURATION(KafkaIOReadImplementation.SDF),
        TIMESTAMP_POLICY_FACTORY,
        OFFSET_CONSUMER_CONFIG,
        KEY_DESERIALIZER_PROVIDER,
        VALUE_DESERIALIZER_PROVIDER,
        CHECK_STOP_READING_FN(KafkaIOReadImplementation.SDF);

        @Nonnull
        private final ImmutableSet<KafkaIOReadImplementation> supportedImplementations;
        @Nonnull
        private final Method getterMethod;

        private KafkaIOReadProperties() {
            this(KafkaIOReadImplementation.values());
        }

        private KafkaIOReadProperties(KafkaIOReadImplementation ... supportedImplementations) {
            this.supportedImplementations = Sets.immutableEnumSet(Arrays.asList(supportedImplementations));
            this.getterMethod = KafkaIOReadProperties.findGetterMethod(this);
        }

        private static Method findGetterMethod(@UnderInitialization(value=Enum.class) KafkaIOReadProperties property) {
            String propertyNameInUpperCamel = CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, property.name());
            try {
                return KafkaIO.Read.class.getDeclaredMethod("get" + propertyNameInUpperCamel, new Class[0]);
            }
            catch (NoSuchMethodException e) {
                try {
                    return KafkaIO.Read.class.getDeclaredMethod("is" + propertyNameInUpperCamel, new Class[0]);
                }
                catch (NoSuchMethodException e2) {
                    throw new RuntimeException("Should not happen", e);
                }
            }
        }

        @Nullable
        @VisibleForTesting
        Object getDefaultValue() {
            return null;
        }

        @VisibleForTesting
        Method getGetterMethod() {
            return this.getterMethod;
        }
    }

    static enum KafkaIOReadImplementation {
        LEGACY,
        SDF;

    }
}

