/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.kafka;

import java.util.Collection;
import java.util.Map;
import org.apache.beam.sdk.io.kafka.KafkaTimestampType;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.OffsetAndTimestamp;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.serialization.Deserializer;
import org.joda.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.SpelParserConfiguration;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

class ConsumerSpEL {
    private static final Logger LOG = LoggerFactory.getLogger(ConsumerSpEL.class);
    private static final SpelParserConfiguration config = new SpelParserConfiguration(true, true);
    private static final ExpressionParser parser = new SpelExpressionParser(config);
    private static final Expression seek2endExpression = parser.parseExpression("#consumer.seekToEnd(#tp)");
    private static final Expression assignExpression = parser.parseExpression("#consumer.assign(#tp)");
    private static boolean hasRecordTimestamp;
    private static boolean hasHeaders;
    private static boolean hasOffsetsForTimes;
    private static boolean deserializerSupportsHeaders;

    ConsumerSpEL() {
    }

    public static void evaluateSeek2End(Consumer<?, ?> consumer, TopicPartition topicPartition) {
        StandardEvaluationContext mapContext = new StandardEvaluationContext();
        mapContext.setVariable("consumer", consumer);
        mapContext.setVariable("tp", (Object)topicPartition);
        seek2endExpression.getValue((EvaluationContext)mapContext);
    }

    public static void evaluateAssign(Consumer<?, ?> consumer, Collection<TopicPartition> topicPartitions) {
        StandardEvaluationContext mapContext = new StandardEvaluationContext();
        mapContext.setVariable("consumer", consumer);
        mapContext.setVariable("tp", topicPartitions);
        assignExpression.getValue((EvaluationContext)mapContext);
    }

    public static long getRecordTimestamp(ConsumerRecord<byte[], byte[]> rawRecord) {
        if (hasRecordTimestamp) {
            return rawRecord.timestamp();
        }
        return -1L;
    }

    public static KafkaTimestampType getRecordTimestampType(ConsumerRecord<byte[], byte[]> rawRecord) {
        if (hasRecordTimestamp) {
            return KafkaTimestampType.forOrdinal(rawRecord.timestampType().ordinal());
        }
        return KafkaTimestampType.NO_TIMESTAMP_TYPE;
    }

    public static boolean hasOffsetsForTimes() {
        return hasOffsetsForTimes;
    }

    public static boolean hasHeaders() {
        return hasHeaders;
    }

    public static boolean deserializerSupportsHeaders() {
        return deserializerSupportsHeaders;
    }

    public static <T> T deserializeKey(Deserializer<T> deserializer, ConsumerRecord<byte[], byte[]> rawRecord) {
        if (deserializerSupportsHeaders) {
            return (T)deserializer.deserialize(rawRecord.topic(), rawRecord.headers(), (byte[])rawRecord.key());
        }
        return (T)deserializer.deserialize(rawRecord.topic(), (byte[])rawRecord.key());
    }

    public static <T> T deserializeValue(Deserializer<T> deserializer, ConsumerRecord<byte[], byte[]> rawRecord) {
        if (deserializerSupportsHeaders) {
            return (T)deserializer.deserialize(rawRecord.topic(), rawRecord.headers(), (byte[])rawRecord.value());
        }
        return (T)deserializer.deserialize(rawRecord.topic(), (byte[])rawRecord.value());
    }

    public static long offsetForTime(Consumer<?, ?> consumer, TopicPartition topicPartition, Instant time) {
        Preconditions.checkArgument((boolean)hasOffsetsForTimes, (Object)"This Kafka Client must support Consumer.OffsetsForTimes().");
        OffsetAndTimestamp offsetAndTimestamp = (OffsetAndTimestamp)Iterables.getOnlyElement(consumer.offsetsForTimes((Map)ImmutableMap.of((Object)topicPartition, (Object)time.getMillis())).values());
        if (offsetAndTimestamp == null) {
            throw new RuntimeException("There are no messages has a timestamp that is greater than or equals to the target time or the message format version in this partition is before 0.10.0, topicPartition is: " + topicPartition);
        }
        return offsetAndTimestamp.offset();
    }

    static {
        try {
            hasRecordTimestamp = ConsumerRecord.class.getMethod("timestamp", null).getReturnType().equals(Long.TYPE);
        }
        catch (NoSuchMethodException | SecurityException e) {
            LOG.debug("Timestamp for Kafka message is not available.");
        }
        try {
            hasHeaders = "org.apache.kafka.common.header.Headers".equals(ConsumerRecord.class.getMethod("headers", null).getReturnType().getName());
        }
        catch (NoSuchMethodException | SecurityException e) {
            LOG.debug("Headers is not available");
        }
        try {
            hasOffsetsForTimes = Consumer.class.getMethod("offsetsForTimes", Map.class).getReturnType().equals(Map.class);
        }
        catch (NoSuchMethodException | SecurityException e) {
            LOG.debug("OffsetsForTimes is not available.");
        }
        try {
            deserializerSupportsHeaders = "T".equals(Deserializer.class.getDeclaredMethod("deserialize", String.class, Headers.class, byte[].class).getGenericReturnType().getTypeName());
        }
        catch (NoSuchMethodException | SecurityException e) {
            LOG.debug("Deserializer interface does not support Kafka headers");
        }
    }
}

