/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.kafka;

import com.google.auto.value.AutoValue;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.beam.sdk.io.kafka.AutoValue_KafkaSourceDescriptor;
import org.apache.beam.sdk.schemas.AutoValueSchema;
import org.apache.beam.sdk.schemas.annotations.DefaultSchema;
import org.apache.beam.sdk.schemas.annotations.SchemaCreate;
import org.apache.beam.sdk.schemas.annotations.SchemaFieldName;
import org.apache.beam.sdk.schemas.annotations.SchemaIgnore;
import org.apache.kafka.common.TopicPartition;
import org.joda.time.Instant;

@DefaultSchema(value=AutoValueSchema.class)
@AutoValue
public abstract class KafkaSourceDescriptor
implements Serializable {
    private TopicPartition topicPartition = null;

    @SchemaFieldName(value="topic")
    abstract String getTopic();

    @SchemaFieldName(value="partition")
    abstract Integer getPartition();

    @SchemaFieldName(value="start_read_offset")
    @Nullable
    abstract Long getStartReadOffset();

    @SchemaFieldName(value="start_read_time")
    @Nullable
    abstract Instant getStartReadTime();

    @SchemaFieldName(value="bootstrap_servers")
    @Nullable
    abstract List<String> getBootStrapServers();

    @SchemaIgnore
    public TopicPartition getTopicPartition() {
        if (this.topicPartition == null) {
            this.topicPartition = new TopicPartition(this.getTopic(), this.getPartition().intValue());
        }
        return this.topicPartition;
    }

    public static KafkaSourceDescriptor of(TopicPartition topicPartition, Long startReadOffset, Instant startReadTime, List<String> bootstrapServers) {
        return new AutoValue_KafkaSourceDescriptor(topicPartition.topic(), topicPartition.partition(), startReadOffset, startReadTime, bootstrapServers);
    }

    @SchemaCreate
    static KafkaSourceDescriptor create(String topic, Integer partition, Long start_read_offset, Instant start_read_time, List<String> bootstrap_servers) {
        return new AutoValue_KafkaSourceDescriptor(topic, partition, start_read_offset, start_read_time, bootstrap_servers);
    }
}

