/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.kafka;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.AuthorizationException;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

class ProducerSpEL {
    private static @UnknownKeyFor @NonNull @Initialized boolean supportsTransactions;
    private static @UnknownKeyFor @NonNull @Initialized Method initTransactionsMethod;
    private static @UnknownKeyFor @NonNull @Initialized Method beginTransactionMethod;
    private static @UnknownKeyFor @NonNull @Initialized Method commitTransactionMethod;
    private static @UnknownKeyFor @NonNull @Initialized Method abortTransactionMethod;
    private static @UnknownKeyFor @NonNull @Initialized Method sendOffsetsToTransactionMethod;
    static final @UnknownKeyFor @NonNull @Initialized String ENABLE_IDEMPOTENCE_CONFIG = "enable.idempotence";
    static final @UnknownKeyFor @NonNull @Initialized String TRANSACTIONAL_ID_CONFIG = "transactional.id";
    private static /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> producerFencedExceptionClass;
    private static /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> outOfOrderSequenceExceptionClass;

    ProducerSpEL() {
    }

    static @UnknownKeyFor @NonNull @Initialized boolean supportsTransactions() {
        return supportsTransactions;
    }

    private static void ensureTransactionsSupport() {
        Preconditions.checkArgument((boolean)ProducerSpEL.supportsTransactions(), (String)"This version of Kafka client library does not support transactions. ", (Object)"Please used version 0.11 or later.");
    }

    private static void invoke(@UnknownKeyFor @NonNull @Initialized Method method, @UnknownKeyFor @NonNull @Initialized Object obj, Object ... args) {
        try {
            method.invoke(obj, args);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (ApiException e) {
            Class<?> eClass = ((Object)((Object)e)).getClass();
            if (producerFencedExceptionClass.isAssignableFrom(eClass) || outOfOrderSequenceExceptionClass.isAssignableFrom(eClass) || AuthorizationException.class.isAssignableFrom(eClass)) {
                throw new UnrecoverableProducerException(e);
            }
            throw e;
        }
    }

    static void initTransactions(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Producer<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> producer) {
        ProducerSpEL.ensureTransactionsSupport();
        ProducerSpEL.invoke(initTransactionsMethod, producer, new Object[0]);
    }

    static void beginTransaction(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Producer<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> producer) {
        ProducerSpEL.ensureTransactionsSupport();
        ProducerSpEL.invoke(beginTransactionMethod, producer, new Object[0]);
    }

    static void commitTransaction(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Producer<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> producer) {
        ProducerSpEL.ensureTransactionsSupport();
        ProducerSpEL.invoke(commitTransactionMethod, producer, new Object[0]);
    }

    static void abortTransaction(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Producer<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> producer) {
        ProducerSpEL.ensureTransactionsSupport();
        ProducerSpEL.invoke(abortTransactionMethod, producer, new Object[0]);
    }

    static void sendOffsetsToTransaction(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Producer<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> producer, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TopicPartition, @UnknownKeyFor @NonNull @Initialized OffsetAndMetadata> offsets, @UnknownKeyFor @NonNull @Initialized String consumerGroupId) {
        ProducerSpEL.ensureTransactionsSupport();
        ProducerSpEL.invoke(sendOffsetsToTransactionMethod, producer, offsets, consumerGroupId);
    }

    static {
        try {
            initTransactionsMethod = Producer.class.getMethod("initTransactions", new Class[0]);
            beginTransactionMethod = Producer.class.getMethod("beginTransaction", new Class[0]);
            commitTransactionMethod = Producer.class.getMethod("commitTransaction", new Class[0]);
            abortTransactionMethod = Producer.class.getMethod("abortTransaction", new Class[0]);
            sendOffsetsToTransactionMethod = Producer.class.getMethod("sendOffsetsToTransaction", Map.class, String.class);
            producerFencedExceptionClass = Class.forName("org.apache.kafka.common.errors.ProducerFencedException");
            outOfOrderSequenceExceptionClass = Class.forName("org.apache.kafka.common.errors.OutOfOrderSequenceException");
            supportsTransactions = true;
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            supportsTransactions = false;
        }
    }

    static class UnrecoverableProducerException
    extends ApiException {
        UnrecoverableProducerException(@UnknownKeyFor @NonNull @Initialized ApiException cause) {
            super((Throwable)cause);
        }
    }
}

