/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.kafka;

import java.util.Collection;
import java.util.Map;
import org.apache.beam.sdk.io.kafka.KafkaTimestampType;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.OffsetAndTimestamp;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.serialization.Deserializer;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.SpelParserConfiguration;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

class ConsumerSpEL {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(ConsumerSpEL.class);
    private @UnknownKeyFor @NonNull @Initialized SpelParserConfiguration config = new SpelParserConfiguration(true, true);
    private @UnknownKeyFor @NonNull @Initialized ExpressionParser parser = new SpelExpressionParser(this.config);
    private @UnknownKeyFor @NonNull @Initialized Expression seek2endExpression = this.parser.parseExpression("#consumer.seekToEnd(#tp)");
    private @UnknownKeyFor @NonNull @Initialized Expression assignExpression = this.parser.parseExpression("#consumer.assign(#tp)");
    private @UnknownKeyFor @NonNull @Initialized Expression deserializeWithHeadersExpression = this.parser.parseExpression("#deserializer.deserialize(#topic, #headers, #data)");
    private @UnknownKeyFor @NonNull @Initialized boolean hasRecordTimestamp = false;
    private @UnknownKeyFor @NonNull @Initialized boolean hasOffsetsForTimes = false;
    private @UnknownKeyFor @NonNull @Initialized boolean deserializerSupportsHeaders = false;

    static @UnknownKeyFor @NonNull @Initialized boolean hasHeaders() {
        boolean clientHasHeaders = false;
        try {
            clientHasHeaders = "org.apache.kafka.common.header.Headers".equals(ConsumerRecord.class.getMethod("headers", null).getReturnType().getName());
        }
        catch (NoSuchMethodException | SecurityException e) {
            LOG.debug("Headers is not available");
        }
        return clientHasHeaders;
    }

    public ConsumerSpEL() {
        try {
            this.hasRecordTimestamp = ConsumerRecord.class.getMethod("timestamp", null).getReturnType().equals(Long.TYPE);
        }
        catch (NoSuchMethodException | SecurityException e) {
            LOG.debug("Timestamp for Kafka message is not available.");
        }
        try {
            this.hasOffsetsForTimes = Consumer.class.getMethod("offsetsForTimes", Map.class).getReturnType().equals(Map.class);
        }
        catch (NoSuchMethodException | SecurityException e) {
            LOG.debug("OffsetsForTimes is not available.");
        }
        try {
            this.deserializerSupportsHeaders = "T".equals(Deserializer.class.getDeclaredMethod("deserialize", String.class, Headers.class, byte[].class).getGenericReturnType().getTypeName());
        }
        catch (NoSuchMethodException | SecurityException e) {
            LOG.debug("Deserializer interface does not support Kafka headers");
        }
    }

    public void evaluateSeek2End(@UnknownKeyFor @NonNull @Initialized Consumer consumer, @UnknownKeyFor @NonNull @Initialized TopicPartition topicPartition) {
        StandardEvaluationContext mapContext = new StandardEvaluationContext();
        mapContext.setVariable("consumer", (Object)consumer);
        mapContext.setVariable("tp", (Object)topicPartition);
        this.seek2endExpression.getValue((EvaluationContext)mapContext);
    }

    public void evaluateAssign(@UnknownKeyFor @NonNull @Initialized Consumer consumer, @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized TopicPartition> topicPartitions) {
        StandardEvaluationContext mapContext = new StandardEvaluationContext();
        mapContext.setVariable("consumer", (Object)consumer);
        mapContext.setVariable("tp", topicPartitions);
        this.assignExpression.getValue((EvaluationContext)mapContext);
    }

    public @UnknownKeyFor @NonNull @Initialized Object evaluateDeserializeWithHeaders(@UnknownKeyFor @NonNull @Initialized Deserializer deserializer, @UnknownKeyFor @NonNull @Initialized ConsumerRecord<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> rawRecord, @UnknownKeyFor @NonNull @Initialized Boolean isKey) {
        StandardEvaluationContext mapContext = new StandardEvaluationContext();
        mapContext.setVariable("deserializer", (Object)deserializer);
        mapContext.setVariable("topic", (Object)rawRecord.topic());
        mapContext.setVariable("headers", (Object)rawRecord.headers());
        mapContext.setVariable("data", isKey != false ? rawRecord.key() : rawRecord.value());
        return this.deserializeWithHeadersExpression.getValue((EvaluationContext)mapContext);
    }

    public @UnknownKeyFor @NonNull @Initialized long getRecordTimestamp(@UnknownKeyFor @NonNull @Initialized ConsumerRecord<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> rawRecord) {
        if (this.hasRecordTimestamp) {
            return rawRecord.timestamp();
        }
        return -1L;
    }

    public @UnknownKeyFor @NonNull @Initialized KafkaTimestampType getRecordTimestampType(@UnknownKeyFor @NonNull @Initialized ConsumerRecord<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> rawRecord) {
        if (this.hasRecordTimestamp) {
            return KafkaTimestampType.forOrdinal(rawRecord.timestampType().ordinal());
        }
        return KafkaTimestampType.NO_TIMESTAMP_TYPE;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean hasOffsetsForTimes() {
        return this.hasOffsetsForTimes;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean deserializerSupportsHeaders() {
        return this.deserializerSupportsHeaders;
    }

    public @UnknownKeyFor @NonNull @Initialized Object deserializeKey(@UnknownKeyFor @NonNull @Initialized Deserializer deserializer, @UnknownKeyFor @NonNull @Initialized ConsumerRecord<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> rawRecord) {
        if (this.deserializerSupportsHeaders) {
            return this.evaluateDeserializeWithHeaders(deserializer, rawRecord, true);
        }
        return deserializer.deserialize(rawRecord.topic(), (byte[])rawRecord.key());
    }

    public @UnknownKeyFor @NonNull @Initialized Object deserializeValue(@UnknownKeyFor @NonNull @Initialized Deserializer deserializer, @UnknownKeyFor @NonNull @Initialized ConsumerRecord<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> rawRecord) {
        if (this.deserializerSupportsHeaders) {
            return this.evaluateDeserializeWithHeaders(deserializer, rawRecord, false);
        }
        return deserializer.deserialize(rawRecord.topic(), (byte[])rawRecord.value());
    }

    public @UnknownKeyFor @NonNull @Initialized long offsetForTime(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Consumer<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> consumer, @UnknownKeyFor @NonNull @Initialized TopicPartition topicPartition, @UnknownKeyFor @NonNull @Initialized Instant time) {
        Preconditions.checkArgument((boolean)this.hasOffsetsForTimes, (Object)"This Kafka Client must support Consumer.OffsetsForTimes().");
        OffsetAndTimestamp offsetAndTimestamp = (OffsetAndTimestamp)Iterables.getOnlyElement(consumer.offsetsForTimes((Map)ImmutableMap.of((Object)topicPartition, (Object)time.getMillis())).values());
        if (offsetAndTimestamp == null) {
            throw new RuntimeException("There are no messages has a timestamp that is greater than or equals to the target time or the message format version in this partition is before 0.10.0, topicPartition is: " + topicPartition);
        }
        return offsetAndTimestamp.offset();
    }
}

