/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.kafka;

import com.google.auto.value.AutoValue;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.coders.AtomicCoder;
import org.apache.beam.sdk.coders.ByteArrayCoder;
import org.apache.beam.sdk.coders.CannotProvideCoderException;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderRegistry;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.coders.NullableCoder;
import org.apache.beam.sdk.coders.VarIntCoder;
import org.apache.beam.sdk.coders.VarLongCoder;
import org.apache.beam.sdk.expansion.ExternalTransformRegistrar;
import org.apache.beam.sdk.io.Read;
import org.apache.beam.sdk.io.UnboundedSource;
import org.apache.beam.sdk.io.kafka.AutoValue_KafkaIO_Read;
import org.apache.beam.sdk.io.kafka.AutoValue_KafkaIO_Write;
import org.apache.beam.sdk.io.kafka.AutoValue_KafkaIO_WriteRecords;
import org.apache.beam.sdk.io.kafka.ConsumerSpEL;
import org.apache.beam.sdk.io.kafka.KafkaCheckpointMark;
import org.apache.beam.sdk.io.kafka.KafkaExactlyOnceSink;
import org.apache.beam.sdk.io.kafka.KafkaPublishTimestampFunction;
import org.apache.beam.sdk.io.kafka.KafkaRecord;
import org.apache.beam.sdk.io.kafka.KafkaUnboundedSource;
import org.apache.beam.sdk.io.kafka.KafkaWriter;
import org.apache.beam.sdk.io.kafka.ProducerRecordCoder;
import org.apache.beam.sdk.io.kafka.TimestampPolicyFactory;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.ExternalTransformBuilder;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PDone;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Joiner;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.common.utils.AppInfoParser;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental(value=Experimental.Kind.SOURCE_SINK)
public class KafkaIO {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaIO.class);

    public static Read<byte[], byte[]> readBytes() {
        return KafkaIO.read().withKeyDeserializer(ByteArrayDeserializer.class).withValueDeserializer(ByteArrayDeserializer.class);
    }

    public static <K, V> Read<K, V> read() {
        return new AutoValue_KafkaIO_Read.Builder().setTopics(new ArrayList<String>()).setTopicPartitions(new ArrayList<TopicPartition>()).setConsumerFactoryFn((SerializableFunction<Map<String, Object>, Consumer<byte[], byte[]>>)Read.KAFKA_CONSUMER_FACTORY_FN).setConsumerConfig(Read.DEFAULT_CONSUMER_PROPERTIES).setMaxNumRecords(Long.MAX_VALUE).setCommitOffsetsInFinalizeEnabled(false).setTimestampPolicyFactory(TimestampPolicyFactory.withProcessingTime()).build();
    }

    public static <K, V> Write<K, V> write() {
        return new AutoValue_KafkaIO_Write.Builder().setWriteRecordsTransform(new AutoValue_KafkaIO_WriteRecords.Builder().setProducerConfig(WriteRecords.DEFAULT_PRODUCER_PROPERTIES).setEOS(false).setNumShards(0).setConsumerFactoryFn(Read.KAFKA_CONSUMER_FACTORY_FN).build()).build();
    }

    public static <K, V> WriteRecords<K, V> writeRecords() {
        return new AutoValue_KafkaIO_WriteRecords.Builder().setProducerConfig(WriteRecords.DEFAULT_PRODUCER_PROPERTIES).setEOS(false).setNumShards(0).setConsumerFactoryFn(Read.KAFKA_CONSUMER_FACTORY_FN).build();
    }

    private static Map<String, Object> updateKafkaProperties(Map<String, Object> currentConfig, Map<String, String> ignoredProperties, Map<String, Object> updates) {
        for (String key : updates.keySet()) {
            Preconditions.checkArgument((!ignoredProperties.containsKey(key) ? 1 : 0) != 0, (String)"No need to configure '%s'. %s", (Object)key, (Object)ignoredProperties.get(key));
        }
        HashMap<String, Object> config = new HashMap<String, Object>(currentConfig);
        config.putAll(updates);
        return config;
    }

    private KafkaIO() {
    }

    @VisibleForTesting
    static <T> NullableCoder<T> inferCoder(CoderRegistry coderRegistry, Class<? extends Deserializer<T>> deserializer) {
        Preconditions.checkNotNull(deserializer);
        for (Type type : deserializer.getGenericInterfaces()) {
            ParameterizedType parameterizedType;
            if (!(type instanceof ParameterizedType) || (parameterizedType = (ParameterizedType)type).getRawType() != Deserializer.class) continue;
            Type parameter = parameterizedType.getActualTypeArguments()[0];
            Class clazz = (Class)parameter;
            try {
                return NullableCoder.of((Coder)coderRegistry.getCoder(clazz));
            }
            catch (CannotProvideCoderException e) {
                throw new RuntimeException(String.format("Unable to automatically infer a Coder for the Kafka Deserializer %s: no coder registered for type %s", deserializer, clazz));
            }
        }
        throw new RuntimeException(String.format("Could not extract the Kafka Deserializer type from %s", deserializer));
    }

    private static Class resolveClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Could not find class: " + className);
        }
    }

    private static class NullOnlyCoder<T>
    extends AtomicCoder<T> {
        private NullOnlyCoder() {
        }

        public void encode(T value, OutputStream outStream) {
            Preconditions.checkArgument((value == null ? 1 : 0) != 0, (Object)"Can only encode nulls");
        }

        public T decode(InputStream inStream) {
            return null;
        }
    }

    private static class KafkaValueWrite<K, V>
    extends PTransform<PCollection<V>, PDone> {
        private final Write<K, V> kvWriteTransform;

        private KafkaValueWrite(Write<K, V> kvWriteTransform) {
            this.kvWriteTransform = kvWriteTransform;
        }

        public PDone expand(PCollection<V> input) {
            return (PDone)((PCollection)input.apply("Kafka values with default key", (PTransform)MapElements.via((SimpleFunction)new SimpleFunction<V, KV<K, V>>(){

                public KV<K, V> apply(V element) {
                    return KV.of(null, element);
                }
            }))).setCoder((Coder)KvCoder.of(new NullOnlyCoder(), (Coder)input.getCoder())).apply(this.kvWriteTransform);
        }

        public void populateDisplayData(DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            this.kvWriteTransform.populateDisplayData(builder);
        }
    }

    @AutoValue
    public static abstract class Write<K, V>
    extends PTransform<PCollection<KV<K, V>>, PDone> {
        @Nullable
        abstract String getTopic();

        abstract WriteRecords<K, V> getWriteRecordsTransform();

        abstract Builder<K, V> toBuilder();

        private Write<K, V> withWriteRecordsTransform(WriteRecords<K, V> transform) {
            return this.toBuilder().setWriteRecordsTransform(transform).build();
        }

        public Write<K, V> withBootstrapServers(String bootstrapServers) {
            return this.withWriteRecordsTransform(this.getWriteRecordsTransform().withBootstrapServers(bootstrapServers));
        }

        public Write<K, V> withTopic(String topic) {
            return this.toBuilder().setTopic(topic).setWriteRecordsTransform(this.getWriteRecordsTransform().withTopic(topic)).build();
        }

        public Write<K, V> withKeySerializer(Class<? extends Serializer<K>> keySerializer) {
            return this.withWriteRecordsTransform(this.getWriteRecordsTransform().withKeySerializer(keySerializer));
        }

        public Write<K, V> withValueSerializer(Class<? extends Serializer<V>> valueSerializer) {
            return this.withWriteRecordsTransform(this.getWriteRecordsTransform().withValueSerializer(valueSerializer));
        }

        public Write<K, V> withProducerFactoryFn(SerializableFunction<Map<String, Object>, Producer<K, V>> producerFactoryFn) {
            return this.withWriteRecordsTransform(this.getWriteRecordsTransform().withProducerFactoryFn(producerFactoryFn));
        }

        public Write<K, V> withInputTimestamp() {
            return this.withWriteRecordsTransform(this.getWriteRecordsTransform().withInputTimestamp());
        }

        @Deprecated
        public Write<K, V> withPublishTimestampFunction(KafkaPublishTimestampFunction<KV<K, V>> timestampFunction) {
            return this.withWriteRecordsTransform(this.getWriteRecordsTransform().withPublishTimestampFunction(new PublishTimestampFunctionKV<K, V>(timestampFunction)));
        }

        public Write<K, V> withEOS(int numShards, String sinkGroupId) {
            return this.withWriteRecordsTransform(this.getWriteRecordsTransform().withEOS(numShards, sinkGroupId));
        }

        public Write<K, V> withConsumerFactoryFn(SerializableFunction<Map<String, Object>, ? extends Consumer<?, ?>> consumerFactoryFn) {
            return this.withWriteRecordsTransform(this.getWriteRecordsTransform().withConsumerFactoryFn(consumerFactoryFn));
        }

        @Deprecated
        public Write<K, V> updateProducerProperties(Map<String, Object> configUpdates) {
            return this.withWriteRecordsTransform(this.getWriteRecordsTransform().updateProducerProperties(configUpdates));
        }

        public Write<K, V> withProducerConfigUpdates(Map<String, Object> configUpdates) {
            return this.withWriteRecordsTransform(this.getWriteRecordsTransform().withProducerConfigUpdates(configUpdates));
        }

        public PDone expand(PCollection<KV<K, V>> input) {
            Preconditions.checkArgument((this.getTopic() != null ? 1 : 0) != 0, (Object)"withTopic() is required");
            KvCoder kvCoder = (KvCoder)input.getCoder();
            return (PDone)((PCollection)input.apply("Kafka ProducerRecord", (PTransform)MapElements.via((SimpleFunction)new SimpleFunction<KV<K, V>, ProducerRecord<K, V>>(){

                public ProducerRecord<K, V> apply(KV<K, V> element) {
                    return new ProducerRecord(this.getTopic(), element.getKey(), element.getValue());
                }
            }))).setCoder(ProducerRecordCoder.of(kvCoder.getKeyCoder(), kvCoder.getValueCoder())).apply(this.getWriteRecordsTransform());
        }

        public void validate(PipelineOptions options) {
            this.getWriteRecordsTransform().validate(options);
        }

        public void populateDisplayData(DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            this.getWriteRecordsTransform().populateDisplayData(builder);
        }

        public PTransform<PCollection<V>, PDone> values() {
            return new KafkaValueWrite(this.withKeySerializer(StringSerializer.class));
        }

        private static class PublishTimestampFunctionKV<K, V>
        implements KafkaPublishTimestampFunction<ProducerRecord<K, V>> {
            private KafkaPublishTimestampFunction<KV<K, V>> fn;

            public PublishTimestampFunctionKV(KafkaPublishTimestampFunction<KV<K, V>> fn) {
                this.fn = fn;
            }

            @Override
            public Instant getTimestamp(ProducerRecord<K, V> e, Instant ts) {
                return this.fn.getTimestamp(KV.of((Object)e.key(), (Object)e.value()), ts);
            }
        }

        @Experimental
        public static class External
        implements ExternalTransformRegistrar {
            public static final String URN = "beam:external:java:kafka:write:v1";

            public Map<String, Class<? extends ExternalTransformBuilder>> knownBuilders() {
                return ImmutableMap.of((Object)URN, AutoValue_KafkaIO_Write.Builder.class);
            }

            public static class Configuration {
                private Iterable<KV<String, String>> producerConfig;
                private String topic;
                private String keySerializer;
                private String valueSerializer;

                public void setProducerConfig(Iterable<KV<String, String>> producerConfig) {
                    this.producerConfig = producerConfig;
                }

                public void setTopic(String topic) {
                    this.topic = topic;
                }

                public void setKeySerializer(String keySerializer) {
                    this.keySerializer = keySerializer;
                }

                public void setValueSerializer(String valueSerializer) {
                    this.valueSerializer = valueSerializer;
                }
            }
        }

        @Experimental
        @AutoValue.Builder
        static abstract class Builder<K, V>
        implements ExternalTransformBuilder<External.Configuration, PCollection<KV<K, V>>, PDone> {
            Builder() {
            }

            abstract Builder<K, V> setTopic(String var1);

            abstract Builder<K, V> setWriteRecordsTransform(WriteRecords<K, V> var1);

            abstract Write<K, V> build();

            public PTransform<PCollection<KV<K, V>>, PDone> buildExternal(External.Configuration configuration) {
                this.setTopic(configuration.topic);
                HashMap<String, Object> producerConfig = new HashMap<String, Object>();
                for (KV kv : configuration.producerConfig) {
                    producerConfig.put((String)kv.getKey(), kv.getValue());
                }
                Class keySerializer = KafkaIO.resolveClass(configuration.keySerializer);
                Class valSerializer = KafkaIO.resolveClass(configuration.valueSerializer);
                WriteRecords writeRecords = KafkaIO.writeRecords().withProducerConfigUpdates(producerConfig).withKeySerializer(keySerializer).withValueSerializer(valSerializer).withTopic(configuration.topic);
                this.setWriteRecordsTransform(writeRecords);
                return this.build();
            }
        }
    }

    @AutoValue
    public static abstract class WriteRecords<K, V>
    extends PTransform<PCollection<ProducerRecord<K, V>>, PDone> {
        private static final Map<String, Object> DEFAULT_PRODUCER_PROPERTIES = ImmutableMap.of((Object)"retries", (Object)3);
        private static final Map<String, String> IGNORED_PRODUCER_PROPERTIES = ImmutableMap.of((Object)"key.serializer", (Object)"Use withKeySerializer instead", (Object)"value.serializer", (Object)"Use withValueSerializer instead");

        @Nullable
        abstract String getTopic();

        abstract Map<String, Object> getProducerConfig();

        @Nullable
        abstract SerializableFunction<Map<String, Object>, Producer<K, V>> getProducerFactoryFn();

        @Nullable
        abstract Class<? extends Serializer<K>> getKeySerializer();

        @Nullable
        abstract Class<? extends Serializer<V>> getValueSerializer();

        @Nullable
        abstract KafkaPublishTimestampFunction<ProducerRecord<K, V>> getPublishTimestampFunction();

        abstract boolean isEOS();

        @Nullable
        abstract String getSinkGroupId();

        abstract int getNumShards();

        @Nullable
        abstract SerializableFunction<Map<String, Object>, ? extends Consumer<?, ?>> getConsumerFactoryFn();

        abstract Builder<K, V> toBuilder();

        public WriteRecords<K, V> withBootstrapServers(String bootstrapServers) {
            return this.withProducerConfigUpdates((Map<String, Object>)ImmutableMap.of((Object)"bootstrap.servers", (Object)bootstrapServers));
        }

        public WriteRecords<K, V> withTopic(String topic) {
            return this.toBuilder().setTopic(topic).build();
        }

        public WriteRecords<K, V> withKeySerializer(Class<? extends Serializer<K>> keySerializer) {
            return this.toBuilder().setKeySerializer(keySerializer).build();
        }

        public WriteRecords<K, V> withValueSerializer(Class<? extends Serializer<V>> valueSerializer) {
            return this.toBuilder().setValueSerializer(valueSerializer).build();
        }

        @Deprecated
        public WriteRecords<K, V> updateProducerProperties(Map<String, Object> configUpdates) {
            Map config = KafkaIO.updateKafkaProperties(this.getProducerConfig(), WriteRecords.IGNORED_PRODUCER_PROPERTIES, configUpdates);
            return this.toBuilder().setProducerConfig(config).build();
        }

        public WriteRecords<K, V> withProducerConfigUpdates(Map<String, Object> configUpdates) {
            Map config = KafkaIO.updateKafkaProperties(this.getProducerConfig(), WriteRecords.IGNORED_PRODUCER_PROPERTIES, configUpdates);
            return this.toBuilder().setProducerConfig(config).build();
        }

        public WriteRecords<K, V> withProducerFactoryFn(SerializableFunction<Map<String, Object>, Producer<K, V>> producerFactoryFn) {
            return this.toBuilder().setProducerFactoryFn(producerFactoryFn).build();
        }

        public WriteRecords<K, V> withInputTimestamp() {
            return this.withPublishTimestampFunction(KafkaPublishTimestampFunction.withElementTimestamp());
        }

        @Deprecated
        public WriteRecords<K, V> withPublishTimestampFunction(KafkaPublishTimestampFunction<ProducerRecord<K, V>> timestampFunction) {
            return this.toBuilder().setPublishTimestampFunction(timestampFunction).build();
        }

        public WriteRecords<K, V> withEOS(int numShards, String sinkGroupId) {
            KafkaExactlyOnceSink.ensureEOSSupport();
            Preconditions.checkArgument((numShards >= 1 ? 1 : 0) != 0, (Object)"numShards should be >= 1");
            Preconditions.checkArgument((sinkGroupId != null ? 1 : 0) != 0, (Object)"sinkGroupId is required for exactly-once sink");
            return this.toBuilder().setEOS(true).setNumShards(numShards).setSinkGroupId(sinkGroupId).build();
        }

        public WriteRecords<K, V> withConsumerFactoryFn(SerializableFunction<Map<String, Object>, ? extends Consumer<?, ?>> consumerFactoryFn) {
            return this.toBuilder().setConsumerFactoryFn(consumerFactoryFn).build();
        }

        public PDone expand(PCollection<ProducerRecord<K, V>> input) {
            Preconditions.checkArgument((this.getProducerConfig().get("bootstrap.servers") != null ? 1 : 0) != 0, (Object)"withBootstrapServers() is required");
            Preconditions.checkArgument((this.getKeySerializer() != null ? 1 : 0) != 0, (Object)"withKeySerializer() is required");
            Preconditions.checkArgument((this.getValueSerializer() != null ? 1 : 0) != 0, (Object)"withValueSerializer() is required");
            if (this.isEOS()) {
                Preconditions.checkArgument((this.getTopic() != null ? 1 : 0) != 0, (Object)"withTopic() is required when isEOS() is true");
                KafkaExactlyOnceSink.ensureEOSSupport();
                input.apply(new KafkaExactlyOnceSink(this));
            } else {
                input.apply((PTransform)ParDo.of(new KafkaWriter(this)));
            }
            return PDone.in((Pipeline)input.getPipeline());
        }

        public void validate(PipelineOptions options) {
            if (this.isEOS()) {
                String runner = options.getRunner().getName();
                if ("org.apache.beam.runners.direct.DirectRunner".equals(runner) || runner.startsWith("org.apache.beam.runners.dataflow.") || runner.startsWith("org.apache.beam.runners.spark.") || runner.startsWith("org.apache.beam.runners.flink.")) {
                    return;
                }
                throw new UnsupportedOperationException(runner + " is not whitelisted among runners compatible with Kafka exactly-once sink. This implementation of exactly-once sink relies on specific checkpoint guarantees. Only the runners with known to have compatible checkpoint semantics are whitelisted.");
            }
        }

        public void populateDisplayData(DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.addIfNotNull(DisplayData.item((String)"topic", (String)this.getTopic()).withLabel("Topic"));
            Set<String> ignoredProducerPropertiesKeys = IGNORED_PRODUCER_PROPERTIES.keySet();
            for (Map.Entry<String, Object> conf : this.getProducerConfig().entrySet()) {
                String key = conf.getKey();
                if (ignoredProducerPropertiesKeys.contains(key)) continue;
                Object value = DisplayData.inferType((Object)conf.getValue()) != null ? conf.getValue() : String.valueOf(conf.getValue());
                builder.add(DisplayData.item((String)key, (ValueProvider)ValueProvider.StaticValueProvider.of((Object)value)));
            }
        }

        @AutoValue.Builder
        static abstract class Builder<K, V> {
            Builder() {
            }

            abstract Builder<K, V> setTopic(String var1);

            abstract Builder<K, V> setProducerConfig(Map<String, Object> var1);

            abstract Builder<K, V> setProducerFactoryFn(SerializableFunction<Map<String, Object>, Producer<K, V>> var1);

            abstract Builder<K, V> setKeySerializer(Class<? extends Serializer<K>> var1);

            abstract Builder<K, V> setValueSerializer(Class<? extends Serializer<V>> var1);

            abstract Builder<K, V> setPublishTimestampFunction(KafkaPublishTimestampFunction<ProducerRecord<K, V>> var1);

            abstract Builder<K, V> setEOS(boolean var1);

            abstract Builder<K, V> setSinkGroupId(String var1);

            abstract Builder<K, V> setNumShards(int var1);

            abstract Builder<K, V> setConsumerFactoryFn(SerializableFunction<Map<String, Object>, ? extends Consumer<?, ?>> var1);

            abstract WriteRecords<K, V> build();
        }
    }

    public static class TypedWithoutMetadata<K, V>
    extends PTransform<PBegin, PCollection<KV<K, V>>> {
        private final Read<K, V> read;

        TypedWithoutMetadata(Read<K, V> read) {
            super("KafkaIO.Read");
            this.read = read;
        }

        public PCollection<KV<K, V>> expand(PBegin begin) {
            return (PCollection)((PCollection)begin.apply(this.read)).apply("Remove Kafka Metadata", (PTransform)ParDo.of((DoFn)new DoFn<KafkaRecord<K, V>, KV<K, V>>(){

                @DoFn.ProcessElement
                public void processElement(DoFn.ProcessContext ctx) {
                    ctx.output(((KafkaRecord)ctx.element()).getKV());
                }
            }));
        }

        public void populateDisplayData(DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            this.read.populateDisplayData(builder);
        }
    }

    @AutoValue
    public static abstract class Read<K, V>
    extends PTransform<PBegin, PCollection<KafkaRecord<K, V>>> {
        private static final Map<String, String> IGNORED_CONSUMER_PROPERTIES = ImmutableMap.of((Object)"key.deserializer", (Object)"Set keyDeserializer instead", (Object)"value.deserializer", (Object)"Set valueDeserializer instead");
        private static final Map<String, Object> DEFAULT_CONSUMER_PROPERTIES = ImmutableMap.of((Object)"key.deserializer", (Object)ByteArrayDeserializer.class.getName(), (Object)"value.deserializer", (Object)ByteArrayDeserializer.class.getName(), (Object)"receive.buffer.bytes", (Object)524288, (Object)"auto.offset.reset", (Object)"latest", (Object)"enable.auto.commit", (Object)false);
        private static final SerializableFunction<Map<String, Object>, Consumer<byte[], byte[]>> KAFKA_CONSUMER_FACTORY_FN = KafkaConsumer::new;

        abstract Map<String, Object> getConsumerConfig();

        abstract List<String> getTopics();

        abstract List<TopicPartition> getTopicPartitions();

        @Nullable
        abstract Coder<K> getKeyCoder();

        @Nullable
        abstract Coder<V> getValueCoder();

        @Nullable
        abstract Class<? extends Deserializer<K>> getKeyDeserializer();

        @Nullable
        abstract Class<? extends Deserializer<V>> getValueDeserializer();

        abstract SerializableFunction<Map<String, Object>, Consumer<byte[], byte[]>> getConsumerFactoryFn();

        @Nullable
        abstract SerializableFunction<KafkaRecord<K, V>, Instant> getWatermarkFn();

        abstract long getMaxNumRecords();

        @Nullable
        abstract Duration getMaxReadTime();

        @Nullable
        abstract Instant getStartReadTime();

        abstract boolean isCommitOffsetsInFinalizeEnabled();

        abstract TimestampPolicyFactory<K, V> getTimestampPolicyFactory();

        @Nullable
        abstract Map<String, Object> getOffsetConsumerConfig();

        abstract Builder<K, V> toBuilder();

        public Read<K, V> withBootstrapServers(String bootstrapServers) {
            return this.withConsumerConfigUpdates((Map<String, Object>)ImmutableMap.of((Object)"bootstrap.servers", (Object)bootstrapServers));
        }

        public Read<K, V> withTopic(String topic) {
            return this.withTopics((List<String>)ImmutableList.of((Object)topic));
        }

        public Read<K, V> withTopics(List<String> topics) {
            Preconditions.checkState((boolean)this.getTopicPartitions().isEmpty(), (Object)"Only topics or topicPartitions can be set, not both");
            return this.toBuilder().setTopics((List<String>)ImmutableList.copyOf(topics)).build();
        }

        public Read<K, V> withTopicPartitions(List<TopicPartition> topicPartitions) {
            Preconditions.checkState((boolean)this.getTopics().isEmpty(), (Object)"Only topics or topicPartitions can be set, not both");
            return this.toBuilder().setTopicPartitions((List<TopicPartition>)ImmutableList.copyOf(topicPartitions)).build();
        }

        public Read<K, V> withKeyDeserializer(Class<? extends Deserializer<K>> keyDeserializer) {
            return this.toBuilder().setKeyDeserializer(keyDeserializer).build();
        }

        public Read<K, V> withKeyDeserializerAndCoder(Class<? extends Deserializer<K>> keyDeserializer, Coder<K> keyCoder) {
            return this.toBuilder().setKeyDeserializer(keyDeserializer).setKeyCoder(keyCoder).build();
        }

        public Read<K, V> withValueDeserializer(Class<? extends Deserializer<V>> valueDeserializer) {
            return this.toBuilder().setValueDeserializer(valueDeserializer).build();
        }

        public Read<K, V> withValueDeserializerAndCoder(Class<? extends Deserializer<V>> valueDeserializer, Coder<V> valueCoder) {
            return this.toBuilder().setValueDeserializer(valueDeserializer).setValueCoder(valueCoder).build();
        }

        public Read<K, V> withConsumerFactoryFn(SerializableFunction<Map<String, Object>, Consumer<byte[], byte[]>> consumerFactoryFn) {
            return this.toBuilder().setConsumerFactoryFn(consumerFactoryFn).build();
        }

        @Deprecated
        public Read<K, V> updateConsumerProperties(Map<String, Object> configUpdates) {
            Map config = KafkaIO.updateKafkaProperties(this.getConsumerConfig(), Read.IGNORED_CONSUMER_PROPERTIES, configUpdates);
            return this.toBuilder().setConsumerConfig(config).build();
        }

        public Read<K, V> withMaxNumRecords(long maxNumRecords) {
            return this.toBuilder().setMaxNumRecords(maxNumRecords).build();
        }

        public Read<K, V> withStartReadTime(Instant startReadTime) {
            return this.toBuilder().setStartReadTime(startReadTime).build();
        }

        public Read<K, V> withMaxReadTime(Duration maxReadTime) {
            return this.toBuilder().setMaxReadTime(maxReadTime).build();
        }

        public Read<K, V> withLogAppendTime() {
            return this.withTimestampPolicyFactory(TimestampPolicyFactory.withLogAppendTime());
        }

        public Read<K, V> withProcessingTime() {
            return this.withTimestampPolicyFactory(TimestampPolicyFactory.withProcessingTime());
        }

        public Read<K, V> withCreateTime(Duration maxDelay) {
            return this.withTimestampPolicyFactory(TimestampPolicyFactory.withCreateTime(maxDelay));
        }

        public Read<K, V> withTimestampPolicyFactory(TimestampPolicyFactory<K, V> timestampPolicyFactory) {
            return this.toBuilder().setTimestampPolicyFactory(timestampPolicyFactory).build();
        }

        @Deprecated
        public Read<K, V> withTimestampFn2(SerializableFunction<KafkaRecord<K, V>, Instant> timestampFn) {
            Preconditions.checkArgument((timestampFn != null ? 1 : 0) != 0, (Object)"timestampFn can not be null");
            return this.toBuilder().setTimestampPolicyFactory(TimestampPolicyFactory.withTimestampFn(timestampFn)).build();
        }

        @Deprecated
        public Read<K, V> withWatermarkFn2(SerializableFunction<KafkaRecord<K, V>, Instant> watermarkFn) {
            Preconditions.checkArgument((watermarkFn != null ? 1 : 0) != 0, (Object)"watermarkFn can not be null");
            return this.toBuilder().setWatermarkFn(watermarkFn).build();
        }

        @Deprecated
        public Read<K, V> withTimestampFn(SerializableFunction<KV<K, V>, Instant> timestampFn) {
            Preconditions.checkArgument((timestampFn != null ? 1 : 0) != 0, (Object)"timestampFn can not be null");
            return this.withTimestampFn2(Read.unwrapKafkaAndThen(timestampFn));
        }

        @Deprecated
        public Read<K, V> withWatermarkFn(SerializableFunction<KV<K, V>, Instant> watermarkFn) {
            Preconditions.checkArgument((watermarkFn != null ? 1 : 0) != 0, (Object)"watermarkFn can not be null");
            return this.withWatermarkFn2(Read.unwrapKafkaAndThen(watermarkFn));
        }

        public Read<K, V> withReadCommitted() {
            return this.withConsumerConfigUpdates((Map<String, Object>)ImmutableMap.of((Object)"isolation.level", (Object)"read_committed"));
        }

        public Read<K, V> commitOffsetsInFinalize() {
            return this.toBuilder().setCommitOffsetsInFinalizeEnabled(true).build();
        }

        public Read<K, V> withOffsetConsumerConfigOverrides(Map<String, Object> offsetConsumerConfig) {
            return this.toBuilder().setOffsetConsumerConfig(offsetConsumerConfig).build();
        }

        public Read<K, V> withConsumerConfigUpdates(Map<String, Object> configUpdates) {
            Map config = KafkaIO.updateKafkaProperties(this.getConsumerConfig(), Read.IGNORED_CONSUMER_PROPERTIES, configUpdates);
            return this.toBuilder().setConsumerConfig(config).build();
        }

        public PTransform<PBegin, PCollection<KV<K, V>>> withoutMetadata() {
            return new TypedWithoutMetadata(this);
        }

        public PCollection<KafkaRecord<K, V>> expand(PBegin input) {
            Read.Unbounded unbounded;
            Preconditions.checkArgument((this.getConsumerConfig().get("bootstrap.servers") != null ? 1 : 0) != 0, (Object)"withBootstrapServers() is required");
            Preconditions.checkArgument((this.getTopics().size() > 0 || this.getTopicPartitions().size() > 0 ? 1 : 0) != 0, (Object)"Either withTopic(), withTopics() or withTopicPartitions() is required");
            Preconditions.checkArgument((this.getKeyDeserializer() != null ? 1 : 0) != 0, (Object)"withKeyDeserializer() is required");
            Preconditions.checkArgument((this.getValueDeserializer() != null ? 1 : 0) != 0, (Object)"withValueDeserializer() is required");
            ConsumerSpEL consumerSpEL = new ConsumerSpEL();
            if (!consumerSpEL.hasOffsetsForTimes()) {
                LOG.warn("Kafka client version {} is too old. Versions before 0.10.1.0 are deprecated and may not be supported in next release of Apache Beam. Please upgrade your Kafka client version.", (Object)AppInfoParser.getVersion());
            }
            if (this.getStartReadTime() != null) {
                Preconditions.checkArgument((boolean)consumerSpEL.hasOffsetsForTimes(), (Object)("Consumer.offsetsForTimes is only supported by Kafka Client 0.10.1.0 onwards, current version of Kafka Client is " + AppInfoParser.getVersion() + ". If you are building with maven, set \"kafka.clients.version\" maven property to 0.10.1.0 or newer."));
            }
            if (this.isCommitOffsetsInFinalizeEnabled()) {
                Preconditions.checkArgument((this.getConsumerConfig().get("group.id") != null ? 1 : 0) != 0, (Object)"commitOffsetsInFinalize() is enabled, but group.id in Kafka consumer config is not set. Offset management requires group.id.");
                if (Boolean.TRUE.equals(this.getConsumerConfig().get("enable.auto.commit"))) {
                    LOG.warn("'{}' in consumer config is enabled even though commitOffsetsInFinalize() is set. You need only one of them.", (Object)"enable.auto.commit");
                }
            }
            CoderRegistry registry = input.getPipeline().getCoderRegistry();
            Coder<K> keyCoder = this.getKeyCoder() != null ? this.getKeyCoder() : KafkaIO.inferCoder(registry, this.getKeyDeserializer());
            Preconditions.checkArgument((keyCoder != null ? 1 : 0) != 0, (Object)"Key coder could not be inferred from key deserializer. Please providekey coder explicitly using withKeyDeserializerAndCoder()");
            Coder<V> valueCoder = this.getValueCoder() != null ? this.getValueCoder() : KafkaIO.inferCoder(registry, this.getValueDeserializer());
            Preconditions.checkArgument((valueCoder != null ? 1 : 0) != 0, (Object)"Value coder could not be inferred from value deserializer. Please providevalue coder explicitly using withValueDeserializerAndCoder()");
            Read.Unbounded transform = unbounded = org.apache.beam.sdk.io.Read.from(this.toBuilder().setKeyCoder(keyCoder).setValueCoder(valueCoder).build().makeSource());
            if (this.getMaxNumRecords() < Long.MAX_VALUE || this.getMaxReadTime() != null) {
                transform = unbounded.withMaxReadTime(this.getMaxReadTime()).withMaxNumRecords(this.getMaxNumRecords());
            }
            return (PCollection)input.getPipeline().apply((PTransform)transform);
        }

        @VisibleForTesting
        UnboundedSource<KafkaRecord<K, V>, KafkaCheckpointMark> makeSource() {
            return new KafkaUnboundedSource(this, -1);
        }

        private static <KeyT, ValueT, OutT> SerializableFunction<KafkaRecord<KeyT, ValueT>, OutT> unwrapKafkaAndThen(SerializableFunction<KV<KeyT, ValueT>, OutT> fn) {
            return (SerializableFunction & Serializable)record -> fn.apply(record.getKV());
        }

        public void populateDisplayData(DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            List<String> topics = this.getTopics();
            List<TopicPartition> topicPartitions = this.getTopicPartitions();
            if (topics.size() > 0) {
                builder.add(DisplayData.item((String)"topics", (String)Joiner.on((String)",").join(topics)).withLabel("Topic/s"));
            } else if (topicPartitions.size() > 0) {
                builder.add(DisplayData.item((String)"topicPartitions", (String)Joiner.on((String)",").join(topicPartitions)).withLabel("Topic Partition/s"));
            }
            Set<String> ignoredConsumerPropertiesKeys = IGNORED_CONSUMER_PROPERTIES.keySet();
            for (Map.Entry<String, Object> conf : this.getConsumerConfig().entrySet()) {
                String key = conf.getKey();
                if (ignoredConsumerPropertiesKeys.contains(key)) continue;
                Object value = DisplayData.inferType((Object)conf.getValue()) != null ? conf.getValue() : String.valueOf(conf.getValue());
                builder.add(DisplayData.item((String)key, (ValueProvider)ValueProvider.StaticValueProvider.of((Object)value)));
            }
        }

        @Experimental
        public static class External
        implements ExternalTransformRegistrar {
            public static final String URN = "beam:external:java:kafka:read:v1";

            public Map<String, Class<? extends ExternalTransformBuilder>> knownBuilders() {
                return ImmutableMap.of((Object)URN, AutoValue_KafkaIO_Read.Builder.class);
            }

            public static class Configuration {
                private Iterable<KV<String, String>> consumerConfig;
                private Iterable<String> topics;
                private String keyDeserializer;
                private String valueDeserializer;

                public void setConsumerConfig(Iterable<KV<String, String>> consumerConfig) {
                    this.consumerConfig = consumerConfig;
                }

                public void setTopics(Iterable<String> topics) {
                    this.topics = topics;
                }

                public void setKeyDeserializer(String keyDeserializer) {
                    this.keyDeserializer = keyDeserializer;
                }

                public void setValueDeserializer(String valueDeserializer) {
                    this.valueDeserializer = valueDeserializer;
                }
            }
        }

        @Experimental
        @AutoValue.Builder
        static abstract class Builder<K, V>
        implements ExternalTransformBuilder<External.Configuration, PBegin, PCollection<KV<K, V>>> {
            Builder() {
            }

            abstract Builder<K, V> setConsumerConfig(Map<String, Object> var1);

            abstract Builder<K, V> setTopics(List<String> var1);

            abstract Builder<K, V> setTopicPartitions(List<TopicPartition> var1);

            abstract Builder<K, V> setKeyCoder(Coder<K> var1);

            abstract Builder<K, V> setValueCoder(Coder<V> var1);

            abstract Builder<K, V> setKeyDeserializer(Class<? extends Deserializer<K>> var1);

            abstract Builder<K, V> setValueDeserializer(Class<? extends Deserializer<V>> var1);

            abstract Builder<K, V> setConsumerFactoryFn(SerializableFunction<Map<String, Object>, Consumer<byte[], byte[]>> var1);

            abstract Builder<K, V> setWatermarkFn(SerializableFunction<KafkaRecord<K, V>, Instant> var1);

            abstract Builder<K, V> setMaxNumRecords(long var1);

            abstract Builder<K, V> setMaxReadTime(Duration var1);

            abstract Builder<K, V> setStartReadTime(Instant var1);

            abstract Builder<K, V> setCommitOffsetsInFinalizeEnabled(boolean var1);

            abstract Builder<K, V> setTimestampPolicyFactory(TimestampPolicyFactory<K, V> var1);

            abstract Builder<K, V> setOffsetConsumerConfig(Map<String, Object> var1);

            abstract Read<K, V> build();

            public PTransform<PBegin, PCollection<KV<K, V>>> buildExternal(External.Configuration config) {
                ImmutableList.Builder listBuilder = ImmutableList.builder();
                for (String topic : config.topics) {
                    listBuilder.add((Object)topic);
                }
                this.setTopics((List<String>)listBuilder.build());
                Class keyDeserializer = KafkaIO.resolveClass(config.keyDeserializer);
                this.setKeyDeserializer(keyDeserializer);
                this.setKeyCoder(Builder.resolveCoder(keyDeserializer));
                Class valueDeserializer = KafkaIO.resolveClass(config.valueDeserializer);
                this.setValueDeserializer(valueDeserializer);
                this.setValueCoder(Builder.resolveCoder(valueDeserializer));
                HashMap<String, Object> consumerConfig = new HashMap<String, Object>();
                for (KV kv : config.consumerConfig) {
                    consumerConfig.put((String)kv.getKey(), kv.getValue());
                }
                consumerConfig.put("key.deserializer", keyDeserializer.getName());
                consumerConfig.put("value.deserializer", valueDeserializer.getName());
                this.setConsumerConfig(consumerConfig);
                this.setTopicPartitions(Collections.emptyList());
                this.setConsumerFactoryFn((SerializableFunction<Map<String, Object>, Consumer<byte[], byte[]>>)KAFKA_CONSUMER_FACTORY_FN);
                this.setMaxNumRecords(Long.MAX_VALUE);
                this.setCommitOffsetsInFinalizeEnabled(false);
                this.setTimestampPolicyFactory(TimestampPolicyFactory.withProcessingTime());
                return this.build().withoutMetadata();
            }

            private static Coder resolveCoder(Class deserializer) {
                for (Method method : deserializer.getDeclaredMethods()) {
                    Class<?> returnType;
                    if (!method.getName().equals("deserialize") || (returnType = method.getReturnType()).equals(Object.class)) continue;
                    if (returnType.equals(byte[].class)) {
                        return ByteArrayCoder.of();
                    }
                    if (returnType.equals(Integer.class)) {
                        return VarIntCoder.of();
                    }
                    if (returnType.equals(Long.class)) {
                        return VarLongCoder.of();
                    }
                    throw new RuntimeException("Couldn't infer Coder from " + deserializer);
                }
                throw new RuntimeException("Couldn't resolve coder for Deserializer: " + deserializer);
            }
        }
    }
}

