/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.kafka;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.AuthorizationException;

class ProducerSpEL {
    private static boolean supportsTransactions;
    private static Method initTransactionsMethod;
    private static Method beginTransactionMethod;
    private static Method commitTransactionMethod;
    private static Method abortTransactionMethod;
    private static Method sendOffsetsToTransactionMethod;
    static final String ENABLE_IDEMPOTENCE_CONFIG = "enable.idempotence";
    static final String TRANSACTIONAL_ID_CONFIG = "transactional.id";
    private static Class<?> producerFencedExceptionClass;
    private static Class<?> outOfOrderSequenceExceptionClass;

    ProducerSpEL() {
    }

    static boolean supportsTransactions() {
        return supportsTransactions;
    }

    private static void ensureTransactionsSupport() {
        Preconditions.checkArgument((boolean)ProducerSpEL.supportsTransactions(), (String)"This version of Kafka client library does not support transactions. ", (Object)"Please used version 0.11 or later.");
    }

    private static void invoke(Method method, Object obj, Object ... args) {
        try {
            method.invoke(obj, args);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (ApiException e) {
            Class<?> eClass = ((Object)((Object)e)).getClass();
            if (producerFencedExceptionClass.isAssignableFrom(eClass) || outOfOrderSequenceExceptionClass.isAssignableFrom(eClass) || AuthorizationException.class.isAssignableFrom(eClass)) {
                throw new UnrecoverableProducerException(e);
            }
            throw e;
        }
    }

    static void initTransactions(Producer<?, ?> producer) {
        ProducerSpEL.ensureTransactionsSupport();
        ProducerSpEL.invoke(initTransactionsMethod, producer, new Object[0]);
    }

    static void beginTransaction(Producer<?, ?> producer) {
        ProducerSpEL.ensureTransactionsSupport();
        ProducerSpEL.invoke(beginTransactionMethod, producer, new Object[0]);
    }

    static void commitTransaction(Producer<?, ?> producer) {
        ProducerSpEL.ensureTransactionsSupport();
        ProducerSpEL.invoke(commitTransactionMethod, producer, new Object[0]);
    }

    static void abortTransaction(Producer<?, ?> producer) {
        ProducerSpEL.ensureTransactionsSupport();
        ProducerSpEL.invoke(abortTransactionMethod, producer, new Object[0]);
    }

    static void sendOffsetsToTransaction(Producer<?, ?> producer, Map<TopicPartition, OffsetAndMetadata> offsets, String consumerGroupId) {
        ProducerSpEL.ensureTransactionsSupport();
        ProducerSpEL.invoke(sendOffsetsToTransactionMethod, producer, offsets, consumerGroupId);
    }

    static {
        try {
            initTransactionsMethod = Producer.class.getMethod("initTransactions", new Class[0]);
            beginTransactionMethod = Producer.class.getMethod("beginTransaction", new Class[0]);
            commitTransactionMethod = Producer.class.getMethod("commitTransaction", new Class[0]);
            abortTransactionMethod = Producer.class.getMethod("abortTransaction", new Class[0]);
            sendOffsetsToTransactionMethod = Producer.class.getMethod("sendOffsetsToTransaction", Map.class, String.class);
            producerFencedExceptionClass = Class.forName("org.apache.kafka.common.errors.ProducerFencedException");
            outOfOrderSequenceExceptionClass = Class.forName("org.apache.kafka.common.errors.OutOfOrderSequenceException");
            supportsTransactions = true;
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            supportsTransactions = false;
        }
    }

    static class UnrecoverableProducerException
    extends ApiException {
        UnrecoverableProducerException(ApiException cause) {
            super((Throwable)cause);
        }
    }
}

