/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.kafka;

import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.kafka.KafkaIO;
import org.apache.beam.sdk.io.kafka.KafkaRecord;
import org.apache.beam.sdk.io.kafka.TimestampPolicyFactory;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.serialization.Deserializer;
import org.joda.time.Duration;
import org.joda.time.Instant;

final class AutoValue_KafkaIO_Read<K, V>
extends KafkaIO.Read<K, V> {
    private final Map<String, Object> consumerConfig;
    private final List<String> topics;
    private final List<TopicPartition> topicPartitions;
    private final Coder<K> keyCoder;
    private final Coder<V> valueCoder;
    private final Class<? extends Deserializer<K>> keyDeserializer;
    private final Class<? extends Deserializer<V>> valueDeserializer;
    private final SerializableFunction<Map<String, Object>, Consumer<byte[], byte[]>> consumerFactoryFn;
    private final SerializableFunction<KafkaRecord<K, V>, Instant> watermarkFn;
    private final long maxNumRecords;
    private final Duration maxReadTime;
    private final Instant startReadTime;
    private final boolean commitOffsetsInFinalizeEnabled;
    private final TimestampPolicyFactory<K, V> timestampPolicyFactory;

    private AutoValue_KafkaIO_Read(Map<String, Object> consumerConfig, List<String> topics, List<TopicPartition> topicPartitions, @Nullable Coder<K> keyCoder, @Nullable Coder<V> valueCoder, @Nullable Class<? extends Deserializer<K>> keyDeserializer, @Nullable Class<? extends Deserializer<V>> valueDeserializer, SerializableFunction<Map<String, Object>, Consumer<byte[], byte[]>> consumerFactoryFn, @Nullable SerializableFunction<KafkaRecord<K, V>, Instant> watermarkFn, long maxNumRecords, @Nullable Duration maxReadTime, @Nullable Instant startReadTime, boolean commitOffsetsInFinalizeEnabled, TimestampPolicyFactory<K, V> timestampPolicyFactory) {
        this.consumerConfig = consumerConfig;
        this.topics = topics;
        this.topicPartitions = topicPartitions;
        this.keyCoder = keyCoder;
        this.valueCoder = valueCoder;
        this.keyDeserializer = keyDeserializer;
        this.valueDeserializer = valueDeserializer;
        this.consumerFactoryFn = consumerFactoryFn;
        this.watermarkFn = watermarkFn;
        this.maxNumRecords = maxNumRecords;
        this.maxReadTime = maxReadTime;
        this.startReadTime = startReadTime;
        this.commitOffsetsInFinalizeEnabled = commitOffsetsInFinalizeEnabled;
        this.timestampPolicyFactory = timestampPolicyFactory;
    }

    @Override
    Map<String, Object> getConsumerConfig() {
        return this.consumerConfig;
    }

    @Override
    List<String> getTopics() {
        return this.topics;
    }

    @Override
    List<TopicPartition> getTopicPartitions() {
        return this.topicPartitions;
    }

    @Override
    @Nullable
    Coder<K> getKeyCoder() {
        return this.keyCoder;
    }

    @Override
    @Nullable
    Coder<V> getValueCoder() {
        return this.valueCoder;
    }

    @Override
    @Nullable
    Class<? extends Deserializer<K>> getKeyDeserializer() {
        return this.keyDeserializer;
    }

    @Override
    @Nullable
    Class<? extends Deserializer<V>> getValueDeserializer() {
        return this.valueDeserializer;
    }

    @Override
    SerializableFunction<Map<String, Object>, Consumer<byte[], byte[]>> getConsumerFactoryFn() {
        return this.consumerFactoryFn;
    }

    @Override
    @Nullable
    SerializableFunction<KafkaRecord<K, V>, Instant> getWatermarkFn() {
        return this.watermarkFn;
    }

    @Override
    long getMaxNumRecords() {
        return this.maxNumRecords;
    }

    @Override
    @Nullable
    Duration getMaxReadTime() {
        return this.maxReadTime;
    }

    @Override
    @Nullable
    Instant getStartReadTime() {
        return this.startReadTime;
    }

    @Override
    boolean isCommitOffsetsInFinalizeEnabled() {
        return this.commitOffsetsInFinalizeEnabled;
    }

    @Override
    TimestampPolicyFactory<K, V> getTimestampPolicyFactory() {
        return this.timestampPolicyFactory;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof KafkaIO.Read) {
            KafkaIO.Read that = (KafkaIO.Read)((Object)o);
            return this.consumerConfig.equals(that.getConsumerConfig()) && this.topics.equals(that.getTopics()) && this.topicPartitions.equals(that.getTopicPartitions()) && (this.keyCoder == null ? that.getKeyCoder() == null : this.keyCoder.equals(that.getKeyCoder())) && (this.valueCoder == null ? that.getValueCoder() == null : this.valueCoder.equals(that.getValueCoder())) && (this.keyDeserializer == null ? that.getKeyDeserializer() == null : this.keyDeserializer.equals(that.getKeyDeserializer())) && (this.valueDeserializer == null ? that.getValueDeserializer() == null : this.valueDeserializer.equals(that.getValueDeserializer())) && this.consumerFactoryFn.equals(that.getConsumerFactoryFn()) && (this.watermarkFn == null ? that.getWatermarkFn() == null : this.watermarkFn.equals(that.getWatermarkFn())) && this.maxNumRecords == that.getMaxNumRecords() && (this.maxReadTime == null ? that.getMaxReadTime() == null : this.maxReadTime.equals((Object)that.getMaxReadTime())) && (this.startReadTime == null ? that.getStartReadTime() == null : this.startReadTime.equals((Object)that.getStartReadTime())) && this.commitOffsetsInFinalizeEnabled == that.isCommitOffsetsInFinalizeEnabled() && this.timestampPolicyFactory.equals(that.getTimestampPolicyFactory());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.consumerConfig.hashCode();
        h$ *= 1000003;
        h$ ^= this.topics.hashCode();
        h$ *= 1000003;
        h$ ^= this.topicPartitions.hashCode();
        h$ *= 1000003;
        h$ ^= this.keyCoder == null ? 0 : this.keyCoder.hashCode();
        h$ *= 1000003;
        h$ ^= this.valueCoder == null ? 0 : this.valueCoder.hashCode();
        h$ *= 1000003;
        h$ ^= this.keyDeserializer == null ? 0 : this.keyDeserializer.hashCode();
        h$ *= 1000003;
        h$ ^= this.valueDeserializer == null ? 0 : this.valueDeserializer.hashCode();
        h$ *= 1000003;
        h$ ^= this.consumerFactoryFn.hashCode();
        h$ *= 1000003;
        h$ ^= this.watermarkFn == null ? 0 : this.watermarkFn.hashCode();
        h$ *= 1000003;
        h$ ^= (int)(this.maxNumRecords >>> 32 ^ this.maxNumRecords);
        h$ *= 1000003;
        h$ ^= this.maxReadTime == null ? 0 : this.maxReadTime.hashCode();
        h$ *= 1000003;
        h$ ^= this.startReadTime == null ? 0 : this.startReadTime.hashCode();
        h$ *= 1000003;
        h$ ^= this.commitOffsetsInFinalizeEnabled ? 1231 : 1237;
        h$ *= 1000003;
        return h$ ^= this.timestampPolicyFactory.hashCode();
    }

    @Override
    KafkaIO.Read.Builder<K, V> toBuilder() {
        return new Builder(this);
    }

    static final class Builder<K, V>
    extends KafkaIO.Read.Builder<K, V> {
        private Map<String, Object> consumerConfig;
        private List<String> topics;
        private List<TopicPartition> topicPartitions;
        private Coder<K> keyCoder;
        private Coder<V> valueCoder;
        private Class<? extends Deserializer<K>> keyDeserializer;
        private Class<? extends Deserializer<V>> valueDeserializer;
        private SerializableFunction<Map<String, Object>, Consumer<byte[], byte[]>> consumerFactoryFn;
        private SerializableFunction<KafkaRecord<K, V>, Instant> watermarkFn;
        private Long maxNumRecords;
        private Duration maxReadTime;
        private Instant startReadTime;
        private Boolean commitOffsetsInFinalizeEnabled;
        private TimestampPolicyFactory<K, V> timestampPolicyFactory;

        Builder() {
        }

        private Builder(KafkaIO.Read<K, V> source) {
            this.consumerConfig = source.getConsumerConfig();
            this.topics = source.getTopics();
            this.topicPartitions = source.getTopicPartitions();
            this.keyCoder = source.getKeyCoder();
            this.valueCoder = source.getValueCoder();
            this.keyDeserializer = source.getKeyDeserializer();
            this.valueDeserializer = source.getValueDeserializer();
            this.consumerFactoryFn = source.getConsumerFactoryFn();
            this.watermarkFn = source.getWatermarkFn();
            this.maxNumRecords = source.getMaxNumRecords();
            this.maxReadTime = source.getMaxReadTime();
            this.startReadTime = source.getStartReadTime();
            this.commitOffsetsInFinalizeEnabled = source.isCommitOffsetsInFinalizeEnabled();
            this.timestampPolicyFactory = source.getTimestampPolicyFactory();
        }

        @Override
        KafkaIO.Read.Builder<K, V> setConsumerConfig(Map<String, Object> consumerConfig) {
            if (consumerConfig == null) {
                throw new NullPointerException("Null consumerConfig");
            }
            this.consumerConfig = consumerConfig;
            return this;
        }

        @Override
        KafkaIO.Read.Builder<K, V> setTopics(List<String> topics) {
            if (topics == null) {
                throw new NullPointerException("Null topics");
            }
            this.topics = topics;
            return this;
        }

        @Override
        KafkaIO.Read.Builder<K, V> setTopicPartitions(List<TopicPartition> topicPartitions) {
            if (topicPartitions == null) {
                throw new NullPointerException("Null topicPartitions");
            }
            this.topicPartitions = topicPartitions;
            return this;
        }

        @Override
        KafkaIO.Read.Builder<K, V> setKeyCoder(Coder<K> keyCoder) {
            this.keyCoder = keyCoder;
            return this;
        }

        @Override
        KafkaIO.Read.Builder<K, V> setValueCoder(Coder<V> valueCoder) {
            this.valueCoder = valueCoder;
            return this;
        }

        @Override
        KafkaIO.Read.Builder<K, V> setKeyDeserializer(Class<? extends Deserializer<K>> keyDeserializer) {
            this.keyDeserializer = keyDeserializer;
            return this;
        }

        @Override
        KafkaIO.Read.Builder<K, V> setValueDeserializer(Class<? extends Deserializer<V>> valueDeserializer) {
            this.valueDeserializer = valueDeserializer;
            return this;
        }

        @Override
        KafkaIO.Read.Builder<K, V> setConsumerFactoryFn(SerializableFunction<Map<String, Object>, Consumer<byte[], byte[]>> consumerFactoryFn) {
            if (consumerFactoryFn == null) {
                throw new NullPointerException("Null consumerFactoryFn");
            }
            this.consumerFactoryFn = consumerFactoryFn;
            return this;
        }

        @Override
        KafkaIO.Read.Builder<K, V> setWatermarkFn(SerializableFunction<KafkaRecord<K, V>, Instant> watermarkFn) {
            this.watermarkFn = watermarkFn;
            return this;
        }

        @Override
        KafkaIO.Read.Builder<K, V> setMaxNumRecords(long maxNumRecords) {
            this.maxNumRecords = maxNumRecords;
            return this;
        }

        @Override
        KafkaIO.Read.Builder<K, V> setMaxReadTime(Duration maxReadTime) {
            this.maxReadTime = maxReadTime;
            return this;
        }

        @Override
        KafkaIO.Read.Builder<K, V> setStartReadTime(Instant startReadTime) {
            this.startReadTime = startReadTime;
            return this;
        }

        @Override
        KafkaIO.Read.Builder<K, V> setCommitOffsetsInFinalizeEnabled(boolean commitOffsetsInFinalizeEnabled) {
            this.commitOffsetsInFinalizeEnabled = commitOffsetsInFinalizeEnabled;
            return this;
        }

        @Override
        KafkaIO.Read.Builder<K, V> setTimestampPolicyFactory(TimestampPolicyFactory<K, V> timestampPolicyFactory) {
            if (timestampPolicyFactory == null) {
                throw new NullPointerException("Null timestampPolicyFactory");
            }
            this.timestampPolicyFactory = timestampPolicyFactory;
            return this;
        }

        @Override
        KafkaIO.Read<K, V> build() {
            String missing = "";
            if (this.consumerConfig == null) {
                missing = missing + " consumerConfig";
            }
            if (this.topics == null) {
                missing = missing + " topics";
            }
            if (this.topicPartitions == null) {
                missing = missing + " topicPartitions";
            }
            if (this.consumerFactoryFn == null) {
                missing = missing + " consumerFactoryFn";
            }
            if (this.maxNumRecords == null) {
                missing = missing + " maxNumRecords";
            }
            if (this.commitOffsetsInFinalizeEnabled == null) {
                missing = missing + " commitOffsetsInFinalizeEnabled";
            }
            if (this.timestampPolicyFactory == null) {
                missing = missing + " timestampPolicyFactory";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_KafkaIO_Read(this.consumerConfig, this.topics, this.topicPartitions, this.keyCoder, this.valueCoder, this.keyDeserializer, this.valueDeserializer, this.consumerFactoryFn, this.watermarkFn, this.maxNumRecords, this.maxReadTime, this.startReadTime, this.commitOffsetsInFinalizeEnabled, this.timestampPolicyFactory);
        }
    }
}

