/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.kafka;

import java.util.Map;
import javax.annotation.Nullable;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.kafka.KafkaIO;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.kafka.clients.producer.Producer;

final class AutoValue_KafkaIO_Write<K, V>
extends KafkaIO.Write<K, V> {
    private final String topic;
    private final Coder<K> keyCoder;
    private final Coder<V> valueCoder;
    private final boolean valueOnly;
    private final Map<String, Object> producerConfig;
    private final SerializableFunction<Map<String, Object>, Producer<K, V>> producerFactoryFn;

    private AutoValue_KafkaIO_Write(@Nullable String topic, @Nullable Coder<K> keyCoder, @Nullable Coder<V> valueCoder, boolean valueOnly, Map<String, Object> producerConfig, @Nullable SerializableFunction<Map<String, Object>, Producer<K, V>> producerFactoryFn) {
        this.topic = topic;
        this.keyCoder = keyCoder;
        this.valueCoder = valueCoder;
        this.valueOnly = valueOnly;
        this.producerConfig = producerConfig;
        this.producerFactoryFn = producerFactoryFn;
    }

    @Override
    @Nullable
    String getTopic() {
        return this.topic;
    }

    @Override
    @Nullable
    Coder<K> getKeyCoder() {
        return this.keyCoder;
    }

    @Override
    @Nullable
    Coder<V> getValueCoder() {
        return this.valueCoder;
    }

    @Override
    boolean getValueOnly() {
        return this.valueOnly;
    }

    @Override
    Map<String, Object> getProducerConfig() {
        return this.producerConfig;
    }

    @Override
    @Nullable
    SerializableFunction<Map<String, Object>, Producer<K, V>> getProducerFactoryFn() {
        return this.producerFactoryFn;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof KafkaIO.Write) {
            KafkaIO.Write that = (KafkaIO.Write)((Object)o);
            return (this.topic == null ? that.getTopic() == null : this.topic.equals(that.getTopic())) && (this.keyCoder == null ? that.getKeyCoder() == null : this.keyCoder.equals(that.getKeyCoder())) && (this.valueCoder == null ? that.getValueCoder() == null : this.valueCoder.equals(that.getValueCoder())) && this.valueOnly == that.getValueOnly() && this.producerConfig.equals(that.getProducerConfig()) && (this.producerFactoryFn == null ? that.getProducerFactoryFn() == null : this.producerFactoryFn.equals(that.getProducerFactoryFn()));
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.topic == null ? 0 : this.topic.hashCode();
        h *= 1000003;
        h ^= this.keyCoder == null ? 0 : this.keyCoder.hashCode();
        h *= 1000003;
        h ^= this.valueCoder == null ? 0 : this.valueCoder.hashCode();
        h *= 1000003;
        h ^= this.valueOnly ? 1231 : 1237;
        h *= 1000003;
        h ^= this.producerConfig.hashCode();
        h *= 1000003;
        return h ^= this.producerFactoryFn == null ? 0 : this.producerFactoryFn.hashCode();
    }

    @Override
    public KafkaIO.Write.Builder<K, V> toBuilder() {
        return new Builder(this);
    }

    static final class Builder<K, V>
    extends KafkaIO.Write.Builder<K, V> {
        private String topic;
        private Coder<K> keyCoder;
        private Coder<V> valueCoder;
        private Boolean valueOnly;
        private Map<String, Object> producerConfig;
        private SerializableFunction<Map<String, Object>, Producer<K, V>> producerFactoryFn;

        Builder() {
        }

        Builder(KafkaIO.Write<K, V> source) {
            this.topic = source.getTopic();
            this.keyCoder = source.getKeyCoder();
            this.valueCoder = source.getValueCoder();
            this.valueOnly = source.getValueOnly();
            this.producerConfig = source.getProducerConfig();
            this.producerFactoryFn = source.getProducerFactoryFn();
        }

        @Override
        public KafkaIO.Write.Builder<K, V> setTopic(@Nullable String topic) {
            this.topic = topic;
            return this;
        }

        @Override
        public KafkaIO.Write.Builder<K, V> setKeyCoder(@Nullable Coder<K> keyCoder) {
            this.keyCoder = keyCoder;
            return this;
        }

        @Override
        public KafkaIO.Write.Builder<K, V> setValueCoder(@Nullable Coder<V> valueCoder) {
            this.valueCoder = valueCoder;
            return this;
        }

        @Override
        public KafkaIO.Write.Builder<K, V> setValueOnly(boolean valueOnly) {
            this.valueOnly = valueOnly;
            return this;
        }

        @Override
        public KafkaIO.Write.Builder<K, V> setProducerConfig(Map<String, Object> producerConfig) {
            this.producerConfig = producerConfig;
            return this;
        }

        @Override
        public KafkaIO.Write.Builder<K, V> setProducerFactoryFn(@Nullable SerializableFunction<Map<String, Object>, Producer<K, V>> producerFactoryFn) {
            this.producerFactoryFn = producerFactoryFn;
            return this;
        }

        @Override
        public KafkaIO.Write<K, V> build() {
            String missing = "";
            if (this.valueOnly == null) {
                missing = missing + " valueOnly";
            }
            if (this.producerConfig == null) {
                missing = missing + " producerConfig";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_KafkaIO_Write(this.topic, this.keyCoder, this.valueCoder, this.valueOnly, this.producerConfig, this.producerFactoryFn);
        }
    }
}

