/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.jdbc;

import com.google.auto.service.AutoService;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.io.jdbc.JdbcIO;
import org.apache.beam.sdk.io.jdbc.JdbcUtil;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.io.SchemaIO;
import org.apache.beam.sdk.schemas.io.SchemaIOProvider;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PDone;
import org.apache.beam.sdk.values.Row;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@Internal
@AutoService(value={SchemaIOProvider.class})
public class JdbcSchemaIOProvider
implements SchemaIOProvider {
    public @UnknownKeyFor @NonNull @Initialized String identifier() {
        return "jdbc";
    }

    public @UnknownKeyFor @NonNull @Initialized Schema configurationSchema() {
        return Schema.builder().addStringField("driverClassName").addStringField("jdbcUrl").addStringField("username").addStringField("password").addNullableField("connectionProperties", Schema.FieldType.STRING).addNullableField("connectionInitSqls", Schema.FieldType.iterable((Schema.FieldType)Schema.FieldType.STRING)).addNullableField("readQuery", Schema.FieldType.STRING).addNullableField("writeStatement", Schema.FieldType.STRING).addNullableField("fetchSize", Schema.FieldType.INT16).addNullableField("disableAutoCommit", Schema.FieldType.BOOLEAN).addNullableField("outputParallelization", Schema.FieldType.BOOLEAN).addNullableField("autosharding", Schema.FieldType.BOOLEAN).addNullableField("partitionColumn", Schema.FieldType.STRING).addNullableField("partitions", Schema.FieldType.INT16).addNullableField("maxConnections", Schema.FieldType.INT16).addNullableField("driverJars", Schema.FieldType.STRING).addNullableField("writeBatchSize", Schema.FieldType.INT64).build();
    }

    public @UnknownKeyFor @NonNull @Initialized JdbcSchemaIO from(@UnknownKeyFor @NonNull @Initialized String location, @UnknownKeyFor @NonNull @Initialized Row configuration, @Nullable @UnknownKeyFor @Initialized Schema dataSchema) {
        return new JdbcSchemaIO(location, configuration, dataSchema);
    }

    public @UnknownKeyFor @NonNull @Initialized boolean requiresDataSchema() {
        return false;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized PCollection.IsBounded isBounded() {
        return PCollection.IsBounded.BOUNDED;
    }

    static class JdbcSchemaIO
    implements SchemaIO,
    Serializable {
        protected final @UnknownKeyFor @NonNull @Initialized Row config;
        protected final @UnknownKeyFor @NonNull @Initialized String location;
        protected final @Nullable @UnknownKeyFor @Initialized Schema dataSchema;

        JdbcSchemaIO(@UnknownKeyFor @NonNull @Initialized String location, @UnknownKeyFor @NonNull @Initialized Row config, @Nullable @UnknownKeyFor @Initialized Schema dataSchema) {
            this.config = config;
            this.location = location;
            this.dataSchema = dataSchema;
        }

        public @Nullable @UnknownKeyFor @Initialized Schema schema() {
            return null;
        }

        public @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PBegin, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row>> buildReader() {
            return new PTransform<PBegin, PCollection<Row>>(){

                public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> expand(@UnknownKeyFor @NonNull @Initialized PBegin input) {
                    Boolean disableAutoCommit;
                    Boolean outputParallelization;
                    String partitionColumn;
                    String string = partitionColumn = config.getSchema().hasField("partitionColumn") ? config.getString("partitionColumn") : null;
                    if (partitionColumn != null) {
                        Boolean disableAutoCommit2;
                        Short fetchSize;
                        JdbcIO.ReadWithPartitions readRows = JdbcIO.readWithPartitions().withDataSourceConfiguration(this.getDataSourceConfiguration()).withTable(location).withPartitionColumn(partitionColumn).withRowOutput();
                        @Nullable Short partitions = config.getInt16("partitions");
                        if (partitions != null) {
                            readRows = readRows.withNumPartitions(partitions.shortValue());
                        }
                        if ((fetchSize = config.getInt16("fetchSize")) != null) {
                            readRows = readRows.withFetchSize(fetchSize.shortValue());
                        }
                        if ((disableAutoCommit2 = config.getBoolean("disableAutoCommit")) != null) {
                            readRows = readRows.withDisableAutoCommit(disableAutoCommit2);
                        }
                        if (dataSchema != null) {
                            readRows = readRows.withSchema(dataSchema);
                        }
                        return (PCollection)input.apply(readRows);
                    }
                    @Nullable String readQuery = config.getString("readQuery");
                    if (readQuery == null) {
                        readQuery = String.format("SELECT * FROM %s", location);
                    }
                    JdbcIO.ReadRows readRows = JdbcIO.readRows().withDataSourceConfiguration(this.getDataSourceConfiguration()).withQuery(readQuery);
                    @Nullable Short fetchSize = config.getInt16("fetchSize");
                    if (fetchSize != null) {
                        readRows = readRows.withFetchSize(fetchSize.shortValue());
                    }
                    if ((outputParallelization = config.getBoolean("outputParallelization")) != null) {
                        readRows = readRows.withOutputParallelization(outputParallelization);
                    }
                    if ((disableAutoCommit = config.getBoolean("disableAutoCommit")) != null) {
                        readRows = readRows.withDisableAutoCommit(disableAutoCommit);
                    }
                    if (dataSchema != null) {
                        readRows = readRows.withSchema(dataSchema);
                    }
                    return (PCollection)input.apply((PTransform)readRows);
                }
            };
        }

        public @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row>, @UnknownKeyFor @NonNull @Initialized PDone> buildWriter() {
            return new PTransform<PCollection<Row>, PDone>(){

                public @UnknownKeyFor @NonNull @Initialized PDone expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> input) {
                    Long writeBatchSize;
                    JdbcIO.Write<Row> writeRows = JdbcIO.write().withDataSourceConfiguration(this.getDataSourceConfiguration()).withStatement(this.generateWriteStatement(input.getSchema())).withPreparedStatementSetter(new JdbcUtil.BeamRowPreparedStatementSetter());
                    @Nullable Boolean autosharding = config.getBoolean("autosharding");
                    if (autosharding != null && autosharding.booleanValue()) {
                        writeRows = writeRows.withAutoSharding();
                    }
                    if ((writeBatchSize = config.getInt64("writeBatchSize")) != null) {
                        writeRows = writeRows.withBatchSize(writeBatchSize);
                    }
                    return (PDone)input.apply(writeRows);
                }
            };
        }

        protected @UnknownKeyFor @NonNull @Initialized JdbcIO.DataSourceConfiguration getDataSourceConfiguration() {
            String driverJars;
            Short maxConnections;
            Iterable connectionInitSqls;
            JdbcIO.DataSourceConfiguration dataSourceConfiguration = JdbcIO.DataSourceConfiguration.create((String)Preconditions.checkStateNotNull((Object)this.config.getString("driverClassName")), (String)Preconditions.checkStateNotNull((Object)this.config.getString("jdbcUrl"))).withUsername(this.config.getString("username")).withPassword(this.config.getString("password"));
            @Nullable String connectionProperties = this.config.getString("connectionProperties");
            if (connectionProperties != null) {
                dataSourceConfiguration = dataSourceConfiguration.withConnectionProperties(connectionProperties);
            }
            if ((connectionInitSqls = this.config.getIterable("connectionInitSqls")) != null) {
                List<@Nullable String> initSqls = StreamSupport.stream(connectionInitSqls.spliterator(), false).collect(Collectors.toList());
                dataSourceConfiguration = dataSourceConfiguration.withConnectionInitSqls(initSqls);
            }
            if ((maxConnections = this.config.getInt16("maxConnections")) != null) {
                dataSourceConfiguration = dataSourceConfiguration.withMaxConnections(maxConnections.intValue());
            }
            if ((driverJars = this.config.getString("driverJars")) != null) {
                dataSourceConfiguration = dataSourceConfiguration.withDriverJars(driverJars);
            }
            return dataSourceConfiguration;
        }

        private @UnknownKeyFor @NonNull @Initialized String generateWriteStatement(@UnknownKeyFor @NonNull @Initialized Schema schema) {
            @Nullable String configuredWriteStatement = this.config.getString("writeStatement");
            if (configuredWriteStatement != null) {
                return configuredWriteStatement;
            }
            StringBuilder writeStatement = new StringBuilder("INSERT INTO ");
            writeStatement.append(this.location);
            writeStatement.append(" VALUES(");
            for (int i = 0; i < schema.getFieldCount() - 1; ++i) {
                writeStatement.append("?, ");
            }
            writeStatement.append("?)");
            return writeStatement.toString();
        }
    }
}

