/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.jdbc;

import com.google.auto.value.AutoValue;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.JDBCType;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.TimeZone;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.sql.DataSource;
import org.apache.beam.sdk.io.FileSystems;
import org.apache.beam.sdk.io.fs.ResourceId;
import org.apache.beam.sdk.io.jdbc.AutoValue_JdbcUtil_FQNComponents;
import org.apache.beam.sdk.io.jdbc.AutoValue_JdbcUtil_JdbcUrl;
import org.apache.beam.sdk.io.jdbc.JdbcIO;
import org.apache.beam.sdk.io.jdbc.JdbcReadWithPartitionsHelper;
import org.apache.beam.sdk.io.jdbc.LogicalTypes;
import org.apache.beam.sdk.io.jdbc.SchemaUtil;
import org.apache.beam.sdk.metrics.Lineage;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.logicaltypes.MicrosInstant;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Splitter;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Strings;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Lists;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.io.ByteStreams;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.io.Files;
import org.apache.commons.dbcp2.BasicDataSource;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.ReadableDateTime;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcUtil {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(JdbcUtil.class);
    public static final @UnknownKeyFor @NonNull @Initialized String MYSQL = "mysql";
    public static final @UnknownKeyFor @NonNull @Initialized String POSTGRES = "postgres";
    public static final @UnknownKeyFor @NonNull @Initialized String ORACLE = "oracle";
    public static final @UnknownKeyFor @NonNull @Initialized String MSSQL = "mssql";
    static final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> JDBC_DRIVER_MAP = new HashMap<String, String>((Map<String, String>)ImmutableMap.of((Object)"mysql", (Object)"com.mysql.cj.jdbc.Driver", (Object)"postgres", (Object)"org.postgresql.Driver", (Object)"oracle", (Object)"oracle.jdbc.driver.OracleDriver", (Object)"mssql", (Object)"com.microsoft.sqlserver.jdbc.SQLServerDriver"));
    private static @UnknownKeyFor @NonNull @Initialized Map<// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.TypeName,  @UnknownKeyFor @NonNull @Initialized JdbcIO.PreparedStatementSetCaller> typeNamePsSetCallerMap = new EnumMap<Schema.TypeName, JdbcIO.PreparedStatementSetCaller>((Map<Schema.TypeName, JdbcIO.PreparedStatementSetCaller>)ImmutableMap.builder().put((Object)Schema.TypeName.BYTE, (element, ps, i, fieldWithIndex) -> {
        Byte value = element.getByte(fieldWithIndex.getIndex().intValue());
        if (value == null) {
            JdbcUtil.setNullToPreparedStatement(ps, i, JDBCType.TINYINT);
        } else {
            ps.setByte(i + 1, value);
        }
    }).put((Object)Schema.TypeName.INT16, (element, ps, i, fieldWithIndex) -> {
        Short value = element.getInt16(fieldWithIndex.getIndex().intValue());
        if (value == null) {
            JdbcUtil.setNullToPreparedStatement(ps, i, JDBCType.SMALLINT);
        } else {
            ps.setInt(i + 1, value.shortValue());
        }
    }).put((Object)Schema.TypeName.INT64, (element, ps, i, fieldWithIndex) -> {
        Long value = element.getInt64(fieldWithIndex.getIndex().intValue());
        if (value == null) {
            JdbcUtil.setNullToPreparedStatement(ps, i, JDBCType.BIGINT);
        } else {
            ps.setLong(i + 1, value);
        }
    }).put((Object)Schema.TypeName.DECIMAL, (element, ps, i, fieldWithIndex) -> ps.setBigDecimal(i + 1, element.getDecimal(fieldWithIndex.getIndex().intValue()))).put((Object)Schema.TypeName.FLOAT, (element, ps, i, fieldWithIndex) -> {
        Float value = element.getFloat(fieldWithIndex.getIndex().intValue());
        if (value == null) {
            JdbcUtil.setNullToPreparedStatement(ps, i, JDBCType.FLOAT);
        } else {
            ps.setFloat(i + 1, value.floatValue());
        }
    }).put((Object)Schema.TypeName.DOUBLE, (element, ps, i, fieldWithIndex) -> {
        Double value = element.getDouble(fieldWithIndex.getIndex().intValue());
        if (value == null) {
            JdbcUtil.setNullToPreparedStatement(ps, i, JDBCType.DOUBLE);
        } else {
            ps.setDouble(i + 1, value);
        }
    }).put((Object)Schema.TypeName.DATETIME, (element, ps, i, fieldWithIndex) -> {
        ReadableDateTime value = element.getDateTime(fieldWithIndex.getIndex().intValue());
        ps.setTimestamp(i + 1, value == null ? null : new Timestamp(value.getMillis()));
    }).put((Object)Schema.TypeName.BOOLEAN, (element, ps, i, fieldWithIndex) -> {
        Boolean value = element.getBoolean(fieldWithIndex.getIndex().intValue());
        if (value == null) {
            JdbcUtil.setNullToPreparedStatement(ps, i, JDBCType.BOOLEAN);
        } else {
            ps.setBoolean(i + 1, value);
        }
    }).put((Object)Schema.TypeName.BYTES, (Object)JdbcUtil.createBytesCaller()).put((Object)Schema.TypeName.INT32, (element, ps, i, fieldWithIndex) -> {
        Integer value = element.getInt32(fieldWithIndex.getIndex().intValue());
        if (value == null) {
            JdbcUtil.setNullToPreparedStatement(ps, i, JDBCType.INTEGER);
        } else {
            ps.setInt(i + 1, value);
        }
    }).put((Object)Schema.TypeName.STRING, (Object)JdbcUtil.createStringCaller()).build());
    public static final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized JdbcReadWithPartitionsHelper<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> PRESET_HELPERS = ImmutableMap.of(Long.class, (Object)new JdbcReadWithPartitionsHelper<Long>(){

        @Override
        public @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Long, @UnknownKeyFor @NonNull @Initialized Long>> calculateRanges(@UnknownKeyFor @NonNull @Initialized Long lowerBound, @UnknownKeyFor @NonNull @Initialized Long upperBound, @UnknownKeyFor @NonNull @Initialized Long partitions) {
            ArrayList<KV<Long, Long>> ranges = new ArrayList<KV<Long, Long>>();
            long stride = upperBound / partitions - lowerBound / partitions + 1L;
            long highest = lowerBound;
            for (long i = lowerBound.longValue(); i < upperBound - stride; i += stride) {
                ranges.add(KV.of((Object)i, (Object)(i + stride)));
                highest = i + stride;
            }
            if (highest < upperBound + 1L) {
                ranges.add((KV<Long, Long>)KV.of((Object)highest, (Object)(upperBound + 1L)));
            }
            return ranges;
        }

        @Override
        public void setParameters(@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Long, @UnknownKeyFor @NonNull @Initialized Long> element, @UnknownKeyFor @NonNull @Initialized PreparedStatement preparedStatement) {
            try {
                preparedStatement.setLong(1, (Long)element.getKey());
                preparedStatement.setLong(2, (Long)element.getValue());
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Long, @UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Long, @UnknownKeyFor @NonNull @Initialized Long>> mapRow(@UnknownKeyFor @NonNull @Initialized ResultSet resultSet) throws @UnknownKeyFor @NonNull @Initialized Exception {
            if (resultSet.getMetaData().getColumnCount() == 3) {
                return KV.of((Object)resultSet.getLong(3), (Object)KV.of((Object)resultSet.getLong(1), (Object)resultSet.getLong(2)));
            }
            return KV.of((Object)0L, (Object)KV.of((Object)resultSet.getLong(1), (Object)resultSet.getLong(2)));
        }
    }, DateTime.class, (Object)new JdbcReadWithPartitionsHelper<DateTime>(){

        @Override
        public @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized DateTime, @UnknownKeyFor @NonNull @Initialized DateTime>> calculateRanges(@UnknownKeyFor @NonNull @Initialized DateTime lowerBound, @UnknownKeyFor @NonNull @Initialized DateTime upperBound, @UnknownKeyFor @NonNull @Initialized Long partitions) {
            ArrayList<KV<DateTime, DateTime>> result = new ArrayList<KV<DateTime, DateTime>>();
            long intervalMillis = upperBound.getMillis() - lowerBound.getMillis();
            Duration stride = Duration.millis((long)Math.max(1L, intervalMillis / partitions));
            DateTime currentLowerBound = lowerBound;
            while (currentLowerBound.compareTo((ReadableInstant)upperBound) <= 0) {
                DateTime currentUpper = currentLowerBound.plus((ReadableDuration)stride);
                if (currentUpper.compareTo((ReadableInstant)upperBound) >= 0) {
                    currentUpper = upperBound.plusMillis(1);
                    result.add((KV<DateTime, DateTime>)KV.of((Object)currentLowerBound, (Object)currentUpper));
                    return result;
                }
                result.add((KV<DateTime, DateTime>)KV.of((Object)currentLowerBound, (Object)currentUpper));
                currentLowerBound = currentLowerBound.plus((ReadableDuration)stride);
            }
            return result;
        }

        @Override
        public void setParameters(@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized DateTime, @UnknownKeyFor @NonNull @Initialized DateTime> element, @UnknownKeyFor @NonNull @Initialized PreparedStatement preparedStatement) {
            try {
                preparedStatement.setTimestamp(1, new Timestamp(((DateTime)element.getKey()).getMillis()));
                preparedStatement.setTimestamp(2, new Timestamp(((DateTime)element.getValue()).getMillis()));
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Long, @UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized DateTime, @UnknownKeyFor @NonNull @Initialized DateTime>> mapRow(@UnknownKeyFor @NonNull @Initialized ResultSet resultSet) throws @UnknownKeyFor @NonNull @Initialized Exception {
            if (resultSet.getMetaData().getColumnCount() == 3) {
                return KV.of((Object)resultSet.getLong(3), (Object)KV.of((Object)new DateTime(Preconditions.checkArgumentNotNull((Object)resultSet.getTimestamp(1))), (Object)new DateTime(Preconditions.checkArgumentNotNull((Object)resultSet.getTimestamp(2)))));
            }
            return KV.of((Object)0L, (Object)KV.of((Object)new DateTime(Preconditions.checkArgumentNotNull((Object)resultSet.getTimestamp(1))), (Object)new DateTime(Preconditions.checkArgumentNotNull((Object)resultSet.getTimestamp(2)))));
        }
    });
    private static final @UnknownKeyFor @NonNull @Initialized Pattern TABLE_PATTERN = Pattern.compile("(\\[?`?(?<schemaName>[^\\s\\[\\]`]+)\\]?`?\\.)?\\[?`?(?<tableName>[^\\s\\[\\]`]+)\\]?`?", 2);
    private static final @UnknownKeyFor @NonNull @Initialized Pattern READ_STATEMENT_PATTERN = Pattern.compile("SELECT\\s+.+?\\s+FROM\\s+(\\[?`?(?<schemaName>[^\\s\\[\\]`]+)\\]?`?\\.)?\\[?`?(?<tableName>[^\\s\\[\\]`]+)\\]?`?", 2);
    private static final @UnknownKeyFor @NonNull @Initialized Pattern WRITE_STATEMENT_PATTERN = Pattern.compile("INSERT\\s+INTO\\s+(\\[?`?(?<schemaName>[^\\s\\[\\]`]+)\\]?`?\\.)?\\[?(?<tableName>[^\\s\\[\\]]+)\\]?", 2);

    @VisibleForTesting
    static void registerJdbcDriver(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> jdbcType) {
        JDBC_DRIVER_MAP.putAll(jdbcType);
    }

    static @UnknownKeyFor @NonNull @Initialized URL @UnknownKeyFor @NonNull @Initialized [] saveFilesLocally(@UnknownKeyFor @NonNull @Initialized String driverJars) {
        List listOfJarPaths = Splitter.on((char)',').trimResults().splitToList((CharSequence)driverJars);
        String destRoot = Files.createTempDir().getAbsolutePath();
        ArrayList driverJarUrls = new ArrayList();
        listOfJarPaths.stream().forEach(jarPath -> {
            try {
                ResourceId sourceResourceId = FileSystems.matchNewResource((String)jarPath, (boolean)false);
                File destFile = Paths.get(destRoot, sourceResourceId.getFilename()).toFile();
                ResourceId destResourceId = FileSystems.matchNewResource((String)destFile.getAbsolutePath(), (boolean)false);
                JdbcUtil.copy(sourceResourceId, destResourceId);
                LOG.info("Localized jar: " + sourceResourceId + " to: " + destResourceId);
                driverJarUrls.add(destFile.toURI().toURL());
            }
            catch (IOException e) {
                LOG.warn("Unable to copy " + jarPath, (Throwable)e);
            }
        });
        return (URL[])driverJarUrls.stream().toArray(URL[]::new);
    }

    private static void copy(@UnknownKeyFor @NonNull @Initialized ResourceId source, @UnknownKeyFor @NonNull @Initialized ResourceId dest) throws @UnknownKeyFor @NonNull @Initialized IOException {
        try (ReadableByteChannel rbc = FileSystems.open((ResourceId)source);
             WritableByteChannel wbc = FileSystems.create((ResourceId)dest, (String)"application/octet-stream");){
            ByteStreams.copy((ReadableByteChannel)rbc, (WritableByteChannel)wbc);
        }
    }

    static @UnknownKeyFor @NonNull @Initialized String generateStatement(@UnknownKeyFor @NonNull @Initialized String tableName, @UnknownKeyFor @NonNull @Initialized List<// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.Field> fields) {
        String fieldNames = IntStream.range(0, fields.size()).mapToObj(index -> ((Schema.Field)fields.get(index)).getName()).collect(Collectors.joining(", "));
        String valuePlaceholder = IntStream.range(0, fields.size()).mapToObj(index -> "?").collect(Collectors.joining(", "));
        return String.format("INSERT INTO %s(%s) VALUES(%s)", tableName, fieldNames, valuePlaceholder);
    }

    static  @UnknownKeyFor @NonNull @Initialized JdbcIO.PreparedStatementSetCaller getPreparedStatementSetCaller(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.FieldType fieldType) {
        switch (fieldType.getTypeName()) {
            case ARRAY: 
            case ITERABLE: {
                return (element, ps, i, fieldWithIndex) -> {
                    Collection value = element.getArray(fieldWithIndex.getIndex().intValue());
                    if (value == null) {
                        JdbcUtil.setArrayNull(ps, i);
                    } else {
                        Schema.FieldType collectionElementType = (Schema.FieldType)Preconditions.checkArgumentNotNull((Object)fieldType.getCollectionElementType());
                        ps.setArray(i + 1, ps.getConnection().createArrayOf(collectionElementType.getTypeName().name(), value.toArray()));
                    }
                };
            }
            case LOGICAL_TYPE: {
                Schema.LogicalType logicalType = (Schema.LogicalType)Preconditions.checkArgumentNotNull((Object)fieldType.getLogicalType());
                if (Objects.equals(logicalType, LogicalTypes.JDBC_UUID_TYPE.getLogicalType())) {
                    return (element, ps, i, fieldWithIndex) -> ps.setObject(i + 1, element.getLogicalTypeValue(fieldWithIndex.getIndex().intValue(), UUID.class));
                }
                String logicalTypeName = logicalType.getIdentifier();
                if (logicalTypeName.equals(MicrosInstant.IDENTIFIER)) {
                    return (element, ps, i, fieldWithIndex) -> {
                        Instant value = (Instant)element.getLogicalTypeValue(fieldWithIndex.getIndex().intValue(), Instant.class);
                        ps.setTimestamp(i + 1, value == null ? null : new Timestamp(value.toEpochMilli()));
                    };
                }
                if (logicalTypeName.equals("beam:logical_type:fixed_decimal:v1")) {
                    return (element, ps, i, fieldWithIndex) -> ps.setBigDecimal(i + 1, element.getDecimal(fieldWithIndex.getIndex().intValue()));
                }
                if (logicalTypeName.equals("DATE")) {
                    return (element, ps, i, fieldWithIndex) -> {
                        ReadableDateTime value = element.getDateTime(fieldWithIndex.getIndex().intValue());
                        ps.setDate(i + 1, value == null ? null : new Date(JdbcUtil.getDateOrTimeOnly(value.toDateTime(), true).getTime().getTime()));
                    };
                }
                if (logicalTypeName.equals("TIME")) {
                    return (element, ps, i, fieldWithIndex) -> {
                        ReadableDateTime value = element.getDateTime(fieldWithIndex.getIndex().intValue());
                        ps.setTime(i + 1, value == null ? null : new Time(JdbcUtil.getDateOrTimeOnly(value.toDateTime(), false).getTime().getTime()));
                    };
                }
                if (logicalTypeName.equals("TIMESTAMP_WITH_TIMEZONE")) {
                    return (element, ps, i, fieldWithIndex) -> {
                        ReadableDateTime value = element.getDateTime(fieldWithIndex.getIndex().intValue());
                        if (value == null) {
                            ps.setTimestamp(i + 1, null);
                        } else {
                            Calendar calendar = JdbcUtil.withTimestampAndTimezone(value.toDateTime());
                            ps.setTimestamp(i + 1, new Timestamp(calendar.getTime().getTime()), calendar);
                        }
                    };
                }
                if (logicalTypeName.equals("OTHER")) {
                    return (element, ps, i, fieldWithIndex) -> ps.setObject(i + 1, element.getValue(fieldWithIndex.getIndex().intValue()), 1111);
                }
                return JdbcUtil.getPreparedStatementSetCaller(logicalType.getBaseType());
            }
        }
        JdbcIO.PreparedStatementSetCaller pssc = typeNamePsSetCallerMap.get(fieldType.getTypeName());
        if (pssc != null) {
            return pssc;
        }
        throw new RuntimeException(fieldType.getTypeName().name() + " in schema is not supported while writing. Please provide statement and preparedStatementSetter");
    }

    private static void setArrayNull(@UnknownKeyFor @NonNull @Initialized PreparedStatement ps, @UnknownKeyFor @NonNull @Initialized int i) throws @UnknownKeyFor @NonNull @Initialized SQLException {
        ps.setArray(i + 1, null);
    }

    static void setNullToPreparedStatement(@UnknownKeyFor @NonNull @Initialized PreparedStatement ps, @UnknownKeyFor @NonNull @Initialized int i, @UnknownKeyFor @NonNull @Initialized JDBCType type) throws @UnknownKeyFor @NonNull @Initialized SQLException {
        ps.setNull(i + 1, type.getVendorTypeNumber());
    }

    private static  @UnknownKeyFor @NonNull @Initialized JdbcIO.PreparedStatementSetCaller createBytesCaller() {
        return (element, ps, i, fieldWithIndex) -> {
            byte[] value = element.getBytes(fieldWithIndex.getIndex().intValue());
            if (value != null) {
                JdbcUtil.validateLogicalTypeLength(fieldWithIndex.getField(), value.length);
            }
            ps.setBytes(i + 1, value);
        };
    }

    private static  @UnknownKeyFor @NonNull @Initialized JdbcIO.PreparedStatementSetCaller createStringCaller() {
        return (element, ps, i, fieldWithIndex) -> {
            String value = element.getString(fieldWithIndex.getIndex().intValue());
            if (value != null) {
                JdbcUtil.validateLogicalTypeLength(fieldWithIndex.getField(), value.length());
            }
            ps.setString(i + 1, value);
        };
    }

    private static void validateLogicalTypeLength(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.Field field, @UnknownKeyFor @NonNull @Initialized Integer length) {
        try {
            if (!field.getType().getTypeName().isLogicalType()) {
                return;
            }
            Integer maxLimit = (Integer)((Schema.LogicalType)Preconditions.checkArgumentNotNull((Object)field.getType().getLogicalType())).getArgument();
            if (maxLimit == null) {
                return;
            }
            if (length > maxLimit) {
                throw new RuntimeException(String.format("Length of Schema.Field[%s] data exceeds database column capacity", field.getName()));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private static @UnknownKeyFor @NonNull @Initialized Calendar getDateOrTimeOnly(@UnknownKeyFor @NonNull @Initialized DateTime dateTime, @UnknownKeyFor @NonNull @Initialized boolean wantDateOnly) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeZone(TimeZone.getTimeZone(dateTime.getZone().getID()));
        if (wantDateOnly) {
            cal.set(1, dateTime.getYear());
            cal.set(2, dateTime.getMonthOfYear() - 1);
            cal.set(5, dateTime.getDayOfMonth());
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
        } else {
            cal.set(1, 1970);
            cal.set(2, 0);
            cal.set(5, 1);
            cal.set(11, dateTime.getHourOfDay());
            cal.set(12, dateTime.getMinuteOfHour());
            cal.set(13, dateTime.getSecondOfMinute());
            cal.set(14, dateTime.getMillisOfSecond());
        }
        return cal;
    }

    private static @UnknownKeyFor @NonNull @Initialized Calendar withTimestampAndTimezone(@UnknownKeyFor @NonNull @Initialized DateTime dateTime) {
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone(dateTime.getZone().getID()));
        calendar.setTimeInMillis(dateTime.getMillis());
        return calendar;
    }

    static <T> @Nullable @UnknownKeyFor @Initialized JdbcReadWithPartitionsHelper<T> getPartitionsHelper(@UnknownKeyFor @NonNull @Initialized TypeDescriptor<T> type) {
        return PRESET_HELPERS.get(type.getRawType());
    }

    static @Nullable @UnknownKeyFor @Initialized KV<@Nullable @UnknownKeyFor @Initialized String, @UnknownKeyFor @NonNull @Initialized String> extractTableFromReadQuery(@Nullable @UnknownKeyFor @Initialized String query) {
        if (query == null) {
            return null;
        }
        Matcher matchRead = READ_STATEMENT_PATTERN.matcher(query);
        if (matchRead.find()) {
            String matchedTable = matchRead.group("tableName");
            String matchedSchema = matchRead.group("schemaName");
            System.out.println(matchedSchema);
            if (matchedTable != null) {
                return KV.of((Object)matchedSchema, (Object)matchedTable);
            }
        }
        return null;
    }

    static @Nullable @UnknownKeyFor @Initialized KV<@Nullable @UnknownKeyFor @Initialized String, @UnknownKeyFor @NonNull @Initialized String> extractTableFromTable(@Nullable @UnknownKeyFor @Initialized String table) {
        if (table == null) {
            return null;
        }
        Matcher matchRead = TABLE_PATTERN.matcher(table);
        if (matchRead.find()) {
            String matchedTable = matchRead.group("tableName");
            String matchedSchema = matchRead.group("schemaName");
            if (matchedTable != null) {
                return KV.of((Object)matchedSchema, (Object)matchedTable);
            }
        }
        return null;
    }

    static @Nullable @UnknownKeyFor @Initialized KV<@Nullable @UnknownKeyFor @Initialized String, @UnknownKeyFor @NonNull @Initialized String> extractTableFromWriteQuery(@Nullable @UnknownKeyFor @Initialized String query) {
        if (query == null) {
            return null;
        }
        Matcher matchRead = WRITE_STATEMENT_PATTERN.matcher(query);
        if (matchRead.find()) {
            String matchedTable = matchRead.group("tableName");
            String matchedSchema = matchRead.group("schemaName");
            if (matchedTable != null) {
                return KV.of((Object)matchedSchema, (Object)matchedTable);
            }
        }
        return null;
    }

    @AutoValue
    static abstract class FQNComponents {
        static final @UnknownKeyFor @NonNull @Initialized String DEFAULT_SCHEMA = "default";

        FQNComponents() {
        }

        abstract @UnknownKeyFor @NonNull @Initialized String getScheme();

        abstract @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized String> getSegments();

        void reportLineage(@UnknownKeyFor @NonNull @Initialized Lineage lineage, @Nullable @UnknownKeyFor @Initialized KV<@Nullable @UnknownKeyFor @Initialized String, @UnknownKeyFor @NonNull @Initialized String> tableWithSchema) {
            ImmutableList.Builder builder = ImmutableList.builder().addAll(this.getSegments());
            if (tableWithSchema != null) {
                if (tableWithSchema.getKey() != null && !((String)tableWithSchema.getKey()).isEmpty()) {
                    builder.add((Object)((String)tableWithSchema.getKey()));
                } else {
                    builder.add((Object)DEFAULT_SCHEMA);
                }
                if (!((String)tableWithSchema.getValue()).isEmpty()) {
                    builder.add((Object)((String)tableWithSchema.getValue()));
                }
            }
            lineage.add(this.getScheme(), (Iterable)builder.build());
        }

        static @Nullable @UnknownKeyFor @Initialized FQNComponents of(@UnknownKeyFor @NonNull @Initialized DataSource dataSource) {
            String url;
            String maybeSqlInstance;
            try {
                Properties properties;
                Method getProperties;
                if (dataSource instanceof BasicDataSource) {
                    BasicDataSource source = (BasicDataSource)dataSource;
                    getProperties = source.getClass().getDeclaredMethod("getConnectionProperties", new Class[0]);
                    getProperties.setAccessible(true);
                    properties = (Properties)getProperties.invoke((Object)dataSource, new Object[0]);
                    if (properties == null) {
                        return null;
                    }
                    maybeSqlInstance = properties.getProperty("cloudSqlInstance");
                    if (maybeSqlInstance == null) {
                        return null;
                    }
                    url = source.getUrl();
                } else {
                    Class<?> hikariClass = Class.forName("com.zaxxer.hikari.HikariDataSource");
                    if (!hikariClass.isInstance(dataSource)) {
                        return null;
                    }
                    getProperties = hikariClass.getMethod("getDataSourceProperties", new Class[0]);
                    properties = (Properties)getProperties.invoke((Object)dataSource, new Object[0]);
                    if (properties == null) {
                        return null;
                    }
                    maybeSqlInstance = properties.getProperty("cloudSqlInstance");
                    if (maybeSqlInstance == null) {
                        return null;
                    }
                    Method getUrl = hikariClass.getMethod("getJdbcUrl", new Class[0]);
                    url = (String)getUrl.invoke((Object)dataSource, new Object[0]);
                    if (url == null) {
                        return null;
                    }
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                return null;
            }
            JdbcUrl jdbcUrl = JdbcUrl.of(url);
            if (jdbcUrl == null) {
                LOG.info("Failed to parse JdbcUrl {}. Lineage will not be reported.", (Object)url);
                return null;
            }
            String scheme = "cloudsql_" + jdbcUrl.getScheme();
            ImmutableList.Builder segments = ImmutableList.builder();
            List<String> sqlInstance = Arrays.asList(maybeSqlInstance.split(":"));
            if (sqlInstance.size() > 3) {
                segments.add((Object)String.join((CharSequence)":", sqlInstance.subList(0, sqlInstance.size() - 2))).add((Object)sqlInstance.get(sqlInstance.size() - 2)).add((Object)sqlInstance.get(sqlInstance.size() - 1));
            } else {
                segments.addAll(Arrays.asList(maybeSqlInstance.split(":")));
            }
            segments.add((Object)jdbcUrl.getDatabase());
            return new AutoValue_JdbcUtil_FQNComponents(scheme, (Iterable<String>)segments.build());
        }

        static @Nullable @UnknownKeyFor @Initialized FQNComponents of(@UnknownKeyFor @NonNull @Initialized Connection connection) {
            try {
                DatabaseMetaData metadata = connection.getMetaData();
                if (metadata == null) {
                    return null;
                }
                String url = metadata.getURL();
                if (url == null) {
                    return null;
                }
                return FQNComponents.of(url);
            }
            catch (Exception e) {
                return null;
            }
        }

        @VisibleForTesting
        static @Nullable @UnknownKeyFor @Initialized FQNComponents of(@UnknownKeyFor @NonNull @Initialized String url) {
            JdbcUrl jdbcUrl = JdbcUrl.of(url);
            if (jdbcUrl == null || jdbcUrl.getHostAndPort() == null) {
                LOG.info("Failed to parse JdbcUrl {}. Lineage will not be reported.", (Object)url);
                return null;
            }
            String hostAndPort = jdbcUrl.getHostAndPort();
            if (hostAndPort == null) {
                LOG.info("Failed to parse host/port from JdbcUrl {}. Lineage will not be reported.", (Object)url);
                return null;
            }
            return new AutoValue_JdbcUtil_FQNComponents(jdbcUrl.getScheme(), (Iterable<String>)ImmutableList.of((Object)hostAndPort, (Object)jdbcUrl.getDatabase()));
        }
    }

    @AutoValue
    static abstract class JdbcUrl {
        JdbcUrl() {
        }

        abstract @UnknownKeyFor @NonNull @Initialized String getScheme();

        abstract @Nullable @UnknownKeyFor @Initialized String getHostAndPort();

        abstract @UnknownKeyFor @NonNull @Initialized String getDatabase();

        static @Nullable @UnknownKeyFor @Initialized JdbcUrl of(@UnknownKeyFor @NonNull @Initialized String url) {
            if (Strings.isNullOrEmpty((String)url) || !url.startsWith("jdbc:")) {
                return null;
            }
            String cleanUri = url.substring(5);
            int start = cleanUri.indexOf("//");
            if (start == -1) {
                if (cleanUri.startsWith("derby:")) {
                    List components;
                    String scheme = "derby";
                    int endUrl = cleanUri.indexOf(";");
                    if (endUrl == -1) {
                        endUrl = cleanUri.length();
                    }
                    if ((components = Splitter.on((char)':').splitToList((CharSequence)cleanUri.substring("derby:".length(), endUrl))).size() < 2) {
                        return null;
                    }
                    return new AutoValue_JdbcUtil_JdbcUrl(scheme, (String)components.get(0), (String)components.get(1));
                }
                if (cleanUri.startsWith("oracle:thin:")) {
                    String scheme = JdbcUtil.ORACLE;
                    int startHost = cleanUri.indexOf("@");
                    if (startHost == -1) {
                        return null;
                    }
                    List components = Splitter.on((char)':').splitToList((CharSequence)cleanUri.substring(startHost + 1));
                    if (components.size() < 3) {
                        return null;
                    }
                    return new AutoValue_JdbcUtil_JdbcUrl(scheme, (String)components.get(0) + ":" + (String)components.get(1), (String)components.get(2));
                }
                return null;
            }
            List subschemes = Splitter.on((char)':').splitToList((CharSequence)cleanUri.substring(0, start));
            cleanUri = (String)subschemes.get(0) + ":" + cleanUri.substring(start);
            URI uri = URI.create(cleanUri);
            String scheme = uri.getScheme();
            @Nullable String path = uri.getPath();
            if (path != null && path.startsWith("/")) {
                path = path.substring(1);
            }
            if (path == null) {
                return null;
            }
            String hostAndPort = null;
            @Nullable String host = uri.getHost();
            if (host != null) {
                int port = uri.getPort();
                hostAndPort = port != -1 ? host + ":" + port : null;
            }
            return new AutoValue_JdbcUtil_JdbcUrl(scheme, hostAndPort, path);
        }
    }

    static class PartitioningFn<@UnknownKeyFor T>
    extends DoFn<KV<Long, KV<T, T>>, KV<T, T>> {
        private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(PartitioningFn.class);
        final @UnknownKeyFor @NonNull @Initialized JdbcReadWithPartitionsHelper<T> partitionsHelper;

        PartitioningFn(@UnknownKeyFor @NonNull @Initialized JdbcReadWithPartitionsHelper<T> partitionsHelper) {
            this.partitionsHelper = partitionsHelper;
        }

        @DoFn.ProcessElement
        public void processElement(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) {
            Object lowerBound = ((KV)((KV)c.element()).getValue()).getKey();
            Object upperBound = ((KV)((KV)c.element()).getValue()).getValue();
            ArrayList ranges = Lists.newArrayList(this.partitionsHelper.calculateRanges(lowerBound, upperBound, (Long)((KV)c.element()).getKey()));
            LOG.warn("Total of {} ranges: {}", (Object)ranges.size(), (Object)ranges);
            for (KV e : ranges) {
                c.output((Object)e);
            }
        }
    }

    static class BeamRowPreparedStatementSetter
    implements JdbcIO.PreparedStatementSetter<Row> {
        BeamRowPreparedStatementSetter() {
        }

        @Override
        public void setParameters(@UnknownKeyFor @NonNull @Initialized Row row, @UnknownKeyFor @NonNull @Initialized PreparedStatement statement) {
            Schema schema = row.getSchema();
            List fieldTypes = schema.getFields();
            IntStream.range(0, fieldTypes.size()).forEachOrdered(i -> {
                Schema.FieldType type = ((Schema.Field)fieldTypes.get(i)).getType();
                try {
                    JdbcUtil.getPreparedStatementSetCaller(type).set(row, statement, i, SchemaUtil.FieldWithIndex.of(schema.getField(i), i));
                }
                catch (SQLException throwables) {
                    throwables.printStackTrace();
                    throw new RuntimeException(String.format("Unable to create prepared statement for type: %s", type), throwables);
                }
            });
        }
    }
}

