/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.jdbc;

import com.google.auto.service.AutoService;
import com.google.auto.value.AutoValue;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.beam.sdk.io.jdbc.AutoValue_JdbcReadSchemaTransformProvider_JdbcReadSchemaTransformConfiguration;
import org.apache.beam.sdk.io.jdbc.JdbcIO;
import org.apache.beam.sdk.schemas.AutoValueSchema;
import org.apache.beam.sdk.schemas.annotations.DefaultSchema;
import org.apache.beam.sdk.schemas.transforms.SchemaTransform;
import org.apache.beam.sdk.schemas.transforms.SchemaTransformProvider;
import org.apache.beam.sdk.schemas.transforms.TypedSchemaTransformProvider;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionRowTuple;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Strings;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@AutoService(value={SchemaTransformProvider.class})
public class JdbcReadSchemaTransformProvider
extends TypedSchemaTransformProvider<JdbcReadSchemaTransformConfiguration> {
    protected @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized JdbcReadSchemaTransformConfiguration> configurationClass() {
        return JdbcReadSchemaTransformConfiguration.class;
    }

    protected @UnknownKeyFor @NonNull @Initialized SchemaTransform from(@UnknownKeyFor @NonNull @Initialized JdbcReadSchemaTransformConfiguration configuration) {
        configuration.validate();
        return new JdbcReadSchemaTransform(configuration);
    }

    public @UnknownKeyFor @NonNull @Initialized String identifier() {
        return "beam:schematransform:org.apache.beam:jdbc_read:v1";
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> inputCollectionNames() {
        return Collections.emptyList();
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> outputCollectionNames() {
        return Collections.singletonList("output");
    }

    @DefaultSchema(value=AutoValueSchema.class)
    @AutoValue
    public static abstract class JdbcReadSchemaTransformConfiguration
    implements Serializable {
        public abstract @UnknownKeyFor @NonNull @Initialized String getDriverClassName();

        public abstract @UnknownKeyFor @NonNull @Initialized String getJdbcUrl();

        @Nullable
        public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized String getUsername();

        @Nullable
        public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized String getPassword();

        @Nullable
        public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized String getConnectionProperties();

        @Nullable
        public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized List<@org.checkerframework.checker.nullness.qual.Nullable @UnknownKeyFor @Initialized String> getConnectionInitSql();

        @Nullable
        public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized String getReadQuery();

        @Nullable
        public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized String getLocation();

        @Nullable
        public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Short getFetchSize();

        @Nullable
        public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Boolean getOutputParallelization();

        public void validate() throws @UnknownKeyFor @NonNull @Initialized IllegalArgumentException {
            boolean locationPresent;
            if (Strings.isNullOrEmpty((String)this.getDriverClassName())) {
                throw new IllegalArgumentException("JDBC Driver class name cannot be blank.");
            }
            if (Strings.isNullOrEmpty((String)this.getJdbcUrl())) {
                throw new IllegalArgumentException("JDBC URL cannot be blank");
            }
            boolean readQueryPresent = this.getReadQuery() != null && !"".equals(this.getReadQuery());
            boolean bl = locationPresent = this.getLocation() != null && !"".equals(this.getLocation());
            if (readQueryPresent && locationPresent) {
                throw new IllegalArgumentException("ReadQuery and Location are mutually exclusive configurations");
            }
            if (!readQueryPresent && !locationPresent) {
                throw new IllegalArgumentException("Either ReadQuery or Location must be set.");
            }
        }

        public static @UnknownKeyFor @NonNull @Initialized Builder builder() {
            return new AutoValue_JdbcReadSchemaTransformProvider_JdbcReadSchemaTransformConfiguration.Builder();
        }

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract @UnknownKeyFor @NonNull @Initialized Builder setDriverClassName(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setJdbcUrl(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setUsername(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setPassword(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setLocation(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setReadQuery(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setConnectionProperties(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setConnectionInitSql(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setFetchSize(@UnknownKeyFor @NonNull @Initialized Short var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setOutputParallelization(@UnknownKeyFor @NonNull @Initialized Boolean var1);

            public abstract @UnknownKeyFor @NonNull @Initialized JdbcReadSchemaTransformConfiguration build();
        }
    }

    static class JdbcReadSchemaTransform
    extends SchemaTransform
    implements Serializable {
        @UnknownKeyFor @NonNull @Initialized JdbcReadSchemaTransformConfiguration config;

        public JdbcReadSchemaTransform(@UnknownKeyFor @NonNull @Initialized JdbcReadSchemaTransformConfiguration config) {
            this.config = config;
        }

        protected @UnknownKeyFor @NonNull @Initialized JdbcIO.DataSourceConfiguration dataSourceConfiguration() {
            List<String> initialSql;
            JdbcIO.DataSourceConfiguration dsConfig = JdbcIO.DataSourceConfiguration.create(this.config.getDriverClassName(), this.config.getJdbcUrl()).withUsername("".equals(this.config.getUsername()) ? null : this.config.getUsername()).withPassword("".equals(this.config.getPassword()) ? null : this.config.getPassword());
            String connectionProperties = this.config.getConnectionProperties();
            if (connectionProperties != null) {
                dsConfig = dsConfig.withConnectionProperties(connectionProperties);
            }
            if ((initialSql = this.config.getConnectionInitSql()) != null && initialSql.size() > 0) {
                dsConfig = dsConfig.withConnectionInitSqls(initialSql);
            }
            return dsConfig;
        }

        public @UnknownKeyFor @NonNull @Initialized PCollectionRowTuple expand(@UnknownKeyFor @NonNull @Initialized PCollectionRowTuple input) {
            Boolean outputParallelization;
            String query = this.config.getReadQuery();
            if (query == null) {
                query = String.format("SELECT * FROM %s", this.config.getLocation());
            }
            JdbcIO.ReadRows readRows = JdbcIO.readRows().withDataSourceConfiguration(this.dataSourceConfiguration()).withQuery(query);
            Short fetchSize = this.config.getFetchSize();
            if (fetchSize != null && fetchSize > 0) {
                readRows = readRows.withFetchSize(fetchSize.shortValue());
            }
            if ((outputParallelization = this.config.getOutputParallelization()) != null) {
                readRows = readRows.withOutputParallelization(outputParallelization);
            }
            return PCollectionRowTuple.of((String)"output", (PCollection)((PCollection)input.getPipeline().apply((PTransform)readRows)));
        }
    }
}

