/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.jdbc;

import java.sql.Date;
import java.sql.JDBCType;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.beam.sdk.io.jdbc.JdbcIO;
import org.apache.beam.sdk.io.jdbc.LogicalTypes;
import org.apache.beam.sdk.io.jdbc.SchemaUtil;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.logicaltypes.MicrosInstant;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.ReadableDateTime;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JdbcUtil {
    private static Map<Schema.TypeName, JdbcIO.PreparedStatementSetCaller> typeNamePsSetCallerMap = new EnumMap<Schema.TypeName, JdbcIO.PreparedStatementSetCaller>((Map<Schema.TypeName, JdbcIO.PreparedStatementSetCaller>)ImmutableMap.builder().put((Object)Schema.TypeName.BYTE, (element, ps, i, fieldWithIndex) -> {
        Byte value = element.getByte(fieldWithIndex.getIndex().intValue());
        if (value == null) {
            JdbcUtil.setNullToPreparedStatement(ps, i);
        } else {
            ps.setByte(i + 1, value);
        }
    }).put((Object)Schema.TypeName.INT16, (element, ps, i, fieldWithIndex) -> {
        Short value = element.getInt16(fieldWithIndex.getIndex().intValue());
        if (value == null) {
            JdbcUtil.setNullToPreparedStatement(ps, i);
        } else {
            ps.setInt(i + 1, value.shortValue());
        }
    }).put((Object)Schema.TypeName.INT64, (element, ps, i, fieldWithIndex) -> {
        Long value = element.getInt64(fieldWithIndex.getIndex().intValue());
        if (value == null) {
            JdbcUtil.setNullToPreparedStatement(ps, i);
        } else {
            ps.setLong(i + 1, value);
        }
    }).put((Object)Schema.TypeName.DECIMAL, (element, ps, i, fieldWithIndex) -> ps.setBigDecimal(i + 1, element.getDecimal(fieldWithIndex.getIndex().intValue()))).put((Object)Schema.TypeName.FLOAT, (element, ps, i, fieldWithIndex) -> {
        Float value = element.getFloat(fieldWithIndex.getIndex().intValue());
        if (value == null) {
            JdbcUtil.setNullToPreparedStatement(ps, i);
        } else {
            ps.setFloat(i + 1, value.floatValue());
        }
    }).put((Object)Schema.TypeName.DOUBLE, (element, ps, i, fieldWithIndex) -> {
        Double value = element.getDouble(fieldWithIndex.getIndex().intValue());
        if (value == null) {
            JdbcUtil.setNullToPreparedStatement(ps, i);
        } else {
            ps.setDouble(i + 1, value);
        }
    }).put((Object)Schema.TypeName.DATETIME, (element, ps, i, fieldWithIndex) -> {
        ReadableDateTime value = element.getDateTime(fieldWithIndex.getIndex().intValue());
        ps.setTimestamp(i + 1, value == null ? null : new Timestamp(value.getMillis()));
    }).put((Object)Schema.TypeName.BOOLEAN, (element, ps, i, fieldWithIndex) -> {
        Boolean value = element.getBoolean(fieldWithIndex.getIndex().intValue());
        if (value == null) {
            JdbcUtil.setNullToPreparedStatement(ps, i);
        } else {
            ps.setBoolean(i + 1, value);
        }
    }).put((Object)Schema.TypeName.BYTES, (Object)JdbcUtil.createBytesCaller()).put((Object)Schema.TypeName.INT32, (element, ps, i, fieldWithIndex) -> {
        Integer value = element.getInt32(fieldWithIndex.getIndex().intValue());
        if (value == null) {
            JdbcUtil.setNullToPreparedStatement(ps, i);
        } else {
            ps.setInt(i + 1, value);
        }
    }).put((Object)Schema.TypeName.STRING, (Object)JdbcUtil.createStringCaller()).build());
    public static final Map<Class<?>, JdbcReadWithPartitionsHelper<?>> PRESET_HELPERS = ImmutableMap.of(Long.class, (Object)new JdbcReadWithPartitionsHelper<Long>(){

        @Override
        public Iterable<KV<Long, Long>> calculateRanges(Long lowerBound, Long upperBound, Long partitions) {
            ArrayList<KV<Long, Long>> ranges = new ArrayList<KV<Long, Long>>();
            long stride = upperBound / partitions - lowerBound / partitions + 1L;
            long highest = lowerBound;
            for (long i = lowerBound.longValue(); i < upperBound - stride; i += stride) {
                ranges.add(KV.of((Object)i, (Object)(i + stride)));
                highest = i + stride;
            }
            if (highest < upperBound + 1L) {
                ranges.add((KV<Long, Long>)KV.of((Object)highest, (Object)(upperBound + 1L)));
            }
            return ranges;
        }

        @Override
        public void setParameters(KV<Long, Long> element, PreparedStatement preparedStatement) {
            try {
                preparedStatement.setLong(1, (Long)element.getKey());
                preparedStatement.setLong(2, (Long)element.getValue());
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public KV<Long, KV<Long, Long>> mapRow(ResultSet resultSet) throws Exception {
            if (resultSet.getMetaData().getColumnCount() == 3) {
                return KV.of((Object)resultSet.getLong(3), (Object)KV.of((Object)resultSet.getLong(1), (Object)resultSet.getLong(2)));
            }
            return KV.of((Object)0L, (Object)KV.of((Object)resultSet.getLong(1), (Object)resultSet.getLong(2)));
        }
    }, DateTime.class, (Object)new JdbcReadWithPartitionsHelper<DateTime>(){

        @Override
        public Iterable<KV<DateTime, DateTime>> calculateRanges(DateTime lowerBound, DateTime upperBound, Long partitions) {
            ArrayList<KV<DateTime, DateTime>> result = new ArrayList<KV<DateTime, DateTime>>();
            long intervalMillis = upperBound.getMillis() - lowerBound.getMillis();
            Duration stride = Duration.millis((long)Math.max(1L, intervalMillis / partitions));
            DateTime currentLowerBound = lowerBound;
            while (currentLowerBound.compareTo((ReadableInstant)upperBound) <= 0) {
                DateTime currentUpper = currentLowerBound.plus((ReadableDuration)stride);
                if (currentUpper.compareTo((ReadableInstant)upperBound) >= 0) {
                    currentUpper = upperBound.plusMillis(1);
                    result.add((KV<DateTime, DateTime>)KV.of((Object)currentLowerBound, (Object)currentUpper));
                    return result;
                }
                result.add((KV<DateTime, DateTime>)KV.of((Object)currentLowerBound, (Object)currentUpper));
                currentLowerBound = currentLowerBound.plus((ReadableDuration)stride);
            }
            return result;
        }

        @Override
        public void setParameters(KV<DateTime, DateTime> element, PreparedStatement preparedStatement) {
            try {
                preparedStatement.setTimestamp(1, new Timestamp(((DateTime)element.getKey()).getMillis()));
                preparedStatement.setTimestamp(2, new Timestamp(((DateTime)element.getValue()).getMillis()));
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public KV<Long, KV<DateTime, DateTime>> mapRow(ResultSet resultSet) throws Exception {
            if (resultSet.getMetaData().getColumnCount() == 3) {
                return KV.of((Object)resultSet.getLong(3), (Object)KV.of((Object)new DateTime((Object)resultSet.getTimestamp(1)), (Object)new DateTime((Object)resultSet.getTimestamp(2))));
            }
            return KV.of((Object)0L, (Object)KV.of((Object)new DateTime((Object)resultSet.getTimestamp(1)), (Object)new DateTime((Object)resultSet.getTimestamp(2))));
        }
    });

    JdbcUtil() {
    }

    static String generateStatement(String tableName, List<Schema.Field> fields) {
        String fieldNames = IntStream.range(0, fields.size()).mapToObj(index -> ((Schema.Field)fields.get(index)).getName()).collect(Collectors.joining(", "));
        String valuePlaceholder = IntStream.range(0, fields.size()).mapToObj(index -> "?").collect(Collectors.joining(", "));
        return String.format("INSERT INTO %s(%s) VALUES(%s)", tableName, fieldNames, valuePlaceholder);
    }

    static JdbcIO.PreparedStatementSetCaller getPreparedStatementSetCaller(Schema.FieldType fieldType) {
        switch (fieldType.getTypeName()) {
            case ARRAY: 
            case ITERABLE: {
                return (element, ps, i, fieldWithIndex) -> {
                    Collection value = element.getArray(fieldWithIndex.getIndex().intValue());
                    if (value == null) {
                        ps.setArray(i + 1, null);
                    } else {
                        ps.setArray(i + 1, ps.getConnection().createArrayOf(fieldType.getCollectionElementType().getTypeName().name(), value.toArray()));
                    }
                };
            }
            case LOGICAL_TYPE: {
                if (Objects.equals(fieldType.getLogicalType(), LogicalTypes.JDBC_UUID_TYPE.getLogicalType())) {
                    return (element, ps, i, fieldWithIndex) -> ps.setObject(i + 1, element.getLogicalTypeValue(fieldWithIndex.getIndex().intValue(), UUID.class));
                }
                String logicalTypeName = fieldType.getLogicalType().getIdentifier();
                if (logicalTypeName.equals(MicrosInstant.IDENTIFIER)) {
                    return (element, ps, i, fieldWithIndex) -> {
                        Instant value = (Instant)element.getLogicalTypeValue(fieldWithIndex.getIndex().intValue(), Instant.class);
                        ps.setTimestamp(i + 1, value == null ? null : new Timestamp(value.toEpochMilli()));
                    };
                }
                if (logicalTypeName.equals("beam:logical_type:fixed_decimal:v1")) {
                    return (element, ps, i, fieldWithIndex) -> ps.setBigDecimal(i + 1, element.getDecimal(fieldWithIndex.getIndex().intValue()));
                }
                JDBCType jdbcType = JDBCType.valueOf(logicalTypeName);
                switch (jdbcType) {
                    case DATE: {
                        return (element, ps, i, fieldWithIndex) -> {
                            ReadableDateTime value = element.getDateTime(fieldWithIndex.getIndex().intValue());
                            ps.setDate(i + 1, value == null ? null : new Date(JdbcUtil.getDateOrTimeOnly(value.toDateTime(), true).getTime().getTime()));
                        };
                    }
                    case TIME: {
                        return (element, ps, i, fieldWithIndex) -> {
                            ReadableDateTime value = element.getDateTime(fieldWithIndex.getIndex().intValue());
                            ps.setTime(i + 1, value == null ? null : new Time(JdbcUtil.getDateOrTimeOnly(element.getDateTime(fieldWithIndex.getIndex().intValue()).toDateTime(), false).getTime().getTime()));
                        };
                    }
                    case TIMESTAMP_WITH_TIMEZONE: {
                        return (element, ps, i, fieldWithIndex) -> {
                            ReadableDateTime value = element.getDateTime(fieldWithIndex.getIndex().intValue());
                            if (value == null) {
                                ps.setTimestamp(i + 1, null);
                            } else {
                                Calendar calendar = JdbcUtil.withTimestampAndTimezone(value.toDateTime());
                                ps.setTimestamp(i + 1, new Timestamp(calendar.getTime().getTime()), calendar);
                            }
                        };
                    }
                    case OTHER: {
                        return (element, ps, i, fieldWithIndex) -> ps.setObject(i + 1, element.getValue(fieldWithIndex.getIndex().intValue()), 1111);
                    }
                }
                return JdbcUtil.getPreparedStatementSetCaller(fieldType.getLogicalType().getBaseType());
            }
        }
        if (typeNamePsSetCallerMap.containsKey(fieldType.getTypeName())) {
            return typeNamePsSetCallerMap.get(fieldType.getTypeName());
        }
        throw new RuntimeException(fieldType.getTypeName().name() + " in schema is not supported while writing. Please provide statement and preparedStatementSetter");
    }

    static void setNullToPreparedStatement(PreparedStatement ps, int i) throws SQLException {
        ps.setNull(i + 1, JDBCType.NULL.getVendorTypeNumber());
    }

    private static JdbcIO.PreparedStatementSetCaller createBytesCaller() {
        return (element, ps, i, fieldWithIndex) -> {
            byte[] value = element.getBytes(fieldWithIndex.getIndex().intValue());
            if (value != null) {
                JdbcUtil.validateLogicalTypeLength(fieldWithIndex.getField(), value.length);
            }
            ps.setBytes(i + 1, value);
        };
    }

    private static JdbcIO.PreparedStatementSetCaller createStringCaller() {
        return (element, ps, i, fieldWithIndex) -> {
            String value = element.getString(fieldWithIndex.getIndex().intValue());
            if (value != null) {
                JdbcUtil.validateLogicalTypeLength(fieldWithIndex.getField(), value.length());
            }
            ps.setString(i + 1, value);
        };
    }

    private static void validateLogicalTypeLength(Schema.Field field, Integer length) {
        try {
            if (field.getType().getTypeName().isLogicalType() && field.getType().getLogicalType().getArgument() != null) {
                int maxLimit = (Integer)field.getType().getLogicalType().getArgument();
                if (length > maxLimit) {
                    throw new RuntimeException(String.format("Length of Schema.Field[%s] data exceeds database column capacity", field.getName()));
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private static Calendar getDateOrTimeOnly(DateTime dateTime, boolean wantDateOnly) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeZone(TimeZone.getTimeZone(dateTime.getZone().getID()));
        if (wantDateOnly) {
            cal.set(1, dateTime.getYear());
            cal.set(2, dateTime.getMonthOfYear() - 1);
            cal.set(5, dateTime.getDayOfMonth());
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
        } else {
            cal.set(1, 1970);
            cal.set(2, 0);
            cal.set(5, 1);
            cal.set(11, dateTime.getHourOfDay());
            cal.set(12, dateTime.getMinuteOfHour());
            cal.set(13, dateTime.getSecondOfMinute());
            cal.set(14, dateTime.getMillisOfSecond());
        }
        return cal;
    }

    private static Calendar withTimestampAndTimezone(DateTime dateTime) {
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone(dateTime.getZone().getID()));
        calendar.setTimeInMillis(dateTime.getMillis());
        return calendar;
    }

    static class PartitioningFn<T>
    extends DoFn<KV<Long, KV<T, T>>, KV<T, T>> {
        private static final Logger LOG = LoggerFactory.getLogger(PartitioningFn.class);
        final TypeDescriptor<T> partitioningColumnType;

        PartitioningFn(TypeDescriptor<T> partitioningColumnType) {
            this.partitioningColumnType = partitioningColumnType;
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext c) {
            Object lowerBound = ((KV)((KV)c.element()).getValue()).getKey();
            Object upperBound = ((KV)((KV)c.element()).getValue()).getValue();
            JdbcReadWithPartitionsHelper<T> helper = JdbcReadWithPartitionsHelper.getPartitionsHelper(this.partitioningColumnType);
            ArrayList ranges = Lists.newArrayList(helper.calculateRanges(lowerBound, upperBound, (Long)((KV)c.element()).getKey()));
            LOG.warn("Total of {} ranges: {}", (Object)ranges.size(), (Object)ranges);
            for (KV e : ranges) {
                c.output((Object)e);
            }
        }
    }

    static interface JdbcReadWithPartitionsHelper<PartitionT>
    extends JdbcIO.PreparedStatementSetter<KV<PartitionT, PartitionT>>,
    JdbcIO.RowMapper<KV<Long, KV<PartitionT, PartitionT>>> {
        public static <T> JdbcReadWithPartitionsHelper<T> getPartitionsHelper(TypeDescriptor<T> type) {
            return PRESET_HELPERS.get(type.getRawType());
        }

        public Iterable<KV<PartitionT, PartitionT>> calculateRanges(PartitionT var1, PartitionT var2, Long var3);

        @Override
        public void setParameters(KV<PartitionT, PartitionT> var1, PreparedStatement var2);

        @Override
        public KV<Long, KV<PartitionT, PartitionT>> mapRow(ResultSet var1) throws Exception;
    }

    static class BeamRowPreparedStatementSetter
    implements JdbcIO.PreparedStatementSetter<Row> {
        BeamRowPreparedStatementSetter() {
        }

        @Override
        public void setParameters(Row row, PreparedStatement statement) {
            Schema schema = row.getSchema();
            List fieldTypes = schema.getFields();
            IntStream.range(0, fieldTypes.size()).forEachOrdered(i -> {
                Schema.FieldType type = ((Schema.Field)fieldTypes.get(i)).getType();
                try {
                    JdbcUtil.getPreparedStatementSetCaller(type).set(row, statement, i, SchemaUtil.FieldWithIndex.of(schema.getField(i), i));
                }
                catch (SQLException throwables) {
                    throwables.printStackTrace();
                    throw new RuntimeException(String.format("Unable to create prepared statement for type: %s", type), throwables);
                }
            });
        }
    }
}

