/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.jdbc;

import com.google.auto.service.AutoService;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.io.jdbc.JdbcIO;
import org.apache.beam.sdk.io.jdbc.JdbcUtil;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.io.SchemaIO;
import org.apache.beam.sdk.schemas.io.SchemaIOProvider;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PDone;
import org.apache.beam.sdk.values.Row;

@Internal
@AutoService(value={SchemaIOProvider.class})
public class JdbcSchemaIOProvider
implements SchemaIOProvider {
    public String identifier() {
        return "jdbc";
    }

    public Schema configurationSchema() {
        return Schema.builder().addStringField("driverClassName").addStringField("jdbcUrl").addStringField("username").addStringField("password").addNullableField("connectionProperties", Schema.FieldType.STRING).addNullableField("connectionInitSqls", Schema.FieldType.iterable((Schema.FieldType)Schema.FieldType.STRING)).addNullableField("readQuery", Schema.FieldType.STRING).addNullableField("writeStatement", Schema.FieldType.STRING).addNullableField("fetchSize", Schema.FieldType.INT16).addNullableField("outputParallelization", Schema.FieldType.BOOLEAN).addNullableField("autosharding", Schema.FieldType.BOOLEAN).build();
    }

    public JdbcSchemaIO from(String location, Row configuration, Schema dataSchema) {
        return new JdbcSchemaIO(location, configuration);
    }

    public boolean requiresDataSchema() {
        return false;
    }

    public PCollection.IsBounded isBounded() {
        return PCollection.IsBounded.BOUNDED;
    }

    static class JdbcSchemaIO
    implements SchemaIO,
    Serializable {
        protected final Row config;
        protected final String location;

        JdbcSchemaIO(String location, Row config) {
            this.config = config;
            this.location = location;
        }

        public Schema schema() {
            return null;
        }

        public PTransform<PBegin, PCollection<Row>> buildReader() {
            return new PTransform<PBegin, PCollection<Row>>(){

                public PCollection<Row> expand(PBegin input) {
                    String readQuery = config.getString("readQuery") != null ? config.getString("readQuery") : String.format("SELECT * FROM %s", location);
                    JdbcIO.ReadRows readRows = JdbcIO.readRows().withDataSourceConfiguration(this.getDataSourceConfiguration()).withQuery(readQuery);
                    if (config.getInt16("fetchSize") != null) {
                        readRows = readRows.withFetchSize(config.getInt16("fetchSize").shortValue());
                    }
                    if (config.getBoolean("outputParallelization") != null) {
                        readRows = readRows.withOutputParallelization(config.getBoolean("outputParallelization"));
                    }
                    return (PCollection)input.apply((PTransform)readRows);
                }
            };
        }

        public PTransform<PCollection<Row>, PDone> buildWriter() {
            return new PTransform<PCollection<Row>, PDone>(){

                public PDone expand(PCollection<Row> input) {
                    JdbcIO.Write<Row> writeRows = JdbcIO.write().withDataSourceConfiguration(this.getDataSourceConfiguration()).withStatement(this.generateWriteStatement(input.getSchema())).withPreparedStatementSetter(new JdbcUtil.BeamRowPreparedStatementSetter());
                    if (config.getBoolean("autosharding") != null && config.getBoolean("autosharding").booleanValue()) {
                        writeRows = writeRows.withAutoSharding();
                    }
                    return (PDone)input.apply(writeRows);
                }
            };
        }

        protected JdbcIO.DataSourceConfiguration getDataSourceConfiguration() {
            Iterable connectionInitSqls = this.config.getIterable("connectionInitSqls");
            JdbcIO.DataSourceConfiguration dataSourceConfiguration = JdbcIO.DataSourceConfiguration.create(this.config.getString("driverClassName"), this.config.getString("jdbcUrl")).withUsername(this.config.getString("username")).withPassword(this.config.getString("password"));
            if (this.config.getString("connectionProperties") != null) {
                dataSourceConfiguration = dataSourceConfiguration.withConnectionProperties(this.config.getString("connectionProperties"));
            }
            if (connectionInitSqls != null) {
                List<String> initSqls = StreamSupport.stream(connectionInitSqls.spliterator(), false).collect(Collectors.toList());
                dataSourceConfiguration = dataSourceConfiguration.withConnectionInitSqls(initSqls);
            }
            return dataSourceConfiguration;
        }

        private String generateWriteStatement(Schema schema) {
            if (this.config.getString("writeStatement") != null) {
                return this.config.getString("writeStatement");
            }
            StringBuilder writeStatement = new StringBuilder("INSERT INTO ");
            writeStatement.append(this.location);
            writeStatement.append(" VALUES(");
            for (int i = 0; i < schema.getFieldCount() - 1; ++i) {
                writeStatement.append("?, ");
            }
            writeStatement.append("?)");
            return writeStatement.toString();
        }
    }
}

