/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.jdbc;

import java.util.List;
import java.util.Map;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.expansion.ExternalTransformRegistrar;
import org.apache.beam.sdk.io.jdbc.JdbcIO;
import org.apache.beam.sdk.io.jdbc.JdbcUtil;
import org.apache.beam.sdk.transforms.ExternalTransformBuilder;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PDone;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.checkerframework.checker.nullness.qual.Nullable;

@Experimental(value=Experimental.Kind.PORTABILITY)
public class JdbcTransformsRegistrar
implements ExternalTransformRegistrar {
    public static final String READ_ROWS_URN = "beam:external:java:jdbc:read_rows:v1";
    public static final String WRITE_URN = "beam:external:java:jdbc:write:v1";

    public Map<String, ExternalTransformBuilder<?, ?, ?>> knownBuilderInstances() {
        return ImmutableMap.of((Object)READ_ROWS_URN, (Object)new ReadRowsBuilder(), (Object)WRITE_URN, (Object)new WriteBuilder());
    }

    public static class WriteBuilder
    implements ExternalTransformBuilder<Configuration, PCollection<Row>, PDone> {
        public PTransform<PCollection<Row>, PDone> buildExternal(Configuration configuration) {
            JdbcIO.DataSourceConfiguration dataSourceConfiguration = configuration.getDataSourceConfiguration();
            return JdbcIO.write().withDataSourceConfiguration(dataSourceConfiguration).withStatement(configuration.statement).withPreparedStatementSetter(new JdbcUtil.BeamRowPreparedStatementSetter());
        }

        public static class Configuration
        extends CrossLanguageConfiguration {
            private String statement;

            public void setStatement(String statement) {
                this.statement = statement;
            }
        }
    }

    public static class ReadRowsBuilder
    implements ExternalTransformBuilder<Configuration, PBegin, PCollection<Row>> {
        public PTransform<PBegin, PCollection<Row>> buildExternal(Configuration configuration) {
            JdbcIO.ReadRows readRows = JdbcIO.readRows().withDataSourceConfiguration(configuration.getDataSourceConfiguration()).withQuery(configuration.query);
            if (configuration.fetchSize != null) {
                readRows = readRows.withFetchSize(configuration.fetchSize);
            }
            if (configuration.outputParallelization != null) {
                readRows = readRows.withOutputParallelization(configuration.outputParallelization);
            }
            return readRows;
        }

        public static class Configuration
        extends CrossLanguageConfiguration {
            private String query;
            private @Nullable Integer fetchSize;
            private @Nullable Boolean outputParallelization;

            public void setOutputParallelization(@Nullable Boolean outputParallelization) {
                this.outputParallelization = outputParallelization;
            }

            public void setFetchSize(@Nullable Long fetchSize) {
                if (fetchSize != null) {
                    this.fetchSize = fetchSize.intValue();
                }
            }

            public void setQuery(String query) {
                this.query = query;
            }
        }
    }

    private static class CrossLanguageConfiguration {
        String driverClassName;
        String jdbcUrl;
        String username;
        String password;
        @Nullable String connectionProperties;
        @Nullable List<String> connectionInitSqls;

        private CrossLanguageConfiguration() {
        }

        public void setDriverClassName(String driverClassName) {
            this.driverClassName = driverClassName;
        }

        public void setJdbcUrl(String jdbcUrl) {
            this.jdbcUrl = jdbcUrl;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public void setConnectionProperties(@Nullable String connectionProperties) {
            this.connectionProperties = connectionProperties;
        }

        public void setConnectionInitSqls(@Nullable List<String> connectionInitSqls) {
            this.connectionInitSqls = connectionInitSqls;
        }

        protected JdbcIO.DataSourceConfiguration getDataSourceConfiguration() {
            JdbcIO.DataSourceConfiguration dataSourceConfiguration = JdbcIO.DataSourceConfiguration.create(this.driverClassName, this.jdbcUrl).withUsername(this.username).withPassword(this.password);
            if (this.connectionProperties != null) {
                dataSourceConfiguration = dataSourceConfiguration.withConnectionProperties(this.connectionProperties);
            }
            if (this.connectionInitSqls != null) {
                dataSourceConfiguration = dataSourceConfiguration.withConnectionInitSqls(this.connectionInitSqls);
            }
            return dataSourceConfiguration;
        }
    }
}

