/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.jdbc;

import java.math.BigDecimal;
import java.sql.JDBCType;
import java.time.Instant;
import java.util.Arrays;
import java.util.Objects;
import org.apache.beam.repackaged.core.org.apache.commons.lang3.StringUtils;
import org.apache.beam.sdk.schemas.LogicalTypes;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;

public class LogicalTypes {
    public static final Schema.FieldType JDBC_BIT_TYPE = Schema.FieldType.logicalType((Schema.LogicalType)new LogicalTypes.PassThroughLogicalType<Boolean>(JDBCType.BIT.getName(), "", Schema.FieldType.BOOLEAN){});
    public static final Schema.FieldType JDBC_DATE_TYPE = Schema.FieldType.logicalType((Schema.LogicalType)new LogicalTypes.PassThroughLogicalType<Instant>(JDBCType.DATE.getName(), "", Schema.FieldType.DATETIME){});
    public static final Schema.FieldType JDBC_FLOAT_TYPE = Schema.FieldType.logicalType((Schema.LogicalType)new LogicalTypes.PassThroughLogicalType<Double>(JDBCType.FLOAT.getName(), "", Schema.FieldType.DOUBLE){});
    public static final Schema.FieldType JDBC_TIME_TYPE = Schema.FieldType.logicalType((Schema.LogicalType)new LogicalTypes.PassThroughLogicalType<Instant>(JDBCType.TIME.getName(), "", Schema.FieldType.DATETIME){});
    public static final Schema.FieldType JDBC_TIMESTAMP_WITH_TIMEZONE_TYPE = Schema.FieldType.logicalType((Schema.LogicalType)new LogicalTypes.PassThroughLogicalType<Instant>(JDBCType.TIMESTAMP_WITH_TIMEZONE.getName(), "", Schema.FieldType.DATETIME){});

    @VisibleForTesting
    static Schema.FieldType fixedLengthString(JDBCType jdbcType, int length) {
        return Schema.FieldType.logicalType((Schema.LogicalType)FixedLengthString.of(jdbcType.getName(), length));
    }

    @VisibleForTesting
    static Schema.FieldType fixedLengthBytes(JDBCType jdbcType, int length) {
        return Schema.FieldType.logicalType((Schema.LogicalType)FixedLengthBytes.of(jdbcType.getName(), length));
    }

    @VisibleForTesting
    static Schema.FieldType variableLengthString(JDBCType jdbcType, int length) {
        return Schema.FieldType.logicalType((Schema.LogicalType)VariableLengthString.of(jdbcType.getName(), length));
    }

    @VisibleForTesting
    static Schema.FieldType variableLengthBytes(JDBCType jdbcType, int length) {
        return Schema.FieldType.logicalType((Schema.LogicalType)VariableLengthBytes.of(jdbcType.getName(), length));
    }

    @VisibleForTesting
    static Schema.FieldType numeric(int precision, int scale) {
        return Schema.FieldType.logicalType((Schema.LogicalType)FixedPrecisionNumeric.of(JDBCType.NUMERIC.getName(), precision, scale));
    }

    public static final class FixedPrecisionNumeric
    extends JdbcLogicalType<BigDecimal> {
        private final int precision;
        private final int scale;

        public static FixedPrecisionNumeric of(String identifier, int precision, int scale) {
            return new FixedPrecisionNumeric(identifier, precision, scale);
        }

        private FixedPrecisionNumeric(String identifier, int precision, int scale) {
            super(identifier, Schema.FieldType.DECIMAL, precision + ":" + scale);
            this.precision = precision;
            this.scale = scale;
        }

        public BigDecimal toInputType(BigDecimal base) {
            Preconditions.checkArgument((base == null || base.precision() == this.precision && base.scale() == this.scale ? 1 : 0) != 0);
            return base;
        }
    }

    public static final class VariableLengthBytes
    extends JdbcLogicalType<byte[]> {
        private final int maxLength;

        public static VariableLengthBytes of(String identifier, int maxLength) {
            return new VariableLengthBytes(identifier, maxLength);
        }

        private VariableLengthBytes(String identifier, int maxLength) {
            super(identifier, Schema.FieldType.BYTES, String.valueOf(maxLength));
            this.maxLength = maxLength;
        }

        public byte[] toInputType(byte[] base) {
            Preconditions.checkArgument((base == null || base.length <= this.maxLength ? 1 : 0) != 0);
            return base;
        }
    }

    public static final class VariableLengthString
    extends JdbcLogicalType<String> {
        private final int maxLength;

        public static VariableLengthString of(String identifier, int maxLength) {
            return new VariableLengthString(identifier, maxLength);
        }

        private VariableLengthString(String identifier, int maxLength) {
            super(identifier, Schema.FieldType.STRING, String.valueOf(maxLength));
            this.maxLength = maxLength;
        }

        public String toInputType(String base) {
            Preconditions.checkArgument((base == null || base.length() <= this.maxLength ? 1 : 0) != 0);
            return base;
        }
    }

    public static final class FixedLengthBytes
    extends JdbcLogicalType<byte[]> {
        private final int length;

        public static FixedLengthBytes of(String identifier, int length) {
            return new FixedLengthBytes(identifier, length);
        }

        private FixedLengthBytes(String identifier, int length) {
            super(identifier, Schema.FieldType.BYTES, String.valueOf(length));
            this.length = length;
        }

        public byte[] toInputType(byte[] base) {
            Preconditions.checkArgument((base == null || base.length <= this.length ? 1 : 0) != 0);
            if (base == null || base.length == this.length) {
                return base;
            }
            return Arrays.copyOf(base, this.length);
        }
    }

    public static final class FixedLengthString
    extends JdbcLogicalType<String> {
        private final int length;

        public static FixedLengthString of(String identifier, int length) {
            return new FixedLengthString(identifier, length);
        }

        private FixedLengthString(String identifier, int length) {
            super(identifier, Schema.FieldType.STRING, String.valueOf(length));
            this.length = length;
        }

        public String toInputType(String base) {
            Preconditions.checkArgument((base == null || base.length() <= this.length ? 1 : 0) != 0);
            return StringUtils.rightPad((String)base, (int)this.length);
        }
    }

    public static abstract class JdbcLogicalType<T>
    implements Schema.LogicalType<T, T> {
        protected final String identifier;
        protected final Schema.FieldType baseType;
        protected final String argument;

        protected JdbcLogicalType(String identifier, Schema.FieldType baseType, String argument) {
            this.identifier = identifier;
            this.baseType = baseType;
            this.argument = argument;
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public String getArgument() {
            return this.argument;
        }

        public Schema.FieldType getBaseType() {
            return this.baseType;
        }

        public T toBaseType(T input) {
            return input;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof JdbcLogicalType)) {
                return false;
            }
            JdbcLogicalType that = (JdbcLogicalType)o;
            return Objects.equals(this.identifier, that.identifier) && Objects.equals(this.baseType, that.baseType) && Objects.equals(this.argument, that.argument);
        }

        public int hashCode() {
            return Objects.hash(this.identifier, this.baseType, this.argument);
        }
    }
}

