/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.jdbc;

import com.google.auto.value.AutoValue;
import java.io.IOException;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.sql.DataSource;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.jdbc.AutoValue_JdbcIO_DataSourceConfiguration;
import org.apache.beam.sdk.io.jdbc.AutoValue_JdbcIO_Read;
import org.apache.beam.sdk.io.jdbc.AutoValue_JdbcIO_ReadAll;
import org.apache.beam.sdk.io.jdbc.AutoValue_JdbcIO_Write;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.Filter;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.ProcessFunction;
import org.apache.beam.sdk.transforms.Reshuffle;
import org.apache.beam.sdk.transforms.SerializableFunctions;
import org.apache.beam.sdk.transforms.View;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.util.BackOff;
import org.apache.beam.sdk.util.BackOffUtils;
import org.apache.beam.sdk.util.FluentBackoff;
import org.apache.beam.sdk.util.Sleeper;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.PDone;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Preconditions;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.commons.dbcp2.ConnectionFactory;
import org.apache.commons.dbcp2.DataSourceConnectionFactory;
import org.apache.commons.dbcp2.PoolableConnectionFactory;
import org.apache.commons.dbcp2.PoolingDataSource;
import org.apache.commons.pool2.ObjectPool;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.joda.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental(value=Experimental.Kind.SOURCE_SINK)
public class JdbcIO {
    private static final Logger LOG = LoggerFactory.getLogger(JdbcIO.class);
    private static final long DEFAULT_BATCH_SIZE = 1000L;
    private static final int DEFAULT_FETCH_SIZE = 50000;

    public static <T> Read<T> read() {
        return new AutoValue_JdbcIO_Read.Builder().setFetchSize(50000).build();
    }

    public static <ParameterT, OutputT> ReadAll<ParameterT, OutputT> readAll() {
        return new AutoValue_JdbcIO_ReadAll.Builder().setFetchSize(50000).build();
    }

    public static <T> Write<T> write() {
        return new AutoValue_JdbcIO_Write.Builder().setBatchSize(1000L).setRetryStrategy(new DefaultRetryStrategy()).build();
    }

    private JdbcIO() {
    }

    private static class Reparallelize<T>
    extends PTransform<PCollection<T>, PCollection<T>> {
        private Reparallelize() {
        }

        public PCollection<T> expand(PCollection<T> input) {
            PCollectionView empty = (PCollectionView)((PCollection)input.apply("Consume", (PTransform)Filter.by((ProcessFunction)SerializableFunctions.constant((Object)false)))).apply((PTransform)View.asIterable());
            PCollection materialized = (PCollection)input.apply("Identity", (PTransform)ParDo.of((DoFn)new DoFn<T, T>(){

                @DoFn.ProcessElement
                public void process(DoFn.ProcessContext c) {
                    c.output(c.element());
                }
            }).withSideInputs(new PCollectionView[]{empty}));
            return (PCollection)materialized.apply((PTransform)Reshuffle.viaRandomKey());
        }
    }

    @AutoValue
    public static abstract class Write<T>
    extends PTransform<PCollection<T>, PDone> {
        @Nullable
        abstract DataSourceConfiguration getDataSourceConfiguration();

        @Nullable
        abstract ValueProvider<String> getStatement();

        abstract long getBatchSize();

        @Nullable
        abstract PreparedStatementSetter<T> getPreparedStatementSetter();

        @Nullable
        abstract RetryStrategy getRetryStrategy();

        abstract Builder<T> toBuilder();

        public Write<T> withDataSourceConfiguration(DataSourceConfiguration config) {
            return this.toBuilder().setDataSourceConfiguration(config).build();
        }

        public Write<T> withStatement(String statement) {
            return this.withStatement((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)statement));
        }

        public Write<T> withStatement(ValueProvider<String> statement) {
            return this.toBuilder().setStatement(statement).build();
        }

        public Write<T> withPreparedStatementSetter(PreparedStatementSetter<T> setter) {
            return this.toBuilder().setPreparedStatementSetter(setter).build();
        }

        public Write<T> withBatchSize(long batchSize) {
            Preconditions.checkArgument((batchSize > 0L ? 1 : 0) != 0, (String)"batchSize must be > 0, but was %s", (long)batchSize);
            return this.toBuilder().setBatchSize(batchSize).build();
        }

        public Write<T> withRetryStrategy(RetryStrategy retryStrategy) {
            Preconditions.checkArgument((retryStrategy != null ? 1 : 0) != 0, (Object)"retryStrategy can not be null");
            return this.toBuilder().setRetryStrategy(retryStrategy).build();
        }

        public PDone expand(PCollection<T> input) {
            Preconditions.checkArgument((this.getDataSourceConfiguration() != null ? 1 : 0) != 0, (Object)"withDataSourceConfiguration() is required");
            Preconditions.checkArgument((this.getStatement() != null ? 1 : 0) != 0, (Object)"withStatement() is required");
            Preconditions.checkArgument((this.getPreparedStatementSetter() != null ? 1 : 0) != 0, (Object)"withPreparedStatementSetter() is required");
            input.apply((PTransform)ParDo.of(new WriteFn(this)));
            return PDone.in((Pipeline)input.getPipeline());
        }

        private static class WriteFn<T>
        extends DoFn<T, Void> {
            private final Write<T> spec;
            private static final int MAX_RETRIES = 5;
            private static final FluentBackoff BUNDLE_WRITE_BACKOFF = FluentBackoff.DEFAULT.withMaxRetries(5).withInitialBackoff(Duration.standardSeconds((long)5L));
            private DataSource dataSource;
            private Connection connection;
            private PreparedStatement preparedStatement;
            private List<T> records = new ArrayList<T>();

            public WriteFn(Write<T> spec) {
                this.spec = spec;
            }

            @DoFn.Setup
            public void setup() throws Exception {
                this.dataSource = this.spec.getDataSourceConfiguration().buildDatasource();
            }

            @DoFn.StartBundle
            public void startBundle() throws Exception {
                this.connection = this.dataSource.getConnection();
                this.connection.setAutoCommit(false);
                this.preparedStatement = this.connection.prepareStatement((String)this.spec.getStatement().get());
            }

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext context) throws Exception {
                Object record = context.element();
                this.records.add(record);
                if ((long)this.records.size() >= this.spec.getBatchSize()) {
                    this.executeBatch();
                }
            }

            private void processRecord(T record, PreparedStatement preparedStatement) {
                try {
                    preparedStatement.clearParameters();
                    this.spec.getPreparedStatementSetter().setParameters(record, preparedStatement);
                    preparedStatement.addBatch();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            @DoFn.FinishBundle
            public void finishBundle() throws Exception {
                this.executeBatch();
                try {
                    if (this.preparedStatement != null) {
                        this.preparedStatement.close();
                    }
                }
                finally {
                    if (this.connection != null) {
                        this.connection.close();
                    }
                }
            }

            private void executeBatch() throws SQLException, IOException, InterruptedException {
                if (this.records.isEmpty()) {
                    return;
                }
                Sleeper sleeper = Sleeper.DEFAULT;
                BackOff backoff = BUNDLE_WRITE_BACKOFF.backoff();
                while (true) {
                    PreparedStatement preparedStatement = this.connection.prepareStatement((String)this.spec.getStatement().get());
                    Throwable throwable = null;
                    try {
                        for (T record : this.records) {
                            this.processRecord(record, preparedStatement);
                        }
                        preparedStatement.executeBatch();
                        this.connection.commit();
                    }
                    catch (SQLException exception) {
                        if (!this.spec.getRetryStrategy().apply(exception)) {
                            throw exception;
                        }
                        LOG.warn("Deadlock detected, retrying", (Throwable)exception);
                        preparedStatement.clearBatch();
                        this.connection.rollback();
                        if (BackOffUtils.next((Sleeper)sleeper, (BackOff)backoff)) continue;
                        throw exception;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (preparedStatement == null) continue;
                        if (throwable != null) {
                            try {
                                preparedStatement.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        preparedStatement.close();
                        continue;
                    }
                    break;
                }
                this.records.clear();
            }

            @DoFn.Teardown
            public void teardown() throws Exception {
                if (this.dataSource instanceof AutoCloseable) {
                    ((AutoCloseable)((Object)this.dataSource)).close();
                }
            }
        }

        @AutoValue.Builder
        static abstract class Builder<T> {
            Builder() {
            }

            abstract Builder<T> setDataSourceConfiguration(DataSourceConfiguration var1);

            abstract Builder<T> setStatement(ValueProvider<String> var1);

            abstract Builder<T> setBatchSize(long var1);

            abstract Builder<T> setPreparedStatementSetter(PreparedStatementSetter<T> var1);

            abstract Builder<T> setRetryStrategy(RetryStrategy var1);

            abstract Write<T> build();
        }
    }

    @FunctionalInterface
    public static interface RetryStrategy
    extends Serializable {
        public boolean apply(SQLException var1);
    }

    @FunctionalInterface
    public static interface PreparedStatementSetter<T>
    extends Serializable {
        public void setParameters(T var1, PreparedStatement var2) throws Exception;
    }

    private static class ReadFn<ParameterT, OutputT>
    extends DoFn<ParameterT, OutputT> {
        private final DataSourceConfiguration dataSourceConfiguration;
        private final ValueProvider<String> query;
        private final PreparedStatementSetter<ParameterT> parameterSetter;
        private final RowMapper<OutputT> rowMapper;
        private final int fetchSize;
        private DataSource dataSource;
        private Connection connection;

        private ReadFn(DataSourceConfiguration dataSourceConfiguration, ValueProvider<String> query, PreparedStatementSetter<ParameterT> parameterSetter, RowMapper<OutputT> rowMapper, int fetchSize) {
            this.dataSourceConfiguration = dataSourceConfiguration;
            this.query = query;
            this.parameterSetter = parameterSetter;
            this.rowMapper = rowMapper;
            this.fetchSize = fetchSize;
        }

        @DoFn.Setup
        public void setup() throws Exception {
            this.dataSource = this.dataSourceConfiguration.buildDatasource();
            this.connection = this.dataSource.getConnection();
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext context) throws Exception {
            try (PreparedStatement statement = this.connection.prepareStatement((String)this.query.get(), 1003, 1007);){
                statement.setFetchSize(this.fetchSize);
                this.parameterSetter.setParameters(context.element(), statement);
                try (ResultSet resultSet = statement.executeQuery();){
                    while (resultSet.next()) {
                        context.output(this.rowMapper.mapRow(resultSet));
                    }
                }
            }
        }

        @DoFn.Teardown
        public void teardown() throws Exception {
            this.connection.close();
            if (this.dataSource instanceof AutoCloseable) {
                ((AutoCloseable)((Object)this.dataSource)).close();
            }
        }
    }

    @AutoValue
    public static abstract class ReadAll<ParameterT, OutputT>
    extends PTransform<PCollection<ParameterT>, PCollection<OutputT>> {
        @Nullable
        abstract DataSourceConfiguration getDataSourceConfiguration();

        @Nullable
        abstract ValueProvider<String> getQuery();

        @Nullable
        abstract PreparedStatementSetter<ParameterT> getParameterSetter();

        @Nullable
        abstract RowMapper<OutputT> getRowMapper();

        @Nullable
        abstract Coder<OutputT> getCoder();

        abstract int getFetchSize();

        abstract Builder<ParameterT, OutputT> toBuilder();

        public ReadAll<ParameterT, OutputT> withDataSourceConfiguration(DataSourceConfiguration configuration) {
            return this.toBuilder().setDataSourceConfiguration(configuration).build();
        }

        public ReadAll<ParameterT, OutputT> withQuery(String query) {
            Preconditions.checkArgument((query != null ? 1 : 0) != 0, (Object)"JdbcIO.readAll().withQuery(query) called with null query");
            return this.withQuery((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)query));
        }

        public ReadAll<ParameterT, OutputT> withQuery(ValueProvider<String> query) {
            Preconditions.checkArgument((query != null ? 1 : 0) != 0, (Object)"JdbcIO.readAll().withQuery(query) called with null query");
            return this.toBuilder().setQuery(query).build();
        }

        public ReadAll<ParameterT, OutputT> withParameterSetter(PreparedStatementSetter<ParameterT> parameterSetter) {
            Preconditions.checkArgument((parameterSetter != null ? 1 : 0) != 0, (Object)"JdbcIO.readAll().withParameterSetter(parameterSetter) called with null statementPreparator");
            return this.toBuilder().setParameterSetter(parameterSetter).build();
        }

        public ReadAll<ParameterT, OutputT> withRowMapper(RowMapper<OutputT> rowMapper) {
            Preconditions.checkArgument((rowMapper != null ? 1 : 0) != 0, (Object)"JdbcIO.readAll().withRowMapper(rowMapper) called with null rowMapper");
            return this.toBuilder().setRowMapper(rowMapper).build();
        }

        public ReadAll<ParameterT, OutputT> withCoder(Coder<OutputT> coder) {
            Preconditions.checkArgument((coder != null ? 1 : 0) != 0, (Object)"JdbcIO.readAll().withCoder(coder) called with null coder");
            return this.toBuilder().setCoder(coder).build();
        }

        public ReadAll<ParameterT, OutputT> withFetchSize(int fetchSize) {
            Preconditions.checkArgument((fetchSize > 0 ? 1 : 0) != 0, (Object)"fetch size must be >0");
            return this.toBuilder().setFetchSize(fetchSize).build();
        }

        public PCollection<OutputT> expand(PCollection<ParameterT> input) {
            return (PCollection)((PCollection)input.apply((PTransform)ParDo.of(new ReadFn(this.getDataSourceConfiguration(), this.getQuery(), this.getParameterSetter(), this.getRowMapper(), this.getFetchSize())))).setCoder(this.getCoder()).apply(new Reparallelize());
        }

        public void populateDisplayData(DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.add(DisplayData.item((String)"query", this.getQuery()));
            builder.add(DisplayData.item((String)"rowMapper", (String)this.getRowMapper().getClass().getName()));
            builder.add(DisplayData.item((String)"coder", (String)this.getCoder().getClass().getName()));
            this.getDataSourceConfiguration().populateDisplayData(builder);
        }

        @AutoValue.Builder
        static abstract class Builder<ParameterT, OutputT> {
            Builder() {
            }

            abstract Builder<ParameterT, OutputT> setDataSourceConfiguration(DataSourceConfiguration var1);

            abstract Builder<ParameterT, OutputT> setQuery(ValueProvider<String> var1);

            abstract Builder<ParameterT, OutputT> setParameterSetter(PreparedStatementSetter<ParameterT> var1);

            abstract Builder<ParameterT, OutputT> setRowMapper(RowMapper<OutputT> var1);

            abstract Builder<ParameterT, OutputT> setCoder(Coder<OutputT> var1);

            abstract Builder<ParameterT, OutputT> setFetchSize(int var1);

            abstract ReadAll<ParameterT, OutputT> build();
        }
    }

    @AutoValue
    public static abstract class Read<T>
    extends PTransform<PBegin, PCollection<T>> {
        @Nullable
        abstract DataSourceConfiguration getDataSourceConfiguration();

        @Nullable
        abstract ValueProvider<String> getQuery();

        @Nullable
        abstract StatementPreparator getStatementPreparator();

        @Nullable
        abstract RowMapper<T> getRowMapper();

        @Nullable
        abstract Coder<T> getCoder();

        abstract int getFetchSize();

        abstract Builder<T> toBuilder();

        public Read<T> withDataSourceConfiguration(DataSourceConfiguration configuration) {
            return this.toBuilder().setDataSourceConfiguration(configuration).build();
        }

        public Read<T> withQuery(String query) {
            Preconditions.checkArgument((query != null ? 1 : 0) != 0, (Object)"query can not be null");
            return this.withQuery((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)query));
        }

        public Read<T> withQuery(ValueProvider<String> query) {
            Preconditions.checkArgument((query != null ? 1 : 0) != 0, (Object)"query can not be null");
            return this.toBuilder().setQuery(query).build();
        }

        public Read<T> withStatementPreparator(StatementPreparator statementPreparator) {
            Preconditions.checkArgument((statementPreparator != null ? 1 : 0) != 0, (Object)"statementPreparator can not be null");
            return this.toBuilder().setStatementPreparator(statementPreparator).build();
        }

        public Read<T> withRowMapper(RowMapper<T> rowMapper) {
            Preconditions.checkArgument((rowMapper != null ? 1 : 0) != 0, (Object)"rowMapper can not be null");
            return this.toBuilder().setRowMapper(rowMapper).build();
        }

        public Read<T> withCoder(Coder<T> coder) {
            Preconditions.checkArgument((coder != null ? 1 : 0) != 0, (Object)"coder can not be null");
            return this.toBuilder().setCoder(coder).build();
        }

        public Read<T> withFetchSize(int fetchSize) {
            Preconditions.checkArgument((fetchSize > 0 ? 1 : 0) != 0, (Object)"fetch size must be > 0");
            return this.toBuilder().setFetchSize(fetchSize).build();
        }

        public PCollection<T> expand(PBegin input) {
            Preconditions.checkArgument((this.getQuery() != null ? 1 : 0) != 0, (Object)"withQuery() is required");
            Preconditions.checkArgument((this.getRowMapper() != null ? 1 : 0) != 0, (Object)"withRowMapper() is required");
            Preconditions.checkArgument((this.getCoder() != null ? 1 : 0) != 0, (Object)"withCoder() is required");
            Preconditions.checkArgument((this.getDataSourceConfiguration() != null ? 1 : 0) != 0, (Object)"withDataSourceConfiguration() is required");
            return (PCollection)((PCollection)input.apply((PTransform)Create.of((Object)null, (Object[])new Void[0]))).apply(JdbcIO.readAll().withDataSourceConfiguration(this.getDataSourceConfiguration()).withQuery(this.getQuery()).withCoder(this.getCoder()).withRowMapper(this.getRowMapper()).withFetchSize(this.getFetchSize()).withParameterSetter((element, preparedStatement) -> {
                if (this.getStatementPreparator() != null) {
                    this.getStatementPreparator().setParameters(preparedStatement);
                }
            }));
        }

        public void populateDisplayData(DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.add(DisplayData.item((String)"query", this.getQuery()));
            builder.add(DisplayData.item((String)"rowMapper", (String)this.getRowMapper().getClass().getName()));
            builder.add(DisplayData.item((String)"coder", (String)this.getCoder().getClass().getName()));
            this.getDataSourceConfiguration().populateDisplayData(builder);
        }

        @AutoValue.Builder
        static abstract class Builder<T> {
            Builder() {
            }

            abstract Builder<T> setDataSourceConfiguration(DataSourceConfiguration var1);

            abstract Builder<T> setQuery(ValueProvider<String> var1);

            abstract Builder<T> setStatementPreparator(StatementPreparator var1);

            abstract Builder<T> setRowMapper(RowMapper<T> var1);

            abstract Builder<T> setCoder(Coder<T> var1);

            abstract Builder<T> setFetchSize(int var1);

            abstract Read<T> build();
        }
    }

    @FunctionalInterface
    public static interface StatementPreparator
    extends Serializable {
        public void setParameters(PreparedStatement var1) throws Exception;
    }

    @AutoValue
    public static abstract class DataSourceConfiguration
    implements Serializable {
        @Nullable
        abstract ValueProvider<String> getDriverClassName();

        @Nullable
        abstract ValueProvider<String> getUrl();

        @Nullable
        abstract ValueProvider<String> getUsername();

        @Nullable
        abstract ValueProvider<String> getPassword();

        @Nullable
        abstract ValueProvider<String> getConnectionProperties();

        @Nullable
        abstract DataSource getDataSource();

        abstract Builder builder();

        public static DataSourceConfiguration create(DataSource dataSource) {
            Preconditions.checkArgument((dataSource != null ? 1 : 0) != 0, (Object)"dataSource can not be null");
            Preconditions.checkArgument((boolean)(dataSource instanceof Serializable), (Object)"dataSource must be Serializable");
            return new AutoValue_JdbcIO_DataSourceConfiguration.Builder().setDataSource(dataSource).build();
        }

        public static DataSourceConfiguration create(String driverClassName, String url) {
            Preconditions.checkArgument((driverClassName != null ? 1 : 0) != 0, (Object)"driverClassName can not be null");
            Preconditions.checkArgument((url != null ? 1 : 0) != 0, (Object)"url can not be null");
            return DataSourceConfiguration.create((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)driverClassName), (ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)url));
        }

        public static DataSourceConfiguration create(ValueProvider<String> driverClassName, ValueProvider<String> url) {
            Preconditions.checkArgument((driverClassName != null ? 1 : 0) != 0, (Object)"driverClassName can not be null");
            Preconditions.checkArgument((url != null ? 1 : 0) != 0, (Object)"url can not be null");
            return new AutoValue_JdbcIO_DataSourceConfiguration.Builder().setDriverClassName(driverClassName).setUrl(url).build();
        }

        public DataSourceConfiguration withUsername(String username) {
            return this.withUsername((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)username));
        }

        public DataSourceConfiguration withUsername(ValueProvider<String> username) {
            return this.builder().setUsername(username).build();
        }

        public DataSourceConfiguration withPassword(String password) {
            return this.withPassword((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)password));
        }

        public DataSourceConfiguration withPassword(ValueProvider<String> password) {
            return this.builder().setPassword(password).build();
        }

        public DataSourceConfiguration withConnectionProperties(String connectionProperties) {
            Preconditions.checkArgument((connectionProperties != null ? 1 : 0) != 0, (Object)"connectionProperties can not be null");
            return this.withConnectionProperties((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)connectionProperties));
        }

        public DataSourceConfiguration withConnectionProperties(ValueProvider<String> connectionProperties) {
            Preconditions.checkArgument((connectionProperties != null ? 1 : 0) != 0, (Object)"connectionProperties can not be null");
            return this.builder().setConnectionProperties(connectionProperties).build();
        }

        private void populateDisplayData(DisplayData.Builder builder) {
            if (this.getDataSource() != null) {
                builder.addIfNotNull(DisplayData.item((String)"dataSource", (String)this.getDataSource().getClass().getName()));
            } else {
                builder.addIfNotNull(DisplayData.item((String)"jdbcDriverClassName", this.getDriverClassName()));
                builder.addIfNotNull(DisplayData.item((String)"jdbcUrl", this.getUrl()));
                builder.addIfNotNull(DisplayData.item((String)"username", this.getUsername()));
            }
        }

        DataSource buildDatasource() throws Exception {
            DataSource current = null;
            if (this.getDataSource() != null) {
                current = this.getDataSource();
            } else {
                BasicDataSource basicDataSource = new BasicDataSource();
                if (this.getDriverClassName() != null) {
                    basicDataSource.setDriverClassName((String)this.getDriverClassName().get());
                }
                if (this.getUrl() != null) {
                    basicDataSource.setUrl((String)this.getUrl().get());
                }
                if (this.getUsername() != null) {
                    basicDataSource.setUsername((String)this.getUsername().get());
                }
                if (this.getPassword() != null) {
                    basicDataSource.setPassword((String)this.getPassword().get());
                }
                if (this.getConnectionProperties() != null && this.getConnectionProperties().get() != null) {
                    basicDataSource.setConnectionProperties((String)this.getConnectionProperties().get());
                }
                current = basicDataSource;
            }
            DataSourceConnectionFactory connectionFactory = new DataSourceConnectionFactory(current);
            PoolableConnectionFactory poolableConnectionFactory = new PoolableConnectionFactory((ConnectionFactory)connectionFactory, null);
            GenericObjectPoolConfig poolConfig = new GenericObjectPoolConfig();
            poolConfig.setMaxTotal(1);
            poolConfig.setMinIdle(0);
            poolConfig.setMinEvictableIdleTimeMillis(10000L);
            poolConfig.setSoftMinEvictableIdleTimeMillis(30000L);
            GenericObjectPool connectionPool = new GenericObjectPool((PooledObjectFactory)poolableConnectionFactory, poolConfig);
            poolableConnectionFactory.setPool((ObjectPool)connectionPool);
            poolableConnectionFactory.setDefaultAutoCommit(Boolean.valueOf(false));
            poolableConnectionFactory.setDefaultReadOnly(Boolean.valueOf(false));
            return new PoolingDataSource((ObjectPool)connectionPool);
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract Builder setDriverClassName(ValueProvider<String> var1);

            abstract Builder setUrl(ValueProvider<String> var1);

            abstract Builder setUsername(ValueProvider<String> var1);

            abstract Builder setPassword(ValueProvider<String> var1);

            abstract Builder setConnectionProperties(ValueProvider<String> var1);

            abstract Builder setDataSource(DataSource var1);

            abstract DataSourceConfiguration build();
        }
    }

    @FunctionalInterface
    public static interface RowMapper<T>
    extends Serializable {
        public T mapRow(ResultSet var1) throws Exception;
    }

    public static class DefaultRetryStrategy
    implements RetryStrategy {
        @Override
        public boolean apply(SQLException e) {
            return "40001".equals(e.getSQLState());
        }
    }
}

