/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.jdbc;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Random;
import javax.annotation.Nullable;
import javax.sql.DataSource;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.jdbc.AutoValue_JdbcIO_DataSourceConfiguration;
import org.apache.beam.sdk.io.jdbc.AutoValue_JdbcIO_Read;
import org.apache.beam.sdk.io.jdbc.AutoValue_JdbcIO_Write;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.Flatten;
import org.apache.beam.sdk.transforms.GroupByKey;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.Values;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PDone;
import org.apache.commons.dbcp2.BasicDataSource;

public class JdbcIO {
    public static <T> Read<T> read() {
        return new AutoValue_JdbcIO_Read.Builder().build();
    }

    public static <T> Write<T> write() {
        return new AutoValue_JdbcIO_Write.Builder().build();
    }

    private JdbcIO() {
    }

    public static abstract class Write<T>
    extends PTransform<PCollection<T>, PDone> {
        @Nullable
        abstract DataSourceConfiguration getDataSourceConfiguration();

        @Nullable
        abstract String getStatement();

        @Nullable
        abstract PreparedStatementSetter<T> getPreparedStatementSetter();

        abstract Builder<T> toBuilder();

        public Write<T> withDataSourceConfiguration(DataSourceConfiguration config) {
            return this.toBuilder().setDataSourceConfiguration(config).build();
        }

        public Write<T> withStatement(String statement) {
            return this.toBuilder().setStatement(statement).build();
        }

        public Write<T> withPreparedStatementSetter(PreparedStatementSetter<T> setter) {
            return this.toBuilder().setPreparedStatementSetter(setter).build();
        }

        public PDone apply(PCollection<T> input) {
            input.apply((PTransform)ParDo.of(new WriteFn(this)));
            return PDone.in((Pipeline)input.getPipeline());
        }

        public void validate(PCollection<T> input) {
            Preconditions.checkNotNull((Object)this.getDataSourceConfiguration(), (Object)"dataSourceConfiguration");
            Preconditions.checkNotNull((Object)this.getStatement(), (Object)"statement");
            Preconditions.checkNotNull(this.getPreparedStatementSetter(), (Object)"preparedStatementSetter");
        }

        private static class WriteFn<T>
        extends DoFn<T, Void> {
            private static final int DEFAULT_BATCH_SIZE = 1000;
            private final Write<T> spec;
            private Connection connection;
            private PreparedStatement preparedStatement;
            private int batchCount;

            public WriteFn(Write<T> spec) {
                this.spec = spec;
            }

            @DoFn.Setup
            public void setup() throws Exception {
                this.connection = this.spec.getDataSourceConfiguration().getConnection();
                this.connection.setAutoCommit(false);
                this.preparedStatement = this.connection.prepareStatement(this.spec.getStatement());
            }

            @DoFn.StartBundle
            public void startBundle(DoFn.Context context) {
                this.batchCount = 0;
            }

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext context) throws Exception {
                Object record = context.element();
                this.preparedStatement.clearParameters();
                this.spec.getPreparedStatementSetter().setParameters(record, this.preparedStatement);
                this.preparedStatement.addBatch();
                ++this.batchCount;
                if (this.batchCount >= 1000) {
                    this.finishBundle((DoFn.Context)context);
                }
            }

            @DoFn.FinishBundle
            public void finishBundle(DoFn.Context context) throws Exception {
                if (this.batchCount > 0) {
                    this.preparedStatement.executeBatch();
                    this.connection.commit();
                    this.batchCount = 0;
                }
            }

            @DoFn.Teardown
            public void teardown() throws Exception {
                try {
                    if (this.preparedStatement != null) {
                        this.preparedStatement.close();
                    }
                }
                finally {
                    if (this.connection != null) {
                        this.connection.close();
                    }
                }
            }
        }

        static abstract class Builder<T> {
            Builder() {
            }

            abstract Builder<T> setDataSourceConfiguration(DataSourceConfiguration var1);

            abstract Builder<T> setStatement(String var1);

            abstract Builder<T> setPreparedStatementSetter(PreparedStatementSetter<T> var1);

            abstract Write<T> build();
        }
    }

    public static interface PreparedStatementSetter<T>
    extends Serializable {
        public void setParameters(T var1, PreparedStatement var2) throws Exception;
    }

    public static abstract class Read<T>
    extends PTransform<PBegin, PCollection<T>> {
        @Nullable
        abstract DataSourceConfiguration getDataSourceConfiguration();

        @Nullable
        abstract String getQuery();

        @Nullable
        abstract RowMapper<T> getRowMapper();

        @Nullable
        abstract Coder<T> getCoder();

        abstract Builder<T> toBuilder();

        public Read<T> withDataSourceConfiguration(DataSourceConfiguration configuration) {
            Preconditions.checkNotNull((Object)configuration, (Object)"configuration");
            return this.toBuilder().setDataSourceConfiguration(configuration).build();
        }

        public Read<T> withQuery(String query) {
            Preconditions.checkNotNull((Object)query, (Object)"query");
            return this.toBuilder().setQuery(query).build();
        }

        public Read<T> withRowMapper(RowMapper<T> rowMapper) {
            Preconditions.checkNotNull(rowMapper, (Object)"rowMapper");
            return this.toBuilder().setRowMapper(rowMapper).build();
        }

        public Read<T> withCoder(Coder<T> coder) {
            Preconditions.checkNotNull(coder, (Object)"coder");
            return this.toBuilder().setCoder(coder).build();
        }

        public PCollection<T> apply(PBegin input) {
            return (PCollection)((PCollection)((PCollection)((PCollection)((PCollection)((PCollection)input.apply((PTransform)Create.of((Object[])new String[]{this.getQuery()}))).apply((PTransform)ParDo.of(new ReadFn(this)))).setCoder(this.getCoder()).apply((PTransform)ParDo.of((DoFn)new DoFn<T, KV<Integer, T>>(){
                private Random random;

                @DoFn.Setup
                public void setup() {
                    this.random = new Random();
                }

                @DoFn.ProcessElement
                public void processElement(DoFn.ProcessContext context) {
                    context.output((Object)KV.of((Object)this.random.nextInt(), (Object)context.element()));
                }
            }))).apply((PTransform)GroupByKey.create())).apply((PTransform)Values.create())).apply((PTransform)Flatten.iterables());
        }

        public void validate(PBegin input) {
            Preconditions.checkNotNull((Object)this.getQuery(), (Object)"query");
            Preconditions.checkNotNull(this.getRowMapper(), (Object)"rowMapper");
            Preconditions.checkNotNull(this.getCoder(), (Object)"coder");
            Preconditions.checkNotNull((Object)this.getDataSourceConfiguration());
        }

        public void populateDisplayData(DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.add(DisplayData.item((String)"query", (String)this.getQuery()));
            builder.add(DisplayData.item((String)"rowMapper", (String)this.getRowMapper().getClass().getName()));
            builder.add(DisplayData.item((String)"coder", (String)this.getCoder().getClass().getName()));
            this.getDataSourceConfiguration().populateDisplayData(builder);
        }

        static class ReadFn<T>
        extends DoFn<String, T> {
            private Read<T> spec;
            private Connection connection;

            private ReadFn(Read<T> spec) {
                this.spec = spec;
            }

            @DoFn.Setup
            public void setup() throws Exception {
                this.connection = this.spec.getDataSourceConfiguration().getConnection();
            }

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext context) throws Exception {
                String query = (String)context.element();
                try (PreparedStatement statement = this.connection.prepareStatement(query);
                     ResultSet resultSet = statement.executeQuery();){
                    while (resultSet.next()) {
                        context.output(this.spec.getRowMapper().mapRow(resultSet));
                    }
                }
            }

            @DoFn.Teardown
            public void teardown() throws Exception {
                if (this.connection != null) {
                    this.connection.close();
                }
            }
        }

        static abstract class Builder<T> {
            Builder() {
            }

            abstract Builder<T> setDataSourceConfiguration(DataSourceConfiguration var1);

            abstract Builder<T> setQuery(String var1);

            abstract Builder<T> setRowMapper(RowMapper<T> var1);

            abstract Builder<T> setCoder(Coder<T> var1);

            abstract Read<T> build();
        }
    }

    public static abstract class DataSourceConfiguration
    implements Serializable {
        @Nullable
        abstract String getDriverClassName();

        @Nullable
        abstract String getUrl();

        @Nullable
        abstract String getUsername();

        @Nullable
        abstract String getPassword();

        @Nullable
        abstract DataSource getDataSource();

        abstract Builder builder();

        public static DataSourceConfiguration create(DataSource dataSource) {
            Preconditions.checkNotNull((Object)dataSource, (Object)"dataSource");
            Preconditions.checkArgument((boolean)(dataSource instanceof Serializable), (Object)"dataSource must be Serializable");
            return new AutoValue_JdbcIO_DataSourceConfiguration.Builder().setDataSource(dataSource).build();
        }

        public static DataSourceConfiguration create(String driverClassName, String url) {
            Preconditions.checkNotNull((Object)driverClassName, (Object)"driverClassName");
            Preconditions.checkNotNull((Object)url, (Object)"url");
            return new AutoValue_JdbcIO_DataSourceConfiguration.Builder().setDriverClassName(driverClassName).setUrl(url).build();
        }

        public DataSourceConfiguration withUsername(String username) {
            return this.builder().setUsername(username).build();
        }

        public DataSourceConfiguration withPassword(String password) {
            return this.builder().setPassword(password).build();
        }

        private void populateDisplayData(DisplayData.Builder builder) {
            if (this.getDataSource() != null) {
                builder.addIfNotNull(DisplayData.item((String)"dataSource", (String)this.getDataSource().getClass().getName()));
            } else {
                builder.addIfNotNull(DisplayData.item((String)"jdbcDriverClassName", (String)this.getDriverClassName()));
                builder.addIfNotNull(DisplayData.item((String)"jdbcUrl", (String)this.getUrl()));
                builder.addIfNotNull(DisplayData.item((String)"username", (String)this.getUsername()));
            }
        }

        Connection getConnection() throws Exception {
            if (this.getDataSource() != null) {
                return this.getUsername() != null ? this.getDataSource().getConnection(this.getUsername(), this.getPassword()) : this.getDataSource().getConnection();
            }
            BasicDataSource basicDataSource = new BasicDataSource();
            basicDataSource.setDriverClassName(this.getDriverClassName());
            basicDataSource.setUrl(this.getUrl());
            basicDataSource.setUsername(this.getUsername());
            basicDataSource.setPassword(this.getPassword());
            return basicDataSource.getConnection();
        }

        static abstract class Builder {
            Builder() {
            }

            abstract Builder setDriverClassName(String var1);

            abstract Builder setUrl(String var1);

            abstract Builder setUsername(String var1);

            abstract Builder setPassword(String var1);

            abstract Builder setDataSource(DataSource var1);

            abstract DataSourceConfiguration build();
        }
    }

    public static interface RowMapper<T>
    extends Serializable {
        public T mapRow(ResultSet var1) throws Exception;
    }
}

