/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.hadoop.format;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.beam.sdk.coders.AtomicCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderRegistry;
import org.apache.beam.sdk.coders.IterableCoder;
import org.apache.beam.sdk.coders.ListCoder;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeDescriptors;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

class IterableCombinerFn<@UnknownKeyFor T>
extends Combine.AccumulatingCombineFn<T, CollectionAccumulator<T>, Iterable<T>> {
    private final @UnknownKeyFor @NonNull @Initialized TypeDescriptor<T> typeDescriptor;

    IterableCombinerFn(@UnknownKeyFor @NonNull @Initialized TypeDescriptor<T> typeDescriptor) {
        this.typeDescriptor = typeDescriptor;
    }

    public @UnknownKeyFor @NonNull @Initialized CollectionAccumulator<T> createAccumulator() {
        return new CollectionAccumulator();
    }

    public @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @NonNull @Initialized Iterable<T>> getOutputType() {
        return TypeDescriptors.iterables(this.typeDescriptor);
    }

    public @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized Iterable<T>> getDefaultOutputCoder(@UnknownKeyFor @NonNull @Initialized CoderRegistry registry, @UnknownKeyFor @NonNull @Initialized Coder<T> inputCoder) {
        return IterableCoder.of(inputCoder);
    }

    public @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized CollectionAccumulator<T>> getAccumulatorCoder(@UnknownKeyFor @NonNull @Initialized CoderRegistry registry, @UnknownKeyFor @NonNull @Initialized Coder<T> inputCoder) {
        return new CollectionAccumulatorCoder(inputCoder);
    }

    private static class CollectionAccumulatorCoder<@UnknownKeyFor T>
    extends AtomicCoder<CollectionAccumulator<T>> {
        private final @UnknownKeyFor @NonNull @Initialized ListCoder<T> listCoder;

        private CollectionAccumulatorCoder(@UnknownKeyFor @NonNull @Initialized Coder<T> typeCoder) {
            this.listCoder = ListCoder.of(typeCoder);
        }

        public void encode(@UnknownKeyFor @NonNull @Initialized CollectionAccumulator<T> value, @UnknownKeyFor @NonNull @Initialized OutputStream outStream) throws @UnknownKeyFor @NonNull @Initialized IOException {
            this.listCoder.encode((Iterable)((CollectionAccumulator)value).collection, outStream);
        }

        public @UnknownKeyFor @NonNull @Initialized CollectionAccumulator<T> decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream) throws @UnknownKeyFor @NonNull @Initialized IOException {
            List decodedList = (List)this.listCoder.decode(inStream);
            return new CollectionAccumulator(decodedList);
        }
    }

    public static class CollectionAccumulator<@UnknownKeyFor T>
    implements Combine.AccumulatingCombineFn.Accumulator<T, CollectionAccumulator<T>, Iterable<T>> {
        private final @UnknownKeyFor @NonNull @Initialized List<T> collection;

        private CollectionAccumulator() {
            this(new ArrayList());
        }

        private CollectionAccumulator(@UnknownKeyFor @NonNull @Initialized List<T> collection) {
            Objects.requireNonNull(collection, "Collection can't be null");
            this.collection = collection;
        }

        public void addInput(T input) {
            this.collection.add(input);
        }

        public void mergeAccumulator(@UnknownKeyFor @NonNull @Initialized CollectionAccumulator<T> other) {
            this.collection.addAll(other.collection);
        }

        public @UnknownKeyFor @NonNull @Initialized Iterable<T> extractOutput() {
            return this.collection;
        }
    }
}

