/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.hdfs;

import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.io.FileSystem;
import org.apache.beam.sdk.io.FileSystemRegistrar;
import org.apache.beam.sdk.io.hdfs.HadoopFileSystem;
import org.apache.beam.sdk.io.hdfs.HadoopFileSystemOptions;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;
import org.apache.hadoop.conf.Configuration;

@Experimental(value=Experimental.Kind.FILESYSTEM)
public class HadoopFileSystemRegistrar
implements FileSystemRegistrar {
    private static final List<String> HA_SCHEMES = Arrays.asList("hdfs", "webhdfs");

    public Iterable<FileSystem> fromOptions(@Nonnull PipelineOptions options) {
        String nameServices;
        List<Configuration> configurations = ((HadoopFileSystemOptions)options.as(HadoopFileSystemOptions.class)).getHdfsConfiguration();
        if (configurations == null) {
            return Collections.emptyList();
        }
        Preconditions.checkArgument((configurations.size() == 1 ? 1 : 0) != 0, (Object)String.format("The %s currently only supports at most a single Hadoop configuration.", HadoopFileSystemRegistrar.class.getSimpleName()));
        ImmutableList.Builder builder = ImmutableList.builder();
        HashSet<String> registeredSchemes = new HashSet<String>();
        Configuration configuration = (Configuration)Iterables.getOnlyElement(configurations);
        String defaultFs = configuration.get("fs.defaultFS");
        if (defaultFs != null && !defaultFs.isEmpty()) {
            String scheme = Objects.requireNonNull(URI.create(defaultFs).getScheme(), String.format("Empty scheme for %s value.", "fs.defaultFS"));
            builder.add((Object)new HadoopFileSystem(scheme, configuration));
            registeredSchemes.add(scheme);
        }
        if ((nameServices = configuration.get("dfs.nameservices")) != null && !nameServices.isEmpty()) {
            for (String scheme : HA_SCHEMES) {
                if (registeredSchemes.contains(scheme)) continue;
                builder.add((Object)new HadoopFileSystem(scheme, configuration));
            }
        }
        return builder.build();
    }
}

