/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.hdfs;

import com.google.auto.service.AutoService;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.io.FileSystem;
import org.apache.beam.sdk.io.FileSystemRegistrar;
import org.apache.beam.sdk.io.hdfs.HadoopFileSystem;
import org.apache.beam.sdk.io.hdfs.HadoopFileSystemOptions;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.ImmutableList;
import org.apache.hadoop.conf.Configuration;

@AutoService(value=FileSystemRegistrar.class)
@Experimental(value=Experimental.Kind.FILESYSTEM)
public class HadoopFileSystemRegistrar
implements FileSystemRegistrar {
    public Iterable<FileSystem> fromOptions(@Nonnull PipelineOptions options) {
        List<Object> configurations = ((HadoopFileSystemOptions)options.as(HadoopFileSystemOptions.class)).getHdfsConfiguration();
        if (configurations == null) {
            configurations = Collections.emptyList();
        }
        Preconditions.checkArgument((configurations.size() <= 1 ? 1 : 0) != 0, (Object)String.format("The %s currently only supports at most a single Hadoop configuration.", HadoopFileSystemRegistrar.class.getSimpleName()));
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Configuration configuration : configurations) {
            try {
                builder.add((Object)new HadoopFileSystem(configuration));
            }
            catch (IOException e) {
                throw new IllegalArgumentException(String.format("Failed to construct Hadoop filesystem with configuration %s", configuration), e);
            }
        }
        return builder.build();
    }
}

