/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner;

import com.google.cloud.spanner.Mutation;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public final class MutationGroup
implements Serializable,
Iterable<Mutation> {
    private final ImmutableList<Mutation> mutations;

    public static MutationGroup create(Mutation primary, Mutation ... other) {
        return MutationGroup.create(primary, Arrays.asList(other));
    }

    public static MutationGroup create(Mutation primary, Iterable<Mutation> other) {
        return new MutationGroup((ImmutableList<Mutation>)ImmutableList.builder().add((Object)primary).addAll(other).build());
    }

    @Override
    public Iterator<Mutation> iterator() {
        return this.mutations.iterator();
    }

    private MutationGroup(ImmutableList<Mutation> mutations) {
        this.mutations = mutations;
    }

    public Mutation primary() {
        return (Mutation)this.mutations.get(0);
    }

    public List<Mutation> attached() {
        return this.mutations.subList(1, this.mutations.size());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MutationGroup mutations1 = (MutationGroup)o;
        return Objects.equal(this.mutations, mutations1.mutations);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mutations});
    }
}

