/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.TableRow;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServices;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServicesImpl;
import org.apache.beam.sdk.io.gcp.bigquery.CreateTables;
import org.apache.beam.sdk.io.gcp.bigquery.DynamicDestinations;
import org.apache.beam.sdk.io.gcp.bigquery.InsertRetryPolicy;
import org.apache.beam.sdk.io.gcp.bigquery.StreamingWriteTables;
import org.apache.beam.sdk.io.gcp.bigquery.WriteResult;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;

public class StreamingInserts<DestinationT>
extends PTransform<PCollection<KV<DestinationT, TableRow>>, WriteResult> {
    private BigQueryServices bigQueryServices;
    private final BigQueryIO.Write.CreateDisposition createDisposition;
    private final DynamicDestinations<?, DestinationT> dynamicDestinations;
    private InsertRetryPolicy retryPolicy;
    private boolean extendedErrorInfo;
    private final boolean skipInvalidRows;
    private final boolean ignoreUnknownValues;

    public StreamingInserts(BigQueryIO.Write.CreateDisposition createDisposition, DynamicDestinations<?, DestinationT> dynamicDestinations) {
        this(createDisposition, dynamicDestinations, new BigQueryServicesImpl(), InsertRetryPolicy.alwaysRetry(), false, false, false);
    }

    private StreamingInserts(BigQueryIO.Write.CreateDisposition createDisposition, DynamicDestinations<?, DestinationT> dynamicDestinations, BigQueryServices bigQueryServices, InsertRetryPolicy retryPolicy, boolean extendedErrorInfo, boolean skipInvalidRows, boolean ignoreUnknownValues) {
        this.createDisposition = createDisposition;
        this.dynamicDestinations = dynamicDestinations;
        this.bigQueryServices = bigQueryServices;
        this.retryPolicy = retryPolicy;
        this.extendedErrorInfo = extendedErrorInfo;
        this.skipInvalidRows = skipInvalidRows;
        this.ignoreUnknownValues = ignoreUnknownValues;
    }

    public StreamingInserts<DestinationT> withInsertRetryPolicy(InsertRetryPolicy retryPolicy) {
        return new StreamingInserts<DestinationT>(this.createDisposition, this.dynamicDestinations, this.bigQueryServices, retryPolicy, this.extendedErrorInfo, this.skipInvalidRows, this.ignoreUnknownValues);
    }

    public StreamingInserts<DestinationT> withExtendedErrorInfo(boolean extendedErrorInfo) {
        return new StreamingInserts<DestinationT>(this.createDisposition, this.dynamicDestinations, this.bigQueryServices, this.retryPolicy, extendedErrorInfo, this.skipInvalidRows, this.ignoreUnknownValues);
    }

    StreamingInserts<DestinationT> withSkipInvalidRows(boolean skipInvalidRows) {
        return new StreamingInserts<DestinationT>(this.createDisposition, this.dynamicDestinations, this.bigQueryServices, this.retryPolicy, this.extendedErrorInfo, skipInvalidRows, this.ignoreUnknownValues);
    }

    StreamingInserts<DestinationT> withIgnoreUnknownValues(boolean ignoreUnknownValues) {
        return new StreamingInserts<DestinationT>(this.createDisposition, this.dynamicDestinations, this.bigQueryServices, this.retryPolicy, this.extendedErrorInfo, this.skipInvalidRows, ignoreUnknownValues);
    }

    StreamingInserts<DestinationT> withTestServices(BigQueryServices bigQueryServices) {
        return new StreamingInserts<DestinationT>(this.createDisposition, this.dynamicDestinations, bigQueryServices, this.retryPolicy, this.extendedErrorInfo, this.skipInvalidRows, this.ignoreUnknownValues);
    }

    public WriteResult expand(PCollection<KV<DestinationT, TableRow>> input) {
        PCollection writes = (PCollection)input.apply("CreateTables", new CreateTables<DestinationT>(this.createDisposition, this.dynamicDestinations).withTestServices(this.bigQueryServices));
        return (WriteResult)writes.apply((PTransform)new StreamingWriteTables().withTestServices(this.bigQueryServices).withInsertRetryPolicy(this.retryPolicy).withExtendedErrorInfo(this.extendedErrorInfo).withSkipInvalidRows(this.skipInvalidRows).withIgnoreUnknownValues(this.ignoreUnknownValues));
    }
}

