/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner.changestreams.dao;

import com.google.cloud.Timestamp;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.Struct;
import com.google.cloud.spanner.Type;
import com.google.protobuf.AbstractMessage;
import com.google.spanner.v1.ChangeStreamRecord;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.dao.ChangeStreamResultSetMetadata;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;

public class ChangeStreamResultSet
implements AutoCloseable {
    private final @UnknownKeyFor @NonNull @Initialized ResultSet resultSet;
    private @UnknownKeyFor @NonNull @Initialized Timestamp queryStartedAt;
    private @UnknownKeyFor @NonNull @Initialized Timestamp recordStreamStartedAt;
    private @UnknownKeyFor @NonNull @Initialized Timestamp recordStreamEndedAt;
    private @UnknownKeyFor @NonNull @Initialized Timestamp recordReadAt;
    private @UnknownKeyFor @NonNull @Initialized Duration totalStreamDuration;
    private @UnknownKeyFor @NonNull @Initialized long numberOfRecordsRead;

    ChangeStreamResultSet(@UnknownKeyFor @NonNull @Initialized ResultSet resultSet) {
        this.resultSet = resultSet;
        this.queryStartedAt = Timestamp.MIN_VALUE;
        this.recordStreamStartedAt = Timestamp.MIN_VALUE;
        this.recordStreamEndedAt = Timestamp.MIN_VALUE;
        this.recordReadAt = Timestamp.MIN_VALUE;
        this.totalStreamDuration = Duration.ZERO;
        this.numberOfRecordsRead = 0L;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean next() {
        if (this.queryStartedAt == null) {
            this.queryStartedAt = Timestamp.now();
        }
        this.recordStreamStartedAt = Timestamp.now();
        boolean hasNext = this.resultSet.next();
        ++this.numberOfRecordsRead;
        this.recordStreamEndedAt = Timestamp.now();
        this.totalStreamDuration = this.totalStreamDuration.withDurationAdded((ReadableDuration)new Duration(this.recordStreamStartedAt.toSqlTimestamp().getTime(), this.recordStreamEndedAt.toSqlTimestamp().getTime()), 1);
        return hasNext;
    }

    public @UnknownKeyFor @NonNull @Initialized Struct getCurrentRowAsStruct() {
        this.recordReadAt = Timestamp.now();
        return this.resultSet.getCurrentRowAsStruct();
    }

    public @UnknownKeyFor @NonNull @Initialized ChangeStreamRecord getProtoChangeStreamRecord() {
        this.recordReadAt = Timestamp.now();
        return (ChangeStreamRecord)this.resultSet.getProtoMessage(0, (AbstractMessage)ChangeStreamRecord.getDefaultInstance());
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isProtoChangeRecord() {
        return this.resultSet.getColumnCount() == 1 && !this.resultSet.isNull(0) && this.resultSet.getColumnType(0).getCode() == Type.Code.PROTO;
    }

    public @UnknownKeyFor @NonNull @Initialized String getPgJsonb(@UnknownKeyFor @NonNull @Initialized int index) {
        this.recordReadAt = Timestamp.now();
        return this.resultSet.getPgJsonb(index);
    }

    public @UnknownKeyFor @NonNull @Initialized ChangeStreamResultSetMetadata getMetadata() {
        return new ChangeStreamResultSetMetadata(this.queryStartedAt, this.recordStreamStartedAt, this.recordStreamEndedAt, this.recordReadAt, this.totalStreamDuration, this.numberOfRecordsRead);
    }

    @Override
    public void close() {
        this.resultSet.close();
    }
}

