/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.Table;
import com.google.api.services.bigquery.model.TableReference;
import com.google.api.services.bigquery.model.TableSchema;
import com.google.cloud.bigquery.storage.v1.ArrowSerializationOptions;
import com.google.cloud.bigquery.storage.v1.AvroSerializationOptions;
import com.google.cloud.bigquery.storage.v1.CreateReadSessionRequest;
import com.google.cloud.bigquery.storage.v1.DataFormat;
import com.google.cloud.bigquery.storage.v1.ReadSession;
import com.google.cloud.bigquery.storage.v1.ReadStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.BoundedSource;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryHelpers;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryOptions;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServices;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryStorageStreamSource;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryUtils;
import org.apache.beam.sdk.io.gcp.bigquery.SchemaAndRecord;
import org.apache.beam.sdk.io.gcp.bigquery.TimestampPrecision;
import org.apache.beam.sdk.metrics.Lineage;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Lists;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class BigQueryStorageSourceBase<@UnknownKeyFor T>
extends BoundedSource<T> {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(BigQueryStorageSourceBase.class);
    private static final @UnknownKeyFor @NonNull @Initialized int MAX_SPLIT_COUNT = 10000;
    private static final @UnknownKeyFor @NonNull @Initialized int MIN_SPLIT_COUNT = 10;
    protected final @Nullable @UnknownKeyFor @Initialized DataFormat format;
    protected final @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String>> selectedFieldsProvider;
    protected final @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> rowRestrictionProvider;
    protected final @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized SchemaAndRecord, T> parseFn;
    protected final @UnknownKeyFor @NonNull @Initialized Coder<T> outputCoder;
    protected final @UnknownKeyFor @NonNull @Initialized BigQueryServices bqServices;
    private final @Nullable @UnknownKeyFor @Initialized TimestampPrecision picosTimestampPrecision;

    BigQueryStorageSourceBase(@Nullable @UnknownKeyFor @Initialized DataFormat format, @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String>> selectedFieldsProvider, @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> rowRestrictionProvider, @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized SchemaAndRecord, T> parseFn, @UnknownKeyFor @NonNull @Initialized Coder<T> outputCoder, @UnknownKeyFor @NonNull @Initialized BigQueryServices bqServices, @Nullable @UnknownKeyFor @Initialized TimestampPrecision picosTimestampPrecision) {
        this.format = format;
        this.selectedFieldsProvider = selectedFieldsProvider;
        this.rowRestrictionProvider = rowRestrictionProvider;
        this.parseFn = (SerializableFunction)org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkNotNull(parseFn, (Object)"parseFn");
        this.outputCoder = (Coder)org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkNotNull(outputCoder, (Object)"outputCoder");
        this.bqServices = (BigQueryServices)org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkNotNull((Object)bqServices, (Object)"bqServices");
        this.picosTimestampPrecision = picosTimestampPrecision;
    }

    protected abstract @Nullable @UnknownKeyFor @Initialized Table getTargetTable(@UnknownKeyFor @NonNull @Initialized BigQueryOptions var1) throws @UnknownKeyFor @NonNull @Initialized Exception;

    protected abstract @Nullable @UnknownKeyFor @Initialized String getTargetTableId(@UnknownKeyFor @NonNull @Initialized BigQueryOptions var1) throws @UnknownKeyFor @NonNull @Initialized Exception;

    public @UnknownKeyFor @NonNull @Initialized Coder<T> getOutputCoder() {
        return this.outputCoder;
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized BigQueryStorageStreamSource<T>> split(@UnknownKeyFor @NonNull @Initialized long desiredBundleSizeBytes, @UnknownKeyFor @NonNull @Initialized PipelineOptions options) throws @UnknownKeyFor @NonNull @Initialized Exception {
        ReadSession readSession;
        BigQueryOptions bqOptions = (BigQueryOptions)options.as(BigQueryOptions.class);
        @Nullable Table targetTable = this.getTargetTable(bqOptions);
        ReadSession.Builder readSessionBuilder = ReadSession.newBuilder();
        Lineage lineage = Lineage.getSources();
        if (targetTable != null) {
            TableReference tableReference = targetTable.getTableReference();
            readSessionBuilder.setTable(BigQueryHelpers.toTableResourceName(tableReference));
            lineage.add("bigquery", BigQueryHelpers.dataCatalogSegments(tableReference, bqOptions));
        } else {
            @Nullable String tableReferenceId = this.getTargetTableId(bqOptions);
            if (tableReferenceId != null) {
                readSessionBuilder.setTable(tableReferenceId);
                TableReference tableReference = BigQueryHelpers.parseTableUrn(tableReferenceId);
                lineage.add("bigquery", BigQueryHelpers.dataCatalogSegments(tableReference, bqOptions));
            }
        }
        ReadSession.TableReadOptions.Builder tableReadOptionsBuilder = ReadSession.TableReadOptions.newBuilder();
        if (this.selectedFieldsProvider != null && this.selectedFieldsProvider.isAccessible()) {
            tableReadOptionsBuilder.addAllSelectedFields((Iterable)this.selectedFieldsProvider.get());
        }
        if (this.rowRestrictionProvider != null && this.rowRestrictionProvider.isAccessible()) {
            tableReadOptionsBuilder.setRowRestriction((String)this.rowRestrictionProvider.get());
        }
        if (this.format != null) {
            readSessionBuilder.setDataFormat(this.format);
            this.setPicosTimestampPrecision(tableReadOptionsBuilder, this.format);
        }
        readSessionBuilder.setReadOptions(tableReadOptionsBuilder);
        int streamCount = 0;
        if (!bqOptions.getEnableStorageReadApiV2().booleanValue()) {
            if (desiredBundleSizeBytes > 0L) {
                long tableSizeBytes = targetTable != null ? targetTable.getNumBytes() : 0L;
                streamCount = (int)Math.min(tableSizeBytes / desiredBundleSizeBytes, 10000L);
            }
            streamCount = Math.max(streamCount, 10);
        }
        CreateReadSessionRequest createReadSessionRequest = CreateReadSessionRequest.newBuilder().setParent(BigQueryHelpers.toProjectResourceName(bqOptions.getBigQueryProject() == null ? bqOptions.getProject() : bqOptions.getBigQueryProject())).setReadSession(readSessionBuilder).setMaxStreamCount(streamCount).build();
        try (BigQueryServices.StorageClient client = this.bqServices.getStorageClient(bqOptions);){
            readSession = client.createReadSession(createReadSessionRequest);
            LOG.info("Sent BigQuery Storage API CreateReadSession request '{}'; received response '{}'.", (Object)createReadSessionRequest, (Object)readSession);
        }
        if (readSession.getStreamsList().isEmpty()) {
            LOG.info("Returned stream list is empty. The underlying table is empty or all rows have been pruned.");
            return ImmutableList.of();
        }
        LOG.info("Read session returned {} streams", (Object)readSession.getStreamsList().size());
        Preconditions.checkStateNotNull((Object)targetTable);
        TableSchema tableSchema = targetTable.getSchema();
        if (this.selectedFieldsProvider != null && this.selectedFieldsProvider.isAccessible()) {
            tableSchema = BigQueryUtils.trimSchema(tableSchema, (List)this.selectedFieldsProvider.get());
        }
        ArrayList sources = Lists.newArrayList();
        for (ReadStream readStream : readSession.getStreamsList()) {
            sources.add(BigQueryStorageStreamSource.create(readSession, readStream, tableSchema, this.parseFn, this.outputCoder, this.bqServices));
        }
        return ImmutableList.copyOf((Collection)sources);
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized BoundedSource.BoundedReader<T> createReader(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) throws @UnknownKeyFor @NonNull @Initialized IOException {
        throw new UnsupportedOperationException("BigQuery storage source must be split before reading");
    }

    private void setPicosTimestampPrecision(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized ReadSession.TableReadOptions.Builder tableReadOptionsBuilder, @UnknownKeyFor @NonNull @Initialized DataFormat dataFormat) {
        if (this.picosTimestampPrecision == null) {
            return;
        }
        if (dataFormat == DataFormat.ARROW) {
            BigQueryStorageSourceBase.setArrowTimestampPrecision(tableReadOptionsBuilder, this.picosTimestampPrecision);
        } else if (dataFormat == DataFormat.AVRO) {
            BigQueryStorageSourceBase.setAvroTimestampPrecision(tableReadOptionsBuilder, this.picosTimestampPrecision);
        }
    }

    private static void setArrowTimestampPrecision(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized ReadSession.TableReadOptions.Builder tableReadOptionsBuilder, @UnknownKeyFor @NonNull @Initialized TimestampPrecision timestampPrecision) {
        ArrowSerializationOptions.PicosTimestampPrecision precision;
        switch (timestampPrecision) {
            case MICROS: {
                precision = ArrowSerializationOptions.PicosTimestampPrecision.TIMESTAMP_PRECISION_MICROS;
                break;
            }
            case NANOS: {
                precision = ArrowSerializationOptions.PicosTimestampPrecision.TIMESTAMP_PRECISION_NANOS;
                break;
            }
            case PICOS: {
                precision = ArrowSerializationOptions.PicosTimestampPrecision.TIMESTAMP_PRECISION_PICOS;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported timestamp precision for Storage Read API: " + (Object)((Object)timestampPrecision));
            }
        }
        tableReadOptionsBuilder.setArrowSerializationOptions(ArrowSerializationOptions.newBuilder().setPicosTimestampPrecision(precision));
    }

    private static void setAvroTimestampPrecision(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized ReadSession.TableReadOptions.Builder tableReadOptionsBuilder, @UnknownKeyFor @NonNull @Initialized TimestampPrecision timestampPrecision) {
        AvroSerializationOptions.PicosTimestampPrecision precision;
        switch (timestampPrecision) {
            case MICROS: {
                precision = AvroSerializationOptions.PicosTimestampPrecision.TIMESTAMP_PRECISION_MICROS;
                break;
            }
            case NANOS: {
                precision = AvroSerializationOptions.PicosTimestampPrecision.TIMESTAMP_PRECISION_NANOS;
                break;
            }
            case PICOS: {
                precision = AvroSerializationOptions.PicosTimestampPrecision.TIMESTAMP_PRECISION_PICOS;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported timestamp precision for Storage Read API: " + (Object)((Object)timestampPrecision));
            }
        }
        tableReadOptionsBuilder.setAvroSerializationOptions(AvroSerializationOptions.newBuilder().setPicosTimestampPrecision(precision));
    }
}

