/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.cloud.bigquery.storage.v1.TableFieldSchema;
import com.google.cloud.bigquery.storage.v1.TableSchema;
import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.Int64Value;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.beam.sdk.io.gcp.bigquery.CivilTimeEncoder;
import org.apache.beam.sdk.io.gcp.bigquery.StorageApiCDC;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.logicaltypes.EnumerationType;
import org.apache.beam.sdk.schemas.logicaltypes.SqlTypes;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Functions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.primitives.Bytes;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.ReadableInstant;

public class BeamRowToStorageApiProto {
    private static final @UnknownKeyFor @NonNull @Initialized int NUMERIC_SCALE = 9;
    private static final @UnknownKeyFor @NonNull @Initialized BigDecimal MAX_NUMERIC_VALUE = new BigDecimal("99999999999999999999999999999.999999999");
    private static final @UnknownKeyFor @NonNull @Initialized BigDecimal MIN_NUMERIC_VALUE = new BigDecimal("-99999999999999999999999999999.999999999");
    static final @UnknownKeyFor @NonNull @Initialized Map<// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.TypeName, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized TableFieldSchema.Type> PRIMITIVE_TYPES = ImmutableMap.builder().put((Object)Schema.TypeName.INT16, (Object)TableFieldSchema.Type.INT64).put((Object)Schema.TypeName.BYTE, (Object)TableFieldSchema.Type.INT64).put((Object)Schema.TypeName.INT32, (Object)TableFieldSchema.Type.INT64).put((Object)Schema.TypeName.INT64, (Object)TableFieldSchema.Type.INT64).put((Object)Schema.TypeName.FLOAT, (Object)TableFieldSchema.Type.DOUBLE).put((Object)Schema.TypeName.DOUBLE, (Object)TableFieldSchema.Type.DOUBLE).put((Object)Schema.TypeName.STRING, (Object)TableFieldSchema.Type.STRING).put((Object)Schema.TypeName.BOOLEAN, (Object)TableFieldSchema.Type.BOOL).put((Object)Schema.TypeName.DATETIME, (Object)TableFieldSchema.Type.DATETIME).put((Object)Schema.TypeName.BYTES, (Object)TableFieldSchema.Type.BYTES).put((Object)Schema.TypeName.DECIMAL, (Object)TableFieldSchema.Type.BIGNUMERIC).build();
    static final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized TableFieldSchema.Type> LOGICAL_TYPES = ImmutableMap.builder().put((Object)SqlTypes.DATE.getIdentifier(), (Object)TableFieldSchema.Type.DATE).put((Object)SqlTypes.TIME.getIdentifier(), (Object)TableFieldSchema.Type.TIME).put((Object)SqlTypes.DATETIME.getIdentifier(), (Object)TableFieldSchema.Type.DATETIME).put((Object)SqlTypes.TIMESTAMP.getIdentifier(), (Object)TableFieldSchema.Type.TIMESTAMP).put((Object)"Enum", (Object)TableFieldSchema.Type.STRING).build();
    static final @UnknownKeyFor @NonNull @Initialized Map<// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.TypeName, @UnknownKeyFor @NonNull @Initialized Function<@UnknownKeyFor @NonNull @Initialized Object, @UnknownKeyFor @NonNull @Initialized Object>> PRIMITIVE_ENCODERS = ImmutableMap.builder().put((Object)Schema.TypeName.INT16, o -> ((Short)o).longValue()).put((Object)Schema.TypeName.BYTE, o -> ((Byte)o).longValue()).put((Object)Schema.TypeName.INT32, o -> ((Integer)o).longValue()).put((Object)Schema.TypeName.INT64, (Object)Functions.identity()).put((Object)Schema.TypeName.FLOAT, o -> Double.valueOf(o.toString())).put((Object)Schema.TypeName.DOUBLE, Function.identity()).put((Object)Schema.TypeName.STRING, Function.identity()).put((Object)Schema.TypeName.BOOLEAN, Function.identity()).put((Object)Schema.TypeName.DATETIME, o -> ((ReadableInstant)o).getMillis() * 1000L).put((Object)Schema.TypeName.BYTES, BeamRowToStorageApiProto::toProtoByteString).put((Object)Schema.TypeName.DECIMAL, o -> BeamRowToStorageApiProto.serializeBigDecimalToNumeric((BigDecimal)o)).build();
    static final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized BiFunction<// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.LogicalType<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized Object, @UnknownKeyFor @NonNull @Initialized Object>> LOGICAL_TYPE_ENCODERS = ImmutableMap.builder().put((Object)SqlTypes.DATE.getIdentifier(), (logicalType, value) -> (int)((LocalDate)value).toEpochDay()).put((Object)SqlTypes.TIME.getIdentifier(), (logicalType, value) -> CivilTimeEncoder.encodePacked64TimeMicros((LocalTime)value)).put((Object)SqlTypes.DATETIME.getIdentifier(), (logicalType, value) -> CivilTimeEncoder.encodePacked64DatetimeMicros((LocalDateTime)value)).put((Object)SqlTypes.TIMESTAMP.getIdentifier(), (logicalType, value) -> ChronoUnit.MICROS.between(Instant.EPOCH, (Instant)value)).put((Object)"Enum", (logicalType, value) -> ((EnumerationType)logicalType).toString((EnumerationType.Value)value)).build();

    private static @UnknownKeyFor @NonNull @Initialized ByteString toProtoByteString(@UnknownKeyFor @NonNull @Initialized Object o) {
        if (o instanceof byte[]) {
            return ByteString.copyFrom((byte[])((byte[])o));
        }
        if (o instanceof ByteBuffer) {
            return ByteString.copyFrom((ByteBuffer)((ByteBuffer)o));
        }
        if (o instanceof String) {
            return ByteString.copyFromUtf8((String)((String)o));
        }
        throw new ClassCastException(String.format("Cannot cast %s to a compatible object to build ByteString.", o.getClass()));
    }

    public static @UnknownKeyFor @NonNull @Initialized DynamicMessage messageFromBeamRow(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Descriptors.Descriptor descriptor, @UnknownKeyFor @NonNull @Initialized Row row, @javax.annotation.Nullable @UnknownKeyFor @Nullable @Initialized String changeType, @UnknownKeyFor @NonNull @Initialized long changeSequenceNum) {
        return BeamRowToStorageApiProto.messageFromBeamRow(descriptor, row, changeType, Long.toHexString(changeSequenceNum));
    }

    public static @UnknownKeyFor @NonNull @Initialized DynamicMessage messageFromBeamRow(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Descriptors.Descriptor descriptor, @UnknownKeyFor @NonNull @Initialized Row row, @javax.annotation.Nullable @UnknownKeyFor @Nullable @Initialized String changeType, @javax.annotation.Nullable @UnknownKeyFor @Nullable @Initialized String changeSequenceNum) {
        Schema beamSchema = row.getSchema();
        DynamicMessage.Builder builder = DynamicMessage.newBuilder((Descriptors.Descriptor)descriptor);
        for (int i = 0; i < row.getFieldCount(); ++i) {
            Schema.Field beamField = beamSchema.getField(i);
            Descriptors.FieldDescriptor fieldDescriptor = (Descriptors.FieldDescriptor)org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkNotNull((Object)descriptor.findFieldByName(beamField.getName().toLowerCase()), (Object)beamField.getName().toLowerCase());
            Object value = BeamRowToStorageApiProto.messageValueFromRowValue(fieldDescriptor, beamField, i, row);
            if (value == null) continue;
            builder.setField(fieldDescriptor, value);
        }
        if (changeType != null) {
            builder.setField((Descriptors.FieldDescriptor)Preconditions.checkStateNotNull((Object)descriptor.findFieldByName("_CHANGE_TYPE")), (Object)changeType);
            builder.setField((Descriptors.FieldDescriptor)Preconditions.checkStateNotNull((Object)descriptor.findFieldByName("_CHANGE_SEQUENCE_NUMBER")), Preconditions.checkStateNotNull((Object)changeSequenceNum));
        }
        return builder.build();
    }

    @VisibleForTesting
    static @UnknownKeyFor @NonNull @Initialized TableSchema protoTableSchemaFromBeamSchema(@UnknownKeyFor @NonNull @Initialized Schema schema) {
        org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkState((schema.getFieldCount() > 0 ? 1 : 0) != 0);
        TableSchema.Builder builder = TableSchema.newBuilder();
        for (Schema.Field field : schema.getFields()) {
            builder.addFields(BeamRowToStorageApiProto.fieldDescriptorFromBeamField(field));
        }
        return builder.build();
    }

    private static @UnknownKeyFor @NonNull @Initialized TableFieldSchema fieldDescriptorFromBeamField(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.Field field) {
        TableFieldSchema.Builder builder = TableFieldSchema.newBuilder();
        if (StorageApiCDC.COLUMNS.contains(field.getName())) {
            throw new RuntimeException("Reserved field name " + field.getName() + " in user schema.");
        }
        builder = builder.setName(field.getName().toLowerCase());
        switch (field.getType().getTypeName()) {
            case ROW: {
                Schema rowSchema = field.getType().getRowSchema();
                if (rowSchema == null) {
                    throw new RuntimeException("Unexpected null schema!");
                }
                builder = builder.setType(TableFieldSchema.Type.STRUCT);
                for (Schema.Field nestedField : rowSchema.getFields()) {
                    builder = builder.addFields(BeamRowToStorageApiProto.fieldDescriptorFromBeamField(nestedField));
                }
                break;
            }
            case ARRAY: 
            case ITERABLE: {
                Schema.FieldType elementType = field.getType().getCollectionElementType();
                if (elementType == null) {
                    throw new RuntimeException("Unexpected null element type on " + field.getName());
                }
                Schema.TypeName containedTypeName = (Schema.TypeName)org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkNotNull((Object)elementType.getTypeName(), (Object)("Null type name found in contained type at " + field.getName()));
                org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkState((!containedTypeName.isCollectionType() && !containedTypeName.isMapType() ? 1 : 0) != 0, (Object)("Nested container types are not supported by BigQuery. Field " + field.getName() + " contains a type " + containedTypeName.name()));
                TableFieldSchema elementFieldSchema = BeamRowToStorageApiProto.fieldDescriptorFromBeamField(Schema.Field.of((String)field.getName(), (Schema.FieldType)elementType));
                builder = builder.setType(elementFieldSchema.getType());
                if (elementFieldSchema.hasTimestampPrecision()) {
                    builder = builder.setTimestampPrecision(elementFieldSchema.getTimestampPrecision());
                }
                builder.addAllFields((Iterable)elementFieldSchema.getFieldsList());
                builder = builder.setMode(TableFieldSchema.Mode.REPEATED);
                break;
            }
            case LOGICAL_TYPE: {
                TableFieldSchema.Type type;
                Schema.LogicalType logicalType = field.getType().getLogicalType();
                if (logicalType == null) {
                    throw new RuntimeException("Unexpected null logical type " + field.getType());
                }
                if (logicalType.getIdentifier().equals("beam:logical_type:timestamp:v1")) {
                    int precision = (Integer)org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkNotNull((Object)((Integer)logicalType.getArgument()), (Object)"Expected logical type argument for timestamp precision.");
                    if (precision != 9) {
                        throw new RuntimeException("Unsupported precision for Timestamp logical type " + precision);
                    }
                    type = TableFieldSchema.Type.TIMESTAMP;
                    builder.setTimestampPrecision(Int64Value.newBuilder().setValue(12L).build());
                } else {
                    type = LOGICAL_TYPES.get(logicalType.getIdentifier());
                    if (type == null) {
                        throw new RuntimeException("Unsupported logical type " + field.getType());
                    }
                }
                builder = builder.setType(type);
                break;
            }
            case MAP: {
                Schema.FieldType keyType = field.getType().getMapKeyType();
                Schema.FieldType valueType = field.getType().getMapValueType();
                if (keyType == null) {
                    throw new RuntimeException("Unexpected null element type for the map's key on " + field.getName());
                }
                if (valueType == null) {
                    throw new RuntimeException("Unexpected null element type for the map's value on " + field.getName());
                }
                builder = builder.setType(TableFieldSchema.Type.STRUCT).addFields(BeamRowToStorageApiProto.fieldDescriptorFromBeamField(Schema.Field.of((String)"key", (Schema.FieldType)keyType))).addFields(BeamRowToStorageApiProto.fieldDescriptorFromBeamField(Schema.Field.of((String)"value", (Schema.FieldType)valueType))).setMode(TableFieldSchema.Mode.REPEATED);
                break;
            }
            default: {
                TableFieldSchema.Type primitiveType = PRIMITIVE_TYPES.get(field.getType().getTypeName());
                if (primitiveType == null) {
                    throw new RuntimeException("Unsupported type " + field.getType());
                }
                builder = builder.setType(primitiveType);
            }
        }
        if (builder.getMode() != TableFieldSchema.Mode.REPEATED) {
            builder = field.getType().getNullable() != false ? builder.setMode(TableFieldSchema.Mode.NULLABLE) : builder.setMode(TableFieldSchema.Mode.REQUIRED);
        }
        if (field.getDescription() != null) {
            builder = builder.setDescription(field.getDescription());
        }
        return builder.build();
    }

    @javax.annotation.Nullable
    private static @UnknownKeyFor @Nullable @Initialized Object messageValueFromRowValue(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Descriptors.FieldDescriptor fieldDescriptor, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.Field beamField, @UnknownKeyFor @NonNull @Initialized int index, @UnknownKeyFor @NonNull @Initialized Row row) {
        Object value = row.getValue(index);
        if (value == null) {
            if (fieldDescriptor.isOptional()) {
                return null;
            }
            if (fieldDescriptor.isRepeated()) {
                return Collections.emptyList();
            }
            throw new IllegalArgumentException("Received null value for non-nullable field " + fieldDescriptor.getName());
        }
        return BeamRowToStorageApiProto.toProtoValue(fieldDescriptor, beamField.getType(), value);
    }

    private static @UnknownKeyFor @NonNull @Initialized Object toProtoValue(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Descriptors.FieldDescriptor fieldDescriptor, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.FieldType beamFieldType, @UnknownKeyFor @NonNull @Initialized Object value) {
        switch (beamFieldType.getTypeName()) {
            case ROW: {
                return BeamRowToStorageApiProto.messageFromBeamRow(fieldDescriptor.getMessageType(), (Row)value, null, -1L);
            }
            case ARRAY: 
            case ITERABLE: {
                Iterable iterable = (Iterable)value;
                Schema.FieldType iterableElementType = beamFieldType.getCollectionElementType();
                if (iterableElementType == null) {
                    throw new RuntimeException("Unexpected null element type: " + fieldDescriptor.getName());
                }
                return StreamSupport.stream(iterable.spliterator(), false).map(v -> BeamRowToStorageApiProto.toProtoValue(fieldDescriptor, iterableElementType, v)).collect(Collectors.toList());
            }
            case MAP: {
                Map map = (Map)value;
                Schema.FieldType keyType = beamFieldType.getMapKeyType();
                Schema.FieldType valueType = beamFieldType.getMapValueType();
                if (keyType == null) {
                    throw new RuntimeException("Unexpected null for key type: " + fieldDescriptor.getName());
                }
                if (valueType == null) {
                    throw new RuntimeException("Unexpected null for value type: " + fieldDescriptor.getName());
                }
                return map.entrySet().stream().map(entry -> BeamRowToStorageApiProto.mapEntryToProtoValue(fieldDescriptor.getMessageType(), keyType, valueType, entry)).collect(Collectors.toList());
            }
        }
        return BeamRowToStorageApiProto.scalarToProtoValue(fieldDescriptor, beamFieldType, value);
    }

    private static @UnknownKeyFor @NonNull @Initialized DynamicMessage buildTimestampPicosMessage(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Descriptors.Descriptor timestampPicosDescriptor, @UnknownKeyFor @NonNull @Initialized Instant instant) {
        long seconds = instant.getEpochSecond();
        long picoseconds = (long)instant.getNano() * 1000L;
        return DynamicMessage.newBuilder((Descriptors.Descriptor)timestampPicosDescriptor).setField((Descriptors.FieldDescriptor)org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkNotNull((Object)timestampPicosDescriptor.findFieldByName("seconds")), (Object)seconds).setField((Descriptors.FieldDescriptor)org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkNotNull((Object)timestampPicosDescriptor.findFieldByName("picoseconds")), (Object)picoseconds).build();
    }

    @VisibleForTesting
    static @UnknownKeyFor @NonNull @Initialized Object scalarToProtoValue(@javax.annotation.Nullable // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @Nullable @Initialized Descriptors.FieldDescriptor fieldDescriptor, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.FieldType beamFieldType, @UnknownKeyFor @NonNull @Initialized Object value) {
        if (beamFieldType.getTypeName() == Schema.TypeName.LOGICAL_TYPE) {
            Schema.LogicalType logicalType = beamFieldType.getLogicalType();
            if (logicalType == null) {
                throw new RuntimeException("Unexpectedly null logical type " + beamFieldType);
            }
            if (logicalType.getIdentifier().equals("beam:logical_type:timestamp:v1")) {
                Instant instant = (Instant)value;
                Descriptors.Descriptor timestampPicosDescriptor = ((Descriptors.FieldDescriptor)org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkNotNull((Object)fieldDescriptor)).getMessageType();
                return BeamRowToStorageApiProto.buildTimestampPicosMessage(timestampPicosDescriptor, instant);
            }
            BiFunction<Schema.LogicalType<?, ?>, Object, Object> logicalTypeEncoder = LOGICAL_TYPE_ENCODERS.get(logicalType.getIdentifier());
            if (logicalTypeEncoder == null) {
                throw new RuntimeException("Unsupported logical type " + logicalType.getIdentifier());
            }
            return logicalTypeEncoder.apply(logicalType, value);
        }
        Function<Object, Object> encoder = PRIMITIVE_ENCODERS.get(beamFieldType.getTypeName());
        if (encoder == null) {
            throw new RuntimeException("Unexpected beam type " + beamFieldType);
        }
        return encoder.apply(value);
    }

    static @UnknownKeyFor @NonNull @Initialized Object mapEntryToProtoValue(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Descriptors.Descriptor descriptor, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.FieldType keyFieldType, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.FieldType valueFieldType, @UnknownKeyFor @NonNull @Initialized Map.Entry<@UnknownKeyFor @NonNull @Initialized Object, @UnknownKeyFor @NonNull @Initialized Object> entryValue) {
        Descriptors.FieldDescriptor valueFieldDescriptor;
        Object value;
        DynamicMessage.Builder builder = DynamicMessage.newBuilder((Descriptors.Descriptor)descriptor);
        Descriptors.FieldDescriptor keyFieldDescriptor = (Descriptors.FieldDescriptor)org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkNotNull((Object)descriptor.findFieldByName("key"));
        Object key = BeamRowToStorageApiProto.toProtoValue(keyFieldDescriptor, keyFieldType, entryValue.getKey());
        if (key != null) {
            builder.setField(keyFieldDescriptor, key);
        }
        if ((value = BeamRowToStorageApiProto.toProtoValue(valueFieldDescriptor = (Descriptors.FieldDescriptor)org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkNotNull((Object)descriptor.findFieldByName("value")), valueFieldType, entryValue.getValue())) != null) {
            builder.setField(valueFieldDescriptor, value);
        }
        return builder.build();
    }

    static @UnknownKeyFor @NonNull @Initialized ByteString serializeBigDecimalToNumeric(@UnknownKeyFor @NonNull @Initialized BigDecimal o) {
        return BeamRowToStorageApiProto.serializeBigDecimal(o, 9, MAX_NUMERIC_VALUE, MIN_NUMERIC_VALUE, "Numeric");
    }

    private static @UnknownKeyFor @NonNull @Initialized ByteString serializeBigDecimal(@UnknownKeyFor @NonNull @Initialized BigDecimal v, @UnknownKeyFor @NonNull @Initialized int scale, @UnknownKeyFor @NonNull @Initialized BigDecimal maxValue, @UnknownKeyFor @NonNull @Initialized BigDecimal minValue, @UnknownKeyFor @NonNull @Initialized String typeName) {
        if (v.scale() > scale) {
            throw new IllegalArgumentException(typeName + " scale cannot exceed " + scale + ": " + v.toPlainString());
        }
        if (v.compareTo(maxValue) > 0 || v.compareTo(minValue) < 0) {
            throw new IllegalArgumentException(typeName + " overflow: " + v.toPlainString());
        }
        byte[] bytes = v.setScale(scale).unscaledValue().toByteArray();
        Bytes.reverse((byte[])bytes);
        return ByteString.copyFrom((byte[])bytes);
    }
}

