/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner.changestreams.action;

import com.google.cloud.Timestamp;
import java.util.Optional;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.ChangeStreamMetrics;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.model.PartitionEventRecord;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.model.PartitionMetadata;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction.RestrictionInterrupter;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction.TimestampRange;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.splittabledofn.ManualWatermarkEstimator;
import org.apache.beam.sdk.transforms.splittabledofn.RestrictionTracker;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartitionEventRecordAction {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(PartitionEventRecordAction.class);
    private final @UnknownKeyFor @NonNull @Initialized ChangeStreamMetrics metrics;

    PartitionEventRecordAction(@UnknownKeyFor @NonNull @Initialized ChangeStreamMetrics metrics) {
        this.metrics = metrics;
    }

    @VisibleForTesting
    public @UnknownKeyFor @NonNull @Initialized Optional<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized DoFn.ProcessContinuation> run(@UnknownKeyFor @NonNull @Initialized PartitionMetadata partition, @UnknownKeyFor @NonNull @Initialized PartitionEventRecord record, @UnknownKeyFor @NonNull @Initialized RestrictionTracker<@UnknownKeyFor @NonNull @Initialized TimestampRange, @UnknownKeyFor @NonNull @Initialized Timestamp> tracker, @UnknownKeyFor @NonNull @Initialized RestrictionInterrupter<@UnknownKeyFor @NonNull @Initialized Timestamp> interrupter, @UnknownKeyFor @NonNull @Initialized ManualWatermarkEstimator<@UnknownKeyFor @NonNull @Initialized Instant> watermarkEstimator) {
        String token = partition.getPartitionToken();
        LOG.debug("[{}] Processing partition event record {}", (Object)token, (Object)record);
        Timestamp timestamp = record.getCommitTimestamp();
        Instant timestampInstant = new Instant(timestamp.toSqlTimestamp().getTime());
        if (interrupter.tryInterrupt(timestamp)) {
            LOG.debug("[{}] Soft deadline reached with partition event record at {}, rescheduling", (Object)token, (Object)timestamp);
            return Optional.of(DoFn.ProcessContinuation.resume());
        }
        if (!tracker.tryClaim((Object)timestamp)) {
            LOG.debug("[{}] Could not claim queryChangeStream({}), stopping", (Object)token, (Object)timestamp);
            return Optional.of(DoFn.ProcessContinuation.stop());
        }
        this.metrics.incPartitionEventRecordCount();
        watermarkEstimator.setWatermark(timestampInstant);
        LOG.debug("[{}] Partition event record action completed successfully", (Object)token);
        return Optional.empty();
    }
}

