/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.JobStatistics;
import com.google.api.services.bigquery.model.Table;
import com.google.api.services.bigquery.model.TableReference;
import com.google.cloud.bigquery.storage.v1.DataFormat;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryOptions;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryQueryHelper;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryResourceNaming;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServices;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryStorageSourceBase;
import org.apache.beam.sdk.io.gcp.bigquery.SchemaAndRecord;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

class BigQueryStorageQuerySource<@UnknownKeyFor T>
extends BigQueryStorageSourceBase<T> {
    private final @UnknownKeyFor @NonNull @Initialized String stepUuid;
    private final @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> queryProvider;
    private final @UnknownKeyFor @NonNull @Initialized Boolean flattenResults;
    private final @UnknownKeyFor @NonNull @Initialized Boolean useLegacySql;
    private final @UnknownKeyFor @NonNull @Initialized BigQueryIO.TypedRead.QueryPriority priority;
    private final @Nullable @UnknownKeyFor @Initialized String location;
    private final @Nullable @UnknownKeyFor @Initialized String queryTempDataset;
    private final @Nullable @UnknownKeyFor @Initialized String queryTempProject;
    private final @Nullable @UnknownKeyFor @Initialized String kmsKey;
    private transient @UnknownKeyFor @NonNull @Initialized AtomicReference<@Nullable @UnknownKeyFor @Initialized JobStatistics> dryRunJobStats;

    public static <T> @UnknownKeyFor @NonNull @Initialized BigQueryStorageQuerySource<T> create(@UnknownKeyFor @NonNull @Initialized String stepUuid, @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> queryProvider, @UnknownKeyFor @NonNull @Initialized Boolean flattenResults, @UnknownKeyFor @NonNull @Initialized Boolean useLegacySql, @UnknownKeyFor @NonNull @Initialized BigQueryIO.TypedRead.QueryPriority priority, @Nullable @UnknownKeyFor @Initialized String location, @Nullable @UnknownKeyFor @Initialized String queryTempDataset, @Nullable @UnknownKeyFor @Initialized String queryTempProject, @Nullable @UnknownKeyFor @Initialized String kmsKey, @Nullable @UnknownKeyFor @Initialized DataFormat format, @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized SchemaAndRecord, T> parseFn, @UnknownKeyFor @NonNull @Initialized Coder<T> outputCoder, @UnknownKeyFor @NonNull @Initialized BigQueryServices bqServices) {
        return new BigQueryStorageQuerySource<T>(stepUuid, queryProvider, flattenResults, useLegacySql, priority, location, queryTempDataset, queryTempProject, kmsKey, format, parseFn, outputCoder, bqServices);
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized BigQueryStorageQuerySource<T> create(@UnknownKeyFor @NonNull @Initialized String stepUuid, @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> queryProvider, @UnknownKeyFor @NonNull @Initialized Boolean flattenResults, @UnknownKeyFor @NonNull @Initialized Boolean useLegacySql, @UnknownKeyFor @NonNull @Initialized BigQueryIO.TypedRead.QueryPriority priority, @Nullable @UnknownKeyFor @Initialized String location, @Nullable @UnknownKeyFor @Initialized String kmsKey, @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized SchemaAndRecord, T> parseFn, @UnknownKeyFor @NonNull @Initialized Coder<T> outputCoder, @UnknownKeyFor @NonNull @Initialized BigQueryServices bqServices) {
        return new BigQueryStorageQuerySource<T>(stepUuid, queryProvider, flattenResults, useLegacySql, priority, location, null, null, kmsKey, null, parseFn, outputCoder, bqServices);
    }

    private BigQueryStorageQuerySource(@UnknownKeyFor @NonNull @Initialized String stepUuid, @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> queryProvider, @UnknownKeyFor @NonNull @Initialized Boolean flattenResults, @UnknownKeyFor @NonNull @Initialized Boolean useLegacySql, @UnknownKeyFor @NonNull @Initialized BigQueryIO.TypedRead.QueryPriority priority, @Nullable @UnknownKeyFor @Initialized String location, @Nullable @UnknownKeyFor @Initialized String queryTempDataset, @Nullable @UnknownKeyFor @Initialized String queryTempProject, @Nullable @UnknownKeyFor @Initialized String kmsKey, @Nullable @UnknownKeyFor @Initialized DataFormat format, @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized SchemaAndRecord, T> parseFn, @UnknownKeyFor @NonNull @Initialized Coder<T> outputCoder, @UnknownKeyFor @NonNull @Initialized BigQueryServices bqServices) {
        super(format, null, null, parseFn, outputCoder, bqServices);
        this.stepUuid = (String)Preconditions.checkNotNull((Object)stepUuid, (Object)"stepUuid");
        this.queryProvider = (ValueProvider)Preconditions.checkNotNull(queryProvider, (Object)"queryProvider");
        this.flattenResults = (Boolean)Preconditions.checkNotNull((Object)flattenResults, (Object)"flattenResults");
        this.useLegacySql = (Boolean)Preconditions.checkNotNull((Object)useLegacySql, (Object)"useLegacySql");
        this.priority = (BigQueryIO.TypedRead.QueryPriority)((Object)Preconditions.checkNotNull((Object)((Object)priority), (Object)"priority"));
        this.location = location;
        this.queryTempDataset = queryTempDataset;
        this.queryTempProject = queryTempProject;
        this.kmsKey = kmsKey;
        this.dryRunJobStats = new AtomicReference();
    }

    private void readObject(@UnknownKeyFor @NonNull @Initialized ObjectInputStream in) throws @UnknownKeyFor @NonNull @Initialized ClassNotFoundException, @UnknownKeyFor @NonNull @Initialized IOException {
        in.defaultReadObject();
        this.dryRunJobStats = new AtomicReference();
    }

    public void populateDisplayData(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
        super.populateDisplayData(builder);
        builder.add(DisplayData.item((String)"query", this.queryProvider).withLabel("Query"));
        builder.add(DisplayData.item((String)"launchesBigQueryJobs", (Boolean)true).withLabel("This transform launches BigQuery jobs to read/write elements."));
    }

    public @UnknownKeyFor @NonNull @Initialized long getEstimatedSizeBytes(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) throws @UnknownKeyFor @NonNull @Initialized Exception {
        return BigQueryQueryHelper.dryRunQueryIfNeeded(this.bqServices, (BigQueryOptions)options.as(BigQueryOptions.class), this.dryRunJobStats, (String)this.queryProvider.get(), this.flattenResults, this.useLegacySql, this.location).getQuery().getTotalBytesProcessed();
    }

    @Override
    protected @Nullable @UnknownKeyFor @Initialized Table getTargetTable(@UnknownKeyFor @NonNull @Initialized BigQueryOptions options) throws @UnknownKeyFor @NonNull @Initialized Exception {
        TableReference queryResultTable = BigQueryQueryHelper.executeQuery(this.bqServices, options, this.dryRunJobStats, this.stepUuid, (String)this.queryProvider.get(), this.flattenResults, this.useLegacySql, this.priority, this.location, this.queryTempDataset, this.queryTempProject, this.kmsKey);
        try (BigQueryServices.DatasetService datasetService = this.bqServices.getDatasetService(options);){
            Table table = datasetService.getTable(queryResultTable);
            return table;
        }
    }

    @Override
    protected @Nullable @UnknownKeyFor @Initialized String getTargetTableId(@UnknownKeyFor @NonNull @Initialized BigQueryOptions options) throws @UnknownKeyFor @NonNull @Initialized Exception {
        return null;
    }

    void removeDestinationIfExists(@UnknownKeyFor @NonNull @Initialized BigQueryOptions options) throws @UnknownKeyFor @NonNull @Initialized Exception {
        String tempTableID;
        TableReference tempTableReference;
        Table destTable;
        BigQueryServices.DatasetService datasetService = this.bqServices.getDatasetService((BigQueryOptions)options.as(BigQueryOptions.class));
        String project = this.queryTempProject;
        if (project == null) {
            String string = project = ((BigQueryOptions)options.as(BigQueryOptions.class)).getBigQueryProject() == null ? ((BigQueryOptions)options.as(BigQueryOptions.class)).getProject() : ((BigQueryOptions)options.as(BigQueryOptions.class)).getBigQueryProject();
        }
        if ((destTable = datasetService.getTable(tempTableReference = BigQueryResourceNaming.createTempTableReference(project, tempTableID = BigQueryResourceNaming.createJobIdPrefix(options.getJobName(), this.stepUuid, BigQueryResourceNaming.JobType.QUERY), Optional.ofNullable(this.queryTempDataset)))) != null) {
            datasetService.deleteTable(tempTableReference);
        }
    }
}

