/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import io.grpc.Status;
import java.time.Duration;
import java.time.Instant;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServicesImpl;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryUtils;
import org.apache.beam.sdk.io.gcp.bigquery.StreamingInsertsMetrics;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.DelegatingCounter;
import org.apache.beam.sdk.metrics.DelegatingHistogram;
import org.apache.beam.sdk.metrics.Histogram;
import org.apache.beam.sdk.metrics.LabeledMetricNameUtils;
import org.apache.beam.sdk.metrics.MetricName;
import org.apache.beam.sdk.util.HistogramData;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class BigQuerySinkMetrics {
    private static @UnknownKeyFor @NonNull @Initialized boolean supportMetricsDeletion = false;
    private static @UnknownKeyFor @NonNull @Initialized boolean supportStreamingInsertsMetrics = false;
    public static final @UnknownKeyFor @NonNull @Initialized String METRICS_NAMESPACE = "BigQuerySink";
    public static final @UnknownKeyFor @NonNull @Initialized String UNKNOWN = Status.Code.UNKNOWN.toString();
    public static final @UnknownKeyFor @NonNull @Initialized String OK = Status.Code.OK.toString();
    static final @UnknownKeyFor @NonNull @Initialized String INTERNAL = "INTERNAL";
    public static final @UnknownKeyFor @NonNull @Initialized String PAYLOAD_TOO_LARGE = "PayloadTooLarge";
    private static final @UnknownKeyFor @NonNull @Initialized String RPC_REQUESTS = "RpcRequestsCount";
    private static final @UnknownKeyFor @NonNull @Initialized String RPC_LATENCY = "RpcLatency";
    private static final @UnknownKeyFor @NonNull @Initialized String APPEND_ROWS_ROW_STATUS = "RowsAppendedCount";
    public static final @UnknownKeyFor @NonNull @Initialized String THROTTLED_TIME = "ThrottledTime";
    private static final @UnknownKeyFor @NonNull @Initialized String TABLE_ID_LABEL = "table_id";
    private static final @UnknownKeyFor @NonNull @Initialized String RPC_STATUS_LABEL = "rpc_status";
    private static final @UnknownKeyFor @NonNull @Initialized String RPC_METHOD = "rpc_method";
    private static final @UnknownKeyFor @NonNull @Initialized String ROW_STATUS = "row_status";

    @VisibleForTesting
    static @UnknownKeyFor @NonNull @Initialized Counter createRPCRequestCounter(@UnknownKeyFor @NonNull @Initialized RpcMethod method, @UnknownKeyFor @NonNull @Initialized String rpcStatus, @UnknownKeyFor @NonNull @Initialized String tableId) {
        LabeledMetricNameUtils.MetricNameBuilder nameBuilder = LabeledMetricNameUtils.MetricNameBuilder.baseNameBuilder((String)RPC_REQUESTS);
        nameBuilder.addLabel(RPC_METHOD, method.toString());
        nameBuilder.addLabel(RPC_STATUS_LABEL, rpcStatus);
        if (supportMetricsDeletion) {
            nameBuilder.addLabel(TABLE_ID_LABEL, tableId);
        }
        MetricName metricName = nameBuilder.build(METRICS_NAMESPACE);
        return new DelegatingCounter(metricName, false, true);
    }

    static @UnknownKeyFor @NonNull @Initialized Histogram createRPCLatencyHistogram(@UnknownKeyFor @NonNull @Initialized RpcMethod method) {
        LabeledMetricNameUtils.MetricNameBuilder nameBuilder = LabeledMetricNameUtils.MetricNameBuilder.baseNameBuilder((String)RPC_LATENCY);
        nameBuilder.addLabel(RPC_METHOD, method.toString());
        nameBuilder.addMetricLabel("PER_WORKER_METRIC", "true");
        MetricName metricName = nameBuilder.build(METRICS_NAMESPACE);
        HistogramData.ExponentialBuckets buckets = HistogramData.ExponentialBuckets.of((int)0, (int)17);
        return new DelegatingHistogram(metricName, (HistogramData.BucketType)buckets, false);
    }

    private static void updateRpcLatencyMetric(@Nonnull /*
     * Issues handling annotations - annotations may be inaccurate
     */
     @UnknownKeyFor @NonNull @Initialized RetryManager.Operation.Context<@UnknownKeyFor @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized @NonNull @Initialized ?> c, @UnknownKeyFor @NonNull @Initialized RpcMethod method) {
        Instant operationStartTime = c.getOperationStartTime();
        Instant operationEndTime = c.getOperationEndTime();
        if (operationStartTime == null || operationEndTime == null) {
            return;
        }
        long timeElapsed = Duration.between(operationStartTime, operationEndTime).toMillis();
        if (timeElapsed > 0L) {
            BigQuerySinkMetrics.createRPCLatencyHistogram(method).update((double)timeElapsed);
        }
    }

    public static @UnknownKeyFor @NonNull @Initialized Counter appendRowsRowStatusCounter(@UnknownKeyFor @NonNull @Initialized RowStatus rowStatus, @UnknownKeyFor @NonNull @Initialized String rpcStatus, @UnknownKeyFor @NonNull @Initialized String tableId) {
        LabeledMetricNameUtils.MetricNameBuilder nameBuilder = LabeledMetricNameUtils.MetricNameBuilder.baseNameBuilder((String)APPEND_ROWS_ROW_STATUS);
        nameBuilder.addLabel(ROW_STATUS, rowStatus.toString());
        nameBuilder.addLabel(RPC_STATUS_LABEL, rpcStatus);
        if (supportMetricsDeletion) {
            nameBuilder.addLabel(TABLE_ID_LABEL, tableId);
        }
        MetricName metricName = nameBuilder.build(METRICS_NAMESPACE);
        return new DelegatingCounter(metricName, false, true);
    }

    public static @UnknownKeyFor @NonNull @Initialized Counter throttledTimeCounter(@UnknownKeyFor @NonNull @Initialized RpcMethod method) {
        LabeledMetricNameUtils.MetricNameBuilder nameBuilder = LabeledMetricNameUtils.MetricNameBuilder.baseNameBuilder((String)THROTTLED_TIME);
        nameBuilder.addLabel(RPC_METHOD, method.toString());
        MetricName metricName = nameBuilder.build(METRICS_NAMESPACE);
        DelegatingCounter fineCounter = new DelegatingCounter(metricName, false, true);
        Counter coarseCounter = BigQueryServicesImpl.StorageClientImpl.THROTTLING_MSECS;
        return new BigQueryUtils.NestedCounter(MetricName.named((String)METRICS_NAMESPACE, (String)(metricName.getName() + coarseCounter.getName().getName())), new Counter[]{fineCounter, coarseCounter});
    }

    public static @UnknownKeyFor @NonNull @Initialized String throwableToGRPCCodeString(@Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Throwable t) {
        if (t == null) {
            return UNKNOWN;
        }
        return Status.fromThrowable((Throwable)t).getCode().toString();
    }

    public static void reportSuccessfulRpcMetrics(@Nullable /*
     * Issues handling annotations - annotations may be inaccurate
     */
     @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized RetryManager.Operation.Context<@UnknownKeyFor @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized @NonNull @Initialized ?> c, @UnknownKeyFor @NonNull @Initialized RpcMethod method) {
        BigQuerySinkMetrics.reportSuccessfulRpcMetrics(c, method, UNKNOWN);
    }

    public static void reportSuccessfulRpcMetrics(@Nullable /*
     * Issues handling annotations - annotations may be inaccurate
     */
     @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized RetryManager.Operation.Context<@UnknownKeyFor @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized @NonNull @Initialized ?> c, @UnknownKeyFor @NonNull @Initialized RpcMethod method, @UnknownKeyFor @NonNull @Initialized String tableId) {
        if (c == null) {
            return;
        }
        BigQuerySinkMetrics.createRPCRequestCounter(method, OK, tableId).inc(1L);
        BigQuerySinkMetrics.updateRpcLatencyMetric(c, method);
    }

    public static void reportFailedRPCMetrics(@Nullable /*
     * Issues handling annotations - annotations may be inaccurate
     */
     @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized RetryManager.Operation.Context<@UnknownKeyFor @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized @NonNull @Initialized ?> c, @UnknownKeyFor @NonNull @Initialized RpcMethod method) {
        BigQuerySinkMetrics.reportFailedRPCMetrics(c, method, UNKNOWN);
    }

    public static void reportFailedRPCMetrics(@Nullable /*
     * Issues handling annotations - annotations may be inaccurate
     */
     @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized RetryManager.Operation.Context<@UnknownKeyFor @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized @NonNull @Initialized ?> c, @UnknownKeyFor @NonNull @Initialized RpcMethod method, @UnknownKeyFor @NonNull @Initialized String tableId) {
        if (c == null) {
            return;
        }
        String statusCode = BigQuerySinkMetrics.throwableToGRPCCodeString(c.getError());
        BigQuerySinkMetrics.createRPCRequestCounter(method, statusCode, tableId).inc(1L);
        BigQuerySinkMetrics.updateRpcLatencyMetric(c, method);
    }

    static @UnknownKeyFor @NonNull @Initialized StreamingInsertsMetrics streamingInsertsMetrics() {
        if (supportStreamingInsertsMetrics) {
            return StreamingInsertsMetrics.StreamingInsertsMetricsImpl.create();
        }
        return StreamingInsertsMetrics.NoOpStreamingInsertsMetrics.getInstance();
    }

    public static void setSupportStreamingInsertsMetrics(@UnknownKeyFor @NonNull @Initialized boolean supportStreamingInsertsMetrics) {
        BigQuerySinkMetrics.supportStreamingInsertsMetrics = supportStreamingInsertsMetrics;
    }

    public static void setSupportMetricsDeletion(@UnknownKeyFor @NonNull @Initialized boolean supportMetricsDeletion) {
        BigQuerySinkMetrics.supportMetricsDeletion = supportMetricsDeletion;
    }

    static enum RowStatus {
        SUCCESSFUL,
        RETRIED,
        FAILED;

    }

    public static enum RpcMethod {
        STREAMING_INSERTS,
        APPEND_ROWS,
        FLUSH_ROWS,
        FINALIZE_STREAM;

    }
}

