/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner;

import java.util.List;
import javax.annotation.Nullable;
import org.apache.beam.sdk.io.gcp.spanner.SpannerReadSchemaTransformProvider;
import org.apache.beam.sdk.schemas.annotations.SchemaFieldDescription;
import org.apache.beam.sdk.schemas.transforms.providers.ErrorHandling;

final class AutoValue_SpannerReadSchemaTransformProvider_SpannerReadSchemaTransformConfiguration
extends SpannerReadSchemaTransformProvider.SpannerReadSchemaTransformConfiguration {
    private final String instanceId;
    private final String databaseId;
    private final String projectId;
    private final String tableId;
    private final String query;
    private final List<String> columns;
    private final String index;
    private final Boolean batching;
    private final ErrorHandling errorHandling;

    private AutoValue_SpannerReadSchemaTransformProvider_SpannerReadSchemaTransformConfiguration(String instanceId, String databaseId, @Nullable String projectId, @Nullable String tableId, @Nullable String query, @Nullable List<String> columns, @Nullable String index, @Nullable Boolean batching, @Nullable ErrorHandling errorHandling) {
        this.instanceId = instanceId;
        this.databaseId = databaseId;
        this.projectId = projectId;
        this.tableId = tableId;
        this.query = query;
        this.columns = columns;
        this.index = index;
        this.batching = batching;
        this.errorHandling = errorHandling;
    }

    @Override
    @SchemaFieldDescription(value="Specifies the Cloud Spanner instance.")
    public String getInstanceId() {
        return this.instanceId;
    }

    @Override
    @SchemaFieldDescription(value="Specifies the Cloud Spanner database.")
    public String getDatabaseId() {
        return this.databaseId;
    }

    @Override
    @Nullable
    @SchemaFieldDescription(value="Specifies the GCP project ID.")
    public String getProjectId() {
        return this.projectId;
    }

    @Override
    @Nullable
    @SchemaFieldDescription(value="Specifies the Cloud Spanner table.")
    public String getTableId() {
        return this.tableId;
    }

    @Override
    @Nullable
    @SchemaFieldDescription(value="Specifies the SQL query to execute.")
    public String getQuery() {
        return this.query;
    }

    @Override
    @Nullable
    @SchemaFieldDescription(value="Specifies the columns to read from the table. This parameter is required when table is specified.")
    public List<String> getColumns() {
        return this.columns;
    }

    @Override
    @Nullable
    @SchemaFieldDescription(value="Specifies the Index to read from. This parameter can only be specified when using table.")
    public String getIndex() {
        return this.index;
    }

    @Override
    @Nullable
    @SchemaFieldDescription(value="Set to false to disable batching. Useful when using a query that is not compatible with the PartitionQuery API. Defaults to true.")
    public Boolean getBatching() {
        return this.batching;
    }

    @Override
    @Nullable
    @SchemaFieldDescription(value="This option specifies whether and where to output unwritable rows.")
    public ErrorHandling getErrorHandling() {
        return this.errorHandling;
    }

    public String toString() {
        return "SpannerReadSchemaTransformConfiguration{instanceId=" + this.instanceId + ", databaseId=" + this.databaseId + ", projectId=" + this.projectId + ", tableId=" + this.tableId + ", query=" + this.query + ", columns=" + this.columns + ", index=" + this.index + ", batching=" + this.batching + ", errorHandling=" + this.errorHandling + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof SpannerReadSchemaTransformProvider.SpannerReadSchemaTransformConfiguration) {
            SpannerReadSchemaTransformProvider.SpannerReadSchemaTransformConfiguration that = (SpannerReadSchemaTransformProvider.SpannerReadSchemaTransformConfiguration)o;
            return this.instanceId.equals(that.getInstanceId()) && this.databaseId.equals(that.getDatabaseId()) && (this.projectId == null ? that.getProjectId() == null : this.projectId.equals(that.getProjectId())) && (this.tableId == null ? that.getTableId() == null : this.tableId.equals(that.getTableId())) && (this.query == null ? that.getQuery() == null : this.query.equals(that.getQuery())) && (this.columns == null ? that.getColumns() == null : this.columns.equals(that.getColumns())) && (this.index == null ? that.getIndex() == null : this.index.equals(that.getIndex())) && (this.batching == null ? that.getBatching() == null : this.batching.equals(that.getBatching())) && (this.errorHandling == null ? that.getErrorHandling() == null : this.errorHandling.equals(that.getErrorHandling()));
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.instanceId.hashCode();
        h$ *= 1000003;
        h$ ^= this.databaseId.hashCode();
        h$ *= 1000003;
        h$ ^= this.projectId == null ? 0 : this.projectId.hashCode();
        h$ *= 1000003;
        h$ ^= this.tableId == null ? 0 : this.tableId.hashCode();
        h$ *= 1000003;
        h$ ^= this.query == null ? 0 : this.query.hashCode();
        h$ *= 1000003;
        h$ ^= this.columns == null ? 0 : this.columns.hashCode();
        h$ *= 1000003;
        h$ ^= this.index == null ? 0 : this.index.hashCode();
        h$ *= 1000003;
        h$ ^= this.batching == null ? 0 : this.batching.hashCode();
        h$ *= 1000003;
        return h$ ^= this.errorHandling == null ? 0 : this.errorHandling.hashCode();
    }

    static final class Builder
    extends SpannerReadSchemaTransformProvider.SpannerReadSchemaTransformConfiguration.Builder {
        private String instanceId;
        private String databaseId;
        private String projectId;
        private String tableId;
        private String query;
        private List<String> columns;
        private String index;
        private Boolean batching;
        private ErrorHandling errorHandling;

        Builder() {
        }

        @Override
        public SpannerReadSchemaTransformProvider.SpannerReadSchemaTransformConfiguration.Builder setInstanceId(String instanceId) {
            if (instanceId == null) {
                throw new NullPointerException("Null instanceId");
            }
            this.instanceId = instanceId;
            return this;
        }

        @Override
        public SpannerReadSchemaTransformProvider.SpannerReadSchemaTransformConfiguration.Builder setDatabaseId(String databaseId) {
            if (databaseId == null) {
                throw new NullPointerException("Null databaseId");
            }
            this.databaseId = databaseId;
            return this;
        }

        @Override
        public SpannerReadSchemaTransformProvider.SpannerReadSchemaTransformConfiguration.Builder setProjectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        @Override
        public SpannerReadSchemaTransformProvider.SpannerReadSchemaTransformConfiguration.Builder setTableId(String tableId) {
            this.tableId = tableId;
            return this;
        }

        @Override
        public SpannerReadSchemaTransformProvider.SpannerReadSchemaTransformConfiguration.Builder setQuery(String query) {
            this.query = query;
            return this;
        }

        @Override
        public SpannerReadSchemaTransformProvider.SpannerReadSchemaTransformConfiguration.Builder setColumns(List<String> columns) {
            this.columns = columns;
            return this;
        }

        @Override
        public SpannerReadSchemaTransformProvider.SpannerReadSchemaTransformConfiguration.Builder setIndex(String index) {
            this.index = index;
            return this;
        }

        @Override
        public SpannerReadSchemaTransformProvider.SpannerReadSchemaTransformConfiguration.Builder setBatching(Boolean batching) {
            this.batching = batching;
            return this;
        }

        @Override
        public SpannerReadSchemaTransformProvider.SpannerReadSchemaTransformConfiguration.Builder setErrorHandling(ErrorHandling errorHandling) {
            this.errorHandling = errorHandling;
            return this;
        }

        @Override
        public SpannerReadSchemaTransformProvider.SpannerReadSchemaTransformConfiguration build() {
            if (this.instanceId == null || this.databaseId == null) {
                StringBuilder missing = new StringBuilder();
                if (this.instanceId == null) {
                    missing.append(" instanceId");
                }
                if (this.databaseId == null) {
                    missing.append(" databaseId");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_SpannerReadSchemaTransformProvider_SpannerReadSchemaTransformConfiguration(this.instanceId, this.databaseId, this.projectId, this.tableId, this.query, this.columns, this.index, this.batching, this.errorHandling);
        }
    }
}

