/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigtable;

import com.google.auto.service.AutoService;
import com.google.auto.value.AutoValue;
import com.google.bigtable.v2.Cell;
import com.google.bigtable.v2.Column;
import com.google.bigtable.v2.Family;
import com.google.bigtable.v2.Row;
import com.google.protobuf.ByteString;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.beam.sdk.io.gcp.bigtable.AutoValue_BigtableReadSchemaTransformProvider_BigtableReadSchemaTransformConfiguration;
import org.apache.beam.sdk.io.gcp.bigtable.BigtableIO;
import org.apache.beam.sdk.schemas.AutoValueSchema;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.annotations.DefaultSchema;
import org.apache.beam.sdk.schemas.transforms.SchemaTransform;
import org.apache.beam.sdk.schemas.transforms.SchemaTransformProvider;
import org.apache.beam.sdk.schemas.transforms.TypedSchemaTransformProvider;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionRowTuple;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@AutoService(value={SchemaTransformProvider.class})
public class BigtableReadSchemaTransformProvider
extends TypedSchemaTransformProvider<BigtableReadSchemaTransformConfiguration> {
    private static final @UnknownKeyFor @NonNull @Initialized String OUTPUT_TAG = "output";
    public static final @UnknownKeyFor @NonNull @Initialized Schema CELL_SCHEMA = Schema.builder().addByteArrayField("value").addInt64Field("timestamp_micros").build();
    public static final @UnknownKeyFor @NonNull @Initialized Schema ROW_SCHEMA = Schema.builder().addByteArrayField("key").addMapField("column_families", Schema.FieldType.STRING, Schema.FieldType.map((Schema.FieldType)Schema.FieldType.STRING, (Schema.FieldType)Schema.FieldType.array((Schema.FieldType)Schema.FieldType.row((Schema)CELL_SCHEMA)))).build();
    public static final @UnknownKeyFor @NonNull @Initialized Schema FLATTENED_ROW_SCHEMA = Schema.builder().addByteArrayField("key").addStringField("family_name").addByteArrayField("column_qualifier").addArrayField("cells", Schema.FieldType.row((Schema)CELL_SCHEMA)).build();

    protected @UnknownKeyFor @NonNull @Initialized SchemaTransform from(@UnknownKeyFor @NonNull @Initialized BigtableReadSchemaTransformConfiguration configuration) {
        return new BigtableReadSchemaTransform(configuration);
    }

    public @UnknownKeyFor @NonNull @Initialized String identifier() {
        return "beam:schematransform:org.apache.beam:bigtable_read:v1";
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> outputCollectionNames() {
        return Collections.singletonList(OUTPUT_TAG);
    }

    private static class BigtableRowConverterDoFn
    extends DoFn<Row, org.apache.beam.sdk.values.Row> {
        private final @UnknownKeyFor @NonNull @Initialized BigtableReadSchemaTransformConfiguration configuration;

        BigtableRowConverterDoFn(@UnknownKeyFor @NonNull @Initialized BigtableReadSchemaTransformConfiguration configuration) {
            this.configuration = configuration;
        }

        private @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized org.apache.beam.sdk.values.Row> convertCells(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Cell> bigtableCells) {
            ArrayList<org.apache.beam.sdk.values.Row> beamCells = new ArrayList<org.apache.beam.sdk.values.Row>();
            for (Cell cell : bigtableCells) {
                org.apache.beam.sdk.values.Row cellRow = org.apache.beam.sdk.values.Row.withSchema((Schema)CELL_SCHEMA).withFieldValue("value", (Object)cell.getValue().toByteArray()).withFieldValue("timestamp_micros", (Object)cell.getTimestampMicros()).build();
                beamCells.add(cellRow);
            }
            return beamCells;
        }

        @DoFn.ProcessElement
        public void processElement(@DoFn.Element @UnknownKeyFor @NonNull @Initialized Row bigtableRow, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized org.apache.beam.sdk.values.Row> out) {
            if (Boolean.FALSE.equals(this.configuration.getFlatten())) {
                HashMap families = new HashMap();
                for (Family fam : bigtableRow.getFamiliesList()) {
                    HashMap<String, List<org.apache.beam.sdk.values.Row>> columns = new HashMap<String, List<org.apache.beam.sdk.values.Row>>();
                    for (Column col : fam.getColumnsList()) {
                        List bigTableCells = col.getCellsList();
                        List<org.apache.beam.sdk.values.Row> cells = this.convertCells(bigTableCells);
                        columns.put(col.getQualifier().toStringUtf8(), cells);
                    }
                    families.put(fam.getName(), columns);
                }
                org.apache.beam.sdk.values.Row beamRow = org.apache.beam.sdk.values.Row.withSchema((Schema)ROW_SCHEMA).withFieldValue("key", (Object)bigtableRow.getKey().toByteArray()).withFieldValue("column_families", families).build();
                out.output((Object)beamRow);
            } else {
                byte[] key = bigtableRow.getKey().toByteArray();
                for (Family fam : bigtableRow.getFamiliesList()) {
                    String familyName = fam.getName();
                    for (Column col : fam.getColumnsList()) {
                        ByteString qualifierName = col.getQualifier();
                        ArrayList<org.apache.beam.sdk.values.Row> cells = new ArrayList<org.apache.beam.sdk.values.Row>();
                        for (Cell cell : col.getCellsList()) {
                            org.apache.beam.sdk.values.Row cellRow = org.apache.beam.sdk.values.Row.withSchema((Schema)CELL_SCHEMA).withFieldValue("value", (Object)cell.getValue().toByteArray()).withFieldValue("timestamp_micros", (Object)cell.getTimestampMicros()).build();
                            cells.add(cellRow);
                        }
                        org.apache.beam.sdk.values.Row flattenedRow = org.apache.beam.sdk.values.Row.withSchema((Schema)FLATTENED_ROW_SCHEMA).withFieldValue("key", (Object)key).withFieldValue("family_name", (Object)familyName).withFieldValue("column_qualifier", (Object)qualifierName.toByteArray()).withFieldValue("cells", cells).build();
                        out.output((Object)flattenedRow);
                    }
                }
            }
        }
    }

    private static class BigtableReadSchemaTransform
    extends SchemaTransform {
        private final @UnknownKeyFor @NonNull @Initialized BigtableReadSchemaTransformConfiguration configuration;

        BigtableReadSchemaTransform(@UnknownKeyFor @NonNull @Initialized BigtableReadSchemaTransformConfiguration configuration) {
            configuration.validate();
            this.configuration = configuration;
        }

        public @UnknownKeyFor @NonNull @Initialized PCollectionRowTuple expand(@UnknownKeyFor @NonNull @Initialized PCollectionRowTuple input) {
            Preconditions.checkArgument((boolean)input.getAll().isEmpty(), (Object)String.format("Input to %s is expected to be empty, but is not.", ((Object)((Object)this)).getClass().getSimpleName()));
            PCollection bigtableRows = (PCollection)input.getPipeline().apply((PTransform)BigtableIO.read().withTableId(this.configuration.getTableId()).withInstanceId(this.configuration.getInstanceId()).withProjectId(this.configuration.getProjectId()));
            Schema outputSchema = Boolean.FALSE.equals(this.configuration.getFlatten()) ? ROW_SCHEMA : FLATTENED_ROW_SCHEMA;
            PCollection beamRows = ((PCollection)bigtableRows.apply("ConvertToBeamRows", (PTransform)ParDo.of((DoFn)new BigtableRowConverterDoFn(this.configuration)))).setRowSchema(outputSchema);
            return PCollectionRowTuple.of((String)BigtableReadSchemaTransformProvider.OUTPUT_TAG, (PCollection)beamRows);
        }
    }

    @DefaultSchema(value=AutoValueSchema.class)
    @AutoValue
    public static abstract class BigtableReadSchemaTransformConfiguration
    implements Serializable {
        public void validate() {
            String emptyStringMessage = "Invalid Bigtable Read configuration: %s should not be a non-empty String";
            Preconditions.checkArgument((!this.getTableId().isEmpty() ? 1 : 0) != 0, (Object)String.format(emptyStringMessage, "table"));
            Preconditions.checkArgument((!this.getInstanceId().isEmpty() ? 1 : 0) != 0, (Object)String.format(emptyStringMessage, "instance"));
            Preconditions.checkArgument((!this.getProjectId().isEmpty() ? 1 : 0) != 0, (Object)String.format(emptyStringMessage, "project"));
        }

        public static @UnknownKeyFor @NonNull @Initialized Builder builder() {
            return new AutoValue_BigtableReadSchemaTransformProvider_BigtableReadSchemaTransformConfiguration.Builder().setFlatten(true);
        }

        public abstract @UnknownKeyFor @NonNull @Initialized String getTableId();

        public abstract @UnknownKeyFor @NonNull @Initialized String getInstanceId();

        public abstract @UnknownKeyFor @NonNull @Initialized String getProjectId();

        public abstract @Nullable @UnknownKeyFor @Initialized Boolean getFlatten();

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract @UnknownKeyFor @NonNull @Initialized Builder setTableId(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setInstanceId(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setProjectId(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setFlatten(@UnknownKeyFor @NonNull @Initialized Boolean var1);

            public abstract @UnknownKeyFor @NonNull @Initialized BigtableReadSchemaTransformConfiguration build();
        }
    }
}

