/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.TableRow;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryRowWriter;
import org.apache.beam.sdk.io.gcp.bigquery.TableRowJsonCoder;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

class TableRowWriter<@UnknownKeyFor T>
extends BigQueryRowWriter<T> {
    private static final @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized TableRow> CODER = TableRowJsonCoder.of();
    private static final @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] NEWLINE = "\n".getBytes(StandardCharsets.UTF_8);
    private final @UnknownKeyFor @NonNull @Initialized SerializableFunction<T, @UnknownKeyFor @NonNull @Initialized TableRow> toRow;

    TableRowWriter(@UnknownKeyFor @NonNull @Initialized String basename, @UnknownKeyFor @NonNull @Initialized SerializableFunction<T, @UnknownKeyFor @NonNull @Initialized TableRow> toRow) throws @UnknownKeyFor @NonNull @Initialized Exception {
        super(basename, "text/plain");
        this.toRow = toRow;
    }

    @Override
    void write(T value) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized BigQueryRowWriter.BigQueryRowSerializationException {
        TableRow tableRow;
        try {
            tableRow = (TableRow)this.toRow.apply(value);
        }
        catch (Exception e) {
            throw new BigQueryRowWriter.BigQueryRowSerializationException(e);
        }
        CODER.encode((Object)tableRow, this.getOutputStream(), Coder.Context.OUTER);
        this.getOutputStream().write(NEWLINE);
    }
}

