/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction;

import java.util.function.Supplier;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;

public class RestrictionInterrupter<@UnknownKeyFor T> {
    private @Nullable T lastAttemptedPosition;
    private @UnknownKeyFor @NonNull @Initialized Supplier<@UnknownKeyFor @NonNull @Initialized Instant> timeSupplier;
    private final @UnknownKeyFor @NonNull @Initialized Instant softDeadline;
    private @UnknownKeyFor @NonNull @Initialized boolean hasInterrupted = true;

    public static <T> @UnknownKeyFor @NonNull @Initialized RestrictionInterrupter<T> withSoftTimeout(@UnknownKeyFor @NonNull @Initialized Duration timeout) {
        return new RestrictionInterrupter<T>(() -> Instant.now(), timeout);
    }

    RestrictionInterrupter(@UnknownKeyFor @NonNull @Initialized Supplier<@UnknownKeyFor @NonNull @Initialized Instant> timeSupplier, @UnknownKeyFor @NonNull @Initialized Duration timeout) {
        this.timeSupplier = timeSupplier;
        this.softDeadline = this.timeSupplier.get().plus((ReadableDuration)timeout);
        this.hasInterrupted = false;
    }

    @VisibleForTesting
    void setTimeSupplier(@UnknownKeyFor @NonNull @Initialized Supplier<@UnknownKeyFor @NonNull @Initialized Instant> timeSupplier) {
        this.timeSupplier = timeSupplier;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean tryInterrupt(@NonNull T position) {
        if (this.hasInterrupted) {
            return true;
        }
        if (this.lastAttemptedPosition == null) {
            this.lastAttemptedPosition = position;
            return false;
        }
        if (position.equals(this.lastAttemptedPosition)) {
            return false;
        }
        this.lastAttemptedPosition = position;
        this.hasInterrupted |= this.timeSupplier.get().isAfter((ReadableInstant)this.softDeadline);
        return this.hasInterrupted;
    }
}

