/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner;

import com.google.auto.service.AutoService;
import com.google.auto.value.AutoValue;
import com.google.cloud.spanner.Struct;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.beam.sdk.io.gcp.spanner.AutoValue_SpannerReadSchemaTransformProvider_SpannerReadSchemaTransformConfiguration;
import org.apache.beam.sdk.io.gcp.spanner.SpannerIO;
import org.apache.beam.sdk.io.gcp.spanner.StructUtils;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.Metrics;
import org.apache.beam.sdk.schemas.AutoValueSchema;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.annotations.DefaultSchema;
import org.apache.beam.sdk.schemas.annotations.SchemaFieldDescription;
import org.apache.beam.sdk.schemas.transforms.SchemaTransform;
import org.apache.beam.sdk.schemas.transforms.SchemaTransformProvider;
import org.apache.beam.sdk.schemas.transforms.TypedSchemaTransformProvider;
import org.apache.beam.sdk.schemas.transforms.providers.ErrorHandling;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionRowTuple;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TupleTagList;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Strings;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@AutoService(value={SchemaTransformProvider.class})
public class SpannerReadSchemaTransformProvider
extends TypedSchemaTransformProvider<SpannerReadSchemaTransformConfiguration> {
    public static final @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized Row> OUTPUT_TAG = new TupleTag<Row>(){};
    public static final @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized Row> ERROR_TAG = new TupleTag<Row>(){};
    public static final @UnknownKeyFor @NonNull @Initialized Schema ERROR_SCHEMA = Schema.builder().addStringField("error").addStringField("row").build();

    public @UnknownKeyFor @NonNull @Initialized String identifier() {
        return "beam:schematransform:org.apache.beam:spanner_read:v1";
    }

    public @UnknownKeyFor @NonNull @Initialized String description() {
        return "Performs a Bulk read from Google Cloud Spanner using a specified SQL query or by directly accessing a single table and its columns.\n\nBoth Query and Read APIs are supported. See more information about <a href=\"https://cloud.google.com/spanner/docs/reads\">reading from Cloud Spanner</a>.\n\nExample configuration for performing a read using a SQL query: ::\n\n    - type: ReadFromSpanner\n      config:\n        instance_id: 'my-instance-id'\n        database_id: 'my-database'\n        query: 'SELECT * FROM table'\n\nIt is also possible to read a table by specifying a table name and a list of columns. For example, the following configuration will perform a read on an entire table: ::\n\n    - type: ReadFromSpanner\n      config:\n        instance_id: 'my-instance-id'\n        database_id: 'my-database'\n        table: 'my-table'\n        columns: ['col1', 'col2']\n\nAdditionally, to read using a <a href=\"https://cloud.google.com/spanner/docs/secondary-indexes\">Secondary Index</a>, specify the index name: ::\n    - type: ReadFromSpanner\n      config:\n        instance_id: 'my-instance-id'\n        database_id: 'my-database'\n        table: 'my-table'\n        index: 'my-index'\n        columns: ['col1', 'col2']\n\n#### Advanced Usage\n\nReads by default use the <a href=\"https://cloud.google.com/spanner/docs/reads#read_data_in_parallel\">PartitionQuery API</a> which enforces some limitations on the type of queries that can be used so that the data can be read in parallel. If the query is not supported by the PartitionQuery API, then you can specify a non-partitioned read by setting batching to false.\n\nFor example: ::\n    - type: ReadFromSpanner\n      config:\n        batching: false\n        ...\n\nNote: See <a href=\"https://beam.apache.org/releases/javadoc/current/org/apache/beam/sdk/io/gcp/spanner/SpannerIO.html\">SpannerIO</a> for more advanced information.";
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> inputCollectionNames() {
        return Collections.emptyList();
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> outputCollectionNames() {
        return Arrays.asList("output", "errors");
    }

    protected @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized SpannerReadSchemaTransformConfiguration> configurationClass() {
        return SpannerReadSchemaTransformConfiguration.class;
    }

    protected @UnknownKeyFor @NonNull @Initialized SchemaTransform from(@UnknownKeyFor @NonNull @Initialized SpannerReadSchemaTransformConfiguration configuration) {
        return new SpannerSchemaTransformRead(configuration);
    }

    @DefaultSchema(value=AutoValueSchema.class)
    @AutoValue
    public static abstract class SpannerReadSchemaTransformConfiguration
    implements Serializable {
        public void validate() {
            String invalidConfigMessage = "Invalid Cloud Spanner Read configuration: ";
            org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((!Strings.isNullOrEmpty((String)this.getInstanceId()) ? 1 : 0) != 0, (Object)(invalidConfigMessage + "Instance ID must be specified."));
            org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((!Strings.isNullOrEmpty((String)this.getDatabaseId()) ? 1 : 0) != 0, (Object)(invalidConfigMessage + "Database ID must be specified."));
            if (Strings.isNullOrEmpty((String)this.getQuery())) {
                org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((!Strings.isNullOrEmpty((String)this.getTableId()) ? 1 : 0) != 0, (Object)(invalidConfigMessage + "Table name must be specified for table read."));
                org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((this.getColumns() != null && !this.getColumns().isEmpty() ? 1 : 0) != 0, (Object)(invalidConfigMessage + "Columns must be specified for table read."));
            } else {
                org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((!Strings.isNullOrEmpty((String)this.getQuery()) ? 1 : 0) != 0, (Object)(invalidConfigMessage + "Query must be specified for query read."));
                org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((boolean)Strings.isNullOrEmpty((String)this.getTableId()), (Object)(invalidConfigMessage + "Table name should not be specified when using a query."));
                org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((this.getColumns() == null || this.getColumns().isEmpty() ? 1 : 0) != 0, (Object)(invalidConfigMessage + "Columns should not be specified when using a query."));
            }
        }

        public static @UnknownKeyFor @Nullable @Initialized Builder builder() {
            return new AutoValue_SpannerReadSchemaTransformProvider_SpannerReadSchemaTransformConfiguration.Builder();
        }

        @SchemaFieldDescription(value="Specifies the Cloud Spanner instance.")
        public abstract @UnknownKeyFor @NonNull @Initialized String getInstanceId();

        @SchemaFieldDescription(value="Specifies the Cloud Spanner database.")
        public abstract @UnknownKeyFor @NonNull @Initialized String getDatabaseId();

        @SchemaFieldDescription(value="Specifies the GCP project ID.")
        @javax.annotation.Nullable
        public abstract @UnknownKeyFor @Nullable @Initialized String getProjectId();

        @SchemaFieldDescription(value="Specifies the Cloud Spanner table.")
        @javax.annotation.Nullable
        public abstract @UnknownKeyFor @Nullable @Initialized String getTableId();

        @SchemaFieldDescription(value="Specifies the SQL query to execute.")
        @javax.annotation.Nullable
        public abstract @UnknownKeyFor @Nullable @Initialized String getQuery();

        @SchemaFieldDescription(value="Specifies the columns to read from the table. This parameter is required when table is specified.")
        @javax.annotation.Nullable
        public abstract @UnknownKeyFor @Nullable @Initialized List<@UnknownKeyFor @NonNull @Initialized String> getColumns();

        @SchemaFieldDescription(value="Specifies the Index to read from. This parameter can only be specified when using table.")
        @javax.annotation.Nullable
        public abstract @UnknownKeyFor @Nullable @Initialized String getIndex();

        @SchemaFieldDescription(value="Set to false to disable batching. Useful when using a query that is not compatible with the PartitionQuery API. Defaults to true.")
        @javax.annotation.Nullable
        public abstract @UnknownKeyFor @Nullable @Initialized Boolean getBatching();

        @SchemaFieldDescription(value="This option specifies whether and where to output unwritable rows.")
        @javax.annotation.Nullable
        public abstract @UnknownKeyFor @Nullable @Initialized ErrorHandling getErrorHandling();

        @javax.annotation.Nullable
        @AutoValue.Builder
        public static abstract class Builder {
            public abstract @UnknownKeyFor @Nullable @Initialized Builder setProjectId(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @Nullable @Initialized Builder setInstanceId(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @Nullable @Initialized Builder setDatabaseId(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @Nullable @Initialized Builder setTableId(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @Nullable @Initialized Builder setQuery(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @Nullable @Initialized Builder setColumns(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> var1);

            public abstract @UnknownKeyFor @Nullable @Initialized Builder setIndex(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @Nullable @Initialized Builder setBatching(@UnknownKeyFor @NonNull @Initialized Boolean var1);

            public abstract @UnknownKeyFor @Nullable @Initialized Builder setErrorHandling(@UnknownKeyFor @NonNull @Initialized ErrorHandling var1);

            public abstract @UnknownKeyFor @NonNull @Initialized SpannerReadSchemaTransformConfiguration build();
        }
    }

    public static class ErrorFn
    extends DoFn<Struct, Row> {
        private final @UnknownKeyFor @NonNull @Initialized Counter errorCounter;
        private @UnknownKeyFor @NonNull @Initialized Long errorsInBundle = 0L;
        private final @UnknownKeyFor @NonNull @Initialized boolean handleErrors;
        private final @UnknownKeyFor @NonNull @Initialized Schema errorSchema;
        private final @UnknownKeyFor @NonNull @Initialized Schema schema;

        public ErrorFn(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized Schema errorSchema, @UnknownKeyFor @NonNull @Initialized Schema schema, @UnknownKeyFor @NonNull @Initialized boolean handleErrors) {
            this.errorCounter = Metrics.counter(SpannerReadSchemaTransformProvider.class, (String)name);
            this.handleErrors = handleErrors;
            this.errorSchema = errorSchema;
            this.schema = schema;
        }

        @DoFn.ProcessElement
        public void processElement(@DoFn.Element @UnknownKeyFor @NonNull @Initialized Struct struct, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DoFn.MultiOutputReceiver receiver) {
            Row mappedRow = null;
            try {
                mappedRow = StructUtils.structToBeamRow(struct, this.schema);
            }
            catch (Exception e) {
                if (!this.handleErrors) {
                    throw new RuntimeException(e);
                }
                this.errorsInBundle = this.errorsInBundle + 1L;
                receiver.get(ERROR_TAG).output((Object)Row.withSchema((Schema)this.errorSchema).addValues(new Object[]{e.getMessage(), struct.toString()}).build());
            }
            if (mappedRow != null) {
                receiver.get(OUTPUT_TAG).output((Object)mappedRow);
            }
        }

        @DoFn.FinishBundle
        public void finish(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized FinishBundleContext c) {
            this.errorCounter.inc(this.errorsInBundle.longValue());
            this.errorsInBundle = 0L;
        }
    }

    static class SpannerSchemaTransformRead
    extends SchemaTransform
    implements Serializable {
        private final @UnknownKeyFor @NonNull @Initialized SpannerReadSchemaTransformConfiguration configuration;

        SpannerSchemaTransformRead(@UnknownKeyFor @NonNull @Initialized SpannerReadSchemaTransformConfiguration configuration) {
            configuration.validate();
            this.configuration = configuration;
        }

        public @UnknownKeyFor @NonNull @Initialized PCollectionRowTuple expand(@UnknownKeyFor @NonNull @Initialized PCollectionRowTuple input) {
            org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkNotNull((Object)input, (Object)"Input to SpannerReadSchemaTransform cannot be null.");
            boolean handleErrors = ErrorHandling.hasOutput((ErrorHandling)this.configuration.getErrorHandling());
            SpannerIO.Read read = SpannerIO.readWithSchema().withProjectId(this.configuration.getProjectId()).withInstanceId(this.configuration.getInstanceId()).withDatabaseId(this.configuration.getDatabaseId());
            read = !Strings.isNullOrEmpty((String)this.configuration.getQuery()) ? read.withQuery(this.configuration.getQuery()) : read.withTable(this.configuration.getTableId()).withColumns(this.configuration.getColumns());
            if (!Strings.isNullOrEmpty((String)this.configuration.getIndex())) {
                read = read.withIndex(this.configuration.getIndex());
            }
            if (Boolean.FALSE.equals(this.configuration.getBatching())) {
                read = read.withBatching(false);
            }
            PCollection spannerRows = (PCollection)input.getPipeline().apply((PTransform)read);
            Schema schema = spannerRows.getSchema();
            PCollectionTuple outputTuple = (PCollectionTuple)spannerRows.apply((PTransform)ParDo.of((DoFn)new ErrorFn("spanner-read-error-counter", ERROR_SCHEMA, schema, handleErrors)).withOutputTags(OUTPUT_TAG, TupleTagList.of(ERROR_TAG)));
            PCollectionRowTuple outputRows = PCollectionRowTuple.of((String)"output", (PCollection)outputTuple.get(OUTPUT_TAG).setRowSchema(schema));
            PCollection errorOutput = outputTuple.get(ERROR_TAG).setRowSchema(ERROR_SCHEMA);
            if (handleErrors) {
                outputRows = outputRows.and(((ErrorHandling)Preconditions.checkArgumentNotNull((Object)this.configuration.getErrorHandling())).getOutput(), errorOutput);
            }
            return outputRows;
        }
    }
}

