/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery.providers;

import com.google.auto.value.AutoValue;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.io.gcp.bigquery.providers.AutoValue_BigQueryWriteConfiguration;
import org.apache.beam.sdk.io.gcp.bigquery.providers.AutoValue_BigQueryWriteConfiguration_ErrorHandling;
import org.apache.beam.sdk.schemas.AutoValueSchema;
import org.apache.beam.sdk.schemas.annotations.DefaultSchema;
import org.apache.beam.sdk.schemas.annotations.SchemaFieldDescription;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Strings;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@DefaultSchema(value=AutoValueSchema.class)
@AutoValue
public abstract class BigQueryWriteConfiguration {
    protected static final @UnknownKeyFor @NonNull @Initialized String DYNAMIC_DESTINATIONS = "DYNAMIC_DESTINATIONS";

    public void validate() {
        ErrorHandling errorHandling;
        String writeDisposition;
        String invalidConfigMessage = "Invalid BigQuery Storage Write configuration: ";
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)this.getTable()) ? 1 : 0) != 0, (Object)(invalidConfigMessage + "Table spec for a BigQuery Write must be specified."));
        String createDisposition = this.getCreateDisposition();
        if (createDisposition != null && !createDisposition.isEmpty()) {
            List createDispositions = Arrays.stream(BigQueryIO.Write.CreateDisposition.values()).map(c -> c.name()).collect(Collectors.toList());
            Preconditions.checkArgument((boolean)createDispositions.contains(createDisposition.toUpperCase()), (String)"Invalid create disposition (%s) was specified. Available dispositions are: %s", (Object)createDisposition, createDispositions);
        }
        if ((writeDisposition = this.getWriteDisposition()) != null && !writeDisposition.isEmpty()) {
            List writeDispostions = Arrays.stream(BigQueryIO.Write.WriteDisposition.values()).map(w -> w.name()).collect(Collectors.toList());
            Preconditions.checkArgument((boolean)writeDispostions.contains(writeDisposition.toUpperCase()), (String)"Invalid write disposition (%s) was specified. Available dispositions are: %s", (Object)writeDisposition, writeDispostions);
        }
        if ((errorHandling = this.getErrorHandling()) != null) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)errorHandling.getOutput()) ? 1 : 0) != 0, (Object)(invalidConfigMessage + "Output must not be empty if error handling specified."));
        }
        Boolean autoSharding = this.getAutoSharding();
        Integer numStreams = this.getNumStreams();
        if (autoSharding != null && autoSharding.booleanValue() && numStreams != null) {
            Preconditions.checkArgument((numStreams == 0 ? 1 : 0) != 0, (Object)(invalidConfigMessage + "Cannot set a fixed number of streams when auto-sharding is enabled. Please pick only one of the two options."));
        }
    }

    public static @UnknownKeyFor @NonNull @Initialized Builder builder() {
        return new AutoValue_BigQueryWriteConfiguration.Builder();
    }

    @SchemaFieldDescription(value="The bigquery table to write to. Format: [${PROJECT}:]${DATASET}.${TABLE}")
    public abstract @UnknownKeyFor @NonNull @Initialized String getTable();

    @SchemaFieldDescription(value="Optional field that specifies whether the job is allowed to create new tables. The following values are supported: CREATE_IF_NEEDED (the job may create the table), CREATE_NEVER (the job must fail if the table does not exist already).")
    public abstract @Nullable @UnknownKeyFor @Initialized String getCreateDisposition();

    @SchemaFieldDescription(value="Specifies the action that occurs if the destination table already exists. The following values are supported: WRITE_TRUNCATE (overwrites the table data), WRITE_APPEND (append the data to the table), WRITE_EMPTY (job must fail if the table is not empty).")
    public abstract @Nullable @UnknownKeyFor @Initialized String getWriteDisposition();

    @SchemaFieldDescription(value="Determines how often to 'commit' progress into BigQuery. Default is every 5 seconds.")
    public abstract @Nullable @UnknownKeyFor @Initialized Long getTriggeringFrequencySeconds();

    @SchemaFieldDescription(value="This option enables lower latency for insertions to BigQuery but may ocassionally duplicate data elements.")
    public abstract @Nullable @UnknownKeyFor @Initialized Boolean getUseAtLeastOnceSemantics();

    @SchemaFieldDescription(value="This option enables using a dynamically determined number of Storage Write API streams to write to BigQuery. Only applicable to unbounded data.")
    public abstract @Nullable @UnknownKeyFor @Initialized Boolean getAutoSharding();

    @SchemaFieldDescription(value="Specifies the number of write streams that the Storage API sink will use. This parameter is only applicable when writing unbounded data.")
    public abstract @Nullable @UnknownKeyFor @Initialized Integer getNumStreams();

    @SchemaFieldDescription(value="Use this Cloud KMS key to encrypt your data")
    public abstract @Nullable @UnknownKeyFor @Initialized String getKmsKey();

    @SchemaFieldDescription(value="This option specifies whether and where to output unwritable rows.")
    public abstract @Nullable @UnknownKeyFor @Initialized ErrorHandling getErrorHandling();

    @SchemaFieldDescription(value="This option enables the use of BigQuery CDC functionality. The expected PCollection should contain Beam Rows with a schema wrapping the record to be inserted and adding the CDC info similar to: {row_mutation_info: {mutation_type:\"...\", change_sequence_number:\"...\"}, record: {...}}")
    public abstract @Nullable @UnknownKeyFor @Initialized Boolean getUseCdcWrites();

    @SchemaFieldDescription(value="If CREATE_IF_NEEDED disposition is set, BigQuery table(s) will be created with this columns as primary key. Required when CDC writes are enabled with CREATE_IF_NEEDED.")
    public abstract @Nullable @UnknownKeyFor @Initialized List<@UnknownKeyFor @NonNull @Initialized String> getPrimaryKey();

    @SchemaFieldDescription(value="A list of field names to keep in the input record. All other fields are dropped before writing. Is mutually exclusive with 'drop' and 'only'.")
    public abstract @Nullable @UnknownKeyFor @Initialized List<@UnknownKeyFor @NonNull @Initialized String> getKeep();

    @SchemaFieldDescription(value="A list of field names to drop from the input record before writing. Is mutually exclusive with 'keep' and 'only'.")
    public abstract @Nullable @UnknownKeyFor @Initialized List<@UnknownKeyFor @NonNull @Initialized String> getDrop();

    @SchemaFieldDescription(value="The name of a single record field that should be written. Is mutually exclusive with 'keep' and 'drop'.")
    public abstract @Nullable @UnknownKeyFor @Initialized String getOnly();

    @SchemaFieldDescription(value="A list of columns to cluster the BigQuery table by.")
    public abstract @Nullable @UnknownKeyFor @Initialized List<@UnknownKeyFor @NonNull @Initialized String> getClusteringFields();

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract @UnknownKeyFor @NonNull @Initialized Builder setTable(@UnknownKeyFor @NonNull @Initialized String var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setCreateDisposition(@UnknownKeyFor @NonNull @Initialized String var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setWriteDisposition(@UnknownKeyFor @NonNull @Initialized String var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setTriggeringFrequencySeconds(@UnknownKeyFor @NonNull @Initialized Long var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setUseAtLeastOnceSemantics(@UnknownKeyFor @NonNull @Initialized Boolean var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setAutoSharding(@UnknownKeyFor @NonNull @Initialized Boolean var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setNumStreams(@UnknownKeyFor @NonNull @Initialized Integer var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setKmsKey(@UnknownKeyFor @NonNull @Initialized String var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setErrorHandling(@UnknownKeyFor @NonNull @Initialized ErrorHandling var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setUseCdcWrites(@UnknownKeyFor @NonNull @Initialized Boolean var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setPrimaryKey(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setKeep(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setDrop(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setOnly(@UnknownKeyFor @NonNull @Initialized String var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setClusteringFields(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> var1);

        public abstract @UnknownKeyFor @NonNull @Initialized BigQueryWriteConfiguration build();
    }

    @AutoValue
    public static abstract class ErrorHandling {
        @SchemaFieldDescription(value="The name of the output PCollection containing failed writes.")
        public abstract @UnknownKeyFor @NonNull @Initialized String getOutput();

        public static @UnknownKeyFor @NonNull @Initialized Builder builder() {
            return new AutoValue_BigQueryWriteConfiguration_ErrorHandling.Builder();
        }

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract @UnknownKeyFor @NonNull @Initialized Builder setOutput(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized ErrorHandling build();
        }
    }
}

