/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner.changestreams.action;

import com.google.cloud.Timestamp;
import java.util.Optional;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.estimator.ThroughputEstimator;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.model.DataChangeRecord;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.model.PartitionMetadata;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction.RestrictionInterrupter;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction.TimestampRange;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.splittabledofn.ManualWatermarkEstimator;
import org.apache.beam.sdk.transforms.splittabledofn.RestrictionTracker;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataChangeRecordAction {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(DataChangeRecordAction.class);
    private final @UnknownKeyFor @NonNull @Initialized ThroughputEstimator<@UnknownKeyFor @NonNull @Initialized DataChangeRecord> throughputEstimator;

    public DataChangeRecordAction(@UnknownKeyFor @NonNull @Initialized ThroughputEstimator<@UnknownKeyFor @NonNull @Initialized DataChangeRecord> throughputEstimator) {
        this.throughputEstimator = throughputEstimator;
    }

    @VisibleForTesting
    public @UnknownKeyFor @NonNull @Initialized Optional<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized DoFn.ProcessContinuation> run(@UnknownKeyFor @NonNull @Initialized PartitionMetadata partition, @UnknownKeyFor @NonNull @Initialized DataChangeRecord record, @UnknownKeyFor @NonNull @Initialized RestrictionTracker<@UnknownKeyFor @NonNull @Initialized TimestampRange, @UnknownKeyFor @NonNull @Initialized Timestamp> tracker, @UnknownKeyFor @NonNull @Initialized RestrictionInterrupter<@UnknownKeyFor @NonNull @Initialized Timestamp> interrupter, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized DataChangeRecord> outputReceiver, @UnknownKeyFor @NonNull @Initialized ManualWatermarkEstimator<@UnknownKeyFor @NonNull @Initialized Instant> watermarkEstimator) {
        String token = partition.getPartitionToken();
        LOG.debug("[{}] Processing data record {}", (Object)token, (Object)record.getCommitTimestamp());
        Timestamp commitTimestamp = record.getCommitTimestamp();
        Instant commitInstant = new Instant(commitTimestamp.toSqlTimestamp().getTime());
        if (interrupter.tryInterrupt(commitTimestamp)) {
            LOG.debug("[{}] Soft deadline reached with data change record at {}, rescheduling", (Object)token, (Object)commitTimestamp);
            return Optional.of(DoFn.ProcessContinuation.resume());
        }
        if (!tracker.tryClaim((Object)commitTimestamp)) {
            LOG.debug("[{}] Could not claim queryChangeStream({}), stopping", (Object)token, (Object)commitTimestamp);
            return Optional.of(DoFn.ProcessContinuation.stop());
        }
        outputReceiver.outputWithTimestamp((Object)record, commitInstant);
        watermarkEstimator.setWatermark(commitInstant);
        this.throughputEstimator.update(Timestamp.now(), record);
        LOG.debug("[{}] Data record action completed successfully", (Object)token);
        return Optional.empty();
    }
}

