/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsublite;

import com.google.auto.service.AutoService;
import com.google.auto.value.AutoValue;
import com.google.cloud.pubsublite.CloudRegionOrZone;
import com.google.cloud.pubsublite.ProjectId;
import com.google.cloud.pubsublite.SubscriptionName;
import com.google.cloud.pubsublite.SubscriptionPath;
import com.google.cloud.pubsublite.proto.AttributeValues;
import com.google.cloud.pubsublite.proto.PubSubMessage;
import com.google.cloud.pubsublite.proto.SequencedMessage;
import com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.avro.Schema;
import org.apache.beam.sdk.extensions.avro.schemas.utils.AvroUtils;
import org.apache.beam.sdk.extensions.gcp.options.GcpOptions;
import org.apache.beam.sdk.extensions.protobuf.ProtoByteUtils;
import org.apache.beam.sdk.io.gcp.pubsublite.AutoValue_PubsubLiteReadSchemaTransformProvider_PubsubLiteReadSchemaTransformConfiguration;
import org.apache.beam.sdk.io.gcp.pubsublite.PubsubLiteIO;
import org.apache.beam.sdk.io.gcp.pubsublite.SubscriberOptions;
import org.apache.beam.sdk.io.gcp.pubsublite.UuidDeduplicationOptions;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.Uuid;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.Metrics;
import org.apache.beam.sdk.schemas.AutoValueSchema;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.annotations.DefaultSchema;
import org.apache.beam.sdk.schemas.annotations.SchemaFieldDescription;
import org.apache.beam.sdk.schemas.transforms.SchemaTransform;
import org.apache.beam.sdk.schemas.transforms.SchemaTransformProvider;
import org.apache.beam.sdk.schemas.transforms.TypedSchemaTransformProvider;
import org.apache.beam.sdk.schemas.transforms.providers.ErrorHandling;
import org.apache.beam.sdk.schemas.utils.JsonUtils;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionRowTuple;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TupleTagList;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Strings;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Sets;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={SchemaTransformProvider.class})
public class PubsubLiteReadSchemaTransformProvider
extends TypedSchemaTransformProvider<PubsubLiteReadSchemaTransformConfiguration> {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(PubsubLiteReadSchemaTransformProvider.class);
    public static final @UnknownKeyFor @NonNull @Initialized String VALID_FORMATS_STR = "RAW,AVRO,JSON,PROTO";
    public static final @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> VALID_DATA_FORMATS = Sets.newHashSet((Object[])"RAW,AVRO,JSON,PROTO".split(","));
    public static final @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized Row> OUTPUT_TAG = new TupleTag<Row>(){};
    public static final @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized Row> ERROR_TAG = new TupleTag<Row>(){};

    protected @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized PubsubLiteReadSchemaTransformConfiguration> configurationClass() {
        return PubsubLiteReadSchemaTransformConfiguration.class;
    }

    public @UnknownKeyFor @NonNull @Initialized String description() {
        return "Performs a read from Google Pub/Sub Lite.\n\n**Note**: This provider is deprecated. See Pub/Sub Lite <a href=\"https://cloud.google.com/pubsub/lite/docs\">documentation</a> for more information.";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public @UnknownKeyFor @NonNull @Initialized SchemaTransform from(final @UnknownKeyFor @NonNull @Initialized PubsubLiteReadSchemaTransformConfiguration configuration) {
        SimpleFunction valueMapper;
        Schema beamSchema;
        if (!VALID_DATA_FORMATS.contains(configuration.getFormat())) {
            throw new IllegalArgumentException(String.format("Format %s not supported. Only supported formats are %s", configuration.getFormat(), VALID_FORMATS_STR));
        }
        boolean handleErrors = ErrorHandling.hasOutput((ErrorHandling)configuration.getErrorHandling());
        String format = configuration.getFormat();
        String inputSchema = configuration.getSchema();
        final List<String> attributes = configuration.getAttributes();
        if (format != null && format.equals("RAW")) {
            beamSchema = Schema.builder().addField("payload", Schema.FieldType.BYTES).build();
            valueMapper = PubsubLiteReadSchemaTransformProvider.getRawBytesToRowFunction(beamSchema);
            return new SchemaTransform((SerializableFunction)valueMapper, handleErrors){
                final /* synthetic */ SerializableFunction val$valueMapper;
                final /* synthetic */ boolean val$handleErrors;
                {
                    this.val$valueMapper = serializableFunction;
                    this.val$handleErrors = bl;
                }

                public @UnknownKeyFor @NonNull @Initialized PCollectionRowTuple expand(@UnknownKeyFor @NonNull @Initialized PCollectionRowTuple input) {
                    PCollection transformSequencedMessage;
                    String attributeMapValue;
                    String project = configuration.getProject();
                    if (Strings.isNullOrEmpty((String)project)) {
                        project = ((GcpOptions)input.getPipeline().getOptions().as(GcpOptions.class)).getProject();
                    }
                    if (project == null) {
                        throw new IllegalArgumentException("Unable to infer the project to read from Pubsub Lite. Please provide a project.");
                    }
                    Schema errorSchema = ErrorHandling.errorSchemaBytes();
                    ArrayList<String> attributeList = new ArrayList();
                    if (attributes != null) {
                        attributeList = attributes;
                    }
                    String attributeMap = (attributeMapValue = configuration.getAttributeMap()) == null ? "" : attributeMapValue;
                    Schema resultingBeamSchema = PubsubLiteReadSchemaTransformProvider.buildSchemaWithAttributes(beamSchema, attributeList, attributeMap);
                    PCollection readPubsubLite = (PCollection)input.getPipeline().apply(PubsubLiteIO.read(SubscriberOptions.newBuilder().setSubscriptionPath(((SubscriptionPath.Builder)((SubscriptionPath.Builder)SubscriptionPath.newBuilder().setLocation(CloudRegionOrZone.parse((String)configuration.getLocation()))).setProject(ProjectId.of((String)project))).setName(SubscriptionName.of((String)configuration.getSubscriptionName())).build()).build()));
                    String attributeId = configuration.getAttributeId();
                    if (attributeId != null && !attributeId.isEmpty()) {
                        UuidDeduplicationOptions.Builder uuidExtractor = UuidDeduplicationOptions.newBuilder().setUuidExtractor(PubsubLiteReadSchemaTransformProvider.getUuidFromMessage(attributeId));
                        transformSequencedMessage = (PCollection)readPubsubLite.apply(PubsubLiteIO.deduplicate(uuidExtractor.build()));
                    } else {
                        transformSequencedMessage = readPubsubLite;
                    }
                    PCollectionTuple outputTuple = (PCollectionTuple)transformSequencedMessage.apply((PTransform)ParDo.of((DoFn)new ErrorFn("PubsubLite-read-error-counter", (SerializableFunction<byte[], Row>)this.val$valueMapper, errorSchema, attributeList, attributeMap, resultingBeamSchema, this.val$handleErrors)).withOutputTags(OUTPUT_TAG, TupleTagList.of(ERROR_TAG)));
                    return PCollectionRowTuple.of((String)"output", (PCollection)outputTuple.get(OUTPUT_TAG).setRowSchema(resultingBeamSchema), (String)"errors", (PCollection)outputTuple.get(ERROR_TAG).setRowSchema(errorSchema));
                }
            };
        } else if (format != null && format.equals("PROTO")) {
            String fileDescriptorPath = configuration.getFileDescriptorPath();
            String messageName = configuration.getMessageName();
            if (fileDescriptorPath != null && messageName != null) {
                beamSchema = ProtoByteUtils.getBeamSchemaFromProto((String)fileDescriptorPath, (String)messageName);
                valueMapper = ProtoByteUtils.getProtoBytesToRowFunction((String)fileDescriptorPath, (String)messageName);
                return new /* invalid duplicate definition of identical inner class */;
            } else {
                if (inputSchema == null || messageName == null) throw new IllegalArgumentException("To read from PubSubLite in PROTO format, either descriptorPath or schema must be provided.");
                beamSchema = ProtoByteUtils.getBeamSchemaFromProtoSchema((String)inputSchema, (String)messageName);
                valueMapper = ProtoByteUtils.getProtoBytesToRowFromSchemaFunction((String)inputSchema, (String)messageName);
            }
            return new /* invalid duplicate definition of identical inner class */;
        } else {
            if (inputSchema == null) throw new IllegalArgumentException("To read from Pubsub Lite in JSON or AVRO format, you must provide a schema.");
            beamSchema = Objects.equals(configuration.getFormat(), "JSON") ? JsonUtils.beamSchemaFromJsonSchema((String)inputSchema) : AvroUtils.toBeamSchema((org.apache.avro.Schema)new Schema.Parser().parse(inputSchema));
            valueMapper = Objects.equals(configuration.getFormat(), "JSON") ? JsonUtils.getJsonBytesToRowFunction((Schema)beamSchema) : AvroUtils.getAvroBytesToRowFunction((Schema)beamSchema);
        }
        return new /* invalid duplicate definition of identical inner class */;
    }

    public static @UnknownKeyFor @NonNull @Initialized Schema buildSchemaWithAttributes(@UnknownKeyFor @NonNull @Initialized Schema schema, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> attributes, @UnknownKeyFor @NonNull @Initialized String attributesMap) {
        Schema.Builder schemaBuilder = Schema.builder();
        schema.getFields().forEach(field -> schemaBuilder.addField(field.getName(), field.getType()));
        attributes.forEach(attribute -> {
            if (attribute == null || attribute.isEmpty()) {
                throw new IllegalArgumentException("Attribute names in the attributes list must not be null or empty.");
            }
            schemaBuilder.addField(attribute, Schema.FieldType.STRING);
        });
        if (!attributesMap.isEmpty()) {
            schemaBuilder.addMapField(attributesMap, Schema.FieldType.STRING, Schema.FieldType.STRING).build();
        }
        return schemaBuilder.build();
    }

    private static void processAttribute(@Nullable @UnknownKeyFor @Initialized AttributeValues attributeValues, @UnknownKeyFor @NonNull @Initialized Consumer<@UnknownKeyFor @NonNull @Initialized String> valueConsumer) {
        if (attributeValues != null) {
            List valueList = attributeValues.getValuesList();
            if (valueList.size() != 1) {
                throw new RuntimeException("Received an unparseable message with multiple values for an attribute.");
            }
            valueConsumer.accept(((ByteString)valueList.get(0)).toStringUtf8());
        }
    }

    public static @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @NonNull @Initialized Row> getRawBytesToRowFunction(final @UnknownKeyFor @NonNull @Initialized Schema rawSchema) {
        return new SimpleFunction<byte[], Row>(){

            public @UnknownKeyFor @NonNull @Initialized Row apply(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] input) {
                return Row.withSchema((Schema)rawSchema).addValue((Object)input).build();
            }
        };
    }

    public static @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized SequencedMessage, @UnknownKeyFor @NonNull @Initialized Uuid> getUuidFromMessage(final @UnknownKeyFor @NonNull @Initialized String attributeId) {
        return new SimpleFunction<SequencedMessage, Uuid>(){

            public @UnknownKeyFor @NonNull @Initialized Uuid apply(@UnknownKeyFor @NonNull @Initialized SequencedMessage input) {
                AttributeValues attribute = (AttributeValues)input.getMessage().getAttributesMap().get(attributeId);
                if (attribute != null) {
                    if (attribute.getValuesCount() != 1) {
                        throw new RuntimeException("Received an unparseable message with multiple values for an attribute.");
                    }
                    return Uuid.of(attribute.getValues(0));
                }
                throw new RuntimeException("Uuid attribute missing.");
            }
        };
    }

    public @UnknownKeyFor @NonNull @Initialized String identifier() {
        return "beam:schematransform:org.apache.beam:pubsublite_read:v1";
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> inputCollectionNames() {
        return Collections.emptyList();
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> outputCollectionNames() {
        return Arrays.asList("output", "errors");
    }

    @DefaultSchema(value=AutoValueSchema.class)
    @AutoValue
    public static abstract class PubsubLiteReadSchemaTransformConfiguration {
        public void validate() {
            String dataFormat = this.getFormat();
            assert (dataFormat == null || VALID_DATA_FORMATS.contains(dataFormat)) : "Valid data formats are " + VALID_DATA_FORMATS;
            String inputSchema = this.getSchema();
            String messageName = this.getMessageName();
            if (dataFormat != null && dataFormat.equals("RAW")) assert (inputSchema == null) : "To read from Pubsub Lite in RAW format, you can't provide a schema.";
            if (dataFormat != null && dataFormat.equals("PROTO")) assert (messageName != null) : "To read from Pubsub Lite in PROTO format, messageName must be provided.";
        }

        @SchemaFieldDescription(value="The encoding format for the data stored in Pubsub Lite. Valid options are: RAW,AVRO,JSON,PROTO")
        public abstract @UnknownKeyFor @NonNull @Initialized String getFormat();

        @SchemaFieldDescription(value="The schema in which the data is encoded in the Pubsub Lite topic. For AVRO data, this is a schema defined with AVRO schema syntax (https://avro.apache.org/docs/1.10.2/spec.html#schemas). For JSON data, this is a schema defined with JSON-schema syntax (https://json-schema.org/).")
        public abstract @Nullable @UnknownKeyFor @Initialized String getSchema();

        @SchemaFieldDescription(value="The GCP project where the Pubsub Lite reservation resides. This can be a project number of a project ID.")
        public abstract @Nullable @UnknownKeyFor @Initialized String getProject();

        @SchemaFieldDescription(value="The name of the subscription to consume data. This will be concatenated with the project and location parameters to build a full subscription path.")
        public abstract @UnknownKeyFor @NonNull @Initialized String getSubscriptionName();

        @SchemaFieldDescription(value="The region or zone where the Pubsub Lite reservation resides.")
        public abstract @UnknownKeyFor @NonNull @Initialized String getLocation();

        @SchemaFieldDescription(value="This option specifies whether and where to output unwritable rows.")
        public abstract @Nullable @UnknownKeyFor @Initialized ErrorHandling getErrorHandling();

        @SchemaFieldDescription(value="List of attribute keys whose values will be flattened into the output message as additional fields.  For example, if the format is `RAW` and attributes is `[\"a\", \"b\"]` then this read will produce elements of the form `Row(payload=..., a=..., b=...)`")
        public abstract @Nullable @UnknownKeyFor @Initialized List<@UnknownKeyFor @NonNull @Initialized String> getAttributes();

        @SchemaFieldDescription(value="Name of a field in which to store the full set of attributes associated with this message.  For example, if the format is `RAW` and `attribute_map` is set to `\"attrs\"` then this read will produce elements of the form `Row(payload=..., attrs=...)` where `attrs` is a Map type of string to string. If both `attributes` and `attribute_map` are set, the overlapping attribute values will be present in both the flattened structure and the attribute map.")
        public abstract @Nullable @UnknownKeyFor @Initialized String getAttributeMap();

        @SchemaFieldDescription(value="The attribute on incoming Pubsub Lite messages to use as a unique record identifier. When specified, the value of this attribute (which can be any string that uniquely identifies the record) will be used for deduplication of messages. If not provided, we cannot guarantee that no duplicate data will be delivered on the Pub/Sub stream. In this case, deduplication of the stream will be strictly best effort.")
        public abstract @Nullable @UnknownKeyFor @Initialized String getAttributeId();

        @SchemaFieldDescription(value="The path to the Protocol Buffer File Descriptor Set file. This file is used for schema definition and message serialization.")
        public abstract @Nullable @UnknownKeyFor @Initialized String getFileDescriptorPath();

        @SchemaFieldDescription(value="The name of the Protocol Buffer message to be used for schema extraction and data conversion.")
        public abstract @Nullable @UnknownKeyFor @Initialized String getMessageName();

        public static @UnknownKeyFor @NonNull @Initialized Builder builder() {
            return new AutoValue_PubsubLiteReadSchemaTransformProvider_PubsubLiteReadSchemaTransformConfiguration.Builder();
        }

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract @UnknownKeyFor @NonNull @Initialized Builder setFormat(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setSchema(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setProject(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setSubscriptionName(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setLocation(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setErrorHandling(@UnknownKeyFor @NonNull @Initialized ErrorHandling var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setAttributes(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setAttributeMap(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setAttributeId(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setFileDescriptorPath(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setMessageName(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized PubsubLiteReadSchemaTransformConfiguration build();
        }
    }

    public static class ErrorFn
    extends DoFn<SequencedMessage, Row> {
        private final @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @NonNull @Initialized Row> valueMapper;
        private final @UnknownKeyFor @NonNull @Initialized Counter errorCounter;
        private @UnknownKeyFor @NonNull @Initialized Long errorsInBundle = 0L;
        private final @UnknownKeyFor @NonNull @Initialized boolean handleErrors;
        private final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> attributes;
        private final @UnknownKeyFor @NonNull @Initialized String attributeMap;
        private final @UnknownKeyFor @NonNull @Initialized Schema errorSchema;
        private final @UnknownKeyFor @NonNull @Initialized Schema attributeSchema;

        public ErrorFn(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @NonNull @Initialized Row> valueMapper, @UnknownKeyFor @NonNull @Initialized Schema errorSchema, @UnknownKeyFor @NonNull @Initialized boolean handleErrors) {
            this.errorCounter = Metrics.counter(PubsubLiteReadSchemaTransformProvider.class, (String)name);
            this.valueMapper = valueMapper;
            this.errorSchema = errorSchema;
            this.handleErrors = handleErrors;
            this.attributes = new ArrayList<String>();
            this.attributeMap = "";
            this.attributeSchema = Schema.builder().build();
        }

        public ErrorFn(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @NonNull @Initialized Row> valueMapper, @UnknownKeyFor @NonNull @Initialized Schema errorSchema, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> attributes, @UnknownKeyFor @NonNull @Initialized String attributeMap, @UnknownKeyFor @NonNull @Initialized Schema attributeSchema, @UnknownKeyFor @NonNull @Initialized boolean handleErrors) {
            this.errorCounter = Metrics.counter(PubsubLiteReadSchemaTransformProvider.class, (String)name);
            this.valueMapper = valueMapper;
            this.errorSchema = errorSchema;
            this.handleErrors = handleErrors;
            this.attributes = attributes;
            this.attributeMap = attributeMap;
            this.attributeSchema = attributeSchema;
        }

        @DoFn.ProcessElement
        public void process(@DoFn.Element @UnknownKeyFor @NonNull @Initialized SequencedMessage seqMessage, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DoFn.MultiOutputReceiver receiver) {
            Row mappedRow = null;
            try {
                if (this.attributes.isEmpty() && this.attributeSchema.getFields().isEmpty() && this.attributeMap.isEmpty()) {
                    mappedRow = (Row)this.valueMapper.apply((Object)seqMessage.getMessage().getData().toByteArray());
                } else {
                    PubSubMessage message = seqMessage.getMessage();
                    Row row = (Row)this.valueMapper.apply((Object)message.getData().toByteArray());
                    Row.Builder rowBuilder = Row.withSchema((Schema)this.attributeSchema).addValues(row.getValues());
                    HashMap stringAttributeMap = new HashMap();
                    message.getAttributesMap().forEach((attributeName, attributeValues) -> {
                        if (this.attributes.contains(attributeName)) {
                            PubsubLiteReadSchemaTransformProvider.processAttribute(attributeValues, arg_0 -> ((Row.Builder)rowBuilder).addValue(arg_0));
                        }
                        if (!this.attributeMap.isEmpty()) {
                            PubsubLiteReadSchemaTransformProvider.processAttribute(attributeValues, value -> stringAttributeMap.put(attributeName, value));
                        }
                    });
                    if (!this.attributeMap.isEmpty() && !stringAttributeMap.isEmpty()) {
                        rowBuilder.addValue(stringAttributeMap);
                    }
                    mappedRow = rowBuilder.build();
                }
            }
            catch (Exception e) {
                if (!this.handleErrors) {
                    throw new RuntimeException(e);
                }
                this.errorsInBundle = this.errorsInBundle + 1L;
                LOG.warn("Error while parsing the element", (Throwable)e);
                receiver.get(ERROR_TAG).output((Object)ErrorHandling.errorRecord((Schema)this.errorSchema, (byte[])seqMessage.getMessage().getData().toByteArray(), (Throwable)e));
            }
            if (mappedRow != null) {
                receiver.get(OUTPUT_TAG).output((Object)mappedRow);
            }
        }

        @DoFn.FinishBundle
        public void finish(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized FinishBundleContext c) {
            this.errorCounter.inc(this.errorsInBundle.longValue());
            this.errorsInBundle = 0L;
        }
    }
}

