/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigtable;

import com.google.auto.value.AutoValue;
import com.google.bigtable.v2.RowFilter;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.apache.beam.sdk.io.gcp.bigtable.AutoValue_BigtableReadOptions;
import org.apache.beam.sdk.io.range.ByteKeyRange;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;

@AutoValue
abstract class BigtableReadOptions
implements Serializable {
    BigtableReadOptions() {
    }

    abstract @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> getTableId();

    abstract @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized RowFilter> getRowFilter();

    abstract @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized ByteKeyRange>> getKeyRanges();

    abstract @Nullable @UnknownKeyFor @Initialized Integer getMaxBufferElementCount();

    abstract @Nullable @UnknownKeyFor @Initialized Duration getAttemptTimeout();

    abstract @Nullable @UnknownKeyFor @Initialized Duration getOperationTimeout();

    abstract @Nullable @UnknownKeyFor @Initialized Duration getWaitTimeout();

    abstract @UnknownKeyFor @NonNull @Initialized Builder toBuilder();

    static @UnknownKeyFor @NonNull @Initialized Builder builder() {
        return new AutoValue_BigtableReadOptions.Builder();
    }

    @UnknownKeyFor @NonNull @Initialized BigtableReadOptions setMaxBufferElementCount(@Nullable @UnknownKeyFor @Initialized Integer maxBufferElementCount) {
        return this.toBuilder().setMaxBufferElementCount(maxBufferElementCount).build();
    }

    @UnknownKeyFor @NonNull @Initialized BigtableReadOptions withRowFilter(@UnknownKeyFor @NonNull @Initialized RowFilter rowFilter) {
        return this.toBuilder().setRowFilter((ValueProvider<RowFilter>)ValueProvider.StaticValueProvider.of((Object)rowFilter)).build();
    }

    @UnknownKeyFor @NonNull @Initialized BigtableReadOptions withKeyRanges(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized ByteKeyRange> keyRanges) {
        return this.toBuilder().setKeyRanges((ValueProvider<List<ByteKeyRange>>)ValueProvider.StaticValueProvider.of(keyRanges)).build();
    }

    @UnknownKeyFor @NonNull @Initialized BigtableReadOptions withKeyRange(@UnknownKeyFor @NonNull @Initialized ByteKeyRange keyRange) {
        return this.withKeyRanges(Collections.singletonList(keyRange));
    }

    @UnknownKeyFor @NonNull @Initialized boolean isDataAccessible() {
        return this.getTableId() != null && this.getTableId().isAccessible();
    }

    void populateDisplayData(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
        builder.addIfNotNull(DisplayData.item((String)"tableId", this.getTableId()).withLabel("Bigtable Table Id")).addIfNotNull(DisplayData.item((String)"rowFilter", this.getRowFilter()).withLabel("Row Filter")).addIfNotNull(DisplayData.item((String)"keyRanges", this.getKeyRanges()).withLabel("Key Ranges")).addIfNotNull(DisplayData.item((String)"attemptTimeout", (Duration)this.getAttemptTimeout()).withLabel("Read Attempt Timeout")).addIfNotNull(DisplayData.item((String)"operationTimeout", (Duration)this.getOperationTimeout()).withLabel("Read Operation Timeout"));
    }

    void validate() {
        Preconditions.checkArgument((this.getTableId() != null && (!this.getTableId().isAccessible() || !((String)this.getTableId().get()).isEmpty()) ? 1 : 0) != 0, (Object)"Could not obtain Bigtable table id");
        if (this.getRowFilter() != null && this.getRowFilter().isAccessible()) {
            Preconditions.checkArgument((this.getRowFilter().get() != null ? 1 : 0) != 0, (Object)"rowFilter can not be null");
        }
        if (this.getMaxBufferElementCount() != null) {
            Preconditions.checkArgument((this.getMaxBufferElementCount() > 0 ? 1 : 0) != 0, (Object)"maxBufferElementCount can not be zero or negative");
        }
        if (this.getKeyRanges() != null && this.getKeyRanges().isAccessible()) {
            Preconditions.checkArgument((this.getKeyRanges().get() != null ? 1 : 0) != 0, (Object)"keyRanges can not be null");
            Preconditions.checkArgument((!((List)this.getKeyRanges().get()).isEmpty() ? 1 : 0) != 0, (Object)"keyRanges can not be empty");
            for (ByteKeyRange range : (List)this.getKeyRanges().get()) {
                Preconditions.checkArgument((range != null ? 1 : 0) != 0, (Object)"keyRanges cannot hold null range");
            }
        }
        if (this.getAttemptTimeout() != null && this.getOperationTimeout() != null) {
            Preconditions.checkArgument((boolean)this.getAttemptTimeout().isShorterThan((ReadableDuration)this.getOperationTimeout()), (Object)"attempt timeout can't be longer than operation timeout");
        }
    }

    @AutoValue.Builder
    static abstract class Builder {
        Builder() {
        }

        abstract @UnknownKeyFor @NonNull @Initialized Builder setTableId(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder setRowFilter(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized RowFilter> var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder setMaxBufferElementCount(@Nullable @UnknownKeyFor @Initialized Integer var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder setKeyRanges(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized ByteKeyRange>> var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder setAttemptTimeout(@UnknownKeyFor @NonNull @Initialized Duration var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder setOperationTimeout(@UnknownKeyFor @NonNull @Initialized Duration var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder setWaitTimeout(@UnknownKeyFor @NonNull @Initialized Duration var1);

        abstract @UnknownKeyFor @NonNull @Initialized BigtableReadOptions build();
    }
}

