/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.Table;
import com.google.api.services.bigquery.model.TableReference;
import com.google.api.services.bigquery.model.TableSchema;
import com.google.auto.value.AutoValue;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.beam.sdk.io.gcp.bigquery.AutoValue_TableSchemaCache_Refresh;
import org.apache.beam.sdk.io.gcp.bigquery.AutoValue_TableSchemaCache_SchemaHolder;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryHelpers;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServices;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Maps;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.util.concurrent.Monitor;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.util.concurrent.MoreExecutors;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableSchemaCache {
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized SchemaHolder> cachedSchemas = Maps.newHashMap();
    private @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Refresh> tablesToRefresh = Maps.newHashMap();
    private final @UnknownKeyFor @NonNull @Initialized Monitor tableUpdateMonitor = new Monitor();
    private final // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Monitor.Guard tableUpdateGuard = new Monitor.Guard(this.tableUpdateMonitor){

        public @UnknownKeyFor @NonNull @Initialized boolean isSatisfied() {
            return !TableSchemaCache.this.tablesToRefresh.isEmpty() || TableSchemaCache.this.stopped || TableSchemaCache.this.clearing;
        }
    };
    private final @UnknownKeyFor @NonNull @Initialized Duration minSchemaRefreshFrequency;
    private final @UnknownKeyFor @NonNull @Initialized ExecutorService refreshExecutor = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setThreadFactory(MoreExecutors.platformThreadFactory()).setDaemon(true).setNameFormat("BigQuery table schema refresh thread").build());
    private @UnknownKeyFor @NonNull @Initialized boolean stopped;
    private @UnknownKeyFor @NonNull @Initialized boolean clearing;
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(TableSchemaCache.class);

    TableSchemaCache(@UnknownKeyFor @NonNull @Initialized Duration minSchemaRefreshFrequency) {
        this.minSchemaRefreshFrequency = minSchemaRefreshFrequency;
        this.stopped = false;
        this.clearing = false;
    }

    void start() {
        this.refreshExecutor.submit(this::refreshThread);
    }

    void clear() throws @UnknownKeyFor @NonNull @Initialized ExecutionException, @UnknownKeyFor @NonNull @Initialized InterruptedException {
        this.runUnderMonitor(() -> {
            this.clearing = true;
            this.tableUpdateMonitor.waitForUninterruptibly(new Monitor.Guard(this.tableUpdateMonitor){

                public @UnknownKeyFor @NonNull @Initialized boolean isSatisfied() {
                    return TableSchemaCache.this.stopped;
                }
            });
        });
        this.runUnderMonitor(() -> {
            this.cachedSchemas.clear();
            this.clearing = false;
            this.stopped = false;
        });
        this.start();
    }

    private void runUnderMonitor(@UnknownKeyFor @NonNull @Initialized Runnable runnable) {
        this.tableUpdateMonitor.enter();
        try {
            runnable.run();
        }
        finally {
            this.tableUpdateMonitor.leave();
        }
    }

    private <T> void runUnderMonitor(@UnknownKeyFor @NonNull @Initialized Consumer<T> consumer, T value) {
        this.tableUpdateMonitor.enter();
        try {
            consumer.accept(value);
        }
        finally {
            this.tableUpdateMonitor.leave();
        }
    }

    private <T> T runUnderMonitor(@UnknownKeyFor @NonNull @Initialized Supplier<T> supplier) {
        this.tableUpdateMonitor.enter();
        try {
            T t = supplier.get();
            return t;
        }
        finally {
            this.tableUpdateMonitor.leave();
        }
    }

    private static @UnknownKeyFor @NonNull @Initialized String tableKey(@UnknownKeyFor @NonNull @Initialized TableReference tableReference) {
        return BigQueryHelpers.stripPartitionDecorator(BigQueryHelpers.toTableSpec(tableReference));
    }

    @Nullable
    public @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized TableSchema getSchema(@UnknownKeyFor @NonNull @Initialized TableReference tableReference, @UnknownKeyFor @NonNull @Initialized BigQueryServices.DatasetService datasetService) {
        String key = TableSchemaCache.tableKey(tableReference);
        Optional<Object> schemaHolder = this.runUnderMonitor(() -> Optional.ofNullable(this.cachedSchemas.get(key)));
        if (!schemaHolder.isPresent()) {
            try {
                Table table = datasetService.getTable(tableReference, Collections.emptyList(), BigQueryServices.DatasetService.TableMetadataView.BASIC);
                schemaHolder = Optional.ofNullable(table == null ? null : SchemaHolder.of(table.getSchema(), 0));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (schemaHolder.isPresent()) {
                this.runUnderMonitor(h -> this.cachedSchemas.put(key, (SchemaHolder)h.get()), schemaHolder);
            }
        }
        return schemaHolder.map(SchemaHolder::getTableSchema).orElse(null);
    }

    @Nullable
    public @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized TableSchema putSchemaIfAbsent(@UnknownKeyFor @NonNull @Initialized TableReference tableReference, @UnknownKeyFor @NonNull @Initialized TableSchema tableSchema) {
        String key = TableSchemaCache.tableKey(tableReference);
        Optional existing = this.runUnderMonitor(() -> Optional.ofNullable(this.cachedSchemas.putIfAbsent(key, SchemaHolder.of(tableSchema, 0))));
        return existing.map(SchemaHolder::getTableSchema).orElse(null);
    }

    public void refreshSchema(@UnknownKeyFor @NonNull @Initialized TableReference tableReference, @UnknownKeyFor @NonNull @Initialized BigQueryServices.DatasetService datasetService) {
        int targetVersion = this.runUnderMonitor(() -> {
            if (this.stopped) {
                throw new RuntimeException("Cannot call refreshSchema after the object has been stopped!");
            }
            String key = TableSchemaCache.tableKey(tableReference);
            SchemaHolder schemaHolder = this.cachedSchemas.get(key);
            int nextVersion = schemaHolder != null ? schemaHolder.getVersion() + 1 : 0;
            this.tablesToRefresh.put(key, Refresh.of(datasetService, nextVersion));
            return nextVersion;
        });
        this.waitForRefresh(tableReference, targetVersion);
    }

    private void waitForRefresh(final @UnknownKeyFor @NonNull @Initialized TableReference tableReference, final @UnknownKeyFor @NonNull @Initialized int version) {
        this.tableUpdateMonitor.enterWhenUninterruptibly(new Monitor.Guard(this.tableUpdateMonitor){

            public @UnknownKeyFor @NonNull @Initialized boolean isSatisfied() {
                if (TableSchemaCache.this.stopped) {
                    return false;
                }
                SchemaHolder schemaHolder = (SchemaHolder)TableSchemaCache.this.cachedSchemas.get(TableSchemaCache.tableKey(tableReference));
                if (schemaHolder == null) {
                    return false;
                }
                return schemaHolder.getVersion() >= version;
            }
        });
        this.tableUpdateMonitor.leave();
    }

    public void refreshThread() {
        Instant start = Instant.now();
        try {
            Map<String, Refresh> localTablesToRefresh;
            this.tableUpdateMonitor.enterWhen(this.tableUpdateGuard);
            try {
                if (this.clearing) {
                    this.stopped = true;
                    return;
                }
                localTablesToRefresh = this.tablesToRefresh;
                this.tablesToRefresh = Maps.newHashMap();
                localTablesToRefresh.entrySet().removeIf(entry -> {
                    SchemaHolder schemaHolder = this.cachedSchemas.get(entry.getKey());
                    return schemaHolder != null && schemaHolder.getVersion() >= ((Refresh)entry.getValue()).getTargetVersion();
                });
            }
            finally {
                this.tableUpdateMonitor.leave();
            }
            Map<String, TableSchema> schemas = this.refreshAll(localTablesToRefresh);
            this.runUnderMonitor(() -> {
                for (Map.Entry entry : schemas.entrySet()) {
                    SchemaHolder schemaHolder = this.cachedSchemas.get(entry.getKey());
                    if (schemaHolder == null) {
                        throw new RuntimeException("Unexpected null schema for " + (String)entry.getKey());
                    }
                    SchemaHolder newSchema = SchemaHolder.of((TableSchema)entry.getValue(), schemaHolder.getVersion() + 1);
                    this.cachedSchemas.put((String)entry.getKey(), newSchema);
                }
            });
            Duration timeElapsed = new Duration((ReadableInstant)start, (ReadableInstant)Instant.now());
            Duration timeRemaining = this.minSchemaRefreshFrequency.minus((ReadableDuration)timeElapsed);
            if (timeRemaining.getMillis() > 0L) {
                Thread.sleep(timeRemaining.getMillis());
            }
        }
        catch (Exception e) {
            LOG.error("Caught exception in BigQuery's table schema cache refresh thread: " + e);
        }
        this.refreshExecutor.submit(this::refreshThread);
    }

    private @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized TableSchema> refreshAll(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Refresh> tables) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized InterruptedException {
        HashMap schemas = Maps.newHashMapWithExpectedSize((int)tables.size());
        for (Map.Entry<String, Refresh> entry : tables.entrySet()) {
            TableReference tableReference = BigQueryHelpers.parseTableSpec(entry.getKey());
            Table table = entry.getValue().getDatasetService().getTable(tableReference, Collections.emptyList(), BigQueryServices.DatasetService.TableMetadataView.BASIC);
            if (table == null) {
                throw new RuntimeException("Did not get value for table " + tableReference);
            }
            LOG.info("Refreshed BigQuery schema for " + entry.getKey());
            schemas.put(entry.getKey(), table.getSchema());
        }
        return schemas;
    }

    @AutoValue
    static abstract class Refresh {
        Refresh() {
        }

        abstract @UnknownKeyFor @NonNull @Initialized BigQueryServices.DatasetService getDatasetService();

        abstract @UnknownKeyFor @NonNull @Initialized int getTargetVersion();

        static @UnknownKeyFor @NonNull @Initialized Refresh of(@UnknownKeyFor @NonNull @Initialized BigQueryServices.DatasetService datasetService, @UnknownKeyFor @NonNull @Initialized int targetVersion) {
            return new AutoValue_TableSchemaCache_Refresh(datasetService, targetVersion);
        }
    }

    @AutoValue
    static abstract class SchemaHolder {
        SchemaHolder() {
        }

        abstract @UnknownKeyFor @NonNull @Initialized TableSchema getTableSchema();

        abstract @UnknownKeyFor @NonNull @Initialized int getVersion();

        static @UnknownKeyFor @NonNull @Initialized SchemaHolder of(@UnknownKeyFor @NonNull @Initialized TableSchema tableSchema, @UnknownKeyFor @NonNull @Initialized int version) {
            return new AutoValue_TableSchemaCache_SchemaHolder(tableSchema, version);
        }
    }
}

