/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import org.apache.beam.sdk.extensions.gcp.options.GcpOptions;
import org.apache.beam.sdk.options.ApplicationNameOptions;
import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.StreamingOptions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@Description(value="Options that are used to configure Google BigQuery. See https://cloud.google.com/bigquery/what-is-bigquery for details on BigQuery.")
public interface BigQueryOptions
extends ApplicationNameOptions,
GcpOptions,
PipelineOptions,
StreamingOptions {
    @Description(value="Temporary dataset for BigQuery table operations. Supported values are \"bigquery.googleapis.com/{dataset}\"")
    @Default.String(value="bigquery.googleapis.com/cloud_dataflow")
    public @UnknownKeyFor @NonNull @Initialized String getTempDatasetId();

    public void setTempDatasetId(@UnknownKeyFor @NonNull @Initialized String var1);

    @Description(value="Timeout for HTTP requests to BigQuery service in milliseconds. Set to 0 to disable.")
    @Default.Integer(value=900000)
    public @UnknownKeyFor @NonNull @Initialized Integer getHTTPWriteTimeout();

    public void setHTTPWriteTimeout(@UnknownKeyFor @NonNull @Initialized Integer var1);

    @Description(value="If specified, the given number of maximum concurrent threads will be used to insert rows from one bundle to BigQuery service with streaming insert API.")
    @Default.Integer(value=3)
    public @UnknownKeyFor @NonNull @Initialized Integer getInsertBundleParallelism();

    public void setInsertBundleParallelism(@UnknownKeyFor @NonNull @Initialized Integer var1);

    @Description(value="The number of keys used per table when doing streaming inserts to BigQuery.")
    @Default.Integer(value=50)
    public @UnknownKeyFor @NonNull @Initialized Integer getNumStreamingKeys();

    public void setNumStreamingKeys(@UnknownKeyFor @NonNull @Initialized Integer var1);

    @Description(value="The maximum number of rows to batch in a single streaming insert to BigQuery.")
    @Default.Long(value=500L)
    public @UnknownKeyFor @NonNull @Initialized Long getMaxStreamingRowsToBatch();

    public void setMaxStreamingRowsToBatch(@UnknownKeyFor @NonNull @Initialized Long var1);

    @Description(value="The maximum byte size of a single streaming insert to BigQuery.")
    @Default.Long(value=65536L)
    public @UnknownKeyFor @NonNull @Initialized Long getMaxStreamingBatchSize();

    public void setMaxStreamingBatchSize(@UnknownKeyFor @NonNull @Initialized Long var1);

    @Description(value="The minimum duration in seconds between streaming API statistics logging. The interval might be longer than the specified value due to each bundle processing time.")
    @Default.Integer(value=180)
    public @UnknownKeyFor @NonNull @Initialized Integer getBqStreamingApiLoggingFrequencySec();

    public void setBqStreamingApiLoggingFrequencySec(@UnknownKeyFor @NonNull @Initialized Integer var1);

    @Description(value="If set, then BigQueryIO.Write will default to using the Storage Write API.")
    @Default.Boolean(value=false)
    public @UnknownKeyFor @NonNull @Initialized Boolean getUseStorageWriteApi();

    public void setUseStorageWriteApi(@UnknownKeyFor @NonNull @Initialized Boolean var1);

    @Description(value="If set, then BigQueryIO.Write will default to using the approximate Storage Write API.")
    @Default.Boolean(value=false)
    public @UnknownKeyFor @NonNull @Initialized Boolean getUseStorageWriteApiAtLeastOnce();

    public void setUseStorageWriteApiAtLeastOnce(@UnknownKeyFor @NonNull @Initialized Boolean var1);

    @Description(value="When writing with a streaming pipeline, the BigQueryIO.Write will default to using this number of Storage Write API streams. ")
    @Default.Integer(value=0)
    public @UnknownKeyFor @NonNull @Initialized Integer getNumStorageWriteApiStreams();

    public void setNumStorageWriteApiStreams(@UnknownKeyFor @NonNull @Initialized Integer var1);

    @Description(value="When using the {@link org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO.Write.Method#STORAGE_API_AT_LEAST_ONCE} write method, this option sets the number of stream append clients that will be allocated at a per worker and destination basis. A large value can cause a large pipeline to go over the BigQuery connection quota quickly on a job with enough number of workers. On the case of low-mid volume pipelines using the default configuration should be sufficient.")
    @Default.Integer(value=1)
    public @UnknownKeyFor @NonNull @Initialized Integer getNumStorageWriteApiStreamAppendClients();

    public void setNumStorageWriteApiStreamAppendClients(@UnknownKeyFor @NonNull @Initialized Integer var1);

    @Description(value="When using the STORAGE_API_AT_LEAST_ONCE write method with multiplexing (ie. useStorageApiConnectionPool=true), this option sets the minimum number of connections each pool creates before any connections are shared. This is on a per worker, per region basis. Note that in practice, the minimum number of connections created is the minimum of this value and (numStorageWriteApiStreamAppendClients x num destinations). BigQuery will create this many connections at first and will only create more connections if the current ones are \"overwhelmed\". Consider increasing this value if you are running into performance issues.")
    @Default.Integer(value=2)
    public @UnknownKeyFor @NonNull @Initialized Integer getMinConnectionPoolConnections();

    public void setMinConnectionPoolConnections(@UnknownKeyFor @NonNull @Initialized Integer var1);

    @Description(value="When using the STORAGE_API_AT_LEAST_ONCE write method with multiplexing (ie. useStorageApiConnectionPool=true), this option sets the maximum number of connections each pool creates. This is on a per worker, per region basis. If writing to many dynamic destinations (>20) and experiencing performance issues or seeing append operations competingfor streams, consider increasing this value.")
    @Default.Integer(value=20)
    public @UnknownKeyFor @NonNull @Initialized Integer getMaxConnectionPoolConnections();

    public void setMaxConnectionPoolConnections(@UnknownKeyFor @NonNull @Initialized Integer var1);

    @Description(value="The max number of messages inflight that we expect each connection will retain.")
    @Default.Long(value=1000L)
    public @UnknownKeyFor @NonNull @Initialized Long getStorageWriteMaxInflightRequests();

    public void setStorageWriteMaxInflightRequests(@UnknownKeyFor @NonNull @Initialized Long var1);

    @Description(value="The max size in bytes for inflight messages that we expect each connection will retain.")
    @Default.Long(value=0x6400000L)
    public @UnknownKeyFor @NonNull @Initialized Long getStorageWriteMaxInflightBytes();

    public void setStorageWriteMaxInflightBytes(@UnknownKeyFor @NonNull @Initialized Long var1);

    @Description(value="Enables multiplexing mode, where multiple tables can share the same connection. Only available when writing with STORAGE_API_AT_LEAST_ONCE mode. This is recommended if your write operation is creating 20+ connections. When using multiplexing, consider tuning the number of connections created by the connection pool with minConnectionPoolConnections and maxConnectionPoolConnections. For more information, see https://cloud.google.com/bigquery/docs/write-api-best-practices#connection_pool_management")
    @Default.Boolean(value=false)
    public @UnknownKeyFor @NonNull @Initialized Boolean getUseStorageApiConnectionPool();

    public void setUseStorageApiConnectionPool(@UnknownKeyFor @NonNull @Initialized Boolean var1);

    @Description(value="If set, then BigQueryIO.Write will default to triggering the Storage Write API writes this often.")
    public @UnknownKeyFor @NonNull @Initialized Integer getStorageWriteApiTriggeringFrequencySec();

    public void setStorageWriteApiTriggeringFrequencySec(@UnknownKeyFor @NonNull @Initialized Integer var1);

    @Description(value="Maximum number of retries for Storage Write API writes. Currently it is only applicable for streaming pipeline.")
    @Default.Integer(value=500)
    public @UnknownKeyFor @NonNull @Initialized Integer getStorageWriteApiMaxRetries();

    public void setStorageWriteApiMaxRetries(@UnknownKeyFor @NonNull @Initialized Integer var1);

    @Description(value="When auto-sharding is used, the maximum duration in milliseconds the input records are allowed to be buffered before being written to BigQuery.")
    @Default.Integer(value=0)
    public @UnknownKeyFor @NonNull @Initialized Integer getMaxBufferingDurationMilliSec();

    public void setMaxBufferingDurationMilliSec(@UnknownKeyFor @NonNull @Initialized Integer var1);

    @Description(value="If specified, it will override the default (GcpOptions#getProject()) project id.")
    public @UnknownKeyFor @NonNull @Initialized String getBigQueryProject();

    public void setBigQueryProject(@UnknownKeyFor @NonNull @Initialized String var1);

    @Description(value="Maximum (best effort) size of a single append to the storage API.")
    @Default.Integer(value=0x200000)
    public @UnknownKeyFor @NonNull @Initialized Integer getStorageApiAppendThresholdBytes();

    public void setStorageApiAppendThresholdBytes(@UnknownKeyFor @NonNull @Initialized Integer var1);

    @Description(value="Maximum (best effort) record count of a single append to the storage API.")
    @Default.Integer(value=150000)
    public @UnknownKeyFor @NonNull @Initialized Integer getStorageApiAppendThresholdRecordCount();

    public void setStorageApiAppendThresholdRecordCount(@UnknownKeyFor @NonNull @Initialized Integer var1);

    @Description(value="Maximum request size allowed by the storage write API. ")
    @Default.Long(value=10000000L)
    public @UnknownKeyFor @NonNull @Initialized Long getStorageWriteApiMaxRequestSize();

    public void setStorageWriteApiMaxRequestSize(@UnknownKeyFor @NonNull @Initialized Long var1);

    @Description(value="If set, BigQueryIO.Read will rely on the Read API backends to surface the appropriate number of streams for read")
    @Default.Boolean(value=false)
    public @UnknownKeyFor @NonNull @Initialized Boolean getEnableStorageReadApiV2();

    public void setEnableStorageReadApiV2(@UnknownKeyFor @NonNull @Initialized Boolean var1);
}

