/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.TableSchema;
import com.google.auto.service.AutoService;
import com.google.cloud.bigquery.storage.v1.AppendRowsRequest;
import com.google.cloud.bigquery.storage.v1.DataFormat;
import java.io.IOException;
import java.io.InvalidClassException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.gcp.bigquery.AutoValue_BigQueryIO_TypedRead;
import org.apache.beam.sdk.io.gcp.bigquery.AutoValue_BigQueryIO_Write;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServices;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServicesImpl;
import org.apache.beam.sdk.io.gcp.bigquery.DynamicDestinations;
import org.apache.beam.sdk.io.gcp.bigquery.InsertRetryPolicy;
import org.apache.beam.sdk.io.gcp.bigquery.RowWriterFactory;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.StreamingOptions;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.logicaltypes.NanosDuration;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.errorhandling.BadRecord;
import org.apache.beam.sdk.transforms.errorhandling.BadRecordRouter;
import org.apache.beam.sdk.transforms.errorhandling.ErrorHandler;
import org.apache.beam.sdk.util.construction.PTransformTranslation;
import org.apache.beam.sdk.util.construction.SdkComponents;
import org.apache.beam.sdk.util.construction.TransformPayloadTranslatorRegistrar;
import org.apache.beam.sdk.util.construction.TransformUpgrader;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.grpc.v1p60p1.com.google.protobuf.ByteString;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BigQueryIOTranslation {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(BigQueryIOTranslation.class);

    @AutoService(value={TransformPayloadTranslatorRegistrar.class})
    public static class WriteRegistrar
    implements TransformPayloadTranslatorRegistrar {
        public @UnknownKeyFor @NonNull @Initialized Map<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized PTransform>, @KeyForBottom @NonNull @Initialized ? extends // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized PTransformTranslation.TransformPayloadTranslator> getTransformPayloadTranslators() {
            return ImmutableMap.builder().put(AutoValue_BigQueryIO_Write.class, (Object)new BigQueryIOWriteTranslator()).build();
        }
    }

    static class BigQueryIOWriteTranslator
    implements PTransformTranslation.TransformPayloadTranslator<BigQueryIO.Write<?>> {
        static @UnknownKeyFor @NonNull @Initialized Schema schema = Schema.builder().addNullableStringField("json_table_ref").addNullableByteArrayField("table_function").addNullableByteArrayField("format_function").addNullableByteArrayField("format_record_on_failure_function").addNullableByteArrayField("avro_row_writer_factory").addNullableByteArrayField("avro_schema_factory").addNullableBooleanField("use_avro_logical_types").addNullableByteArrayField("dynamic_destinations").addNullableStringField("json_schema").addNullableStringField("json_time_partitioning").addNullableStringField("clustering").addNullableByteArrayField("create_disposition").addNullableByteArrayField("write_disposition").addNullableArrayField("schema_update_options", Schema.FieldType.BYTES).addNullableStringField("table_description").addNullableBooleanField("validate").addNullableByteArrayField("bigquery_services").addNullableInt32Field("max_files_per_bundle").addNullableInt64Field("max_file_size").addNullableInt32Field("num_file_shards").addNullableInt32Field("num_storage_write_api_streams").addNullableBooleanField("propagate_successful_storage_api_writes").addNullableInt32Field("max_files_per_partition").addNullableInt64Field("max_bytes_per_partition").addNullableLogicalTypeField("triggering_frequency", (Schema.LogicalType)new NanosDuration()).addNullableByteArrayField("method").addNullableStringField("load_job_project_id").addNullableByteArrayField("failed_insert_retry_policy").addNullableStringField("custom_gcs_temp_location").addNullableBooleanField("extended_error_info").addNullableBooleanField("skip_invalid_rows").addNullableBooleanField("ignore_unknown_values").addNullableBooleanField("ignore_insert_ids").addNullableInt32Field("max_retry_jobs").addNullableStringField("kms_key").addNullableArrayField("primary_key", Schema.FieldType.STRING).addNullableByteArrayField("default_missing_value_interpretation").addNullableBooleanField("optimize_writes").addNullableBooleanField("use_beam_schema").addNullableBooleanField("auto_sharding").addNullableBooleanField("propagate_successful").addNullableBooleanField("auto_schema_update").addNullableByteArrayField("write_protos_class").addNullableBooleanField("direct_write_protos").addNullableByteArrayField("deterministic_record_id_fn").addNullableStringField("write_temp_dataset").addNullableByteArrayField("row_mutation_information_fn").addNullableByteArrayField("bad_record_error_handler").addNullableByteArrayField("bad_record_router").build();
        public static final @UnknownKeyFor @NonNull @Initialized String BIGQUERY_WRITE_TRANSFORM_URN = "beam:transform:org.apache.beam:bigquery_write:v1";

        BigQueryIOWriteTranslator() {
        }

        public @UnknownKeyFor @NonNull @Initialized String getUrn() {
            return BIGQUERY_WRITE_TRANSFORM_URN;
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
         @Nullable @UnknownKeyFor @Initialized RunnerApi.FunctionSpec translate(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?,  @UnknownKeyFor @NonNull @Initialized BigQueryIO.Write<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> application, @UnknownKeyFor @NonNull @Initialized SdkComponents components) throws @UnknownKeyFor @NonNull @Initialized IOException {
            return RunnerApi.FunctionSpec.newBuilder().setUrn(this.getUrn()).setPayload(ByteString.empty()).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Row toConfigRow(/*
         * Issues handling annotations - annotations may be inaccurate
         */
         @UnknownKeyFor @NonNull @Initialized BigQueryIO.Write<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> transform) {
            HashMap<String, Object> fieldValues = new HashMap<String, Object>();
            if (transform.getJsonTableRef() != null) {
                fieldValues.put("json_table_ref", transform.getJsonTableRef().get());
            }
            if (transform.getTableFunction() != null) {
                fieldValues.put("table_function", TransformUpgrader.toByteArray(transform.getTableFunction()));
            }
            if (transform.getFormatFunction() != null) {
                fieldValues.put("format_function", TransformUpgrader.toByteArray(transform.getFormatFunction()));
            }
            if (transform.getFormatRecordOnFailureFunction() != null) {
                fieldValues.put("format_record_on_failure_function", TransformUpgrader.toByteArray(transform.getFormatRecordOnFailureFunction()));
            }
            if (transform.getAvroRowWriterFactory() != null) {
                fieldValues.put("avro_row_writer_factory", TransformUpgrader.toByteArray(transform.getAvroRowWriterFactory()));
            }
            fieldValues.put("use_avro_logical_types", transform.getUseAvroLogicalTypes());
            if (transform.getDynamicDestinations() != null) {
                fieldValues.put("dynamic_destinations", TransformUpgrader.toByteArray(transform.getDynamicDestinations()));
            }
            if (transform.getSchemaFromView() != null) {
                throw new IllegalArgumentException("BigQueryIO.Write transforms cannot be converted to a portable row based config due to 'withSchemaFromView' property being set. Please retry without setting this property when configuring your transform");
            }
            if (transform.getJsonSchema() != null) {
                fieldValues.put("json_schema", transform.getJsonSchema().get());
            }
            if (transform.getJsonTimePartitioning() != null) {
                fieldValues.put("json_time_partitioning", TransformUpgrader.toByteArray((Object)transform.getJsonTimePartitioning().get()));
            }
            if (transform.getJsonClustering() != null) {
                fieldValues.put("clustering", transform.getJsonClustering().get());
            }
            if (transform.getCreateDisposition() != null) {
                fieldValues.put("create_disposition", TransformUpgrader.toByteArray((Object)((Object)transform.getCreateDisposition())));
            }
            if (transform.getWriteDisposition() != null) {
                fieldValues.put("write_disposition", TransformUpgrader.toByteArray((Object)((Object)transform.getWriteDisposition())));
            }
            if (transform.getSchemaUpdateOptions() != null && !transform.getSchemaUpdateOptions().isEmpty()) {
                List schemUpdateOptionsData = transform.getSchemaUpdateOptions().stream().map(option -> TransformUpgrader.toByteArray((Object)option)).collect(Collectors.toList());
                fieldValues.put("schema_update_options", schemUpdateOptionsData);
            }
            if (transform.getTableDescription() != null) {
                fieldValues.put("table_description", transform.getTableDescription());
            }
            fieldValues.put("validate", transform.getValidate());
            if (transform.getBigQueryServices() != null) {
                fieldValues.put("bigquery_services", TransformUpgrader.toByteArray((Object)transform.getBigQueryServices()));
            }
            if (transform.getMaxFilesPerBundle() != null) {
                fieldValues.put("max_files_per_bundle", transform.getMaxFilesPerBundle());
            }
            if (transform.getMaxFileSize() != null) {
                fieldValues.put("max_file_size", transform.getMaxFileSize());
            }
            fieldValues.put("num_file_shards", transform.getNumFileShards());
            fieldValues.put("num_storage_write_api_streams", transform.getNumStorageWriteApiStreams());
            fieldValues.put("propagate_successful_storage_api_writes", transform.getPropagateSuccessfulStorageApiWrites());
            fieldValues.put("max_files_per_partition", transform.getMaxFilesPerPartition());
            fieldValues.put("max_bytes_per_partition", transform.getMaxBytesPerPartition());
            if (transform.getTriggeringFrequency() != null) {
                fieldValues.put("triggering_frequency", java.time.Duration.ofMillis(transform.getTriggeringFrequency().getMillis()));
            }
            if (transform.getMethod() != null) {
                fieldValues.put("method", TransformUpgrader.toByteArray((Object)((Object)transform.getMethod())));
            }
            if (transform.getLoadJobProjectId() != null) {
                fieldValues.put("load_job_project_id", transform.getLoadJobProjectId());
            }
            if (transform.getFailedInsertRetryPolicy() != null) {
                fieldValues.put("failed_insert_retry_policy", TransformUpgrader.toByteArray((Object)transform.getFailedInsertRetryPolicy()));
            }
            if (transform.getCustomGcsTempLocation() != null) {
                fieldValues.put("custom_gcs_temp_location", transform.getCustomGcsTempLocation().get());
            }
            fieldValues.put("extended_error_info", transform.getExtendedErrorInfo());
            if (transform.getSkipInvalidRows() != null) {
                fieldValues.put("skip_invalid_rows", transform.getSkipInvalidRows());
            }
            if (transform.getIgnoreUnknownValues() != null) {
                fieldValues.put("ignore_unknown_values", transform.getIgnoreUnknownValues());
            }
            if (transform.getIgnoreInsertIds() != null) {
                fieldValues.put("ignore_insert_ids", transform.getIgnoreInsertIds());
            }
            fieldValues.put("max_retry_jobs", transform.getMaxRetryJobs());
            if (transform.getPropagateSuccessful() != null) {
                fieldValues.put("propagate_successful", transform.getPropagateSuccessful());
            }
            if (transform.getKmsKey() != null) {
                fieldValues.put("kms_key", transform.getKmsKey());
            }
            if (transform.getPrimaryKey() != null) {
                fieldValues.put("primary_key", transform.getPrimaryKey());
            }
            if (transform.getDefaultMissingValueInterpretation() != null) {
                fieldValues.put("default_missing_value_interpretation", TransformUpgrader.toByteArray((Object)transform.getDefaultMissingValueInterpretation()));
            }
            if (transform.getOptimizeWrites() != null) {
                fieldValues.put("optimize_writes", transform.getOptimizeWrites());
            }
            if (transform.getUseBeamSchema() != null) {
                fieldValues.put("use_beam_schema", transform.getUseBeamSchema());
            }
            if (transform.getAutoSharding() != null) {
                fieldValues.put("auto_sharding", transform.getAutoSharding());
            }
            if (transform.getAutoSchemaUpdate() != null) {
                fieldValues.put("auto_schema_update", transform.getAutoSchemaUpdate());
            }
            if (transform.getWriteProtosClass() != null) {
                fieldValues.put("write_protos_class", TransformUpgrader.toByteArray(transform.getWriteProtosClass()));
            }
            if (transform.getDirectWriteProtos() != null) {
                fieldValues.put("direct_write_protos", transform.getDirectWriteProtos());
            }
            if (transform.getDeterministicRecordIdFn() != null) {
                fieldValues.put("deterministic_record_id_fn", TransformUpgrader.toByteArray(transform.getDeterministicRecordIdFn()));
            }
            if (transform.getWriteTempDataset() != null) {
                fieldValues.put("write_temp_dataset", TransformUpgrader.toByteArray((Object)transform.getWriteTempDataset()));
            }
            if (transform.getRowMutationInformationFn() != null) {
                fieldValues.put("row_mutation_information_fn", TransformUpgrader.toByteArray(transform.getRowMutationInformationFn()));
            }
            fieldValues.put("bad_record_router", TransformUpgrader.toByteArray((Object)transform.getBadRecordRouter()));
            fieldValues.put("bad_record_error_handler", TransformUpgrader.toByteArray(transform.getBadRecordErrorHandler()));
            return Row.withSchema((Schema)schema).withFieldValues(fieldValues).build();
        }

        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
         @UnknownKeyFor @NonNull @Initialized BigQueryIO.Write<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> fromConfigRow(@UnknownKeyFor @NonNull @Initialized Row configRow, @UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
            String updateCompatibilityBeamVersion = ((StreamingOptions)options.as(StreamingOptions.class)).getUpdateCompatibilityVersion();
            updateCompatibilityBeamVersion = updateCompatibilityBeamVersion != null ? updateCompatibilityBeamVersion : "2.53.0";
            try {
                byte[] rowMutationInformationFnBytes;
                String writeTempDataset;
                byte[] deterministicRecordIdFnBytes;
                Boolean directWriteProtos;
                byte[] writeProtosClasses;
                Boolean autoSchemaUpdate;
                Boolean propagateSuccessful;
                Boolean autoSharding;
                Boolean useBeamSchema;
                Boolean optimizeWrites;
                byte[] defaultMissingValueInterpretationsBytes;
                Collection primaryKey;
                String kmsKey;
                Integer maxRetryJobs;
                Boolean ignoreInsertIds;
                Boolean ignoreUnknownValues;
                Boolean skipInvalidRows;
                Boolean extendedErrorInfo;
                String customGcsTempLocations;
                byte[] failedInsertRetryPolicyBytes;
                String loadJobProjectId;
                byte[] methodBytes;
                String triggeringFrequencyFieldName;
                java.time.Duration triggeringFrequency;
                Long maxBytesPerPartition;
                Integer maxFilesPerPartition;
                Boolean propagateSuccessfulStorageApiWrites;
                Integer numStorageWriteApiStreams;
                Integer numFileShards;
                Long maxFileSize;
                Integer maxFilesPerBundle;
                byte[] bigqueryServicesBytes;
                Boolean validate;
                Collection schemaUpdateOptionsData;
                byte[] writeDispositionBytes;
                byte[] createDispositionBytes;
                String jsonClustering;
                String jsonTimePartitioning;
                String jsonSchema;
                byte[] dynamicDestinationsBytes;
                Boolean useAvroLogicalTypes;
                byte[] avroRowWriterFactoryBytes;
                byte[] formatFunctionBytes;
                byte[] tableFunctionBytes;
                BigQueryIO.Write.Builder builder = new AutoValue_BigQueryIO_Write.Builder();
                String jsonTableRef = configRow.getString("json_table_ref");
                if (jsonTableRef != null) {
                    builder = builder.setJsonTableRef((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)jsonTableRef));
                }
                if ((tableFunctionBytes = configRow.getBytes("table_function")) != null) {
                    builder = builder.setTableFunction((SerializableFunction)TransformUpgrader.fromByteArray((byte[])tableFunctionBytes));
                }
                if ((formatFunctionBytes = configRow.getBytes("format_function")) != null) {
                    builder = builder.setFormatFunction((SerializableFunction)TransformUpgrader.fromByteArray((byte[])formatFunctionBytes));
                }
                byte[] formatRecordOnFailureFunctionBytes = configRow.getBytes("format_record_on_failure_function");
                if (tableFunctionBytes != null) {
                    builder = builder.setFormatRecordOnFailureFunction((SerializableFunction)TransformUpgrader.fromByteArray((byte[])formatRecordOnFailureFunctionBytes));
                }
                if ((avroRowWriterFactoryBytes = configRow.getBytes("avro_row_writer_factory")) != null) {
                    builder = builder.setAvroRowWriterFactory((RowWriterFactory.AvroRowWriterFactory)TransformUpgrader.fromByteArray((byte[])avroRowWriterFactoryBytes));
                }
                byte[] avroSchemaFactoryBytes = configRow.getBytes("avro_schema_factory");
                if (tableFunctionBytes != null) {
                    builder = builder.setAvroSchemaFactory((SerializableFunction<TableSchema, org.apache.avro.Schema>)((SerializableFunction)TransformUpgrader.fromByteArray((byte[])avroSchemaFactoryBytes)));
                }
                if ((useAvroLogicalTypes = configRow.getBoolean("use_avro_logical_types")) != null) {
                    builder = builder.setUseAvroLogicalTypes(useAvroLogicalTypes);
                }
                if ((dynamicDestinationsBytes = configRow.getBytes("dynamic_destinations")) != null) {
                    builder = builder.setDynamicDestinations((DynamicDestinations)TransformUpgrader.fromByteArray((byte[])dynamicDestinationsBytes));
                }
                if ((jsonSchema = configRow.getString("json_schema")) != null) {
                    builder = builder.setJsonSchema((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)jsonSchema));
                }
                if ((jsonTimePartitioning = configRow.getString("json_time_partitioning")) != null) {
                    builder = builder.setJsonTimePartitioning((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)jsonTimePartitioning));
                }
                if (TransformUpgrader.compareVersions((String)updateCompatibilityBeamVersion, (String)"2.56.0") >= 0 && (jsonClustering = configRow.getString("clustering")) != null) {
                    builder = builder.setJsonClustering((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)jsonClustering));
                }
                if ((createDispositionBytes = configRow.getBytes("create_disposition")) != null) {
                    builder = builder.setCreateDisposition((BigQueryIO.Write.CreateDisposition)((Object)TransformUpgrader.fromByteArray((byte[])createDispositionBytes)));
                }
                if ((writeDispositionBytes = configRow.getBytes("write_disposition")) != null) {
                    builder = builder.setWriteDisposition((BigQueryIO.Write.WriteDisposition)((Object)TransformUpgrader.fromByteArray((byte[])writeDispositionBytes)));
                }
                if ((schemaUpdateOptionsData = configRow.getArray("schema_update_options")) != null) {
                    Set<BigQueryIO.Write.SchemaUpdateOption> schemaUpdateOptions = schemaUpdateOptionsData.stream().map(data -> {
                        try {
                            return (BigQueryIO.Write.SchemaUpdateOption)((Object)((Object)TransformUpgrader.fromByteArray((byte[])data)));
                        }
                        catch (InvalidClassException e) {
                            throw new RuntimeException(e);
                        }
                    }).collect(Collectors.toSet());
                    builder = builder.setSchemaUpdateOptions(schemaUpdateOptions);
                } else {
                    builder = builder.setSchemaUpdateOptions(Collections.emptySet());
                }
                String tableDescription = configRow.getString("table_description");
                if (tableDescription != null) {
                    builder = builder.setTableDescription(tableDescription);
                }
                if ((validate = configRow.getBoolean("validate")) != null) {
                    builder = builder.setValidate(validate);
                }
                if ((bigqueryServicesBytes = configRow.getBytes("bigquery_services")) != null) {
                    try {
                        builder = builder.setBigQueryServices((BigQueryServices)TransformUpgrader.fromByteArray((byte[])bigqueryServicesBytes));
                    }
                    catch (InvalidClassException e) {
                        LOG.warn("Could not use the provided `BigQueryServices` implementation when upgrading.Using the default.");
                        builder.setBigQueryServices(new BigQueryServicesImpl());
                    }
                }
                if ((maxFilesPerBundle = configRow.getInt32("max_files_per_bundle")) != null) {
                    builder = builder.setMaxFilesPerBundle(maxFilesPerBundle);
                }
                if ((maxFileSize = configRow.getInt64("max_file_size")) != null) {
                    builder = builder.setMaxFileSize(maxFileSize);
                }
                if ((numFileShards = configRow.getInt32("num_file_shards")) != null) {
                    builder = builder.setNumFileShards(numFileShards);
                }
                if ((numStorageWriteApiStreams = configRow.getInt32("num_storage_write_api_streams")) != null) {
                    builder = builder.setNumStorageWriteApiStreams(numStorageWriteApiStreams);
                }
                if ((propagateSuccessfulStorageApiWrites = configRow.getBoolean("propagate_successful_storage_api_writes")) != null) {
                    builder = builder.setPropagateSuccessfulStorageApiWrites(propagateSuccessfulStorageApiWrites);
                }
                if ((maxFilesPerPartition = configRow.getInt32("max_files_per_partition")) != null) {
                    builder = builder.setMaxFilesPerPartition(maxFilesPerPartition);
                }
                if ((maxBytesPerPartition = configRow.getInt64("max_bytes_per_partition")) != null) {
                    builder = builder.setMaxBytesPerPartition(maxBytesPerPartition);
                }
                if ((triggeringFrequency = (java.time.Duration)configRow.getValue(triggeringFrequencyFieldName = TransformUpgrader.compareVersions((String)updateCompatibilityBeamVersion, (String)"2.53.0") == 0 ? "triggerring_frequency" : "triggering_frequency")) != null) {
                    builder = builder.setTriggeringFrequency(Duration.millis((long)triggeringFrequency.toMillis()));
                }
                if ((methodBytes = configRow.getBytes("method")) != null) {
                    builder = builder.setMethod((BigQueryIO.Write.Method)((Object)TransformUpgrader.fromByteArray((byte[])methodBytes)));
                }
                if ((loadJobProjectId = configRow.getString("load_job_project_id")) != null) {
                    builder = builder.setLoadJobProjectId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)loadJobProjectId));
                }
                if ((failedInsertRetryPolicyBytes = configRow.getBytes("failed_insert_retry_policy")) != null) {
                    builder = builder.setFailedInsertRetryPolicy((InsertRetryPolicy)TransformUpgrader.fromByteArray((byte[])failedInsertRetryPolicyBytes));
                }
                if ((customGcsTempLocations = configRow.getString("custom_gcs_temp_location")) != null) {
                    builder = builder.setCustomGcsTempLocation((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)customGcsTempLocations));
                }
                if ((extendedErrorInfo = configRow.getBoolean("extended_error_info")) != null) {
                    builder = builder.setExtendedErrorInfo(extendedErrorInfo);
                }
                if ((skipInvalidRows = configRow.getBoolean("skip_invalid_rows")) != null) {
                    builder = builder.setSkipInvalidRows(skipInvalidRows);
                }
                if ((ignoreUnknownValues = configRow.getBoolean("ignore_unknown_values")) != null) {
                    builder = builder.setIgnoreUnknownValues(ignoreUnknownValues);
                }
                if ((ignoreInsertIds = configRow.getBoolean("ignore_insert_ids")) != null) {
                    builder = builder.setIgnoreInsertIds(ignoreInsertIds);
                }
                if ((maxRetryJobs = configRow.getInt32("max_retry_jobs")) != null) {
                    builder = builder.setMaxRetryJobs(maxRetryJobs);
                }
                if ((kmsKey = configRow.getString("kms_key")) != null) {
                    builder = builder.setKmsKey(kmsKey);
                }
                if ((primaryKey = configRow.getArray("primary_key")) != null && !primaryKey.isEmpty()) {
                    builder = builder.setPrimaryKey((List<String>)ImmutableList.of((Object)primaryKey));
                }
                if ((defaultMissingValueInterpretationsBytes = configRow.getBytes("default_missing_value_interpretation")) != null) {
                    builder = builder.setDefaultMissingValueInterpretation((AppendRowsRequest.MissingValueInterpretation)TransformUpgrader.fromByteArray((byte[])defaultMissingValueInterpretationsBytes));
                }
                if ((optimizeWrites = configRow.getBoolean("optimize_writes")) != null) {
                    builder = builder.setOptimizeWrites(optimizeWrites);
                }
                if ((useBeamSchema = configRow.getBoolean("use_beam_schema")) != null) {
                    builder = builder.setUseBeamSchema(useBeamSchema);
                }
                if ((autoSharding = configRow.getBoolean("auto_sharding")) != null) {
                    builder = builder.setAutoSharding(autoSharding);
                }
                if ((propagateSuccessful = configRow.getBoolean("propagate_successful")) != null) {
                    builder = builder.setPropagateSuccessful(propagateSuccessful);
                }
                if ((autoSchemaUpdate = configRow.getBoolean("auto_schema_update")) != null) {
                    builder = builder.setAutoSchemaUpdate(autoSchemaUpdate);
                }
                if ((writeProtosClasses = configRow.getBytes("write_protos_class")) != null) {
                    builder = builder.setWriteProtosClass((Class)TransformUpgrader.fromByteArray((byte[])defaultMissingValueInterpretationsBytes));
                }
                if ((directWriteProtos = configRow.getBoolean("direct_write_protos")) != null) {
                    builder = builder.setDirectWriteProtos(directWriteProtos);
                }
                if ((deterministicRecordIdFnBytes = configRow.getBytes("deterministic_record_id_fn")) != null) {
                    builder = builder.setDeterministicRecordIdFn((SerializableFunction)TransformUpgrader.fromByteArray((byte[])deterministicRecordIdFnBytes));
                }
                if ((writeTempDataset = configRow.getString("write_temp_dataset")) != null) {
                    builder = builder.setWriteTempDataset(writeTempDataset);
                }
                if ((rowMutationInformationFnBytes = configRow.getBytes("row_mutation_information_fn")) != null) {
                    builder = builder.setRowMutationInformationFn((SerializableFunction)TransformUpgrader.fromByteArray((byte[])rowMutationInformationFnBytes));
                }
                if (TransformUpgrader.compareVersions((String)updateCompatibilityBeamVersion, (String)"2.55.0") < 0) {
                    builder.setBadRecordRouter(BadRecordRouter.THROWING_ROUTER);
                    builder.setBadRecordErrorHandler((ErrorHandler<BadRecord, ?>)new ErrorHandler.DefaultErrorHandler());
                } else {
                    byte[] badRecordRouter = configRow.getBytes("bad_record_router");
                    builder.setBadRecordRouter((BadRecordRouter)TransformUpgrader.fromByteArray((byte[])badRecordRouter));
                    byte[] badRecordErrorHandler = configRow.getBytes("bad_record_error_handler");
                    builder.setBadRecordErrorHandler((ErrorHandler)TransformUpgrader.fromByteArray((byte[])badRecordErrorHandler));
                }
                return builder.build();
            }
            catch (InvalidClassException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @AutoService(value={TransformPayloadTranslatorRegistrar.class})
    public static class ReadRegistrar
    implements TransformPayloadTranslatorRegistrar {
        public @UnknownKeyFor @NonNull @Initialized Map<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized PTransform>, @KeyForBottom @NonNull @Initialized ? extends // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized PTransformTranslation.TransformPayloadTranslator> getTransformPayloadTranslators() {
            return ImmutableMap.builder().put(AutoValue_BigQueryIO_TypedRead.class, (Object)new BigQueryIOReadTranslator()).build();
        }
    }

    static class BigQueryIOReadTranslator
    implements PTransformTranslation.TransformPayloadTranslator<BigQueryIO.TypedRead<?>> {
        static @UnknownKeyFor @NonNull @Initialized Schema schema = Schema.builder().addNullableStringField("json_table_ref").addNullableStringField("query").addNullableBooleanField("validate").addNullableBooleanField("flatten_results").addNullableBooleanField("use_legacy_sql").addNullableBooleanField("with_template_compatibility").addNullableByteArrayField("bigquery_services").addNullableByteArrayField("parse_fn").addNullableByteArrayField("datum_reader_factory").addNullableByteArrayField("query_priority").addNullableStringField("query_location").addNullableStringField("query_temp_dataset").addNullableStringField("query_temp_project").addNullableByteArrayField("method").addNullableByteArrayField("format").addNullableArrayField("selected_fields", Schema.FieldType.STRING).addNullableStringField("row_restriction").addNullableByteArrayField("coder").addNullableStringField("kms_key").addNullableByteArrayField("type_descriptor").addNullableByteArrayField("to_beam_row_fn").addNullableStringField("from_beam_row_fn").addNullableBooleanField("use_avro_logical_types").addNullableBooleanField("projection_pushdown_applied").addNullableByteArrayField("bad_record_router").addNullableByteArrayField("bad_record_error_handler").build();
        public static final @UnknownKeyFor @NonNull @Initialized String BIGQUERY_READ_TRANSFORM_URN = "beam:transform:org.apache.beam:bigquery_read:v1";

        BigQueryIOReadTranslator() {
        }

        public @UnknownKeyFor @NonNull @Initialized String getUrn() {
            return BIGQUERY_READ_TRANSFORM_URN;
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
         @Nullable @UnknownKeyFor @Initialized RunnerApi.FunctionSpec translate(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?,  @UnknownKeyFor @NonNull @Initialized BigQueryIO.TypedRead<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> application, @UnknownKeyFor @NonNull @Initialized SdkComponents components) throws @UnknownKeyFor @NonNull @Initialized IOException {
            return RunnerApi.FunctionSpec.newBuilder().setUrn(this.getUrn()).setPayload(ByteString.empty()).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Row toConfigRow(/*
         * Issues handling annotations - annotations may be inaccurate
         */
         @UnknownKeyFor @NonNull @Initialized BigQueryIO.TypedRead<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> transform) {
            HashMap<String, Object> fieldValues = new HashMap<String, Object>();
            if (transform.getJsonTableRef() != null) {
                fieldValues.put("json_table_ref", transform.getJsonTableRef().get());
            }
            if (transform.getQuery() != null) {
                fieldValues.put("query", transform.getQuery().get());
            }
            fieldValues.put("validate", transform.getValidate());
            fieldValues.put("flatten_results", transform.getFlattenResults());
            fieldValues.put("use_legacy_sql", transform.getUseLegacySql());
            fieldValues.put("with_template_compatibility", transform.getWithTemplateCompatibility());
            if (transform.getBigQueryServices() != null) {
                fieldValues.put("bigquery_services", TransformUpgrader.toByteArray((Object)transform.getBigQueryServices()));
            }
            if (transform.getParseFn() != null) {
                fieldValues.put("parse_fn", TransformUpgrader.toByteArray(transform.getParseFn()));
            }
            if (transform.getDatumReaderFactory() != null) {
                fieldValues.put("datum_reader_factory", TransformUpgrader.toByteArray(transform.getDatumReaderFactory()));
            }
            if (transform.getQueryPriority() != null) {
                fieldValues.put("query_priority", TransformUpgrader.toByteArray((Object)((Object)transform.getQueryPriority())));
            }
            if (transform.getQueryLocation() != null) {
                fieldValues.put("query_location", transform.getQueryLocation());
            }
            if (transform.getQueryTempDataset() != null) {
                fieldValues.put("query_temp_dataset", transform.getQueryTempDataset());
            }
            if (transform.getQueryTempProject() != null) {
                fieldValues.put("query_temp_project", transform.getQueryTempProject());
            }
            if (transform.getMethod() != null) {
                fieldValues.put("method", TransformUpgrader.toByteArray((Object)((Object)transform.getMethod())));
            }
            if (transform.getFormat() != null) {
                fieldValues.put("format", TransformUpgrader.toByteArray((Object)transform.getFormat()));
            }
            if (transform.getSelectedFields() != null && !((List)transform.getSelectedFields().get()).isEmpty()) {
                fieldValues.put("selected_fields", transform.getSelectedFields().get());
            }
            if (transform.getRowRestriction() != null) {
                fieldValues.put("row_restriction", transform.getRowRestriction().get());
            }
            if (transform.getCoder() != null) {
                fieldValues.put("coder", TransformUpgrader.toByteArray(transform.getCoder()));
            }
            if (transform.getKmsKey() != null) {
                fieldValues.put("kms_key", transform.getKmsKey());
            }
            if (transform.getTypeDescriptor() != null) {
                fieldValues.put("type_descriptor", TransformUpgrader.toByteArray(transform.getTypeDescriptor()));
            }
            if (transform.getToBeamRowFn() != null) {
                fieldValues.put("to_beam_row_fn", TransformUpgrader.toByteArray(transform.getToBeamRowFn()));
            }
            if (transform.getFromBeamRowFn() != null) {
                fieldValues.put("from_beam_row_fn", TransformUpgrader.toByteArray(transform.getFromBeamRowFn()));
            }
            if (transform.getUseAvroLogicalTypes() != null) {
                fieldValues.put("use_avro_logical_types", transform.getUseAvroLogicalTypes());
            }
            fieldValues.put("projection_pushdown_applied", transform.getProjectionPushdownApplied());
            fieldValues.put("bad_record_router", TransformUpgrader.toByteArray((Object)transform.getBadRecordRouter()));
            fieldValues.put("bad_record_error_handler", TransformUpgrader.toByteArray(transform.getBadRecordErrorHandler()));
            return Row.withSchema((Schema)schema).withFieldValues(fieldValues).build();
        }

        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
         @UnknownKeyFor @NonNull @Initialized BigQueryIO.TypedRead<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> fromConfigRow(@UnknownKeyFor @NonNull @Initialized Row configRow, @UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
            String updateCompatibilityBeamVersion = ((StreamingOptions)options.as(StreamingOptions.class)).getUpdateCompatibilityVersion();
            updateCompatibilityBeamVersion = updateCompatibilityBeamVersion != null ? updateCompatibilityBeamVersion : "2.53.0";
            try {
                Boolean projectionPushdownApplied;
                Boolean useAvroLogicalTypes;
                byte[] fromBeamRowFnBytes;
                byte[] toBeamRowFnBytes;
                byte[] typeDescriptorBytes;
                String kmsKey;
                byte[] coderBytes;
                String rowRestriction;
                Collection selectedFields;
                byte[] methodBytes;
                String queryTempProject;
                String queryTempDataset;
                String queryLocation;
                byte[] queryPriorityBytes;
                byte[] datumReaderFactoryBytes;
                byte[] parseFnBytes;
                byte[] bigqueryServicesBytes;
                Boolean withTemplateCompatibility;
                Boolean useLegacySQL;
                Boolean flattenResults;
                Boolean validate;
                String query;
                BigQueryIO.TypedRead.Builder builder = new AutoValue_BigQueryIO_TypedRead.Builder();
                String jsonTableRef = configRow.getString("json_table_ref");
                if (jsonTableRef != null) {
                    builder = builder.setJsonTableRef((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)jsonTableRef));
                }
                if ((query = configRow.getString("query")) != null) {
                    builder = builder.setQuery((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)query));
                }
                if ((validate = configRow.getBoolean("validate")) != null) {
                    builder = builder.setValidate(validate);
                }
                if ((flattenResults = configRow.getBoolean("flatten_results")) != null) {
                    builder = builder.setFlattenResults(flattenResults);
                }
                if ((useLegacySQL = configRow.getBoolean("use_legacy_sql")) != null) {
                    builder = builder.setUseLegacySql(useLegacySQL);
                }
                if ((withTemplateCompatibility = configRow.getBoolean("with_template_compatibility")) != null) {
                    builder = builder.setWithTemplateCompatibility(withTemplateCompatibility);
                }
                if ((bigqueryServicesBytes = configRow.getBytes("bigquery_services")) != null) {
                    try {
                        builder = builder.setBigQueryServices((BigQueryServices)TransformUpgrader.fromByteArray((byte[])bigqueryServicesBytes));
                    }
                    catch (InvalidClassException e) {
                        LOG.warn("Could not use the provided `BigQueryServices` implementation when upgrading.Using the default.");
                        builder.setBigQueryServices(new BigQueryServicesImpl());
                    }
                }
                if ((parseFnBytes = configRow.getBytes("parse_fn")) != null) {
                    builder = builder.setParseFn((SerializableFunction)TransformUpgrader.fromByteArray((byte[])parseFnBytes));
                }
                if ((datumReaderFactoryBytes = configRow.getBytes("datum_reader_factory")) != null) {
                    builder = builder.setDatumReaderFactory((SerializableFunction)TransformUpgrader.fromByteArray((byte[])datumReaderFactoryBytes));
                }
                if ((queryPriorityBytes = configRow.getBytes("query_priority")) != null) {
                    builder = builder.setQueryPriority((BigQueryIO.TypedRead.QueryPriority)((Object)TransformUpgrader.fromByteArray((byte[])queryPriorityBytes)));
                }
                if ((queryLocation = configRow.getString("query_location")) != null) {
                    builder = builder.setQueryLocation(queryLocation);
                }
                if ((queryTempDataset = configRow.getString("query_temp_dataset")) != null) {
                    builder = builder.setQueryTempDataset(queryTempDataset);
                }
                if ((queryTempProject = configRow.getString("query_temp_project")) != null) {
                    builder = builder.setQueryTempProject(queryTempProject);
                }
                if ((methodBytes = configRow.getBytes("method")) != null) {
                    builder = builder.setMethod((BigQueryIO.TypedRead.Method)((Object)TransformUpgrader.fromByteArray((byte[])methodBytes)));
                }
                byte[] formatBytes = configRow.getBytes("format");
                if (methodBytes != null) {
                    builder = builder.setFormat((DataFormat)TransformUpgrader.fromByteArray((byte[])formatBytes));
                }
                if ((selectedFields = configRow.getArray("selected_fields")) != null && !selectedFields.isEmpty()) {
                    builder.setSelectedFields((ValueProvider<List<String>>)ValueProvider.StaticValueProvider.of((Object)ImmutableList.of((Object)selectedFields)));
                }
                if ((rowRestriction = configRow.getString("row_restriction")) != null) {
                    builder = builder.setRowRestriction((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)rowRestriction));
                }
                if ((coderBytes = configRow.getBytes("coder")) != null) {
                    try {
                        builder = builder.setCoder((Coder)TransformUpgrader.fromByteArray((byte[])coderBytes));
                    }
                    catch (InvalidClassException e) {
                        LOG.warn("Could not use the provided `Coder` implementation when upgrading.Using the default.");
                    }
                }
                if ((kmsKey = configRow.getString("kms_key")) != null) {
                    builder = builder.setKmsKey(kmsKey);
                }
                if ((typeDescriptorBytes = configRow.getBytes("type_descriptor")) != null) {
                    builder = builder.setTypeDescriptor((TypeDescriptor)TransformUpgrader.fromByteArray((byte[])typeDescriptorBytes));
                }
                if ((toBeamRowFnBytes = configRow.getBytes("to_beam_row_fn")) != null) {
                    builder = builder.setToBeamRowFn((BigQueryIO.TypedRead.ToBeamRowFunction)TransformUpgrader.fromByteArray((byte[])toBeamRowFnBytes));
                }
                if ((fromBeamRowFnBytes = configRow.getBytes("from_beam_row_fn")) != null) {
                    builder = builder.setFromBeamRowFn((BigQueryIO.TypedRead.FromBeamRowFunction)TransformUpgrader.fromByteArray((byte[])fromBeamRowFnBytes));
                }
                if ((useAvroLogicalTypes = configRow.getBoolean("use_avro_logical_types")) != null) {
                    builder = builder.setUseAvroLogicalTypes(useAvroLogicalTypes);
                }
                if ((projectionPushdownApplied = configRow.getBoolean("projection_pushdown_applied")) != null) {
                    builder = builder.setProjectionPushdownApplied(projectionPushdownApplied);
                }
                if (TransformUpgrader.compareVersions((String)updateCompatibilityBeamVersion, (String)"2.55.0") < 0) {
                    builder.setBadRecordRouter(BadRecordRouter.THROWING_ROUTER);
                    builder.setBadRecordErrorHandler((ErrorHandler<BadRecord, ?>)new ErrorHandler.DefaultErrorHandler());
                } else {
                    byte[] badRecordRouter = configRow.getBytes("bad_record_router");
                    builder.setBadRecordRouter((BadRecordRouter)TransformUpgrader.fromByteArray((byte[])badRecordRouter));
                    byte[] badRecordErrorHandler = configRow.getBytes("bad_record_error_handler");
                    builder.setBadRecordErrorHandler((ErrorHandler)TransformUpgrader.fromByteArray((byte[])badRecordErrorHandler));
                }
                return builder.build();
            }
            catch (InvalidClassException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

