/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsublite.internal;

import com.google.auto.value.AutoValue;
import com.google.protobuf.ByteString;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Base64;
import java.util.UUID;
import org.apache.beam.sdk.coders.DefaultCoder;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.AutoValue_Uuid;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.UuidCoder;
import org.apache.beam.sdk.util.ByteStringOutputStream;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@DefaultCoder(value=UuidCoder.class)
@AutoValue
public abstract class Uuid {
    public static final @UnknownKeyFor @NonNull @Initialized String DEFAULT_ATTRIBUTE = "x-goog-pubsublite-dataflow-uuid";

    public abstract @UnknownKeyFor @NonNull @Initialized ByteString value();

    public static @UnknownKeyFor @NonNull @Initialized Uuid of(@UnknownKeyFor @NonNull @Initialized ByteString value) {
        return new AutoValue_Uuid(value);
    }

    public static @UnknownKeyFor @NonNull @Initialized Uuid random() {
        UUID uuid = UUID.randomUUID();
        ByteStringOutputStream output = new ByteStringOutputStream(16);
        DataOutputStream stream = new DataOutputStream((OutputStream)output);
        try {
            stream.writeLong(uuid.getMostSignificantBits());
            stream.writeLong(uuid.getLeastSignificantBits());
        }
        catch (IOException e) {
            throw new RuntimeException("Should never have an IOException since there is no io.", e);
        }
        return Uuid.of(ByteString.copyFrom((ByteBuffer)Base64.getEncoder().encode(output.toByteString().asReadOnlyByteBuffer())));
    }
}

