/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.healthcare;

import java.util.Map;
import java.util.Objects;
import org.apache.beam.sdk.coders.DefaultCoder;
import org.apache.beam.sdk.io.gcp.healthcare.FhirSearchParameterCoder;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

@DefaultCoder(value=FhirSearchParameterCoder.class)
public class FhirSearchParameter<@UnknownKeyFor T> {
    private final @UnknownKeyFor @NonNull @Initialized String resourceType;
    private final @UnknownKeyFor @NonNull @Initialized String key;
    private final @Nullable @UnknownKeyFor @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, T> queries;

    private FhirSearchParameter(@UnknownKeyFor @NonNull @Initialized String resourceType, @Nullable @UnknownKeyFor @Initialized String key, @Nullable @UnknownKeyFor @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, T> queries) {
        this.resourceType = resourceType;
        this.key = key != null ? key : "";
        this.queries = queries;
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized FhirSearchParameter<T> of(@UnknownKeyFor @NonNull @Initialized String resourceType, @Nullable @UnknownKeyFor @Initialized String key, @Nullable @UnknownKeyFor @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, T> queries) {
        return new FhirSearchParameter<T>(resourceType, key, queries);
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized FhirSearchParameter<T> of(@UnknownKeyFor @NonNull @Initialized String resourceType, @Nullable @UnknownKeyFor @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, T> queries) {
        return new FhirSearchParameter<T>(resourceType, null, queries);
    }

    public @UnknownKeyFor @NonNull @Initialized String getResourceType() {
        return this.resourceType;
    }

    public @UnknownKeyFor @NonNull @Initialized String getKey() {
        return this.key;
    }

    public @Nullable @UnknownKeyFor @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, T> getQueries() {
        return this.queries;
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FhirSearchParameter that = (FhirSearchParameter)o;
        return Objects.equals(this.resourceType, that.resourceType) && Objects.equals(this.key, that.key) && Objects.equals(this.queries, that.queries);
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return Objects.hash(this.resourceType, this.queries);
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return String.format("FhirSearchParameter{resourceType='%s', key='%s', queries='%s'}'", this.resourceType, this.key, this.queries);
    }
}

