/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner;

import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.FixedHeaderProvider;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.ServerStreamingCallSettings;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.auth.Credentials;
import com.google.cloud.NoCredentials;
import com.google.cloud.ServiceFactory;
import com.google.cloud.spanner.BatchClient;
import com.google.cloud.spanner.DatabaseAdminClient;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.v1.stub.SpannerStubSettings;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.beam.sdk.io.gcp.spanner.SpannerConfig;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.util.ReleaseInfo;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.threeten.bp.Duration;

public class SpannerAccessor
implements AutoCloseable {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(SpannerAccessor.class);
    private static final @UnknownKeyFor @NonNull @Initialized String USER_AGENT_PREFIX = "Apache_Beam_Java";
    private static final @UnknownKeyFor @NonNull @Initialized ConcurrentHashMap<@UnknownKeyFor @NonNull @Initialized SpannerConfig, @UnknownKeyFor @NonNull @Initialized SpannerAccessor> spannerAccessors = new ConcurrentHashMap();
    private final @UnknownKeyFor @NonNull @Initialized Spanner spanner;
    private final @UnknownKeyFor @NonNull @Initialized DatabaseClient databaseClient;
    private final @UnknownKeyFor @NonNull @Initialized BatchClient batchClient;
    private final @UnknownKeyFor @NonNull @Initialized DatabaseAdminClient databaseAdminClient;
    private final @UnknownKeyFor @NonNull @Initialized SpannerConfig spannerConfig;
    private @UnknownKeyFor @NonNull @Initialized int refcount = 0;

    private SpannerAccessor(@UnknownKeyFor @NonNull @Initialized Spanner spanner, @UnknownKeyFor @NonNull @Initialized DatabaseClient databaseClient, @UnknownKeyFor @NonNull @Initialized DatabaseAdminClient databaseAdminClient, @UnknownKeyFor @NonNull @Initialized BatchClient batchClient, @UnknownKeyFor @NonNull @Initialized SpannerConfig spannerConfig) {
        this.spanner = spanner;
        this.databaseClient = databaseClient;
        this.databaseAdminClient = databaseAdminClient;
        this.batchClient = batchClient;
        this.spannerConfig = spannerConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static @UnknownKeyFor @NonNull @Initialized SpannerAccessor getOrCreate(@UnknownKeyFor @NonNull @Initialized SpannerConfig spannerConfig) {
        ConcurrentHashMap<SpannerConfig, SpannerAccessor> concurrentHashMap = spannerAccessors;
        synchronized (concurrentHashMap) {
            SpannerAccessor self = spannerAccessors.get(spannerConfig);
            if (self == null) {
                LOG.info("Connecting to {}", (Object)spannerConfig);
                self = SpannerAccessor.createAndConnect(spannerConfig);
                LOG.info("Successfully connected to {}", (Object)spannerConfig);
                spannerAccessors.put(spannerConfig, self);
            }
            ++self.refcount;
            LOG.debug("getOrCreate(): refcount={} for {}", (Object)self.refcount, (Object)spannerConfig);
            return self;
        }
    }

    private static @UnknownKeyFor @NonNull @Initialized SpannerAccessor createAndConnect(@UnknownKeyFor @NonNull @Initialized SpannerConfig spannerConfig) {
        ValueProvider<String> emulatorHost;
        ValueProvider<String> host;
        ServiceFactory<Spanner, SpannerOptions> serviceFactory;
        ValueProvider<String> projectId;
        ValueProvider<org.joda.time.Duration> partitionReadTimeout;
        SpannerOptions.Builder builder = SpannerOptions.newBuilder();
        HashSet<StatusCode.Code> retryableCodes = new HashSet<StatusCode.Code>();
        if (spannerConfig.getRetryableCodes() != null) {
            retryableCodes.addAll((Collection<StatusCode.Code>)spannerConfig.getRetryableCodes());
        }
        if (spannerConfig.getDataBoostEnabled() != null && ((Boolean)spannerConfig.getDataBoostEnabled().get()).booleanValue()) {
            retryableCodes.add(StatusCode.Code.RESOURCE_EXHAUSTED);
        }
        HashSet unaryMethodRetryableCodes = new HashSet(retryableCodes);
        unaryMethodRetryableCodes.addAll(builder.getSpannerStubSettingsBuilder().getSessionSettings().getRetryableCodes());
        builder.getSpannerStubSettingsBuilder().applyToAllUnaryMethods(input -> {
            input.setRetryableCodes(unaryMethodRetryableCodes);
            return null;
        });
        HashSet streamingMethodRetryableCodes = new HashSet(retryableCodes);
        streamingMethodRetryableCodes.addAll(builder.getSpannerStubSettingsBuilder().executeStreamingSqlSettings().getRetryableCodes());
        builder.getSpannerStubSettingsBuilder().executeStreamingSqlSettings().setRetryableCodes(streamingMethodRetryableCodes);
        builder.getSpannerStubSettingsBuilder().streamingReadSettings().setRetryableCodes(streamingMethodRetryableCodes);
        UnaryCallSettings.Builder commitSettings = builder.getSpannerStubSettingsBuilder().commitSettings();
        ValueProvider<org.joda.time.Duration> commitDeadline = spannerConfig.getCommitDeadline();
        if (spannerConfig.getCommitRetrySettings() != null) {
            commitSettings.setRetrySettings(spannerConfig.getCommitRetrySettings());
        } else if (commitDeadline != null && ((org.joda.time.Duration)commitDeadline.get()).getMillis() > 0L) {
            RetrySettings.Builder commitRetrySettingsBuilder = commitSettings.getRetrySettings().toBuilder();
            commitSettings.setRetrySettings(commitRetrySettingsBuilder.setTotalTimeout(Duration.ofMillis((long)((org.joda.time.Duration)commitDeadline.get()).getMillis())).setMaxRpcTimeout(Duration.ofMillis((long)((org.joda.time.Duration)commitDeadline.get()).getMillis())).setInitialRpcTimeout(Duration.ofMillis((long)((org.joda.time.Duration)commitDeadline.get()).getMillis())).build());
        }
        ServerStreamingCallSettings.Builder executeStreamingSqlSettings = builder.getSpannerStubSettingsBuilder().executeStreamingSqlSettings();
        if (spannerConfig.getExecuteStreamingSqlRetrySettings() != null) {
            executeStreamingSqlSettings.setRetrySettings(spannerConfig.getExecuteStreamingSqlRetrySettings());
        } else {
            RetrySettings.Builder executeSqlStreamingRetrySettings = executeStreamingSqlSettings.getRetrySettings().toBuilder();
            executeStreamingSqlSettings.setRetrySettings(executeSqlStreamingRetrySettings.setInitialRpcTimeout(Duration.ofMinutes((long)120L)).setMaxRpcTimeout(Duration.ofMinutes((long)120L)).setTotalTimeout(Duration.ofMinutes((long)120L)).build());
        }
        SpannerStubSettings.Builder spannerStubSettingsBuilder = builder.getSpannerStubSettingsBuilder();
        ValueProvider<org.joda.time.Duration> partitionQueryTimeout = spannerConfig.getPartitionQueryTimeout();
        if (partitionQueryTimeout != null && partitionQueryTimeout.get() != null && ((org.joda.time.Duration)partitionQueryTimeout.get()).getMillis() > 0L) {
            spannerStubSettingsBuilder.partitionQuerySettings().setSimpleTimeoutNoRetries(Duration.ofMillis((long)((org.joda.time.Duration)partitionQueryTimeout.get()).getMillis()));
        }
        if ((partitionReadTimeout = spannerConfig.getPartitionReadTimeout()) != null && partitionReadTimeout.get() != null && ((org.joda.time.Duration)partitionReadTimeout.get()).getMillis() > 0L) {
            spannerStubSettingsBuilder.partitionReadSettings().setSimpleTimeoutNoRetries(Duration.ofMillis((long)((org.joda.time.Duration)partitionReadTimeout.get()).getMillis()));
        }
        if ((projectId = spannerConfig.getProjectId()) != null) {
            builder.setProjectId((String)projectId.get());
        }
        if ((serviceFactory = spannerConfig.getServiceFactory()) != null) {
            builder.setServiceFactory(serviceFactory);
        }
        if ((host = spannerConfig.getHost()) != null) {
            builder.setHost((String)host.get());
        }
        if ((emulatorHost = spannerConfig.getEmulatorHost()) != null) {
            builder.setEmulatorHost((String)emulatorHost.get());
            if (spannerConfig.getIsLocalChannelProvider() != null && ((Boolean)spannerConfig.getIsLocalChannelProvider().get()).booleanValue()) {
                builder.setChannelProvider((TransportChannelProvider)LocalChannelProvider.create((String)((String)emulatorHost.get())));
            }
            builder.setCredentials((Credentials)NoCredentials.getInstance());
        }
        String userAgentString = "Apache_Beam_Java/" + ReleaseInfo.getReleaseInfo().getVersion();
        builder.setHeaderProvider((HeaderProvider)FixedHeaderProvider.create((String[])new String[]{"user-agent", userAgentString}));
        ValueProvider<String> databaseRole = spannerConfig.getDatabaseRole();
        if (databaseRole != null && databaseRole.get() != null && !((String)databaseRole.get()).isEmpty()) {
            builder.setDatabaseRole((String)databaseRole.get());
        }
        SpannerOptions options = builder.build();
        Spanner spanner = (Spanner)options.getService();
        String instanceId = (String)spannerConfig.getInstanceId().get();
        String databaseId = (String)spannerConfig.getDatabaseId().get();
        DatabaseClient databaseClient = spanner.getDatabaseClient(DatabaseId.of((String)options.getProjectId(), (String)instanceId, (String)databaseId));
        BatchClient batchClient = spanner.getBatchClient(DatabaseId.of((String)options.getProjectId(), (String)instanceId, (String)databaseId));
        DatabaseAdminClient databaseAdminClient = spanner.getDatabaseAdminClient();
        return new SpannerAccessor(spanner, databaseClient, databaseAdminClient, batchClient, spannerConfig);
    }

    public @UnknownKeyFor @NonNull @Initialized DatabaseClient getDatabaseClient() {
        return this.databaseClient;
    }

    public @UnknownKeyFor @NonNull @Initialized BatchClient getBatchClient() {
        return this.batchClient;
    }

    public @UnknownKeyFor @NonNull @Initialized DatabaseAdminClient getDatabaseAdminClient() {
        return this.databaseAdminClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        ConcurrentHashMap<SpannerConfig, SpannerAccessor> concurrentHashMap = spannerAccessors;
        synchronized (concurrentHashMap) {
            --this.refcount;
            LOG.debug("close(): refcount={} for {}", (Object)this.refcount, (Object)this.spannerConfig);
            if (this.refcount <= 0) {
                spannerAccessors.remove(this.spannerConfig);
                LOG.info("Closing {} ", (Object)this.spannerConfig);
                this.spanner.close();
            }
        }
    }
}

