/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.auto.value.AutoValue;
import io.grpc.Status;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.NavigableMap;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.beam.sdk.io.gcp.bigquery.AutoValue_BigQuerySinkMetrics_ParsedMetricName;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.DelegatingCounter;
import org.apache.beam.sdk.metrics.DelegatingHistogram;
import org.apache.beam.sdk.metrics.Histogram;
import org.apache.beam.sdk.metrics.MetricName;
import org.apache.beam.sdk.util.HistogramData;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Splitter;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class BigQuerySinkMetrics {
    private static @UnknownKeyFor @NonNull @Initialized Boolean supportMetricsDeletion = false;
    public static final @UnknownKeyFor @NonNull @Initialized String METRICS_NAMESPACE = "BigQuerySink";
    private static final @UnknownKeyFor @NonNull @Initialized String UNKNOWN = Status.Code.UNKNOWN.toString();
    public static final @UnknownKeyFor @NonNull @Initialized String OK = Status.Code.OK.toString();
    public static final @UnknownKeyFor @NonNull @Initialized String PAYLOAD_TOO_LARGE = "PayloadTooLarge";
    private static final @UnknownKeyFor @NonNull @Initialized String RPC_REQUESTS = "RpcRequests";
    private static final @UnknownKeyFor @NonNull @Initialized String RPC_LATENCY = "RpcLatency";
    private static final @UnknownKeyFor @NonNull @Initialized String APPEND_ROWS_ROW_STATUS = "AppendRowsRowStatus";
    private static final @UnknownKeyFor @NonNull @Initialized String THROTTLED_TIME = "ThrottledTime";
    private static final @UnknownKeyFor @NonNull @Initialized String TABLE_ID_LABEL = "TableId";
    private static final @UnknownKeyFor @NonNull @Initialized String RPC_STATUS_LABEL = "RpcStatus";
    private static final @UnknownKeyFor @NonNull @Initialized String RPC_METHOD = "Method";
    private static final @UnknownKeyFor @NonNull @Initialized String ROW_STATUS = "RowStatus";
    private static final @UnknownKeyFor @NonNull @Initialized char LABEL_DELIMITER = ';';
    private static final @UnknownKeyFor @NonNull @Initialized char METRIC_KV_DELIMITER = ':';
    private static final @UnknownKeyFor @NonNull @Initialized char METRIC_NAME_DELIMITER = '-';

    private static @UnknownKeyFor @NonNull @Initialized String createLabeledMetricName(@UnknownKeyFor @NonNull @Initialized String baseName, @UnknownKeyFor @NonNull @Initialized NavigableMap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> metricLabels) {
        StringBuilder nameBuilder = new StringBuilder(baseName + '-');
        metricLabels.forEach((labelKey, labelVal) -> nameBuilder.append(labelKey + ':' + labelVal + ';'));
        return nameBuilder.toString();
    }

    @Nullable
    public static @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized ParsedMetricName parseMetricName(@UnknownKeyFor @NonNull @Initialized String metricName) {
        if (metricName.isEmpty()) {
            return null;
        }
        List metricNameSplit = Splitter.on((char)'-').splitToList((CharSequence)metricName);
        ImmutableMap.Builder metricLabelsBuilder = ImmutableMap.builder();
        if (metricNameSplit.size() == 1) {
            return ParsedMetricName.create((String)metricNameSplit.get(0));
        }
        if (metricNameSplit.size() != 2) {
            return null;
        }
        List labels = Splitter.on((char)';').splitToList((CharSequence)metricNameSplit.get(1));
        for (String label : labels) {
            List kv = Splitter.on((char)':').splitToList((CharSequence)label);
            if (kv.size() != 2) continue;
            metricLabelsBuilder.put((Object)((String)kv.get(0)), (Object)((String)kv.get(1)));
        }
        return ParsedMetricName.create((String)metricNameSplit.get(0), (ImmutableMap<String, String>)metricLabelsBuilder.build());
    }

    private static @UnknownKeyFor @NonNull @Initialized Counter createRPCRequestCounter(@UnknownKeyFor @NonNull @Initialized RpcMethod method, @UnknownKeyFor @NonNull @Initialized String rpcStatus, @UnknownKeyFor @NonNull @Initialized String tableId) {
        TreeMap<String, String> metricLabels = new TreeMap<String, String>();
        metricLabels.put(RPC_STATUS_LABEL, rpcStatus);
        metricLabels.put(RPC_METHOD, method.toString());
        if (supportMetricsDeletion.booleanValue()) {
            metricLabels.put(TABLE_ID_LABEL, tableId);
        }
        String fullMetricName = BigQuerySinkMetrics.createLabeledMetricName(RPC_REQUESTS, metricLabels);
        MetricName metricName = MetricName.named((String)METRICS_NAMESPACE, (String)fullMetricName);
        return new DelegatingCounter(metricName, false, true);
    }

    private static @UnknownKeyFor @NonNull @Initialized Histogram createRPCLatencyHistogram(@UnknownKeyFor @NonNull @Initialized RpcMethod method) {
        TreeMap<String, String> metricLabels = new TreeMap<String, String>();
        metricLabels.put(RPC_METHOD, method.toString());
        String fullMetricName = BigQuerySinkMetrics.createLabeledMetricName(RPC_LATENCY, metricLabels);
        MetricName metricName = MetricName.named((String)METRICS_NAMESPACE, (String)fullMetricName);
        HistogramData.ExponentialBuckets buckets = HistogramData.ExponentialBuckets.of((int)1, (int)34);
        return new DelegatingHistogram(metricName, (HistogramData.BucketType)buckets, false, true);
    }

    private static void updateRpcLatencyMetric(@Nonnull /*
     * Issues handling annotations - annotations may be inaccurate
     */
     @UnknownKeyFor @NonNull @Initialized RetryManager.Operation.Context<@UnknownKeyFor @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized @NonNull @Initialized ?> c, @UnknownKeyFor @NonNull @Initialized RpcMethod method) {
        Instant operationStartTime = c.getOperationStartTime();
        Instant operationEndTime = c.getOperationEndTime();
        if (operationStartTime == null || operationEndTime == null) {
            return;
        }
        long timeElapsed = Duration.between(operationStartTime, operationEndTime).toMillis();
        if (timeElapsed > 0L) {
            BigQuerySinkMetrics.createRPCLatencyHistogram(method).update((double)timeElapsed);
        }
    }

    public static @UnknownKeyFor @NonNull @Initialized Counter appendRowsRowStatusCounter(@UnknownKeyFor @NonNull @Initialized RowStatus rowStatus, @UnknownKeyFor @NonNull @Initialized String rpcStatus, @UnknownKeyFor @NonNull @Initialized String tableId) {
        TreeMap<String, String> metricLabels = new TreeMap<String, String>();
        metricLabels.put(RPC_STATUS_LABEL, rpcStatus);
        metricLabels.put(ROW_STATUS, rowStatus.toString());
        if (supportMetricsDeletion.booleanValue()) {
            metricLabels.put(TABLE_ID_LABEL, tableId);
        }
        String fullMetricName = BigQuerySinkMetrics.createLabeledMetricName(APPEND_ROWS_ROW_STATUS, metricLabels);
        MetricName metricName = MetricName.named((String)METRICS_NAMESPACE, (String)fullMetricName);
        return new DelegatingCounter(metricName, false, true);
    }

    public static @UnknownKeyFor @NonNull @Initialized Counter throttledTimeCounter(@UnknownKeyFor @NonNull @Initialized RpcMethod method) {
        TreeMap<String, String> metricLabels = new TreeMap<String, String>();
        metricLabels.put(RPC_METHOD, method.toString());
        String fullMetricName = BigQuerySinkMetrics.createLabeledMetricName(THROTTLED_TIME, metricLabels);
        MetricName metricName = MetricName.named((String)METRICS_NAMESPACE, (String)fullMetricName);
        return new DelegatingCounter(metricName, false, true);
    }

    public static @UnknownKeyFor @NonNull @Initialized String throwableToGRPCCodeString(@Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Throwable t) {
        if (t == null) {
            return UNKNOWN;
        }
        return Status.fromThrowable((Throwable)t).getCode().toString();
    }

    public static void reportSuccessfulRpcMetrics(@Nullable /*
     * Issues handling annotations - annotations may be inaccurate
     */
     @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized RetryManager.Operation.Context<@UnknownKeyFor @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized @NonNull @Initialized ?> c, @UnknownKeyFor @NonNull @Initialized RpcMethod method) {
        BigQuerySinkMetrics.reportSuccessfulRpcMetrics(c, method, UNKNOWN);
    }

    public static void reportSuccessfulRpcMetrics(@Nullable /*
     * Issues handling annotations - annotations may be inaccurate
     */
     @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized RetryManager.Operation.Context<@UnknownKeyFor @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized @NonNull @Initialized ?> c, @UnknownKeyFor @NonNull @Initialized RpcMethod method, @UnknownKeyFor @NonNull @Initialized String tableId) {
        if (c == null) {
            return;
        }
        BigQuerySinkMetrics.createRPCRequestCounter(method, OK, tableId).inc(1L);
        BigQuerySinkMetrics.updateRpcLatencyMetric(c, method);
    }

    public static void reportFailedRPCMetrics(@Nullable /*
     * Issues handling annotations - annotations may be inaccurate
     */
     @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized RetryManager.Operation.Context<@UnknownKeyFor @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized @NonNull @Initialized ?> c, @UnknownKeyFor @NonNull @Initialized RpcMethod method) {
        BigQuerySinkMetrics.reportFailedRPCMetrics(c, method, UNKNOWN);
    }

    public static void reportFailedRPCMetrics(@Nullable /*
     * Issues handling annotations - annotations may be inaccurate
     */
     @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized RetryManager.Operation.Context<@UnknownKeyFor @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized @NonNull @Initialized ?> c, @UnknownKeyFor @NonNull @Initialized RpcMethod method, @UnknownKeyFor @NonNull @Initialized String tableId) {
        if (c == null) {
            return;
        }
        String statusCode = BigQuerySinkMetrics.throwableToGRPCCodeString(c.getError());
        BigQuerySinkMetrics.createRPCRequestCounter(method, statusCode, tableId).inc(1L);
        BigQuerySinkMetrics.updateRpcLatencyMetric(c, method);
    }

    public static void setSupportMetricsDeletion(@UnknownKeyFor @NonNull @Initialized Boolean supportMetricsDeletion) {
        BigQuerySinkMetrics.supportMetricsDeletion = supportMetricsDeletion;
    }

    @AutoValue
    public static abstract class ParsedMetricName {
        public abstract @UnknownKeyFor @NonNull @Initialized String getBaseName();

        public abstract @UnknownKeyFor @NonNull @Initialized ImmutableMap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> getMetricLabels();

        public static @UnknownKeyFor @NonNull @Initialized ParsedMetricName create(@UnknownKeyFor @NonNull @Initialized String baseName, @UnknownKeyFor @NonNull @Initialized ImmutableMap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> metricLabels) {
            return new AutoValue_BigQuerySinkMetrics_ParsedMetricName(baseName, metricLabels);
        }

        public static @UnknownKeyFor @NonNull @Initialized ParsedMetricName create(@UnknownKeyFor @NonNull @Initialized String baseName) {
            ImmutableMap emptyMap = ImmutableMap.of();
            return new AutoValue_BigQuerySinkMetrics_ParsedMetricName(baseName, (ImmutableMap<String, String>)emptyMap);
        }
    }

    static enum RowStatus {
        SUCCESSFUL,
        RETRIED,
        FAILED;

    }

    static enum RpcMethod {
        APPEND_ROWS,
        FLUSH_ROWS,
        FINALIZE_STREAM;

    }
}

