/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsub;

import com.google.api.client.util.Clock;
import javax.annotation.Nullable;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubReadSchemaTransformConfiguration;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubTestClient;
import org.apache.beam.sdk.schemas.annotations.SchemaFieldDescription;

final class AutoValue_PubsubReadSchemaTransformConfiguration
extends PubsubReadSchemaTransformConfiguration {
    private final String topic;
    private final String subscription;
    private final String format;
    private final String schema;
    private final PubsubTestClient.PubsubTestClientFactory clientFactory;
    private final Clock clock;

    private AutoValue_PubsubReadSchemaTransformConfiguration(@Nullable String topic, @Nullable String subscription, String format, String schema, @Nullable PubsubTestClient.PubsubTestClientFactory clientFactory, @Nullable Clock clock) {
        this.topic = topic;
        this.subscription = subscription;
        this.format = format;
        this.schema = schema;
        this.clientFactory = clientFactory;
        this.clock = clock;
    }

    @Override
    @Nullable
    @SchemaFieldDescription(value="The name of the topic to consume data from. If a topic is specified,  will create a new subscription for that topic and start consuming from that point. Either a topic or a subscription must be provided. Format: projects/${PROJECT}/topics/${TOPIC}")
    public String getTopic() {
        return this.topic;
    }

    @Override
    @Nullable
    @SchemaFieldDescription(value="The name of the subscription to consume data. Either a topic or subscription must be provided. Format: projects/${PROJECT}/subscriptions/${SUBSCRIPTION}")
    public String getSubscription() {
        return this.subscription;
    }

    @Override
    @SchemaFieldDescription(value="The encoding format for the data stored in Pubsub. Valid options are: AVRO,JSON")
    public String getFormat() {
        return this.format;
    }

    @Override
    @SchemaFieldDescription(value="The schema in which the data is encoded in the Pubsub topic. For AVRO data, this is a schema defined with AVRO schema syntax (https://avro.apache.org/docs/1.10.2/spec.html#schemas). For JSON data, this is a schema defined with JSON-schema syntax (https://json-schema.org/).")
    public String getSchema() {
        return this.schema;
    }

    @Override
    @Nullable
    public PubsubTestClient.PubsubTestClientFactory getClientFactory() {
        return this.clientFactory;
    }

    @Override
    @Nullable
    public Clock getClock() {
        return this.clock;
    }

    public String toString() {
        return "PubsubReadSchemaTransformConfiguration{topic=" + this.topic + ", subscription=" + this.subscription + ", format=" + this.format + ", schema=" + this.schema + ", clientFactory=" + this.clientFactory + ", clock=" + this.clock + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof PubsubReadSchemaTransformConfiguration) {
            PubsubReadSchemaTransformConfiguration that = (PubsubReadSchemaTransformConfiguration)o;
            return (this.topic == null ? that.getTopic() == null : this.topic.equals(that.getTopic())) && (this.subscription == null ? that.getSubscription() == null : this.subscription.equals(that.getSubscription())) && this.format.equals(that.getFormat()) && this.schema.equals(that.getSchema()) && (this.clientFactory == null ? that.getClientFactory() == null : this.clientFactory.equals(that.getClientFactory())) && (this.clock == null ? that.getClock() == null : this.clock.equals(that.getClock()));
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.topic == null ? 0 : this.topic.hashCode();
        h$ *= 1000003;
        h$ ^= this.subscription == null ? 0 : this.subscription.hashCode();
        h$ *= 1000003;
        h$ ^= this.format.hashCode();
        h$ *= 1000003;
        h$ ^= this.schema.hashCode();
        h$ *= 1000003;
        h$ ^= this.clientFactory == null ? 0 : this.clientFactory.hashCode();
        h$ *= 1000003;
        return h$ ^= this.clock == null ? 0 : this.clock.hashCode();
    }

    static final class Builder
    extends PubsubReadSchemaTransformConfiguration.Builder {
        private String topic;
        private String subscription;
        private String format;
        private String schema;
        private PubsubTestClient.PubsubTestClientFactory clientFactory;
        private Clock clock;

        Builder() {
        }

        @Override
        public PubsubReadSchemaTransformConfiguration.Builder setTopic(@Nullable String topic) {
            this.topic = topic;
            return this;
        }

        @Override
        public PubsubReadSchemaTransformConfiguration.Builder setSubscription(@Nullable String subscription) {
            this.subscription = subscription;
            return this;
        }

        @Override
        public PubsubReadSchemaTransformConfiguration.Builder setFormat(String format) {
            if (format == null) {
                throw new NullPointerException("Null format");
            }
            this.format = format;
            return this;
        }

        @Override
        public PubsubReadSchemaTransformConfiguration.Builder setSchema(String schema) {
            if (schema == null) {
                throw new NullPointerException("Null schema");
            }
            this.schema = schema;
            return this;
        }

        @Override
        public PubsubReadSchemaTransformConfiguration.Builder setClientFactory(@Nullable PubsubTestClient.PubsubTestClientFactory clientFactory) {
            this.clientFactory = clientFactory;
            return this;
        }

        @Override
        public PubsubReadSchemaTransformConfiguration.Builder setClock(@Nullable Clock clock) {
            this.clock = clock;
            return this;
        }

        @Override
        public PubsubReadSchemaTransformConfiguration build() {
            if (this.format == null || this.schema == null) {
                StringBuilder missing = new StringBuilder();
                if (this.format == null) {
                    missing.append(" format");
                }
                if (this.schema == null) {
                    missing.append(" schema");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_PubsubReadSchemaTransformConfiguration(this.topic, this.subscription, this.format, this.schema, this.clientFactory, this.clock);
        }
    }
}

