/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsublite;

import org.apache.beam.sdk.io.gcp.pubsublite.PubsubLiteReadSchemaTransformProvider;
import org.apache.beam.sdk.schemas.annotations.SchemaFieldDescription;
import org.checkerframework.checker.nullness.qual.Nullable;

final class AutoValue_PubsubLiteReadSchemaTransformProvider_PubsubLiteReadSchemaTransformConfiguration
extends PubsubLiteReadSchemaTransformProvider.PubsubLiteReadSchemaTransformConfiguration {
    private final String format;
    private final String schema;
    private final @Nullable String project;
    private final String subscriptionName;
    private final String location;

    private AutoValue_PubsubLiteReadSchemaTransformProvider_PubsubLiteReadSchemaTransformConfiguration(String format, String schema, @Nullable String project, String subscriptionName, String location) {
        this.format = format;
        this.schema = schema;
        this.project = project;
        this.subscriptionName = subscriptionName;
        this.location = location;
    }

    @Override
    @SchemaFieldDescription(value="The encoding format for the data stored in Pubsub Lite. Valid options are: AVRO,JSON")
    public String getFormat() {
        return this.format;
    }

    @Override
    @SchemaFieldDescription(value="The schema in which the data is encoded in the Kafka topic. For AVRO data, this is a schema defined with AVRO schema syntax (https://avro.apache.org/docs/1.10.2/spec.html#schemas). For JSON data, this is a schema defined with JSON-schema syntax (https://json-schema.org/).")
    public String getSchema() {
        return this.schema;
    }

    @Override
    @SchemaFieldDescription(value="The GCP project where the Pubsub Lite reservation resides. This can be a project number of a project ID.")
    public @Nullable String getProject() {
        return this.project;
    }

    @Override
    @SchemaFieldDescription(value="The name of the subscription to consume data. This will be concatenated with the project and location parameters to build a full subscription path.")
    public String getSubscriptionName() {
        return this.subscriptionName;
    }

    @Override
    @SchemaFieldDescription(value="The region or zone where the Pubsub Lite reservation resides.")
    public String getLocation() {
        return this.location;
    }

    public String toString() {
        return "PubsubLiteReadSchemaTransformConfiguration{format=" + this.format + ", schema=" + this.schema + ", project=" + this.project + ", subscriptionName=" + this.subscriptionName + ", location=" + this.location + "}";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof PubsubLiteReadSchemaTransformProvider.PubsubLiteReadSchemaTransformConfiguration) {
            PubsubLiteReadSchemaTransformProvider.PubsubLiteReadSchemaTransformConfiguration that = (PubsubLiteReadSchemaTransformProvider.PubsubLiteReadSchemaTransformConfiguration)o;
            return this.format.equals(that.getFormat()) && this.schema.equals(that.getSchema()) && (this.project == null ? that.getProject() == null : this.project.equals(that.getProject())) && this.subscriptionName.equals(that.getSubscriptionName()) && this.location.equals(that.getLocation());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.format.hashCode();
        h$ *= 1000003;
        h$ ^= this.schema.hashCode();
        h$ *= 1000003;
        h$ ^= this.project == null ? 0 : this.project.hashCode();
        h$ *= 1000003;
        h$ ^= this.subscriptionName.hashCode();
        h$ *= 1000003;
        return h$ ^= this.location.hashCode();
    }

    static final class Builder
    extends PubsubLiteReadSchemaTransformProvider.PubsubLiteReadSchemaTransformConfiguration.Builder {
        private String format;
        private String schema;
        private @Nullable String project;
        private String subscriptionName;
        private String location;

        Builder() {
        }

        @Override
        public PubsubLiteReadSchemaTransformProvider.PubsubLiteReadSchemaTransformConfiguration.Builder setFormat(String format) {
            if (format == null) {
                throw new NullPointerException("Null format");
            }
            this.format = format;
            return this;
        }

        @Override
        public PubsubLiteReadSchemaTransformProvider.PubsubLiteReadSchemaTransformConfiguration.Builder setSchema(String schema) {
            if (schema == null) {
                throw new NullPointerException("Null schema");
            }
            this.schema = schema;
            return this;
        }

        @Override
        public PubsubLiteReadSchemaTransformProvider.PubsubLiteReadSchemaTransformConfiguration.Builder setProject(String project) {
            this.project = project;
            return this;
        }

        @Override
        public PubsubLiteReadSchemaTransformProvider.PubsubLiteReadSchemaTransformConfiguration.Builder setSubscriptionName(String subscriptionName) {
            if (subscriptionName == null) {
                throw new NullPointerException("Null subscriptionName");
            }
            this.subscriptionName = subscriptionName;
            return this;
        }

        @Override
        public PubsubLiteReadSchemaTransformProvider.PubsubLiteReadSchemaTransformConfiguration.Builder setLocation(String location) {
            if (location == null) {
                throw new NullPointerException("Null location");
            }
            this.location = location;
            return this;
        }

        @Override
        public PubsubLiteReadSchemaTransformProvider.PubsubLiteReadSchemaTransformConfiguration build() {
            if (this.format == null || this.schema == null || this.subscriptionName == null || this.location == null) {
                StringBuilder missing = new StringBuilder();
                if (this.format == null) {
                    missing.append(" format");
                }
                if (this.schema == null) {
                    missing.append(" schema");
                }
                if (this.subscriptionName == null) {
                    missing.append(" subscriptionName");
                }
                if (this.location == null) {
                    missing.append(" location");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_PubsubLiteReadSchemaTransformProvider_PubsubLiteReadSchemaTransformConfiguration(this.format, this.schema, this.project, this.subscriptionName, this.location);
        }
    }
}

