/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.TableFieldSchema;
import com.google.api.services.bigquery.model.TableRow;
import com.google.api.services.bigquery.model.TableSchema;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.avro.Conversions;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.MoreObjects;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Verify;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableCollection;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMultimap;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.io.BaseEncoding;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

class BigQueryAvroUtils {
    static final @UnknownKeyFor @NonNull @Initialized ImmutableMultimap<@UnknownKeyFor @NonNull @Initialized String, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.Type> BIG_QUERY_TO_AVRO_TYPES = ImmutableMultimap.builder().put((Object)"STRING", (Object)Schema.Type.STRING).put((Object)"GEOGRAPHY", (Object)Schema.Type.STRING).put((Object)"BYTES", (Object)Schema.Type.BYTES).put((Object)"INTEGER", (Object)Schema.Type.LONG).put((Object)"INT64", (Object)Schema.Type.LONG).put((Object)"FLOAT", (Object)Schema.Type.DOUBLE).put((Object)"FLOAT64", (Object)Schema.Type.DOUBLE).put((Object)"NUMERIC", (Object)Schema.Type.BYTES).put((Object)"BIGNUMERIC", (Object)Schema.Type.BYTES).put((Object)"BOOLEAN", (Object)Schema.Type.BOOLEAN).put((Object)"BOOL", (Object)Schema.Type.BOOLEAN).put((Object)"TIMESTAMP", (Object)Schema.Type.LONG).put((Object)"RECORD", (Object)Schema.Type.RECORD).put((Object)"STRUCT", (Object)Schema.Type.RECORD).put((Object)"DATE", (Object)Schema.Type.STRING).put((Object)"DATE", (Object)Schema.Type.INT).put((Object)"DATETIME", (Object)Schema.Type.STRING).put((Object)"TIME", (Object)Schema.Type.STRING).put((Object)"TIME", (Object)Schema.Type.LONG).put((Object)"JSON", (Object)Schema.Type.STRING).build();
    private static final @UnknownKeyFor @NonNull @Initialized DateTimeFormatter DATE_AND_SECONDS_FORMATTER = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss").withZoneUTC();
    private static final @UnknownKeyFor @NonNull @Initialized java.time.format.DateTimeFormatter ISO_LOCAL_TIME_FORMATTER_MICROS = new DateTimeFormatterBuilder().appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).appendLiteral('.').appendFraction(ChronoField.NANO_OF_SECOND, 6, 6, false).toFormatter();
    private static final @UnknownKeyFor @NonNull @Initialized java.time.format.DateTimeFormatter ISO_LOCAL_TIME_FORMATTER_MILLIS = new DateTimeFormatterBuilder().appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).appendLiteral('.').appendFraction(ChronoField.NANO_OF_SECOND, 3, 3, false).toFormatter();
    private static final @UnknownKeyFor @NonNull @Initialized java.time.format.DateTimeFormatter ISO_LOCAL_TIME_FORMATTER_SECONDS = new DateTimeFormatterBuilder().appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).toFormatter();

    BigQueryAvroUtils() {
    }

    @VisibleForTesting
    static @UnknownKeyFor @NonNull @Initialized String formatTimestamp(@UnknownKeyFor @NonNull @Initialized Long timestampMicro) {
        long timestampSec = timestampMicro / 1000000L;
        long micros = timestampMicro % 1000000L;
        if (micros < 0L) {
            micros += 1000000L;
            --timestampSec;
        }
        String dayAndTime = DATE_AND_SECONDS_FORMATTER.print(timestampSec * 1000L);
        if (micros == 0L) {
            return String.format("%s UTC", dayAndTime);
        }
        return String.format("%s.%06d UTC", dayAndTime, micros);
    }

    private static @UnknownKeyFor @NonNull @Initialized String formatDate(@UnknownKeyFor @NonNull @Initialized int date) {
        return LocalDate.ofEpochDay(date).format(java.time.format.DateTimeFormatter.ISO_LOCAL_DATE);
    }

    private static @UnknownKeyFor @NonNull @Initialized String formatTime(@UnknownKeyFor @NonNull @Initialized long timeMicros) {
        java.time.format.DateTimeFormatter formatter = timeMicros % 1000000L == 0L ? ISO_LOCAL_TIME_FORMATTER_SECONDS : (timeMicros % 1000L == 0L ? ISO_LOCAL_TIME_FORMATTER_MILLIS : ISO_LOCAL_TIME_FORMATTER_MICROS);
        return LocalTime.ofNanoOfDay(timeMicros * 1000L).format(formatter);
    }

    static @UnknownKeyFor @NonNull @Initialized TableSchema trimBigQueryTableSchema(@UnknownKeyFor @NonNull @Initialized TableSchema inputSchema, @UnknownKeyFor @NonNull @Initialized Schema avroSchema) {
        List subSchemas = inputSchema.getFields().stream().flatMap(fieldSchema -> BigQueryAvroUtils.mapTableFieldSchema(fieldSchema, avroSchema)).collect(Collectors.toList());
        return new TableSchema().setFields(subSchemas);
    }

    private static @UnknownKeyFor @NonNull @Initialized Stream<@UnknownKeyFor @NonNull @Initialized TableFieldSchema> mapTableFieldSchema(@UnknownKeyFor @NonNull @Initialized TableFieldSchema fieldSchema, @UnknownKeyFor @NonNull @Initialized Schema avroSchema) {
        Schema.Field avroFieldSchema = avroSchema.getField(fieldSchema.getName());
        if (avroFieldSchema == null) {
            return Stream.empty();
        }
        if (avroFieldSchema.schema().getType() != Schema.Type.RECORD) {
            return Stream.of(fieldSchema);
        }
        List subSchemas = fieldSchema.getFields().stream().flatMap(subSchema -> BigQueryAvroUtils.mapTableFieldSchema(subSchema, avroFieldSchema.schema())).collect(Collectors.toList());
        TableFieldSchema output = new TableFieldSchema().setCategories(fieldSchema.getCategories()).setDescription(fieldSchema.getDescription()).setFields(subSchemas).setMode(fieldSchema.getMode()).setName(fieldSchema.getName()).setType(fieldSchema.getType());
        return Stream.of(output);
    }

    static @UnknownKeyFor @NonNull @Initialized TableRow convertGenericRecordToTableRow(@UnknownKeyFor @NonNull @Initialized GenericRecord record, @UnknownKeyFor @NonNull @Initialized TableSchema schema) {
        return BigQueryAvroUtils.convertGenericRecordToTableRow(record, schema.getFields());
    }

    private static @UnknownKeyFor @NonNull @Initialized TableRow convertGenericRecordToTableRow(@UnknownKeyFor @NonNull @Initialized GenericRecord record, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized TableFieldSchema> fields) {
        TableRow row = new TableRow();
        for (TableFieldSchema subSchema : fields) {
            Schema.Field field = record.getSchema().getField(subSchema.getName());
            Object convertedValue = BigQueryAvroUtils.getTypedCellValue(field.schema(), subSchema, record.get(field.name()));
            if (convertedValue == null) continue;
            row.set(field.name(), convertedValue);
        }
        return row;
    }

    private static @Nullable @UnknownKeyFor @Initialized Object getTypedCellValue(@UnknownKeyFor @NonNull @Initialized Schema schema, @UnknownKeyFor @NonNull @Initialized TableFieldSchema fieldSchema, @UnknownKeyFor @NonNull @Initialized Object v) {
        String mode;
        switch (mode = (String)MoreObjects.firstNonNull((Object)fieldSchema.getMode(), (Object)"NULLABLE")) {
            case "REQUIRED": {
                return BigQueryAvroUtils.convertRequiredField(schema.getType(), schema.getLogicalType(), fieldSchema, v);
            }
            case "REPEATED": {
                return BigQueryAvroUtils.convertRepeatedField(schema, fieldSchema, v);
            }
            case "NULLABLE": {
                return BigQueryAvroUtils.convertNullableField(schema, fieldSchema, v);
            }
        }
        throw new UnsupportedOperationException("Parsing a field with BigQuery field schema mode " + fieldSchema.getMode());
    }

    private static @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Object> convertRepeatedField(@UnknownKeyFor @NonNull @Initialized Schema schema, @UnknownKeyFor @NonNull @Initialized TableFieldSchema fieldSchema, @UnknownKeyFor @NonNull @Initialized Object v) {
        Schema.Type arrayType = schema.getType();
        Verify.verify((arrayType == Schema.Type.ARRAY ? 1 : 0) != 0, (String)"BigQuery REPEATED field %s should be Avro ARRAY, not %s", (Object)fieldSchema.getName(), (Object)arrayType);
        if (v == null) {
            return new ArrayList<Object>();
        }
        List elements = (List)v;
        ArrayList<Object> values = new ArrayList<Object>();
        Schema.Type elementType = schema.getElementType().getType();
        LogicalType elementLogicalType = schema.getElementType().getLogicalType();
        for (Object element : elements) {
            values.add(BigQueryAvroUtils.convertRequiredField(elementType, elementLogicalType, fieldSchema, element));
        }
        return values;
    }

    private static @UnknownKeyFor @NonNull @Initialized Object convertRequiredField(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.Type avroType, @UnknownKeyFor @NonNull @Initialized LogicalType avroLogicalType, @UnknownKeyFor @NonNull @Initialized TableFieldSchema fieldSchema, @UnknownKeyFor @NonNull @Initialized Object v) {
        Preconditions.checkNotNull((Object)v, (String)"REQUIRED field %s should not be null", (Object)fieldSchema.getName());
        String bqType = fieldSchema.getType();
        ImmutableCollection expectedAvroTypes = BIG_QUERY_TO_AVRO_TYPES.get((Object)bqType);
        Verify.verifyNotNull((Object)expectedAvroTypes, (String)"Unsupported BigQuery type: %s", (Object[])new Object[]{bqType});
        Verify.verify((boolean)expectedAvroTypes.contains((Object)avroType), (String)"Expected Avro schema types %s for BigQuery %s field %s, but received %s", (Object)expectedAvroTypes, (Object)bqType, (Object)fieldSchema.getName(), (Object)avroType);
        switch (bqType) {
            case "STRING": 
            case "DATETIME": 
            case "GEOGRAPHY": 
            case "JSON": {
                Verify.verify((boolean)(v instanceof CharSequence), (String)"Expected CharSequence (String), got %s", v.getClass());
                return v.toString();
            }
            case "DATE": {
                if (avroType == Schema.Type.INT) {
                    Verify.verify((boolean)(v instanceof Integer), (String)"Expected Integer, got %s", v.getClass());
                    Verify.verifyNotNull((Object)avroLogicalType, (String)"Expected Date logical type", (Object[])new Object[0]);
                    Verify.verify((boolean)(avroLogicalType instanceof LogicalTypes.Date), (String)"Expected Date logical type", (Object[])new Object[0]);
                    return BigQueryAvroUtils.formatDate((Integer)v);
                }
                Verify.verify((boolean)(v instanceof CharSequence), (String)"Expected CharSequence (String), got %s", v.getClass());
                return v.toString();
            }
            case "TIME": {
                if (avroType == Schema.Type.LONG) {
                    Verify.verify((boolean)(v instanceof Long), (String)"Expected Long, got %s", v.getClass());
                    Verify.verifyNotNull((Object)avroLogicalType, (String)"Expected TimeMicros logical type", (Object[])new Object[0]);
                    Verify.verify((boolean)(avroLogicalType instanceof LogicalTypes.TimeMicros), (String)"Expected TimeMicros logical type", (Object[])new Object[0]);
                    return BigQueryAvroUtils.formatTime((Long)v);
                }
                Verify.verify((boolean)(v instanceof CharSequence), (String)"Expected CharSequence (String), got %s", v.getClass());
                return v.toString();
            }
            case "INTEGER": 
            case "INT64": {
                Verify.verify((boolean)(v instanceof Long), (String)"Expected Long, got %s", v.getClass());
                return ((Long)v).toString();
            }
            case "FLOAT": 
            case "FLOAT64": {
                Verify.verify((boolean)(v instanceof Double), (String)"Expected Double, got %s", v.getClass());
                return v;
            }
            case "NUMERIC": 
            case "BIGNUMERIC": {
                Verify.verify((boolean)(v instanceof ByteBuffer), (String)"Expected ByteBuffer, got %s", v.getClass());
                Verify.verifyNotNull((Object)avroLogicalType, (String)"Expected Decimal logical type", (Object[])new Object[0]);
                Verify.verify((boolean)(avroLogicalType instanceof LogicalTypes.Decimal), (String)"Expected Decimal logical type", (Object[])new Object[0]);
                BigDecimal numericValue = new Conversions.DecimalConversion().fromBytes((ByteBuffer)v, Schema.create((Schema.Type)avroType), avroLogicalType);
                return numericValue.toString();
            }
            case "BOOL": 
            case "BOOLEAN": {
                Verify.verify((boolean)(v instanceof Boolean), (String)"Expected Boolean, got %s", v.getClass());
                return v;
            }
            case "TIMESTAMP": {
                Verify.verify((boolean)(v instanceof Long), (String)"Expected Long, got %s", v.getClass());
                return BigQueryAvroUtils.formatTimestamp((Long)v);
            }
            case "RECORD": 
            case "STRUCT": {
                Verify.verify((boolean)(v instanceof GenericRecord), (String)"Expected GenericRecord, got %s", v.getClass());
                return BigQueryAvroUtils.convertGenericRecordToTableRow((GenericRecord)v, fieldSchema.getFields());
            }
            case "BYTES": {
                Verify.verify((boolean)(v instanceof ByteBuffer), (String)"Expected ByteBuffer, got %s", v.getClass());
                ByteBuffer byteBuffer = (ByteBuffer)v;
                byte[] bytes = new byte[byteBuffer.limit()];
                byteBuffer.get(bytes);
                return BaseEncoding.base64().encode(bytes);
            }
        }
        throw new UnsupportedOperationException(String.format("Unexpected BigQuery field schema type %s for field named %s", fieldSchema.getType(), fieldSchema.getName()));
    }

    private static @Nullable @UnknownKeyFor @Initialized Object convertNullableField(@UnknownKeyFor @NonNull @Initialized Schema avroSchema, @UnknownKeyFor @NonNull @Initialized TableFieldSchema fieldSchema, @UnknownKeyFor @NonNull @Initialized Object v) {
        Verify.verify((avroSchema.getType() == Schema.Type.UNION ? 1 : 0) != 0, (String)"Expected Avro schema type UNION, not %s, for BigQuery NULLABLE field %s", (Object)avroSchema.getType(), (Object)fieldSchema.getName());
        List unionTypes = avroSchema.getTypes();
        Verify.verify((unionTypes.size() == 2 ? 1 : 0) != 0, (String)"BigQuery NULLABLE field %s should be an Avro UNION of NULL and another type, not %s", (Object)fieldSchema.getName(), (Object)unionTypes);
        if (v == null) {
            return null;
        }
        Schema.Type firstType = ((Schema)unionTypes.get(0)).getType();
        if (!firstType.equals((Object)Schema.Type.NULL)) {
            return BigQueryAvroUtils.convertRequiredField(firstType, ((Schema)unionTypes.get(0)).getLogicalType(), fieldSchema, v);
        }
        return BigQueryAvroUtils.convertRequiredField(((Schema)unionTypes.get(1)).getType(), ((Schema)unionTypes.get(1)).getLogicalType(), fieldSchema, v);
    }

    static @UnknownKeyFor @NonNull @Initialized Schema toGenericAvroSchema(@UnknownKeyFor @NonNull @Initialized String schemaName, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized TableFieldSchema> fieldSchemas, @Nullable @UnknownKeyFor @Initialized String namespace) {
        String nextNamespace = namespace == null ? null : String.format("%s.%s", namespace, schemaName);
        ArrayList<Schema.Field> avroFields = new ArrayList<Schema.Field>();
        for (TableFieldSchema bigQueryField : fieldSchemas) {
            avroFields.add(BigQueryAvroUtils.convertField(bigQueryField, nextNamespace));
        }
        return Schema.createRecord((String)schemaName, (String)("Translated Avro Schema for " + schemaName), (String)(namespace == null ? "org.apache.beam.sdk.io.gcp.bigquery" : namespace), (boolean)false, avroFields);
    }

    static @UnknownKeyFor @NonNull @Initialized Schema toGenericAvroSchema(@UnknownKeyFor @NonNull @Initialized String schemaName, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized TableFieldSchema> fieldSchemas) {
        return BigQueryAvroUtils.toGenericAvroSchema(schemaName, fieldSchemas, BigQueryAvroUtils.hasNamespaceCollision(fieldSchemas) ? "org.apache.beam.sdk.io.gcp.bigquery" : null);
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean hasNamespaceCollision(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized TableFieldSchema> fieldSchemas) {
        HashSet<String> recordTypeFieldNames = new HashSet<String>();
        ArrayList<TableFieldSchema> fieldsToCheck = new ArrayList<TableFieldSchema>();
        fieldsToCheck.addAll(fieldSchemas);
        while (!fieldsToCheck.isEmpty()) {
            TableFieldSchema field = (TableFieldSchema)fieldsToCheck.remove(0);
            if (!"STRUCT".equals(field.getType()) && !"RECORD".equals(field.getType())) continue;
            if (recordTypeFieldNames.contains(field.getName())) {
                return true;
            }
            recordTypeFieldNames.add(field.getName());
            fieldsToCheck.addAll(field.getFields());
        }
        return false;
    }

    private static // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.Field convertField(@UnknownKeyFor @NonNull @Initialized TableFieldSchema bigQueryField, @Nullable @UnknownKeyFor @Initialized String namespace) {
        Schema fieldSchema;
        ImmutableCollection avroTypes = BIG_QUERY_TO_AVRO_TYPES.get((Object)bigQueryField.getType());
        if (avroTypes.isEmpty()) {
            throw new IllegalArgumentException("Unable to map BigQuery field type " + bigQueryField.getType() + " to avro type.");
        }
        Schema.Type avroType = (Schema.Type)avroTypes.iterator().next();
        Schema elementSchema = avroType == Schema.Type.RECORD ? BigQueryAvroUtils.toGenericAvroSchema(bigQueryField.getName(), bigQueryField.getFields(), namespace) : BigQueryAvroUtils.handleAvroLogicalTypes(bigQueryField, avroType);
        if (bigQueryField.getMode() == null || "NULLABLE".equals(bigQueryField.getMode())) {
            fieldSchema = Schema.createUnion((Schema[])new Schema[]{Schema.create((Schema.Type)Schema.Type.NULL), elementSchema});
        } else if ("REQUIRED".equals(bigQueryField.getMode())) {
            fieldSchema = elementSchema;
        } else if ("REPEATED".equals(bigQueryField.getMode())) {
            fieldSchema = Schema.createArray((Schema)elementSchema);
        } else {
            throw new IllegalArgumentException(String.format("Unknown BigQuery Field Mode: %s", bigQueryField.getMode()));
        }
        return new Schema.Field(bigQueryField.getName(), fieldSchema, bigQueryField.getDescription(), null);
    }

    private static @UnknownKeyFor @NonNull @Initialized Schema handleAvroLogicalTypes(@UnknownKeyFor @NonNull @Initialized TableFieldSchema bigQueryField, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.Type avroType) {
        String bqType;
        switch (bqType = bigQueryField.getType()) {
            case "NUMERIC": {
                int precision = Optional.ofNullable(bigQueryField.getPrecision()).orElse(38L).intValue();
                int scale = Optional.ofNullable(bigQueryField.getScale()).orElse(9L).intValue();
                return LogicalTypes.decimal((int)precision, (int)scale).addToSchema(Schema.create((Schema.Type)Schema.Type.BYTES));
            }
            case "BIGNUMERIC": {
                int precisionBigNumeric = Optional.ofNullable(bigQueryField.getPrecision()).orElse(77L).intValue();
                int scaleBigNumeric = Optional.ofNullable(bigQueryField.getScale()).orElse(38L).intValue();
                return LogicalTypes.decimal((int)precisionBigNumeric, (int)scaleBigNumeric).addToSchema(Schema.create((Schema.Type)Schema.Type.BYTES));
            }
            case "TIMESTAMP": {
                return LogicalTypes.timestampMicros().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG));
            }
            case "GEOGRAPHY": {
                Schema geoSchema = Schema.create((Schema.Type)Schema.Type.STRING);
                geoSchema.addProp("logicalType", "geography_wkt");
                return geoSchema;
            }
        }
        return Schema.create((Schema.Type)avroType);
    }
}

