/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.TableFieldSchema;
import com.google.api.services.bigquery.model.TableRow;
import com.google.api.services.bigquery.model.TableSchema;
import com.google.common.collect.ImmutableMap;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.beam.sdk.coders.RowCoder;
import org.apache.beam.sdk.io.gcp.bigquery.Mode;
import org.apache.beam.sdk.io.gcp.bigquery.StandardSQLTypeName;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;

public class BigQueryUtils {
    private static final Map<Schema.TypeName, StandardSQLTypeName> BEAM_TO_BIGQUERY_TYPE_MAPPING = ImmutableMap.builder().put((Object)Schema.TypeName.BYTE, (Object)StandardSQLTypeName.INT64).put((Object)Schema.TypeName.INT16, (Object)StandardSQLTypeName.INT64).put((Object)Schema.TypeName.INT32, (Object)StandardSQLTypeName.INT64).put((Object)Schema.TypeName.INT64, (Object)StandardSQLTypeName.INT64).put((Object)Schema.TypeName.FLOAT, (Object)StandardSQLTypeName.FLOAT64).put((Object)Schema.TypeName.DOUBLE, (Object)StandardSQLTypeName.FLOAT64).put((Object)Schema.TypeName.DECIMAL, (Object)StandardSQLTypeName.FLOAT64).put((Object)Schema.TypeName.BOOLEAN, (Object)StandardSQLTypeName.BOOL).put((Object)Schema.TypeName.ARRAY, (Object)StandardSQLTypeName.ARRAY).put((Object)Schema.TypeName.ROW, (Object)StandardSQLTypeName.STRUCT).put((Object)Schema.TypeName.DATETIME, (Object)StandardSQLTypeName.TIMESTAMP).put((Object)Schema.TypeName.STRING, (Object)StandardSQLTypeName.STRING).build();
    private static final Map<byte[], StandardSQLTypeName> BEAM_TO_BIGQUERY_METADATA_MAPPING = ImmutableMap.builder().put((Object)"DATE".getBytes(StandardCharsets.UTF_8), (Object)StandardSQLTypeName.DATE).put((Object)"TIME".getBytes(StandardCharsets.UTF_8), (Object)StandardSQLTypeName.TIME).put((Object)"TIME_WITH_LOCAL_TZ".getBytes(StandardCharsets.UTF_8), (Object)StandardSQLTypeName.TIME).put((Object)"TS".getBytes(StandardCharsets.UTF_8), (Object)StandardSQLTypeName.TIMESTAMP).put((Object)"TS_WITH_LOCAL_TZ".getBytes(StandardCharsets.UTF_8), (Object)StandardSQLTypeName.TIMESTAMP).build();
    private static final SerializableFunction<Row, TableRow> TO_TABLE_ROW = new ToTableRow();

    private static StandardSQLTypeName toStandardSQLTypeName(Schema.FieldType fieldType) {
        StandardSQLTypeName sqlType = BEAM_TO_BIGQUERY_TYPE_MAPPING.get(fieldType.getTypeName());
        if (sqlType == StandardSQLTypeName.TIMESTAMP && fieldType.getMetadata() != null) {
            sqlType = BEAM_TO_BIGQUERY_METADATA_MAPPING.get(fieldType.getMetadata());
        }
        return sqlType;
    }

    private static List<TableFieldSchema> toTableFieldSchema(Schema schema) {
        ArrayList<TableFieldSchema> fields = new ArrayList<TableFieldSchema>(schema.getFieldCount());
        for (Schema.Field schemaField : schema.getFields()) {
            Schema.FieldType type = schemaField.getType();
            TableFieldSchema field = new TableFieldSchema().setName(schemaField.getName());
            if (schemaField.getDescription() != null && !"".equals(schemaField.getDescription())) {
                field.setDescription(schemaField.getDescription());
            }
            if (!schemaField.getNullable().booleanValue()) {
                field.setMode(Mode.REQUIRED.toString());
            }
            if (Schema.TypeName.ARRAY == type.getTypeName()) {
                type = type.getCollectionElementType();
                field.setMode(Mode.REPEATED.toString());
            }
            if (Schema.TypeName.ROW == type.getTypeName()) {
                Schema subType = type.getRowSchema();
                field.setFields(BigQueryUtils.toTableFieldSchema(subType));
            }
            field.setType(BigQueryUtils.toStandardSQLTypeName(type).toString());
            fields.add(field);
        }
        return fields;
    }

    public static TableSchema toTableSchema(Schema schema) {
        return new TableSchema().setFields(BigQueryUtils.toTableFieldSchema(schema));
    }

    public static TableSchema toTableSchema(PCollection<Row> rows) {
        RowCoder coder = (RowCoder)rows.getCoder();
        return BigQueryUtils.toTableSchema(coder.getSchema());
    }

    public static SerializableFunction<Row, TableRow> toTableRow() {
        return TO_TABLE_ROW;
    }

    public static TableRow toTableRow(Row row) {
        TableRow output = new TableRow();
        for (int i = 0; i < row.getFieldCount(); ++i) {
            ArrayList<TableRow> value = row.getValue(i);
            Schema.Field schemaField = row.getSchema().getField(i);
            Schema.TypeName type = schemaField.getType().getTypeName();
            if (Schema.TypeName.ARRAY == type) {
                type = schemaField.getType().getCollectionElementType().getTypeName();
                if (Schema.TypeName.ROW == type) {
                    List rows = value;
                    ArrayList<TableRow> tableRows = new ArrayList<TableRow>(rows.size());
                    for (int j = 0; j < rows.size(); ++j) {
                        tableRows.add(BigQueryUtils.toTableRow((Row)rows.get(j)));
                    }
                    value = tableRows;
                }
            } else if (Schema.TypeName.ROW == type) {
                value = BigQueryUtils.toTableRow((Row)value);
            }
            output = output.set(schemaField.getName(), (Object)value);
        }
        return output;
    }

    private static class ToTableRow
    implements SerializableFunction<Row, TableRow> {
        private ToTableRow() {
        }

        public TableRow apply(Row input) {
            return BigQueryUtils.toTableRow(input);
        }
    }
}

